/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer;

import java.awt.Dimension;
import java.awt.Image;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.keys.positioning.PositioningStyleKeys;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.computed.VariableToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedCounterToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedStringToken;
import org.jfree.layouting.layouter.content.resolved.ResolvedToken;
import org.jfree.layouting.layouter.content.type.GenericType;
import org.jfree.layouting.layouter.content.type.ResourceType;
import org.jfree.layouting.layouter.content.type.TextType;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.renderer.ContentStore;
import org.jfree.layouting.renderer.FlowContext;
import org.jfree.layouting.renderer.ModelPrinter;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.renderer.border.BorderFactory;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.BoxDefinitionFactory;
import org.jfree.layouting.renderer.model.DefaultBoxDefinitionFactory;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.MarkerRenderBox;
import org.jfree.layouting.renderer.model.NormalFlowRenderBox;
import org.jfree.layouting.renderer.model.ParagraphPoolBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.model.RenderableTextBox;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableColumnGroupNode;
import org.jfree.layouting.renderer.model.table.TableColumnNode;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.page.RenderPageContext;
import org.jfree.layouting.renderer.process.CheckHibernationLayoutStep;
import org.jfree.layouting.renderer.text.DefaultRenderableTextFactory;
import org.jfree.layouting.renderer.text.RenderableTextFactory;
import org.jfree.layouting.util.geom.StrictDimension;
import org.jfree.layouting.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.manual.Utf16LE;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public abstract class AbstractRenderer
implements Renderer {
    private LayoutProcess layoutProcess;
    private LogicalPageBox logicalPageBox;
    private ContentStore elementsStore;
    private ContentStore pendingStore;
    private FastStack flowContexts;
    private CodePointBuffer buffer;
    private RenderPageContext pageContext;
    private BoxDefinitionFactory boxDefinitionFactory;
    private Object layoutFailureNodeId;
    private int layoutFailureReason;

    protected AbstractRenderer(LayoutProcess layoutProcess, boolean bl) {
        if (layoutProcess == null) {
            throw new NullPointerException();
        }
        this.layoutProcess = layoutProcess;
        this.flowContexts = new FastStack();
        if (bl) {
            this.elementsStore = new ContentStore();
            this.pendingStore = new ContentStore();
            this.boxDefinitionFactory = new DefaultBoxDefinitionFactory(new BorderFactory());
        }
    }

    public LogicalPageBox getLogicalPageBox() {
        return this.logicalPageBox;
    }

    public LayoutProcess getLayoutProcess() {
        return this.layoutProcess;
    }

    public RenderPageContext getRenderPageContext() {
        return this.pageContext;
    }

    public void setLayoutFailureReason(int n, Object object) {
        this.layoutFailureNodeId = object;
        this.layoutFailureReason = n;
    }

    public void startedDocument(PageContext pageContext) {
        if (pageContext == null) {
            throw new NullPointerException();
        }
        LayoutProcess layoutProcess = this.getLayoutProcess();
        OutputProcessor outputProcessor = layoutProcess.getOutputProcessor();
        outputProcessor.processDocumentMetaData(layoutProcess.getDocumentContext());
        this.pageContext = new RenderPageContext(layoutProcess, pageContext);
        PageGrid pageGrid = this.pageContext.createPageGrid(this.layoutProcess.getOutputMetaData());
        this.logicalPageBox = new LogicalPageBox(pageGrid);
        this.logicalPageBox.setPageContext(this.pageContext.getPageContext());
    }

    protected final void tryValidateOutput(Object object) throws NormalizationException {
        if (this.isValidatable(object)) {
            try {
                this.validateOutput();
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
                ModelPrinter.print(this.logicalPageBox);
            }
        }
    }

    private boolean isValidatable(Object object) {
        if (this.layoutFailureReason == 2) {
            if (object != this.layoutFailureNodeId) {
                return false;
            }
            this.layoutFailureReason = 0;
            this.layoutFailureNodeId = null;
        }
        return true;
    }

    protected abstract void validateOutput() throws NormalizationException;

    protected RenderBox getInsertationPoint() {
        FlowContext flowContext = (FlowContext)this.flowContexts.peek();
        NormalFlowRenderBox normalFlowRenderBox = flowContext.getCurrentFlow();
        if (normalFlowRenderBox == null) {
            throw new IllegalStateException("There is no flow active at the moment.");
        }
        return normalFlowRenderBox.getInsertationPoint();
    }

    protected boolean isProcessingNormalFlow() {
        return this.flowContexts.size() <= 1;
    }

    public void startedFlow(LayoutContext layoutContext) throws NormalizationException {
        this.pageContext = this.pageContext.update(layoutContext);
        if (!this.logicalPageBox.isNormalFlowActive()) {
            this.logicalPageBox.setNormalFlowActive(true);
            DefaultRenderableTextFactory defaultRenderableTextFactory = new DefaultRenderableTextFactory(this.layoutProcess);
            defaultRenderableTextFactory.startText();
            FlowContext flowContext = new FlowContext(defaultRenderableTextFactory, this.logicalPageBox.getNormalFlow());
            this.flowContexts.push((Object)flowContext);
        } else {
            Object object;
            Object object2;
            CSSValue cSSValue = layoutContext.getValue(PositioningStyleKeys.POSITION);
            if (cSSValue instanceof CSSFunctionValue && ((CSSValue[])(object2 = ((CSSFunctionValue)(object = (CSSFunctionValue)cSSValue)).getParameters())).length > 0) {
                CSSValue cSSValue2 = object2[0];
                this.startHeaderFlow(cSSValue2.getCSSText(), layoutContext);
                return;
            }
            object = this.boxDefinitionFactory.createBlockBoxDefinition(layoutContext, this.layoutProcess.getOutputMetaData());
            object2 = new NormalFlowRenderBox((BoxDefinition)object);
            ((NormalFlowRenderBox)object2).appyStyle(layoutContext, this.layoutProcess.getOutputMetaData());
            ((RenderBox)object2).setPageContext(this.pageContext.getPageContext());
            RenderBox renderBox = this.getInsertationPoint();
            renderBox.addChild(((NormalFlowRenderBox)object2).getPlaceHolder());
            renderBox.getNormalFlow().addFlow((NormalFlowRenderBox)object2);
            DefaultRenderableTextFactory defaultRenderableTextFactory = new DefaultRenderableTextFactory(this.layoutProcess);
            defaultRenderableTextFactory.startText();
            FlowContext flowContext = new FlowContext(defaultRenderableTextFactory, (NormalFlowRenderBox)object2);
            this.flowContexts.push((Object)flowContext);
        }
    }

    private void startHeaderFlow(String string, LayoutContext layoutContext) {
        Object object;
        BoxDefinition boxDefinition = this.boxDefinitionFactory.createBlockBoxDefinition(layoutContext, this.layoutProcess.getOutputMetaData());
        NormalFlowRenderBox normalFlowRenderBox = new NormalFlowRenderBox(boxDefinition);
        normalFlowRenderBox.appyStyle(layoutContext, this.layoutProcess.getOutputMetaData());
        normalFlowRenderBox.setPageContext(this.pageContext.getPageContext());
        if ("header".equals(string)) {
            object = this.logicalPageBox.getHeaderArea();
            ((RenderBox)object).clear();
            ((RenderBox)object).addChild(normalFlowRenderBox);
        } else if ("footer".equals(string)) {
            object = this.logicalPageBox.getFooterArea();
            ((RenderBox)object).clear();
            ((RenderBox)object).addChild(normalFlowRenderBox);
        }
        object = new DefaultRenderableTextFactory(this.layoutProcess);
        ((DefaultRenderableTextFactory)object).startText();
        FlowContext flowContext = new FlowContext((RenderableTextFactory)object, normalFlowRenderBox);
        this.flowContexts.push((Object)flowContext);
    }

    public void startedTable(LayoutContext layoutContext) throws NormalizationException {
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(renderableTextFactory.finishText());
        renderableTextFactory.startText();
        BoxDefinition boxDefinition = this.boxDefinitionFactory.createBlockBoxDefinition(layoutContext, this.layoutProcess.getOutputMetaData());
        this.pageContext = this.pageContext.update(layoutContext);
        TableRenderBox tableRenderBox = new TableRenderBox(boxDefinition);
        tableRenderBox.appyStyle(layoutContext, this.layoutProcess.getOutputMetaData());
        tableRenderBox.setPageContext(this.pageContext.getPageContext());
        this.getInsertationPoint().addChild(tableRenderBox);
    }

    private RenderableTextFactory getCurrentTextFactory() {
        FlowContext flowContext = (FlowContext)this.flowContexts.peek();
        return flowContext.getTextFactory();
    }

    public void startedTableColumnGroup(LayoutContext layoutContext) throws NormalizationException {
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(renderableTextFactory.finishText());
        renderableTextFactory.startText();
        this.pageContext = this.pageContext.update(layoutContext);
        BoxDefinition boxDefinition = this.boxDefinitionFactory.createBlockBoxDefinition(layoutContext, this.layoutProcess.getOutputMetaData());
        TableColumnGroupNode tableColumnGroupNode = new TableColumnGroupNode(boxDefinition);
        tableColumnGroupNode.appyStyle(layoutContext, this.layoutProcess.getOutputMetaData());
        this.getInsertationPoint().addChild(tableColumnGroupNode);
    }

    public void startedTableColumn(LayoutContext layoutContext) throws NormalizationException {
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(renderableTextFactory.finishText());
        renderableTextFactory.startText();
        this.pageContext = this.pageContext.update(layoutContext);
        BoxDefinition boxDefinition = this.boxDefinitionFactory.createBlockBoxDefinition(layoutContext, this.layoutProcess.getOutputMetaData());
        TableColumnNode tableColumnNode = new TableColumnNode(boxDefinition, layoutContext);
        this.getInsertationPoint().addChild(tableColumnNode);
    }

    public void startedTableSection(LayoutContext layoutContext) throws NormalizationException {
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(renderableTextFactory.finishText());
        renderableTextFactory.startText();
        this.pageContext = this.pageContext.update(layoutContext);
        BoxDefinition boxDefinition = this.boxDefinitionFactory.createBlockBoxDefinition(layoutContext, this.layoutProcess.getOutputMetaData());
        TableSectionRenderBox tableSectionRenderBox = new TableSectionRenderBox(boxDefinition);
        tableSectionRenderBox.appyStyle(layoutContext, this.layoutProcess.getOutputMetaData());
        tableSectionRenderBox.setPageContext(this.pageContext.getPageContext());
        this.getInsertationPoint().addChild(tableSectionRenderBox);
    }

    public void startedTableRow(LayoutContext layoutContext) throws NormalizationException {
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(renderableTextFactory.finishText());
        renderableTextFactory.startText();
        this.pageContext = this.pageContext.update(layoutContext);
        BoxDefinition boxDefinition = this.boxDefinitionFactory.createBlockBoxDefinition(layoutContext, this.layoutProcess.getOutputMetaData());
        TableRowRenderBox tableRowRenderBox = new TableRowRenderBox(boxDefinition, false);
        tableRowRenderBox.appyStyle(layoutContext, this.layoutProcess.getOutputMetaData());
        tableRowRenderBox.setPageContext(this.pageContext.getPageContext());
        this.getInsertationPoint().addChild(tableRowRenderBox);
    }

    public void startedTableCell(LayoutContext layoutContext) throws NormalizationException {
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(renderableTextFactory.finishText());
        renderableTextFactory.startText();
        this.pageContext = this.pageContext.update(layoutContext);
        BoxDefinition boxDefinition = this.boxDefinitionFactory.createBlockBoxDefinition(layoutContext, this.layoutProcess.getOutputMetaData());
        TableCellRenderBox tableCellRenderBox = new TableCellRenderBox(boxDefinition);
        tableCellRenderBox.setPageContext(this.pageContext.getPageContext());
        tableCellRenderBox.appyStyle(layoutContext, this.layoutProcess.getOutputMetaData());
        this.getInsertationPoint().addChild(tableCellRenderBox);
    }

    public void startedBlock(LayoutContext layoutContext) throws NormalizationException {
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(renderableTextFactory.finishText());
        renderableTextFactory.startText();
        this.pageContext = this.pageContext.update(layoutContext);
        BoxDefinition boxDefinition = this.boxDefinitionFactory.createBlockBoxDefinition(layoutContext, this.layoutProcess.getOutputMetaData());
        BlockRenderBox blockRenderBox = new BlockRenderBox(boxDefinition);
        blockRenderBox.appyStyle(layoutContext, this.layoutProcess.getOutputMetaData());
        blockRenderBox.setPageContext(this.pageContext.getPageContext());
        this.getInsertationPoint().addChild(blockRenderBox);
    }

    public void startedMarker(LayoutContext layoutContext) throws NormalizationException {
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(renderableTextFactory.finishText());
        renderableTextFactory.startText();
        this.pageContext = this.pageContext.update(layoutContext);
        BoxDefinition boxDefinition = this.boxDefinitionFactory.createInlineBoxDefinition(layoutContext, this.layoutProcess.getOutputMetaData());
        MarkerRenderBox markerRenderBox = new MarkerRenderBox(boxDefinition);
        markerRenderBox.appyStyle(layoutContext, this.layoutProcess.getOutputMetaData());
        markerRenderBox.setPageContext(this.pageContext.getPageContext());
        this.getInsertationPoint().addChild(markerRenderBox);
    }

    public void startedRootInline(LayoutContext layoutContext) throws NormalizationException {
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(renderableTextFactory.finishText());
        renderableTextFactory.startText();
        this.pageContext = this.pageContext.update(layoutContext);
        BoxDefinition boxDefinition = this.boxDefinitionFactory.createBlockBoxDefinition(layoutContext, this.layoutProcess.getOutputMetaData());
        ParagraphRenderBox paragraphRenderBox = new ParagraphRenderBox(boxDefinition);
        paragraphRenderBox.appyStyle(layoutContext, this.layoutProcess.getOutputMetaData());
        paragraphRenderBox.setPageContext(this.pageContext.getPageContext());
        RenderBox renderBox = this.getInsertationPoint();
        renderBox.addChild(paragraphRenderBox);
    }

    public void startedInline(LayoutContext layoutContext) throws NormalizationException {
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        this.getInsertationPoint().addChilds(renderableTextFactory.finishText());
        this.pageContext = this.pageContext.update(layoutContext);
        BoxDefinition boxDefinition = this.boxDefinitionFactory.createInlineBoxDefinition(layoutContext, this.layoutProcess.getOutputMetaData());
        InlineRenderBox inlineRenderBox = new InlineRenderBox(boxDefinition);
        inlineRenderBox.appyStyle(layoutContext, this.layoutProcess.getOutputMetaData());
        inlineRenderBox.setPageContext(this.pageContext.getPageContext());
        RenderBox renderBox = this.getInsertationPoint();
        renderBox.addChild(inlineRenderBox);
    }

    public void addContent(LayoutContext layoutContext, ContentToken contentToken) throws NormalizationException {
        RenderNode renderNode;
        Object object;
        Object object2;
        ContentToken contentToken2;
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        if (contentToken instanceof GenericType) {
            contentToken2 = (GenericType)contentToken;
            object2 = null;
            if (contentToken instanceof ResourceType) {
                object = (ResourceType)contentToken;
                object2 = object.getContent().getSource();
            }
            if ((object = contentToken2.getRaw()) instanceof Image) {
                renderNode = this.createImage((Image)object, (ResourceKey)object2, layoutContext);
                if (renderNode != null) {
                    ((RenderableReplacedContent)renderNode).appyStyle(layoutContext, this.layoutProcess.getOutputMetaData());
                    this.getInsertationPoint().addChilds(renderableTextFactory.finishText());
                    this.getInsertationPoint().addChild(renderNode);
                    this.tryValidateOutput(null);
                    return;
                }
            } else if (object instanceof DrawableWrapper && (renderNode = this.createDrawable((DrawableWrapper)object, (ResourceKey)object2, layoutContext)) != null) {
                ((RenderableReplacedContent)renderNode).appyStyle(layoutContext, this.layoutProcess.getOutputMetaData());
                this.getInsertationPoint().addChilds(renderableTextFactory.finishText());
                this.getInsertationPoint().addChild(renderNode);
                this.tryValidateOutput(null);
                return;
            }
        }
        if (contentToken instanceof ResolvedCounterToken) {
            contentToken2 = (ResolvedCounterToken)contentToken;
            if (!this.isProcessingNormalFlow()) {
                this.getInsertationPoint().addChilds(renderableTextFactory.finishText());
                try {
                    object2 = new RenderableTextBox(renderableTextFactory.saveState(), (ResolvedToken)contentToken2, layoutContext);
                    ((RenderBox)object2).appyStyle(layoutContext, this.getLayoutProcess().getOutputMetaData());
                    this.getInsertationPoint().addChild((RenderNode)object2);
                    ((RenderBox)object2).close();
                    this.tryValidateOutput(null);
                    return;
                }
                catch (StateException stateException) {
                    throw new NormalizationException("State failed.", (Exception)((Object)stateException));
                }
            }
        }
        if (layoutContext instanceof ResolvedStringToken && (object2 = ((ResolvedStringToken)(contentToken2 = (ResolvedStringToken)((Object)layoutContext))).getParent()) instanceof VariableToken && !this.isProcessingNormalFlow()) {
            this.getInsertationPoint().addChilds(renderableTextFactory.finishText());
            try {
                object = new RenderableTextBox(renderableTextFactory.saveState(), (ResolvedToken)contentToken2, layoutContext);
                ((RenderBox)object).appyStyle(layoutContext, this.getLayoutProcess().getOutputMetaData());
                this.getInsertationPoint().addChild((RenderNode)object);
                ((RenderBox)object).close();
                this.tryValidateOutput(null);
                return;
            }
            catch (StateException stateException) {
                throw new NormalizationException("State failed.", (Exception)((Object)stateException));
            }
        }
        if (contentToken instanceof TextType) {
            contentToken2 = (TextType)contentToken;
            object2 = contentToken2.getText();
            object = this.createText((String)object2, layoutContext);
            if (((RenderNode[])object).length == 0) {
                return;
            }
            renderNode = this.getInsertationPoint();
            ((RenderBox)renderNode).addChilds((RenderNode[])object);
            this.tryValidateOutput(null);
        }
    }

    private RenderNode[] createText(String string, LayoutContext layoutContext) {
        if (this.buffer != null) {
            this.buffer.setCursor(0);
        }
        this.buffer = Utf16LE.getInstance().decodeString(string, this.buffer);
        int[] nArray = this.buffer.getBuffer();
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        return renderableTextFactory.createText(nArray, 0, this.buffer.getLength(), layoutContext);
    }

    private RenderableReplacedContent createImage(Image image, ResourceKey resourceKey, LayoutContext layoutContext) {
        WaitingImageObserver waitingImageObserver = new WaitingImageObserver(image);
        waitingImageObserver.waitImageLoaded();
        if (waitingImageObserver.isError()) {
            return null;
        }
        CSSValue cSSValue = layoutContext.getValue(BoxStyleKeys.WIDTH);
        RenderLength renderLength = DefaultBoxDefinitionFactory.computeWidth(cSSValue, layoutContext, this.layoutProcess.getOutputMetaData(), true, false);
        CSSValue cSSValue2 = layoutContext.getValue(BoxStyleKeys.HEIGHT);
        RenderLength renderLength2 = DefaultBoxDefinitionFactory.computeWidth(cSSValue2, layoutContext, this.layoutProcess.getOutputMetaData(), true, false);
        StrictDimension strictDimension = StrictGeomUtility.createDimension(image.getWidth(null), image.getHeight(null));
        CSSValue cSSValue3 = layoutContext.getValue(LineStyleKeys.VERTICAL_ALIGN);
        return new RenderableReplacedContent(image, resourceKey, strictDimension, renderLength, renderLength2, cSSValue3);
    }

    private RenderableReplacedContent createDrawable(DrawableWrapper drawableWrapper, ResourceKey resourceKey, LayoutContext layoutContext) {
        StrictDimension strictDimension = new StrictDimension();
        Dimension dimension = drawableWrapper.getPreferredSize();
        if (dimension != null) {
            strictDimension.setWidth(StrictGeomUtility.toInternalValue(dimension.getWidth()));
            strictDimension.setHeight(StrictGeomUtility.toInternalValue(dimension.getHeight()));
        }
        CSSValue cSSValue = layoutContext.getValue(BoxStyleKeys.WIDTH);
        RenderLength renderLength = DefaultBoxDefinitionFactory.computeWidth(cSSValue, layoutContext, this.layoutProcess.getOutputMetaData(), true, false);
        CSSValue cSSValue2 = layoutContext.getValue(BoxStyleKeys.HEIGHT);
        RenderLength renderLength2 = DefaultBoxDefinitionFactory.computeWidth(cSSValue2, layoutContext, this.layoutProcess.getOutputMetaData(), true, false);
        CSSValue cSSValue3 = layoutContext.getValue(LineStyleKeys.VERTICAL_ALIGN);
        return new RenderableReplacedContent(drawableWrapper, resourceKey, strictDimension, renderLength, renderLength2, cSSValue3);
    }

    public void finishedInline() throws NormalizationException {
        RenderBox renderBox = this.getInsertationPoint();
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        RenderNode[] renderNodeArray = renderableTextFactory.finishText();
        renderBox.addChilds(renderNodeArray);
        renderBox.close();
        this.tryValidateOutput(renderBox.getInstanceId());
    }

    public void finishedRootInline() throws NormalizationException {
        RenderBox renderBox = this.getInsertationPoint();
        if (!(renderBox instanceof ParagraphPoolBox)) {
            this.getInsertationPoint();
            throw new IllegalStateException("Assertation: A rootInline must call close on a pool box");
        }
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        RenderNode[] renderNodeArray = renderableTextFactory.finishText();
        renderBox.addChilds(renderNodeArray);
        renderBox.close();
        this.tryValidateOutput(renderBox.getInstanceId());
    }

    public void finishedMarker() throws NormalizationException {
        RenderBox renderBox = this.getInsertationPoint();
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        RenderNode[] renderNodeArray = renderableTextFactory.finishText();
        renderBox.addChilds(renderNodeArray);
        renderBox.close();
        this.tryValidateOutput(renderBox.getInstanceId());
    }

    public void finishedBlock() throws NormalizationException {
        RenderBox renderBox = this.getInsertationPoint();
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        renderBox.addChilds(renderableTextFactory.finishText());
        renderBox.close();
        this.tryValidateOutput(renderBox.getInstanceId());
    }

    public void finishedTableCell() throws NormalizationException {
        RenderBox renderBox = this.getInsertationPoint();
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        renderBox.addChilds(renderableTextFactory.finishText());
        renderBox.close();
        this.isValidatable(renderBox);
    }

    public void finishedTableRow() throws NormalizationException {
        RenderBox renderBox = this.getInsertationPoint();
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        renderBox.addChilds(renderableTextFactory.finishText());
        renderBox.close();
        this.tryValidateOutput(renderBox.getInstanceId());
    }

    public void finishedTableSection() throws NormalizationException {
        RenderBox renderBox = this.getInsertationPoint();
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        renderBox.addChilds(renderableTextFactory.finishText());
        renderBox.close();
        this.tryValidateOutput(renderBox.getInstanceId());
    }

    public void finishedTableColumnGroup() throws NormalizationException {
        RenderBox renderBox = this.getInsertationPoint();
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        renderBox.addChilds(renderableTextFactory.finishText());
        renderBox.close();
    }

    public void finishedTableColumn() throws NormalizationException {
        RenderBox renderBox = this.getInsertationPoint();
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        renderBox.addChilds(renderableTextFactory.finishText());
    }

    public void finishedTable() throws NormalizationException {
        RenderBox renderBox = this.getInsertationPoint();
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        renderBox.addChilds(renderableTextFactory.finishText());
        renderBox.close();
        this.tryValidateOutput(renderBox.getInstanceId());
    }

    public void finishedFlow() throws NormalizationException {
        RenderBox renderBox = this.getInsertationPoint();
        RenderableTextFactory renderableTextFactory = this.getCurrentTextFactory();
        renderBox.addChilds(renderableTextFactory.finishText());
        renderBox.close();
        this.flowContexts.pop();
        this.tryValidateOutput(renderBox.getInstanceId());
    }

    public void finishedDocument() throws NormalizationException {
        this.logicalPageBox.close();
        this.tryValidateOutput(this.logicalPageBox.getInstanceId());
    }

    public RenderPageContext getPageContext() {
        return this.pageContext;
    }

    public void handlePageBreak(PageContext pageContext) {
        if (pageContext == null) {
            throw new NullPointerException();
        }
        this.pageContext = this.pageContext.update(pageContext, this.layoutProcess.getOutputProcessor());
        PageGrid pageGrid = this.pageContext.createPageGrid(this.layoutProcess.getOutputMetaData());
        this.pendingStore = (ContentStore)this.pendingStore.derive();
        this.elementsStore = (ContentStore)this.elementsStore.derive();
        this.logicalPageBox.updatePageArea(pageGrid);
    }

    public void startedPassThrough(LayoutContext layoutContext) {
    }

    public void addPassThroughContent(LayoutContext layoutContext, ContentToken contentToken) {
    }

    public void finishedPassThrough() {
    }

    public void startedTableCaption(LayoutContext layoutContext) throws NormalizationException {
    }

    public void finishedTableCaption() throws NormalizationException {
    }

    protected static abstract class RendererState
    implements State {
        private BoxDefinitionFactory boxDefinitionFactory;
        private State pageContext;
        private int bufferLength;
        private LogicalPageBox logicalPageBox;
        private ContentStore elementsStore;
        private ContentStore pendingStore;
        private FlowContext.FlowContextState[] flowContexts;

        protected RendererState(AbstractRenderer abstractRenderer) throws StateException {
            CheckHibernationLayoutStep checkHibernationLayoutStep;
            this.boxDefinitionFactory = abstractRenderer.boxDefinitionFactory;
            if (abstractRenderer.pageContext != null) {
                this.pageContext = abstractRenderer.pageContext.saveState();
            }
            if (abstractRenderer.buffer != null) {
                this.bufferLength = abstractRenderer.buffer.getData().length;
            }
            if (abstractRenderer.logicalPageBox != null) {
                this.logicalPageBox = (LogicalPageBox)abstractRenderer.logicalPageBox.hibernate();
                if (LibLayoutBoot.isAsserationEnabled()) {
                    checkHibernationLayoutStep = new CheckHibernationLayoutStep();
                    checkHibernationLayoutStep.startProcessing(this.logicalPageBox);
                }
            }
            try {
                this.elementsStore = (ContentStore)abstractRenderer.elementsStore.clone();
                this.pendingStore = (ContentStore)abstractRenderer.pendingStore.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new StateException();
            }
            checkHibernationLayoutStep = abstractRenderer.flowContexts;
            this.flowContexts = new FlowContext.FlowContextState[checkHibernationLayoutStep.size()];
            for (int i = 0; i < checkHibernationLayoutStep.size(); ++i) {
                FlowContext flowContext = (FlowContext)checkHibernationLayoutStep.get(i);
                this.flowContexts[i] = flowContext.saveState();
            }
        }

        protected void fill(AbstractRenderer abstractRenderer, LayoutProcess layoutProcess) throws StateException {
            if (this.bufferLength > 0) {
                abstractRenderer.buffer = new CodePointBuffer(this.bufferLength);
            }
            try {
                abstractRenderer.elementsStore = (ContentStore)this.elementsStore.clone();
                abstractRenderer.pendingStore = (ContentStore)this.pendingStore.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new StateException();
            }
            abstractRenderer.boxDefinitionFactory = this.boxDefinitionFactory;
            if (this.pageContext != null) {
                abstractRenderer.pageContext = (RenderPageContext)this.pageContext.restore(layoutProcess);
            }
            if (this.logicalPageBox != null) {
                abstractRenderer.logicalPageBox = (LogicalPageBox)this.logicalPageBox.derive(true);
            }
            abstractRenderer.flowContexts = new FastStack();
            for (int i = 0; i < this.flowContexts.length; ++i) {
                FlowContext.FlowContextState flowContextState = this.flowContexts[i];
                Object object = flowContextState.getCurrentFlowId();
                State state = flowContextState.getTextFactoryState();
                RenderableTextFactory renderableTextFactory = (RenderableTextFactory)state.restore(layoutProcess);
                NormalFlowRenderBox normalFlowRenderBox = (NormalFlowRenderBox)abstractRenderer.logicalPageBox.findNodeById(object);
                if (normalFlowRenderBox == null) {
                    throw new StateException("No Such normal flow.");
                }
                abstractRenderer.flowContexts.push((Object)new FlowContext(renderableTextFactory, normalFlowRenderBox));
            }
        }
    }
}

