/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.lib.profiler.ui.UIUtils;

public class HTMLLabel
extends JEditorPane
implements HyperlinkListener {
    public HTMLLabel() {
        this.setEditorKit(new HTMLEditorKit());
        this.setEditable(false);
        this.setOpaque(false);
        this.setNavigationFilter(new NavigationFilter(){

            @Override
            public void moveDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
                super.moveDot(filterBypass, 0, bias);
            }

            @Override
            public void setDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
                super.setDot(filterBypass, 0, bias);
            }

            @Override
            public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
                return 0;
            }
        });
        this.setFont(UIManager.getFont("Label.font"));
        this.addHyperlinkListener(this);
    }

    public HTMLLabel(String string) {
        this();
        this.setText(string);
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (UIUtils.isNimbusLookAndFeel() && !bl) {
            this.setBackground(new Color(0, 0, 0, 0));
        }
    }

    @Override
    public void setText(String string) {
        Font font = this.getFont();
        Color color = this.getForeground();
        string = string.replaceAll("\\n\\r|\\r\\n|\\n|\\r", "<br>");
        string = string.replace("<code>", "<code style=\"font-size: " + font.getSize() + "pt;\">");
        String string2 = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        super.setText("<html><body text=\"" + string2 + "\" style=\"font-size: " + font.getSize() + "pt; font-family: " + font.getName() + ";\">" + string + "</body></html>");
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.showURL(hyperlinkEvent.getURL());
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void showURL(URL uRL) {
    }
}

