/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.payloads;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.queries.payloads.AveragePayloadFunction;
import org.apache.lucene.queries.payloads.PayloadFunction;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.ToStringUtils;

@Deprecated
public class PayloadNearQuery
extends SpanNearQuery {
    protected String fieldName;
    protected PayloadFunction function;

    public PayloadNearQuery(SpanQuery[] clauses, int slop, boolean inOrder) {
        this(clauses, slop, inOrder, new AveragePayloadFunction());
    }

    public PayloadNearQuery(SpanQuery[] clauses, int slop, boolean inOrder, PayloadFunction function) {
        super(clauses, slop, inOrder);
        this.fieldName = Objects.requireNonNull(clauses[0].getField(), "all clauses must have same non null field");
        this.function = Objects.requireNonNull(function);
    }

    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        ArrayList<SpanWeight> subWeights = new ArrayList<SpanWeight>();
        for (SpanQuery q : this.clauses) {
            subWeights.add(q.createWeight(searcher, false));
        }
        return new PayloadNearSpanWeight(subWeights, searcher, needsScores ? PayloadNearQuery.getTermContexts(subWeights) : null);
    }

    public PayloadNearQuery clone() {
        int sz = this.clauses.size();
        SpanQuery[] newClauses = new SpanQuery[sz];
        for (int i = 0; i < sz; ++i) {
            newClauses[i] = (SpanQuery)((SpanQuery)this.clauses.get(i)).clone();
        }
        PayloadNearQuery boostingNearQuery = new PayloadNearQuery(newClauses, this.slop, this.inOrder, this.function);
        boostingNearQuery.setBoost(this.getBoost());
        return boostingNearQuery;
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("payloadNear([");
        Iterator i = this.clauses.iterator();
        while (i.hasNext()) {
            SpanQuery clause = (SpanQuery)i.next();
            buffer.append(clause.toString(field));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("], ");
        buffer.append(this.slop);
        buffer.append(", ");
        buffer.append(this.inOrder);
        buffer.append(")");
        buffer.append(ToStringUtils.boost((float)this.getBoost()));
        return buffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        result = 31 * result + this.function.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        PayloadNearQuery other = (PayloadNearQuery)((Object)obj);
        return this.fieldName.equals(other.fieldName) && this.function.equals(other.function);
    }

    public class PayloadNearSpanScorer
    extends Spans
    implements SpanCollector {
        Spans spans;
        protected float payloadScore;
        private int payloadsSeen;
        private final List<byte[]> payloads;
        BytesRef scratch;

        protected PayloadNearSpanScorer(Spans spans, SpanWeight weight, Similarity.SimScorer docScorer) throws IOException {
            super(weight, docScorer);
            this.payloads = new ArrayList<byte[]>();
            this.scratch = new BytesRef();
            this.spans = spans;
        }

        protected void processPayloads(Collection<byte[]> payLoads, int start, int end) {
            for (byte[] thePayload : payLoads) {
                this.scratch.bytes = thePayload;
                this.scratch.offset = 0;
                this.scratch.length = thePayload.length;
                this.payloadScore = PayloadNearQuery.this.function.currentScore(this.docID(), PayloadNearQuery.this.fieldName, start, end, this.payloadsSeen, this.payloadScore, this.docScorer.computePayloadFactor(this.docID(), this.spans.startPosition(), this.spans.endPosition(), this.scratch));
                ++this.payloadsSeen;
            }
        }

        public int nextStartPosition() throws IOException {
            return this.spans.nextStartPosition();
        }

        public int startPosition() {
            return this.spans.startPosition();
        }

        public int endPosition() {
            return this.spans.endPosition();
        }

        public int width() {
            return this.spans.width();
        }

        public void collect(SpanCollector collector) throws IOException {
            this.spans.collect(collector);
        }

        protected void doStartCurrentDoc() throws IOException {
            this.payloadScore = 0.0f;
            this.payloadsSeen = 0;
        }

        protected void doCurrentSpans() throws IOException {
            this.reset();
            this.spans.collect((SpanCollector)this);
            this.processPayloads(this.payloads, this.spans.startPosition(), this.spans.endPosition());
        }

        public float scoreCurrentDoc() throws IOException {
            return super.scoreCurrentDoc() * PayloadNearQuery.this.function.docScore(this.docID(), PayloadNearQuery.this.fieldName, this.payloadsSeen, this.payloadScore);
        }

        public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
            BytesRef payload = postings.getPayload();
            if (payload == null) {
                return;
            }
            byte[] bytes = new byte[payload.length];
            System.arraycopy(payload.bytes, payload.offset, bytes, 0, payload.length);
            this.payloads.add(bytes);
        }

        public void reset() {
            this.payloads.clear();
        }

        public int docID() {
            return this.spans.docID();
        }

        public int nextDoc() throws IOException {
            return this.spans.nextDoc();
        }

        public int advance(int target) throws IOException {
            return this.spans.advance(target);
        }

        public long cost() {
            return this.spans.cost();
        }

        public float positionsCost() {
            return this.spans.positionsCost();
        }
    }

    public class PayloadNearSpanWeight
    extends SpanNearQuery.SpanNearWeight {
        public PayloadNearSpanWeight(List<SpanWeight> subWeights, IndexSearcher searcher, Map<Term, TermContext> terms) throws IOException {
            super((SpanNearQuery)PayloadNearQuery.this, subWeights, searcher, terms);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            Spans spans = super.getSpans(context, SpanWeight.Postings.PAYLOADS);
            Similarity.SimScorer simScorer = this.simWeight == null ? null : this.similarity.simScorer(this.simWeight, context);
            return spans == null ? null : new PayloadNearSpanScorer(spans, (SpanWeight)this, simScorer);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            PayloadNearSpanScorer scorer = (PayloadNearSpanScorer)this.scorer(context);
            if (scorer != null && (newDoc = scorer.advance(doc)) == doc) {
                float freq = scorer.freq();
                Explanation freqExplanation = Explanation.match((float)freq, (String)("phraseFreq=" + freq), (Explanation[])new Explanation[0]);
                Similarity.SimScorer docScorer = this.similarity.simScorer(this.simWeight, context);
                Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
                Explanation expl = Explanation.match((float)scoreExplanation.getValue(), (String)("weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:"), (Explanation[])new Explanation[]{scoreExplanation});
                String field = ((SpanQuery)this.getQuery()).getField();
                Explanation payloadExpl = PayloadNearQuery.this.function.explain(doc, field, scorer.payloadsSeen, scorer.payloadScore);
                return Explanation.match((float)(expl.getValue() * payloadExpl.getValue()), (String)"PayloadNearQuery, product of:", (Explanation[])new Explanation[]{expl, payloadExpl});
            }
            return Explanation.noMatch((String)"no matching term", (Explanation[])new Explanation[0]);
        }
    }
}

