/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharBox;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.CharSymbol;
import org.scilab.forge.jlatexmath.ScaleBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;

public class CharAtom
extends CharSymbol {
    private final char c;
    private String textStyle;

    public CharAtom(char c, String string) {
        this.c = c;
        this.textStyle = string;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        String string;
        if (this.textStyle == null && (string = teXEnvironment.getTextStyle()) != null) {
            this.textStyle = string;
        }
        boolean bl = teXEnvironment.getSmallCap();
        Char char_ = this.getChar(teXEnvironment.getTeXFont(), teXEnvironment.getStyle(), bl);
        Box box = new CharBox(char_);
        if (bl && Character.isLowerCase(this.c)) {
            box = new ScaleBox(box, 0.8f, 0.8f);
        }
        return box;
    }

    public char getCharacter() {
        return this.c;
    }

    private Char getChar(TeXFont teXFont, int n, boolean bl) {
        char c = this.c;
        if (bl && Character.isLowerCase(this.c)) {
            c = Character.toUpperCase(this.c);
        }
        if (this.textStyle == null) {
            return teXFont.getDefaultChar(c, n);
        }
        return teXFont.getChar(c, this.textStyle, n);
    }

    public CharFont getCharFont(TeXFont teXFont) {
        return this.getChar(teXFont, 0, false).getCharFont();
    }

    public String toString() {
        return "CharAtom: '" + this.c + "'";
    }
}

