/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.ClasspathDirectory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileFinder;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Main
implements ProblemSeverities,
SuffixConstants {
    public static ResourceBundle bundle;
    public static final String bundleName = "org.eclipse.jdt.internal.compiler.batch.messages";
    FileSystem.Classpath[] checkedClasspaths;
    public String destinationPath;
    public String[] encodings;
    public Logger logger;
    public int exportedClassFilesCounter;
    public String[] filenames;
    public boolean generatePackagesStructure;
    public int globalErrorsCount;
    public int globalTasksCount;
    public int globalProblemsCount;
    public int globalWarningsCount;
    public long lineCount;
    public String log;
    public boolean noWarn = false;
    public Map options;
    public CompilerOptions compilerOptions;
    public boolean proceed = true;
    public boolean proceedOnError = false;
    public boolean produceRefInfo = false;
    public int repetitions;
    public int maxProblems;
    public boolean showProgress = false;
    public boolean systemExitWhenFinished = true;
    public long startTime;
    public boolean timing = false;
    public long[] times;
    public int timesCounter;
    public boolean verbose = false;
    private File javaHomeCache;
    private boolean javaHomeChecked;

    static {
        Main.relocalize();
    }

    public Main(PrintWriter outWriter, PrintWriter errWriter, boolean systemExitWhenFinished) {
        this(outWriter, errWriter, systemExitWhenFinished, null);
    }

    public Main(PrintWriter outWriter, PrintWriter errWriter, boolean systemExitWhenFinished, Map customDefaultOptions) {
        this.logger = new Logger(outWriter, errWriter);
        this.systemExitWhenFinished = systemExitWhenFinished;
        this.options = new CompilerOptions().getMap();
        if (customDefaultOptions != null) {
            Iterator iter = customDefaultOptions.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                this.options.put(key, customDefaultOptions.get(key));
            }
        }
    }

    public static String bind(String id) {
        return Main.bind(id, null);
    }

    public static String bind(String id, String binding) {
        return Main.bind(id, new String[]{binding});
    }

    public static String bind(String id, String binding1, String binding2) {
        return Main.bind(id, new String[]{binding1, binding2});
    }

    public static String bind(String id, String[] arguments) {
        if (id == null) {
            return "No message available";
        }
        String message = null;
        try {
            message = bundle.getString(id);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + id + " in: " + bundleName;
        }
        return MessageFormat.format(message, arguments);
    }

    public static boolean compile(String commandLine) {
        return Main.compile(commandLine, new PrintWriter(System.out), new PrintWriter(System.err));
    }

    public static boolean compile(String commandLine, PrintWriter outWriter, PrintWriter errWriter) {
        return new Main(outWriter, errWriter, false).compile(Main.tokenize(commandLine));
    }

    public static void main(String[] argv) {
        new Main(new PrintWriter(System.out), new PrintWriter(System.err), true).compile(argv);
    }

    public static void relocalize() {
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
        }
        catch (MissingResourceException e) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + Locale.getDefault());
            throw e;
        }
    }

    public static String[] tokenize(String commandLine) {
        int count = 0;
        String[] arguments = new String[10];
        StringTokenizer tokenizer = new StringTokenizer(commandLine, " \"", true);
        String token = "";
        boolean insideQuotes = false;
        boolean startNewToken = true;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (token.equals(" ")) {
                if (insideQuotes) {
                    int n = count - 1;
                    arguments[n] = String.valueOf(arguments[n]) + token;
                    startNewToken = false;
                    continue;
                }
                startNewToken = true;
                continue;
            }
            if (token.equals("\"")) {
                if (!insideQuotes && startNewToken) {
                    if (count == arguments.length) {
                        String[] stringArray = arguments;
                        arguments = new String[count * 2];
                        System.arraycopy(stringArray, 0, arguments, 0, count);
                    }
                    arguments[count++] = "";
                }
                insideQuotes = !insideQuotes;
                startNewToken = false;
                continue;
            }
            if (insideQuotes) {
                int n = count - 1;
                arguments[n] = String.valueOf(arguments[n]) + token;
            } else if (token.length() > 0 && !startNewToken) {
                int n = count - 1;
                arguments[n] = String.valueOf(arguments[n]) + token;
            } else {
                String trimmedToken;
                if (count == arguments.length) {
                    String[] stringArray = arguments;
                    arguments = new String[count * 2];
                    System.arraycopy(stringArray, 0, arguments, 0, count);
                }
                if ((trimmedToken = token.trim()).length() != 0) {
                    arguments[count++] = trimmedToken;
                }
            }
            startNewToken = false;
        }
        String[] stringArray = arguments;
        arguments = new String[count];
        System.arraycopy(stringArray, 0, arguments, 0, count);
        return arguments;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compile(String[] argv) {
        try {
            try {
                this.configure(argv);
                if (this.proceed) {
                    if (this.showProgress) {
                        this.logger.compiling();
                    }
                    int i = 0;
                    while (true) {
                        if (i >= this.repetitions) {
                            if (this.times != null) {
                                this.logger.logAverage(this.times, this.lineCount);
                            }
                            if (!this.showProgress) break;
                            this.logger.printNewLine();
                            break;
                        }
                        this.globalProblemsCount = 0;
                        this.globalErrorsCount = 0;
                        this.globalWarningsCount = 0;
                        this.globalTasksCount = 0;
                        this.lineCount = 0L;
                        this.exportedClassFilesCounter = 0;
                        if (this.repetitions > 1) {
                            this.logger.flush();
                            this.logger.logRepetition(i, this.repetitions);
                        }
                        this.performCompilation();
                        ++i;
                    }
                }
                if (this.systemExitWhenFinished) {
                    this.logger.flush();
                    this.logger.close();
                    System.exit(this.globalErrorsCount > 0 ? -1 : 0);
                }
            }
            catch (InvalidInputException e) {
                this.logger.logException(e);
                if (this.systemExitWhenFinished) {
                    this.logger.flush();
                    this.logger.close();
                    System.exit(-1);
                }
                Object var3_4 = null;
                this.logger.flush();
                this.logger.close();
                return false;
            }
            catch (RuntimeException runtimeException) {
                if (this.systemExitWhenFinished) {
                    this.logger.flush();
                    this.logger.close();
                    System.exit(-1);
                }
                Object var3_5 = null;
                this.logger.flush();
                this.logger.close();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.logger.flush();
            this.logger.close();
            throw throwable;
        }
        {
            Object var3_7 = null;
            this.logger.flush();
            this.logger.close();
            return this.globalErrorsCount == 0;
        }
    }

    public void configure(String[] argv) throws InvalidInputException {
        int i;
        if (argv == null || argv.length == 0) {
            this.printUsage();
            return;
        }
        int DEFAULT_SIZE_CLASSPATH = 4;
        ArrayList<FileSystem.Classpath> bootclasspaths = new ArrayList<FileSystem.Classpath>(DEFAULT_SIZE_CLASSPATH);
        ArrayList<FileSystem.Classpath> extdirsClasspaths = new ArrayList<FileSystem.Classpath>(DEFAULT_SIZE_CLASSPATH);
        ArrayList<String> extdirsNames = new ArrayList<String>(DEFAULT_SIZE_CLASSPATH);
        ArrayList sourcepathClasspaths = new ArrayList(DEFAULT_SIZE_CLASSPATH);
        ArrayList<FileSystem.Classpath> classpaths = new ArrayList<FileSystem.Classpath>(DEFAULT_SIZE_CLASSPATH);
        String currentClasspathName = null;
        ArrayList<String> currentRuleSpecs = new ArrayList<String>(DEFAULT_SIZE_CLASSPATH);
        int index = -1;
        int filesCount = 0;
        int argCount = argv.length;
        int mode = 0;
        this.repetitions = 0;
        boolean printUsageRequired = false;
        boolean printVersionRequired = false;
        boolean didSpecifySource = false;
        boolean didSpecifyCompliance = false;
        boolean didSpecifyDefaultEncoding = false;
        boolean didSpecifyTarget = false;
        boolean didSpecifyDeprecation = false;
        boolean didSpecifyWarnings = false;
        boolean useEnableJavadoc = false;
        String customEncoding = null;
        String currentArg = "";
        boolean needExpansion = false;
        int i2 = 0;
        while (i2 < argCount) {
            if (argv[i2].startsWith("@")) {
                needExpansion = true;
                break;
            }
            ++i2;
        }
        String[] newCommandLineArgs = null;
        if (needExpansion) {
            newCommandLineArgs = new String[argCount];
            index = 0;
            i = 0;
            while (i < argCount) {
                String[] newArgs = null;
                String arg = argv[i].trim();
                if (arg.startsWith("@")) {
                    try {
                        String line;
                        LineNumberReader reader = new LineNumberReader(new StringReader(new String(Util.getFileCharContent(new File(arg.substring(1)), null))));
                        StringBuffer buffer = new StringBuffer();
                        while ((line = reader.readLine()) != null) {
                            buffer.append(line).append(" ");
                        }
                        newArgs = Main.tokenize(buffer.toString());
                    }
                    catch (IOException iOException) {
                        throw new InvalidInputException(Main.bind("configure.invalidexpansionargumentname", arg));
                    }
                }
                if (newArgs != null) {
                    int newCommandLineArgsLength = newCommandLineArgs.length;
                    int newArgsLength = newArgs.length;
                    String[] stringArray = newCommandLineArgs;
                    newCommandLineArgs = new String[newCommandLineArgsLength + newArgsLength - 1];
                    System.arraycopy(stringArray, 0, newCommandLineArgs, 0, index);
                    System.arraycopy(newArgs, 0, newCommandLineArgs, index, newArgsLength);
                    index += newArgsLength;
                } else {
                    newCommandLineArgs[index++] = arg;
                }
                ++i;
            }
            index = -1;
        } else {
            newCommandLineArgs = argv;
            i = 0;
            while (i < argCount) {
                newCommandLineArgs[i] = newCommandLineArgs[i].trim();
                ++i;
            }
        }
        argCount = newCommandLineArgs.length;
        while (++index < argCount) {
            File dir;
            if (customEncoding != null) {
                throw new InvalidInputException(Main.bind("configure.unexpectedCustomEncoding", currentArg, customEncoding));
            }
            currentArg = newCommandLineArgs[index];
            customEncoding = null;
            if (currentArg.endsWith("]") && mode != 128 && mode != 1 && mode != 1024) {
                int encodingStart = currentArg.indexOf(91) + 1;
                int encodingEnd = currentArg.length() - 1;
                if (encodingStart >= 1) {
                    if (encodingStart < encodingEnd) {
                        customEncoding = currentArg.substring(encodingStart, encodingEnd);
                        try {
                            new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), customEncoding);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            throw new InvalidInputException(Main.bind("configure.unsupportedEncoding", customEncoding));
                        }
                    }
                    currentArg = currentArg.substring(0, encodingStart - 1);
                }
            }
            if (currentArg.endsWith(".java")) {
                if (this.filenames == null) {
                    this.filenames = new String[argCount - index];
                    this.encodings = new String[argCount - index];
                } else if (filesCount == this.filenames.length) {
                    int length = this.filenames.length;
                    this.filenames = new String[length + argCount - index];
                    System.arraycopy(this.filenames, 0, this.filenames, 0, length);
                    this.encodings = new String[length + argCount - index];
                    System.arraycopy(this.encodings, 0, this.encodings, 0, length);
                }
                this.filenames[filesCount] = currentArg;
                this.encodings[filesCount++] = customEncoding;
                customEncoding = null;
                mode = 0;
                continue;
            }
            if (currentArg.equals("-log")) {
                if (this.log != null) {
                    throw new InvalidInputException(Main.bind("configure.duplicateLog", currentArg));
                }
                mode = 8;
                continue;
            }
            if (currentArg.equals("-repeat")) {
                if (this.repetitions > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateRepeat", currentArg));
                }
                mode = 16;
                continue;
            }
            if (currentArg.equals("-maxProblems")) {
                if (this.maxProblems > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateMaxProblems", currentArg));
                }
                mode = 256;
                continue;
            }
            if (currentArg.equals("-source")) {
                mode = 32;
                continue;
            }
            if (currentArg.equals("-encoding")) {
                mode = 64;
                continue;
            }
            if (currentArg.equals("-1.3")) {
                if (didSpecifyCompliance) {
                    throw new InvalidInputException(Main.bind("configure.duplicateCompliance", currentArg));
                }
                didSpecifyCompliance = true;
                this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
                mode = 0;
                continue;
            }
            if (currentArg.equals("-1.4")) {
                if (didSpecifyCompliance) {
                    throw new InvalidInputException(Main.bind("configure.duplicateCompliance", currentArg));
                }
                didSpecifyCompliance = true;
                this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                mode = 0;
                continue;
            }
            if (currentArg.equals("-1.5") || currentArg.equals("-5") || currentArg.equals("-5.0")) {
                if (didSpecifyCompliance) {
                    throw new InvalidInputException(Main.bind("configure.duplicateCompliance", currentArg));
                }
                didSpecifyCompliance = true;
                this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                mode = 0;
                continue;
            }
            if (currentArg.equals("-d")) {
                if (this.destinationPath != null) {
                    throw new InvalidInputException(Main.bind("configure.duplicateOutputPath", currentArg));
                }
                mode = 2;
                this.generatePackagesStructure = true;
                continue;
            }
            if (currentArg.equals("-classpath") || currentArg.equals("-cp")) {
                mode = 1;
                continue;
            }
            if (currentArg.equals("-bootclasspath")) {
                if (bootclasspaths.size() > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateBootClasspath", currentArg));
                }
                mode = 128;
                continue;
            }
            if (currentArg.equals("-sourcepath")) {
                if (sourcepathClasspaths.size() > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateSourcepath", currentArg));
                }
                mode = 1024;
                continue;
            }
            if (currentArg.equals("-extdirs")) {
                if (extdirsNames.size() > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateExtdirs", currentArg));
                }
                mode = 512;
                continue;
            }
            if (currentArg.equals("-progress")) {
                mode = 0;
                this.showProgress = true;
                continue;
            }
            if (currentArg.equals("-proceedOnError")) {
                mode = 0;
                this.proceedOnError = true;
                continue;
            }
            if (currentArg.equals("-time")) {
                mode = 0;
                this.timing = true;
                continue;
            }
            if (currentArg.equals("-version") || currentArg.equals("-v")) {
                this.printVersion();
                this.proceed = false;
                return;
            }
            if (currentArg.equals("-showversion")) {
                printVersionRequired = true;
                continue;
            }
            if ("-deprecation".equals(currentArg)) {
                didSpecifyDeprecation = true;
                this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                continue;
            }
            if (currentArg.equals("-help") || currentArg.equals("-?")) {
                printUsageRequired = true;
                continue;
            }
            if (currentArg.equals("-noExit")) {
                mode = 0;
                this.systemExitWhenFinished = false;
                continue;
            }
            if (currentArg.equals("-verbose")) {
                mode = 0;
                this.verbose = true;
                continue;
            }
            if (currentArg.equals("-referenceInfo")) {
                mode = 0;
                this.produceRefInfo = true;
                continue;
            }
            if (currentArg.equals("-inlineJSR")) {
                mode = 0;
                this.options.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
                continue;
            }
            if (currentArg.startsWith("-g")) {
                mode = 0;
                String debugOption = currentArg;
                int length = currentArg.length();
                if (length == 2) {
                    this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                    continue;
                }
                if (length > 3) {
                    this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
                    if (length == 7 && debugOption.equals("-g:none")) continue;
                    StringTokenizer tokenizer = new StringTokenizer(debugOption.substring(3, debugOption.length()), ",");
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.equals("vars")) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                            continue;
                        }
                        if (token.equals("lines")) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                            continue;
                        }
                        if (token.equals("source")) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                            continue;
                        }
                        throw new InvalidInputException(Main.bind("configure.invalidDebugOption", debugOption));
                    }
                    continue;
                }
                throw new InvalidInputException(Main.bind("configure.invalidDebugOption", debugOption));
            }
            if (currentArg.startsWith("-nowarn")) {
                this.disableWarnings();
                mode = 0;
                continue;
            }
            if (currentArg.startsWith("-warn")) {
                boolean isEnabling;
                int warnTokenStart;
                mode = 0;
                String warningOption = currentArg;
                int length = currentArg.length();
                if (length == 10 && warningOption.equals("-warn:none")) {
                    this.disableWarnings();
                    continue;
                }
                if (length <= 6) {
                    throw new InvalidInputException(Main.bind("configure.invalidWarningConfiguration", warningOption));
                }
                switch (warningOption.charAt(6)) {
                    case '+': {
                        warnTokenStart = 7;
                        isEnabling = true;
                        break;
                    }
                    case '-': {
                        warnTokenStart = 7;
                        isEnabling = false;
                        break;
                    }
                    default: {
                        warnTokenStart = 6;
                        if (!didSpecifyWarnings) {
                            this.disableWarnings();
                        }
                        isEnabling = true;
                    }
                }
                StringTokenizer tokenizer = new StringTokenizer(warningOption.substring(warnTokenStart, warningOption.length()), ",");
                int tokenCounter = 0;
                if (didSpecifyDeprecation) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                }
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    ++tokenCounter;
                    if (token.equals("constructorName")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("pkgDefaultMethod") || token.equals("packageDefaultMethod")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("maskedCatchBlock") || token.equals("maskedCatchBlocks")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("deprecation")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
                        continue;
                    }
                    if (token.equals("allDeprecation")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", isEnabling ? "enabled" : "disabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", isEnabling ? "enabled" : "disabled");
                        continue;
                    }
                    if (token.equals("unusedLocal") || token.equals("unusedLocals")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("unusedArgument") || token.equals("unusedArguments")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("unusedImport") || token.equals("unusedImports")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("unusedPrivate")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("localHiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("fieldHiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("specialParamHiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", isEnabling ? "enabled" : "disabled");
                        continue;
                    }
                    if (token.equals("conditionAssign")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("syntheticAccess") || token.equals("synthetic-access")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("nls")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("staticReceiver")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("indirectStatic")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("noEffectAssign")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("intfNonInherited") || token.equals("interfaceNonInherited")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("charConcat") || token.equals("noImplicitStringConversion")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("semicolon")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("serial")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("emptyBlock")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("uselessTypeCheck")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("unchecked") || token.equals("unsafe")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("finalBound")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.finalParameterBound", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("suppress")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", isEnabling ? "enabled" : "disabled");
                        continue;
                    }
                    if (token.equals("warningToken")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("unnecessaryElse")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryElse", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("javadoc")) {
                        if (!useEnableJavadoc) {
                            this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", isEnabling ? "enabled" : "disabled");
                        }
                        if (!isEnabling) continue;
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "disabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", "disabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "warning");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
                        continue;
                    }
                    if (token.equals("allJavadoc")) {
                        if (!useEnableJavadoc) {
                            this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", isEnabling ? "enabled" : "disabled");
                        }
                        if (!isEnabling) continue;
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "warning");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", "warning");
                        continue;
                    }
                    if (token.startsWith("tasks")) {
                        String taskTags = "";
                        int start = token.indexOf(40);
                        int end = token.indexOf(41);
                        if (start >= 0 && end >= 0 && start < end) {
                            taskTags = token.substring(start + 1, end).trim();
                            taskTags = taskTags.replace('|', ',');
                        }
                        if (taskTags.length() == 0) {
                            throw new InvalidInputException(Main.bind("configure.invalidTaskTag", token));
                        }
                        this.options.put("org.eclipse.jdt.core.compiler.taskTags", isEnabling ? taskTags : "");
                        continue;
                    }
                    if (token.equals("assertIdentifier")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("enumIdentifier")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("finally")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("unusedThrown")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("unqualifiedField") || token.equals("unqualified-field-access")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("typeHiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("varargsCast")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("null")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.nullReference", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("boxing")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.autoboxing", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("over-ann")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("dep-ann")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("intfAnnotation")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.annotationSuperInterface", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("enumSwitch") || token.equals("incomplete-switch")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("hiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("static-access")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    if (token.equals("unused")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", isEnabling ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", isEnabling ? "warning" : "ignore");
                        continue;
                    }
                    throw new InvalidInputException(Main.bind("configure.invalidWarning", token));
                }
                if (tokenCounter == 0) {
                    throw new InvalidInputException(Main.bind("configure.invalidWarningOption", currentArg));
                }
                didSpecifyWarnings = true;
                continue;
            }
            if (currentArg.equals("-target")) {
                mode = 4;
                continue;
            }
            if (currentArg.equals("-preserveAllLocals")) {
                this.options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
                continue;
            }
            if (currentArg.equals("-enableJavadoc")) {
                this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                useEnableJavadoc = true;
                continue;
            }
            if (currentArg.startsWith("-X")) {
                mode = 0;
                continue;
            }
            if (currentArg.startsWith("-J")) {
                mode = 0;
                continue;
            }
            if (currentArg.equals("-O")) {
                mode = 0;
                continue;
            }
            if (currentArg.equals("-sourcepath")) {
                if (sourcepathClasspaths.size() > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateSourcepath", currentArg));
                }
                mode = 1024;
                continue;
            }
            if (currentArg.equals("-extdirs")) {
                if (extdirsNames.size() > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateExtdirs", currentArg));
                }
                mode = 512;
                continue;
            }
            if (mode == 4) {
                if (didSpecifyTarget) {
                    throw new InvalidInputException(Main.bind("configure.duplicateTarget", currentArg));
                }
                didSpecifyTarget = true;
                if (currentArg.equals("1.1")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                } else if (currentArg.equals("1.2")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                } else if (currentArg.equals("1.3")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
                } else if (currentArg.equals("1.4")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    if (didSpecifyCompliance && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) < 0x300000L) {
                        throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForTarget", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.4"));
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                } else if (currentArg.equals("1.5") || currentArg.equals("5") || currentArg.equals("5.0")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    if (didSpecifyCompliance && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) < 0x310000L) {
                        throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForTarget", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.5"));
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                } else {
                    throw new InvalidInputException(Main.bind("configure.targetJDK", currentArg));
                }
                mode = 0;
                continue;
            }
            if (mode == 8) {
                this.log = currentArg;
                mode = 0;
                continue;
            }
            if (mode == 16) {
                try {
                    this.repetitions = Integer.parseInt(currentArg);
                    if (this.repetitions <= 0) {
                        throw new InvalidInputException(Main.bind("configure.repetition", currentArg));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidInputException(Main.bind("configure.repetition", currentArg));
                }
                mode = 0;
                continue;
            }
            if (mode == 256) {
                try {
                    this.maxProblems = Integer.parseInt(currentArg);
                    if (this.maxProblems <= 0) {
                        throw new InvalidInputException(Main.bind("configure.maxProblems", currentArg));
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.maxProblemPerUnit", currentArg);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidInputException(Main.bind("configure.maxProblems", currentArg));
                }
                mode = 0;
                continue;
            }
            if (mode == 32) {
                if (didSpecifySource) {
                    throw new InvalidInputException(Main.bind("configure.duplicateSource", currentArg));
                }
                didSpecifySource = true;
                if (currentArg.equals("1.3")) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                } else if (currentArg.equals("1.4")) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.4");
                } else if (currentArg.equals("1.5") || currentArg.equals("5") || currentArg.equals("5.0")) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                } else {
                    throw new InvalidInputException(Main.bind("configure.source", currentArg));
                }
                mode = 0;
                continue;
            }
            if (mode == 64) {
                if (didSpecifyDefaultEncoding) {
                    throw new InvalidInputException(Main.bind("configure.duplicateDefaultEncoding", currentArg));
                }
                try {
                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), currentArg);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new InvalidInputException(Main.bind("configure.unsupportedEncoding", currentArg));
                }
                this.options.put("org.eclipse.jdt.core.encoding", currentArg);
                didSpecifyDefaultEncoding = true;
                mode = 0;
                continue;
            }
            if (mode == 2) {
                this.destinationPath = currentArg;
                mode = 0;
                continue;
            }
            if (mode == 1 || mode == 128 || mode == 1024) {
                StringTokenizer tokenizer = new StringTokenizer(currentArg, String.valueOf(File.pathSeparator) + "[]", true);
                int state = 0;
                String token = null;
                while (tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken();
                    if (token.equals(File.pathSeparator)) {
                        switch (state) {
                            case 0: {
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: {
                                state = 3;
                                this.addNewEntry(1, 1024, bootclasspaths, classpaths, sourcepathClasspaths, currentClasspathName, currentRuleSpecs, mode, customEncoding);
                                break;
                            }
                            case 6: {
                                state = 4;
                                break;
                            }
                            default: {
                                state = 99;
                                break;
                            }
                        }
                        continue;
                    }
                    if (token.equals("[")) {
                        switch (state) {
                            case 1: {
                                state = 5;
                                break;
                            }
                            default: {
                                state = 99;
                                break;
                            }
                        }
                        continue;
                    }
                    if (token.equals("]")) {
                        switch (state) {
                            case 6: {
                                state = 2;
                                break;
                            }
                            default: {
                                state = 99;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (state) {
                        case 0: 
                        case 3: {
                            state = 1;
                            currentClasspathName = token;
                            break;
                        }
                        case 4: 
                        case 5: {
                            state = 6;
                            currentRuleSpecs.add(token);
                            break;
                        }
                        default: {
                            state = 99;
                        }
                    }
                }
                switch (state) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.addNewEntry(1, 1024, bootclasspaths, classpaths, sourcepathClasspaths, currentClasspathName, currentRuleSpecs, mode, customEncoding);
                        break;
                    }
                    default: {
                        this.logger.logIncorrectClasspath(currentArg);
                    }
                }
                mode = 0;
                continue;
            }
            if (mode == 512) {
                StringTokenizer tokenizer = new StringTokenizer(currentArg, File.pathSeparator, false);
                while (tokenizer.hasMoreTokens()) {
                    extdirsNames.add(tokenizer.nextToken());
                }
                if (extdirsNames.size() == 0) {
                    extdirsNames.add("");
                }
                mode = 0;
                continue;
            }
            if ((currentArg = currentArg.replace('/', File.separatorChar)).endsWith(File.separator)) {
                currentArg = currentArg.substring(0, currentArg.length() - File.separator.length());
            }
            if (!(dir = new File(currentArg)).isDirectory()) {
                throw new InvalidInputException(Main.bind("configure.directoryNotExist", currentArg));
            }
            FileFinder finder = new FileFinder();
            try {
                finder.find(dir, ".JAVA", this.verbose);
            }
            catch (Exception exception) {
                throw new InvalidInputException(Main.bind("configure.IOError", currentArg));
            }
            if (this.filenames != null) {
                String[] results = finder.resultFiles;
                int length = results.length;
                this.filenames = new String[length + filesCount];
                System.arraycopy(this.filenames, 0, this.filenames, 0, filesCount);
                this.encodings = new String[length + filesCount];
                System.arraycopy(this.encodings, 0, this.encodings, 0, filesCount);
                System.arraycopy(results, 0, this.filenames, filesCount, length);
                int i3 = 0;
                while (i3 < length) {
                    this.encodings[filesCount + i3] = customEncoding;
                    ++i3;
                }
                filesCount += length;
                customEncoding = null;
            } else {
                this.filenames = finder.resultFiles;
                filesCount = this.filenames.length;
                this.encodings = new String[filesCount];
                int i4 = 0;
                while (i4 < filesCount) {
                    this.encodings[i4] = customEncoding;
                    ++i4;
                }
                customEncoding = null;
            }
            mode = 0;
        }
        if (this.log != null) {
            this.logger.setLog(this.log);
        } else {
            this.showProgress = false;
        }
        if (printUsageRequired || filesCount == 0) {
            this.printUsage();
            this.proceed = false;
            return;
        }
        if (printVersionRequired) {
            this.printVersion();
        }
        if (filesCount != 0) {
            this.filenames = new String[filesCount];
            System.arraycopy(this.filenames, 0, this.filenames, 0, filesCount);
        }
        if (classpaths.size() == 0) {
            String classProp = System.getProperty("java.class.path");
            if (classProp == null || classProp.length() == 0) {
                this.logger.logNoClasspath();
            } else {
                StringTokenizer tokenizer = new StringTokenizer(classProp, File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    FileSystem.Classpath currentClasspath = FileSystem.getClasspath(token, customEncoding, 0, null);
                    if (currentClasspath != null) {
                        classpaths.add(currentClasspath);
                        continue;
                    }
                    this.logger.logIncorrectClasspath(token);
                }
            }
        }
        if (bootclasspaths.size() == 0) {
            File[] directoriesToCheck;
            File[][] systemLibrariesJars;
            String javaversion = System.getProperty("java.version");
            if (javaversion != null && javaversion.equalsIgnoreCase("1.1.8")) {
                this.logger.logWrongJDK();
                this.proceed = false;
                return;
            }
            if (this.getJavaHome() != null && (systemLibrariesJars = this.getLibrariesFiles(directoriesToCheck = new File[]{new File(this.getJavaHome(), "lib")})) != null) {
                int i5 = 0;
                int max = systemLibrariesJars.length;
                while (i5 < max) {
                    File[] current = systemLibrariesJars[i5];
                    if (current != null) {
                        int j = 0;
                        int max2 = current.length;
                        while (j < max2) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(current[j].getAbsolutePath(), null, 0, null);
                            if (classpath != null) {
                                bootclasspaths.add(classpath);
                            }
                            ++j;
                        }
                    }
                    ++i5;
                }
            }
        }
        if (extdirsNames.size() == 0) {
            String extdirsStr = System.getProperty("java.ext.dirs");
            if (extdirsStr == null) {
                extdirsNames.add(String.valueOf(this.getJavaHome().getAbsolutePath()) + "/lib/ext");
            } else {
                StringTokenizer tokenizer = new StringTokenizer(extdirsStr, File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    extdirsNames.add(tokenizer.nextToken());
                }
            }
        }
        if (extdirsNames.size() != 0) {
            File[] directoriesToCheck = new File[extdirsNames.size()];
            int i6 = 0;
            while (i6 < directoriesToCheck.length) {
                directoriesToCheck[i6] = new File((String)extdirsNames.get(i6));
                ++i6;
            }
            File[][] extdirsJars = this.getLibrariesFiles(directoriesToCheck);
            if (extdirsJars != null) {
                int i7 = 0;
                int max = extdirsJars.length;
                while (i7 < max) {
                    File[] current = extdirsJars[i7];
                    if (current != null) {
                        int j = 0;
                        int max2 = current.length;
                        while (j < max2) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(current[j].getAbsolutePath(), null, 0, null);
                            if (classpath != null) {
                                extdirsClasspaths.add(classpath);
                            }
                            ++j;
                        }
                    }
                    ++i7;
                }
            }
        }
        bootclasspaths.addAll(extdirsClasspaths);
        bootclasspaths.addAll(sourcepathClasspaths);
        bootclasspaths.addAll(classpaths);
        classpaths = bootclasspaths;
        this.checkedClasspaths = new FileSystem.Classpath[classpaths.size()];
        classpaths.toArray(this.checkedClasspaths);
        if (this.destinationPath == null) {
            this.generatePackagesStructure = false;
        } else if ("none".equals(this.destinationPath)) {
            this.destinationPath = null;
        }
        if (didSpecifyCompliance) {
            Object version = this.options.get("org.eclipse.jdt.core.compiler.compliance");
            if ("1.3".equals(version)) {
                if (!didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                }
                if (!didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                }
            } else if ("1.4".equals(version)) {
                if (!didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                }
                if (!didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                }
            } else if ("1.5".equals(version)) {
                if (!didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                }
                if (!didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            }
        }
        if (didSpecifySource) {
            Object version = this.options.get("org.eclipse.jdt.core.compiler.source");
            if ("1.4".equals(version)) {
                if (!didSpecifyCompliance) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                }
                if (!didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                }
            } else if ("1.5".equals(version)) {
                if (!didSpecifyCompliance) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                }
                if (!didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            }
        }
        if (didSpecifyTarget) {
            if (CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.source")) >= 0x310000L && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform")) < 0x310000L) {
                throw new InvalidInputException(Main.bind("configure.incompatibleTargetForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform"), "1.5"));
            }
            if (CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.source")) >= 0x300000L && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform")) < 0x300000L) {
                throw new InvalidInputException(Main.bind("configure.incompatibleTargetForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform"), "1.4"));
            }
            if (CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) < CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform"))) {
                throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForTarget", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), (String)this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform")));
            }
        }
        if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.5") && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) < 0x310000L) {
            throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.5"));
        }
        if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.4") && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) < 0x300000L) {
            throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.4"));
        }
        if (!didSpecifyTarget) {
            if (this.options.get("org.eclipse.jdt.core.compiler.compliance").equals("1.3")) {
                this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
            } else if (this.options.get("org.eclipse.jdt.core.compiler.compliance").equals("1.4")) {
                if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.3")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                } else if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.4")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                }
            } else if (this.options.get("org.eclipse.jdt.core.compiler.compliance").equals("1.5")) {
                if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.3")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                } else if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.4")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                } else if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.5")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            }
        }
        this.logger.logCommandLineArguments(newCommandLineArgs);
        this.logger.logOptions(this.options);
        this.logger.logClasspath(this.checkedClasspaths);
        if (this.repetitions == 0) {
            this.repetitions = 1;
        }
        if (this.repetitions >= 3 && this.timing) {
            this.times = new long[this.repetitions];
            this.timesCounter = 0;
        }
    }

    private void addNewEntry(int InsideClasspath, int InsideSourcepath, ArrayList bootclasspaths, ArrayList classpaths, ArrayList sourcepathClasspaths, String currentClasspathName, ArrayList currentRuleSpecs, int mode, String customEncoding) {
        AccessRule[] accessRules = new AccessRule[currentRuleSpecs.size()];
        boolean rulesOK = true;
        Iterator i = currentRuleSpecs.iterator();
        int j = 0;
        while (i.hasNext()) {
            String ruleSpec = (String)i.next();
            char key = ruleSpec.charAt(0);
            String pattern = ruleSpec.substring(1);
            if (pattern.length() > 0) {
                switch (key) {
                    case '+': {
                        accessRules[j++] = new AccessRule(pattern.toCharArray(), -1);
                        break;
                    }
                    case '~': {
                        accessRules[j++] = new AccessRule(pattern.toCharArray(), 0x1000118);
                        break;
                    }
                    case '-': {
                        accessRules[j++] = new AccessRule(pattern.toCharArray(), 0x1000133);
                        break;
                    }
                    default: {
                        rulesOK = false;
                        break;
                    }
                }
                continue;
            }
            rulesOK = false;
        }
        if (rulesOK) {
            AccessRuleSet accessRuleSet = new AccessRuleSet(accessRules, "{0}");
            FileSystem.Classpath currentClasspath = FileSystem.getClasspath(currentClasspathName, customEncoding, 0, accessRuleSet);
            if (currentClasspath != null) {
                if (mode == InsideClasspath) {
                    classpaths.add(currentClasspath);
                } else if (mode == InsideSourcepath) {
                    if (currentClasspath instanceof ClasspathDirectory) {
                        ((ClasspathDirectory)currentClasspath).mode = 1;
                    }
                    sourcepathClasspaths.add(currentClasspath);
                } else {
                    bootclasspaths.add(currentClasspath);
                }
            } else {
                this.logger.logIncorrectClasspath(currentClasspathName);
            }
        } else {
            this.logger.logIncorrectClasspath(currentClasspathName);
        }
    }

    private File getJavaHome() {
        if (!this.javaHomeChecked) {
            this.javaHomeChecked = true;
            String javaHome = System.getProperty("java.home");
            if (javaHome != null) {
                this.javaHomeCache = new File(javaHome);
                if (!this.javaHomeCache.exists()) {
                    this.javaHomeCache = null;
                }
            }
        }
        return this.javaHomeCache;
    }

    private void disableWarnings() {
        Object[] entries = this.options.entrySet().toArray();
        int i = 0;
        int max = entries.length;
        while (i < max) {
            Map.Entry entry = (Map.Entry)entries[i];
            if (entry.getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getValue()).equals("warning")) {
                this.options.put(entry.getKey(), "ignore");
            }
            ++i;
        }
        this.options.put("org.eclipse.jdt.core.compiler.taskTags", "");
    }

    public String extractDestinationPathFromSourceFile(CompilationResult result) {
        ICompilationUnit compilationUnit = result.compilationUnit;
        if (compilationUnit != null) {
            char[] fileName = compilationUnit.getFileName();
            int lastIndex = CharOperation.lastIndexOf(File.separatorChar, fileName);
            if (lastIndex == -1) {
                return System.getProperty("user.dir");
            }
            return new String(fileName, 0, lastIndex);
        }
        return System.getProperty("user.dir");
    }

    public ICompilerRequestor getBatchRequestor() {
        return new ICompilerRequestor(){
            int lineDelta = 0;

            public void acceptResult(CompilationResult compilationResult) {
                if (compilationResult.lineSeparatorPositions != null) {
                    int unitLineCount = compilationResult.lineSeparatorPositions.length;
                    Main.this.lineCount += (long)unitLineCount;
                    this.lineDelta += unitLineCount;
                    if (Main.this.showProgress && this.lineDelta > 2000) {
                        Main.this.logger.logProgress();
                        this.lineDelta = 0;
                    }
                }
                Main.this.logger.startLoggingSource(compilationResult);
                if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
                    int localErrorCount = Main.this.logger.logProblems(compilationResult.getAllProblems(), compilationResult.compilationUnit.getContents(), Main.this);
                    if (Main.this.systemExitWhenFinished && !Main.this.proceedOnError && localErrorCount > 0) {
                        Main.this.logger.endLoggingSource();
                        Main.this.logger.endLoggingSources();
                        Main.this.logger.printStats(Main.this);
                        Main.this.logger.flush();
                        Main.this.logger.close();
                        System.exit(-1);
                    }
                }
                Main.this.outputClassFiles(compilationResult);
                Main.this.logger.endLoggingSource();
            }
        };
    }

    public CompilationUnit[] getCompilationUnits() throws InvalidInputException {
        int fileCount = this.filenames.length;
        CompilationUnit[] units = new CompilationUnit[fileCount];
        HashtableOfObject knownFileNames = new HashtableOfObject(fileCount);
        String defaultEncoding = (String)this.options.get("org.eclipse.jdt.core.encoding");
        if ("".equals(defaultEncoding)) {
            defaultEncoding = null;
        }
        int i = 0;
        while (i < fileCount) {
            char[] charName = this.filenames[i].toCharArray();
            if (knownFileNames.get(charName) != null) {
                throw new InvalidInputException(Main.bind("unit.more", this.filenames[i]));
            }
            knownFileNames.put(charName, charName);
            File file = new File(this.filenames[i]);
            if (!file.exists()) {
                throw new InvalidInputException(Main.bind("unit.missing", this.filenames[i]));
            }
            String encoding = this.encodings[i];
            if (encoding == null) {
                encoding = defaultEncoding;
            }
            units[i] = new CompilationUnit(null, this.filenames[i], encoding);
            ++i;
        }
        return units;
    }

    private File[][] getLibrariesFiles(File[] files) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                String lowerCaseName = name.toLowerCase();
                return lowerCaseName.endsWith(".jar") || lowerCaseName.endsWith(".zip");
            }
        };
        int filesLength = files.length;
        File[][] result = new File[filesLength][];
        int i = 0;
        while (i < filesLength) {
            File currentFile = files[i];
            if (currentFile.exists() && currentFile.isDirectory()) {
                result[i] = currentFile.listFiles(filter);
            }
            ++i;
        }
        return result;
    }

    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return Main.this.proceedOnError;
            }

            public boolean stopOnFirstError() {
                return false;
            }
        };
    }

    public FileSystem getLibraryAccess() {
        String defaultEncoding = (String)this.options.get("org.eclipse.jdt.core.encoding");
        if ("".equals(defaultEncoding)) {
            defaultEncoding = null;
        }
        return new FileSystem(this.checkedClasspaths, this.filenames);
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(Locale.getDefault());
    }

    public void outputClassFiles(CompilationResult unitResult) {
        if (unitResult != null && (!unitResult.hasErrors() || this.proceedOnError)) {
            ClassFile[] classFiles = unitResult.getClassFiles();
            if (!this.generatePackagesStructure) {
                this.destinationPath = this.extractDestinationPathFromSourceFile(unitResult);
            }
            if (this.destinationPath != null) {
                int i = 0;
                int fileCount = classFiles.length;
                while (i < fileCount) {
                    ClassFile classFile = classFiles[i];
                    char[] filename = classFile.fileName();
                    int length = filename.length;
                    char[] relativeName = new char[length + 6];
                    System.arraycopy(filename, 0, relativeName, 0, length);
                    System.arraycopy(SUFFIX_class, 0, relativeName, length, 6);
                    CharOperation.replace(relativeName, '/', File.separatorChar);
                    String relativeStringName = new String(relativeName);
                    try {
                        if (this.compilerOptions.verbose) {
                            System.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), relativeStringName}));
                        }
                        ClassFile.writeToDisk(this.generatePackagesStructure, this.destinationPath, relativeStringName, classFile.getBytes());
                        this.logger.logClassFile(this.generatePackagesStructure, this.destinationPath, relativeStringName);
                    }
                    catch (IOException e) {
                        String fileName = String.valueOf(this.destinationPath) + relativeStringName;
                        e.printStackTrace();
                        this.logger.logNoClassFileCreated(fileName);
                    }
                    ++this.exportedClassFilesCounter;
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performCompilation() throws InvalidInputException {
        this.startTime = System.currentTimeMillis();
        FileSystem environment = this.getLibraryAccess();
        Compiler batchCompiler = new Compiler(environment, this.getHandlingPolicy(), this.options, this.getBatchRequestor(), this.getProblemFactory());
        this.compilerOptions = batchCompiler.options;
        this.compilerOptions.verbose = this.verbose;
        this.compilerOptions.produceReferenceInfo = this.produceRefInfo;
        try {
            this.logger.startLoggingSources();
            batchCompiler.compile(this.getCompilationUnits());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.logger.endLoggingSources();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.logger.endLoggingSources();
            this.logger.printStats(this);
            environment.cleanup();
            return;
        }
    }

    public void printUsage() {
        this.logger.logUsage(Main.bind("misc.usage", new String[]{System.getProperty("path.separator"), Main.bind("compiler.name"), Main.bind("compiler.version"), Main.bind("compiler.copyright")}));
        this.logger.flush();
    }

    public void printVersion() {
        this.logger.logVersion();
        this.logger.flush();
    }

    public static class Logger {
        private static final String CLASS = "class";
        private static final String CLASS_FILE = "classfile";
        private static final String CLASSPATH = "classpath";
        private static final String CLASSPATH_ID = "id";
        private static final String CLASSPATH_FILE = "FILE";
        private static final String CLASSPATH_FOLDER = "FOLDER";
        private static final String CLASSPATH_JAR = "JAR";
        private static final String CLASSPATHS = "classpaths";
        private static final String COMMAND_LINE_ARGUMENT = "argument";
        private static final String COMMAND_LINE_ARGUMENTS = "command_line";
        private static final String COMPILER = "compiler";
        private static final String COMPILER_COPYRIGHT = "copyright";
        private static final String COMPILER_VERSION = "version";
        private static final String COMPILER_NAME = "name";
        private static final String EXCEPTION = "exception";
        private static final String ERROR = "ERROR";
        private static final String ERROR_TAG = "error";
        private static final String KEY = "key";
        private static final String MESSAGE = "message";
        private static final String NUMBER_OF_CLASSFILES = "number_of_classfiles";
        private static final String NUMBER_OF_ERRORS = "errors";
        private static final String NUMBER_OF_LINES = "number_of_lines";
        private static final String NUMBER_OF_PROBLEMS = "problems";
        private static final String NUMBER_OF_TASKS = "tasks";
        private static final String NUMBER_OF_WARNINGS = "warnings";
        private static final String OPTION = "option";
        private static final String OPTIONS = "options";
        private static final String PATH = "path";
        private static final String PROBLEM_ARGUMENT = "argument";
        private static final String PROBLEM_ARGUMENT_VALUE = "value";
        private static final String PROBLEM_ARGUMENTS = "arguments";
        private static final String PROBLEM_ID = "id";
        private static final String PROBLEM_LINE = "line";
        private static final String PROBLEM_MESSAGE = "message";
        private static final String PROBLEM_SEVERITY = "severity";
        private static final String PROBLEM_SOURCE_START = "charStart";
        private static final String PROBLEM_SOURCE_END = "charEnd";
        private static final String PROBLEM_SUMMARY = "problem_summary";
        private static final String PROBLEM_TAG = "problem";
        private static final String PROBLEMS = "problems";
        private static final String SOURCE = "source";
        private static final String SOURCE_CONTEXT = "source_context";
        private static final String SOURCE_END = "sourceEnd";
        private static final String SOURCE_START = "sourceStart";
        private static final String SOURCES = "sources";
        private static final String STATS = "stats";
        private static final String TASK = "task";
        private static final String TASKS = "tasks";
        private static final String TIME = "time";
        private static final String VALUE = "value";
        private static final String WARNING = "WARNING";
        private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        private static final String XML_DTD_DECLARATION = "<!DOCTYPE compiler SYSTEM \"compiler.dtd\">";
        private static final HashMap FIELD_TABLE = new HashMap();
        private PrintWriter err;
        boolean isXml;
        private PrintWriter log;
        private PrintWriter out;
        private int tab;
        private HashMap parameters;
        static /* synthetic */ Class class$0;

        static {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.compiler.IProblem");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class<?> c = clazz;
                Field[] fields = c.getFields();
                int i = 0;
                int max = fields.length;
                while (i < max) {
                    Field field = fields[i];
                    FIELD_TABLE.put(field.get(null), field.getName());
                    ++i;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        private static void appendEscapedChar(StringBuffer buffer, char c) {
            String replacement = Logger.getReplacement(c);
            if (replacement != null) {
                buffer.append('&');
                buffer.append(replacement);
                buffer.append(';');
            } else {
                buffer.append(c);
            }
        }

        private static String getEscaped(String s) {
            StringBuffer result = new StringBuffer(s.length() + 10);
            int i = 0;
            while (i < s.length()) {
                Logger.appendEscapedChar(result, s.charAt(i));
                ++i;
            }
            return result.toString();
        }

        private static String getReplacement(char c) {
            switch (c) {
                case '<': {
                    return "lt";
                }
                case '>': {
                    return "gt";
                }
                case '\"': {
                    return "quot";
                }
                case '\'': {
                    return "apos";
                }
                case '&': {
                    return "amp";
                }
            }
            return null;
        }

        public Logger(PrintWriter out, PrintWriter err) {
            this.out = out;
            this.err = err;
            this.isXml = false;
            this.parameters = new HashMap();
        }

        public String buildFileName(String outputPath, String relativeFileName) {
            char fileSeparatorChar = File.separatorChar;
            String fileSeparator = File.separator;
            outputPath = outputPath.replace('/', fileSeparatorChar);
            StringBuffer outDir = new StringBuffer(outputPath);
            if (!outputPath.endsWith(fileSeparator)) {
                outDir.append(fileSeparator);
            }
            StringTokenizer tokenizer = new StringTokenizer(relativeFileName, fileSeparator);
            String token = tokenizer.nextToken();
            while (tokenizer.hasMoreTokens()) {
                outDir.append(token).append(fileSeparator);
                token = tokenizer.nextToken();
            }
            return outDir.append(token).toString();
        }

        public void close() {
            if (this.log != null) {
                if (this.isXml) {
                    this.endTag(COMPILER);
                    this.flush();
                }
                this.log.close();
            }
        }

        public void compiling() {
            this.printlnOut(Main.bind("progress.compiling"));
        }

        private void endLoggingProblems() {
            this.endTag("problems");
        }

        public void endLoggingSource() {
            if (this.isXml) {
                this.endTag(SOURCE);
            }
        }

        public void endLoggingSources() {
            if (this.isXml) {
                this.endTag(SOURCES);
            }
        }

        public void endLoggingTasks() {
            if (this.isXml) {
                this.endTag("tasks");
            }
        }

        public void endTag(String name) {
            --this.tab;
            this.printTag(String.valueOf('/') + name, null, true, false);
            --this.tab;
        }

        private void extractContext(IProblem problem, char[] unitSource) {
            char c;
            int endPosition;
            int startPosition = problem.getSourceStart();
            if (startPosition > (endPosition = problem.getSourceEnd()) || startPosition < 0 && endPosition < 0) {
                this.parameters.put("value", Messages.problem_noSourceInformation);
                this.parameters.put(SOURCE_START, "-1");
                this.parameters.put(SOURCE_END, "-1");
                return;
            }
            int length = unitSource.length;
            int begin = startPosition >= length ? length - 1 : startPosition;
            while (begin > 0) {
                c = unitSource[begin - 1];
                if (c == '\n' || c == '\r') break;
                --begin;
            }
            int end = endPosition >= length ? length - 1 : endPosition;
            while (end + 1 < length) {
                c = unitSource[end + 1];
                if (c == '\r' || c == '\n') break;
                ++end;
            }
            while ((c = unitSource[begin]) == ' ' || c == '\t') {
                ++begin;
            }
            while ((c = unitSource[end]) == ' ' || c == '\t') {
                --end;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(unitSource, begin, end - begin + 1);
            this.parameters.put("value", String.valueOf(buffer));
            this.parameters.put(SOURCE_START, Integer.toString(startPosition - begin));
            this.parameters.put(SOURCE_END, Integer.toString(endPosition - begin));
        }

        private String getFieldName(int id) {
            return (String)FIELD_TABLE.get(new Integer(id));
        }

        public void flush() {
            this.out.flush();
            this.err.flush();
            if (this.log != null) {
                this.log.flush();
            }
        }

        public void logAverage(long[] times, long lineCount) {
            Arrays.sort(times);
            int length = times.length;
            long sum = 0L;
            int i = 1;
            int max = length - 1;
            while (i < max) {
                sum += times[i];
                ++i;
            }
            long time = sum / (long)(length - 2);
            this.printlnOut(Main.bind("compile.averageTime", new String[]{String.valueOf(lineCount), String.valueOf(time), String.valueOf((double)((int)((double)lineCount * 10000.0 / (double)time)) / 10.0)}));
        }

        public void logClasspath(FileSystem.Classpath[] classpaths) {
            int length;
            if (classpaths == null) {
                return;
            }
            if (this.isXml && (length = classpaths.length) != 0) {
                this.printTag(CLASSPATHS, null, true, false);
                int i = 0;
                while (i < length) {
                    this.parameters.clear();
                    String classpath = classpaths[i].getPath();
                    this.parameters.put(PATH, classpath);
                    File f = new File(classpath);
                    String id = null;
                    if (f.isFile()) {
                        id = Util.isArchiveFileName(classpath) ? CLASSPATH_JAR : CLASSPATH_FILE;
                    } else if (f.isDirectory()) {
                        id = CLASSPATH_FOLDER;
                    }
                    if (id != null) {
                        this.parameters.put("id", id);
                        this.printTag(CLASSPATH, this.parameters, true, true);
                    }
                    ++i;
                }
                this.endTag(CLASSPATHS);
            }
        }

        public void logClassFile(boolean generatePackagesStructure, String outputPath, String relativeFileName) {
            if (this.isXml) {
                String fileName = null;
                if (generatePackagesStructure) {
                    fileName = this.buildFileName(outputPath, relativeFileName);
                } else {
                    char fileSeparatorChar = File.separatorChar;
                    String fileSeparator = File.separator;
                    outputPath = outputPath.replace('/', fileSeparatorChar);
                    int indexOfPackageSeparator = relativeFileName.lastIndexOf(fileSeparatorChar);
                    if (indexOfPackageSeparator == -1) {
                        fileName = outputPath.endsWith(fileSeparator) ? String.valueOf(outputPath) + relativeFileName : String.valueOf(outputPath) + fileSeparator + relativeFileName;
                    } else {
                        int length = relativeFileName.length();
                        fileName = outputPath.endsWith(fileSeparator) ? String.valueOf(outputPath) + relativeFileName.substring(indexOfPackageSeparator + 1, length) : String.valueOf(outputPath) + fileSeparator + relativeFileName.substring(indexOfPackageSeparator + 1, length);
                    }
                }
                File f = new File(fileName);
                try {
                    this.parameters.clear();
                    this.parameters.put(PATH, f.getCanonicalPath());
                    this.printTag(CLASS_FILE, this.parameters, true, true);
                }
                catch (IOException iOException) {
                    this.logNoClassFileCreated(fileName);
                }
            }
        }

        public void logCommandLineArguments(String[] commandLineArguments) {
            int length;
            if (commandLineArguments == null) {
                return;
            }
            if (this.isXml && (length = commandLineArguments.length) != 0) {
                this.printTag(COMMAND_LINE_ARGUMENTS, null, true, false);
                this.parameters.clear();
                int i = 0;
                while (i < length) {
                    this.parameters.put("value", commandLineArguments[i]);
                    this.printTag("argument", this.parameters, true, true);
                    ++i;
                }
                this.endTag(COMMAND_LINE_ARGUMENTS);
            }
        }

        public void logException(Exception e) {
            String message = e.getMessage();
            if (this.isXml) {
                this.parameters.clear();
                this.parameters.put("message", message);
                this.parameters.put(CLASS, e.getClass());
                this.printTag(EXCEPTION, this.parameters, true, true);
            }
            this.printlnErr(message);
        }

        public void logIncorrectClasspath(String wrongClasspath) {
            if (this.isXml) {
                this.parameters.clear();
                this.parameters.put("message", Main.bind("configure.incorrectClasspath", wrongClasspath));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(Main.bind("configure.incorrectClasspath", wrongClasspath));
        }

        public void logNoClassFileCreated(String fileName) {
            if (this.isXml) {
                this.parameters.clear();
                this.parameters.put("message", Main.bind("output.noClassFileCreated", fileName));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(Main.bind("output.noClassFileCreated", fileName));
        }

        public void logNoClasspath() {
            if (this.isXml) {
                this.parameters.clear();
                this.parameters.put("message", Main.bind("configure.noClasspath"));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(Main.bind("configure.noClasspath"));
        }

        public void logNumberOfClassFilesGenerated(int exportedClassFilesCounter) {
            if (this.isXml) {
                this.parameters.clear();
                this.parameters.put("value", new Integer(exportedClassFilesCounter));
                this.printTag(NUMBER_OF_CLASSFILES, this.parameters, true, true);
            }
            if (exportedClassFilesCounter == 1) {
                this.printlnOut(Main.bind("compile.oneClassFileGenerated"));
            } else {
                this.printlnOut(Main.bind("compile.severalClassFilesGenerated", String.valueOf(exportedClassFilesCounter)));
            }
        }

        public void logOptions(Map options) {
            if (this.isXml) {
                this.printTag(OPTIONS, null, true, false);
                Set keySet = options.keySet();
                Object[] keys = keySet.toArray();
                Arrays.sort(keys);
                int i = 0;
                int max = keys.length;
                while (i < max) {
                    this.parameters.clear();
                    Object key = keys[i];
                    this.parameters.put(KEY, key);
                    this.parameters.put("value", options.get(key));
                    this.printTag(OPTION, this.parameters, true, true);
                    ++i;
                }
                this.endTag(OPTIONS);
            }
        }

        private void logProblem(IProblem problem, int localErrorCount, int globalErrorCount, char[] unitSource) {
            if (localErrorCount == 0) {
                this.printlnErr("----------");
            }
            this.printlnErr(problem.isError() ? Main.bind("requestor.error", Integer.toString(globalErrorCount), new String(problem.getOriginatingFileName())) : Main.bind("requestor.warning", Integer.toString(globalErrorCount), new String(problem.getOriginatingFileName())));
            try {
                this.printlnErr(((DefaultProblem)problem).errorReportSource(unitSource));
                this.printlnErr(problem.getMessage());
            }
            catch (Exception exception) {
                this.printlnErr(Main.bind("requestor.notRetrieveErrorMessage", problem.toString()));
            }
            this.printlnErr("----------");
        }

        public void logProblemsSummary(int globalProblemsCount, int globalErrorsCount, int globalWarningsCount, int globalTasksCount) {
            if (this.isXml) {
                this.parameters.clear();
                this.parameters.put("problems", new Integer(globalProblemsCount));
                this.parameters.put(NUMBER_OF_ERRORS, new Integer(globalErrorsCount));
                this.parameters.put(NUMBER_OF_WARNINGS, new Integer(globalWarningsCount));
                this.parameters.put("tasks", new Integer(globalTasksCount));
                this.printTag(PROBLEM_SUMMARY, this.parameters, true, true);
            }
            if (globalProblemsCount == 1) {
                String message = null;
                message = globalErrorsCount == 1 ? Main.bind("compile.oneError") : Main.bind("compile.oneWarning");
                this.printErr(Main.bind("compile.oneProblem", message));
            } else {
                int warningsNumber;
                String errorMessage = null;
                String warningMessage = null;
                if (globalErrorsCount > 0) {
                    errorMessage = globalErrorsCount == 1 ? Main.bind("compile.oneError") : Main.bind("compile.severalErrors", String.valueOf(globalErrorsCount));
                }
                if ((warningsNumber = globalWarningsCount + globalTasksCount) > 0) {
                    warningMessage = warningsNumber == 1 ? Main.bind("compile.oneWarning") : Main.bind("compile.severalWarnings", String.valueOf(warningsNumber));
                }
                if (errorMessage == null || warningMessage == null) {
                    if (errorMessage == null) {
                        this.printErr(Main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(globalProblemsCount), warningMessage));
                    } else {
                        this.printErr(Main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(globalProblemsCount), errorMessage));
                    }
                } else {
                    this.printErr(Main.bind("compile.severalProblemsErrorsAndWarnings", new String[]{String.valueOf(globalProblemsCount), errorMessage, warningMessage}));
                }
            }
        }

        public int logProblems(IProblem[] problems, char[] unitSource, Main currentMain) {
            int count = problems.length;
            int localErrorCount = 0;
            if (count != 0) {
                if (this.isXml) {
                    IProblem problem;
                    int errors = 0;
                    int warnings = 0;
                    int tasks = 0;
                    int i = 0;
                    while (i < count) {
                        problem = problems[i];
                        if (problem != null) {
                            ++currentMain.globalProblemsCount;
                            this.logProblem(problem, localErrorCount, currentMain.globalProblemsCount, unitSource);
                            if (problem.isError()) {
                                ++errors;
                                ++currentMain.globalErrorsCount;
                                ++localErrorCount;
                            } else if (problem.getID() == 536871362) {
                                ++currentMain.globalTasksCount;
                                ++tasks;
                            } else {
                                ++currentMain.globalWarningsCount;
                                ++warnings;
                            }
                        }
                        ++i;
                    }
                    if (errors + warnings != 0) {
                        this.startLoggingProblems(errors, warnings);
                        i = 0;
                        while (i < count) {
                            problem = problems[i];
                            if (problem != null && problem.getID() != 536871362) {
                                this.logXmlProblem(problem, unitSource);
                            }
                            ++i;
                        }
                        this.endLoggingProblems();
                    }
                    if (tasks != 0) {
                        this.startLoggingTasks(tasks);
                        i = 0;
                        while (i < count) {
                            problem = problems[i];
                            if (problem != null && problem.getID() == 536871362) {
                                this.logXmlTask(problem, unitSource);
                            }
                            ++i;
                        }
                        this.endLoggingTasks();
                    }
                } else {
                    int i = 0;
                    while (i < count) {
                        if (problems[i] != null) {
                            ++currentMain.globalProblemsCount;
                            this.logProblem(problems[i], localErrorCount, currentMain.globalProblemsCount, unitSource);
                            if (problems[i].isError()) {
                                ++currentMain.globalErrorsCount;
                                ++localErrorCount;
                            } else {
                                ++currentMain.globalWarningsCount;
                            }
                        }
                        ++i;
                    }
                }
            }
            return localErrorCount;
        }

        public void logProgress() {
            this.printOut('.');
        }

        public void logRepetition(int i, int repetitions) {
            this.printlnOut(Main.bind("compile.repetition", String.valueOf(i + 1), String.valueOf(repetitions)));
        }

        public void printStats(Main main) {
            boolean isTimed = main.timing;
            if (this.isXml) {
                this.printTag(STATS, null, true, false);
            }
            if (isTimed) {
                long time = System.currentTimeMillis() - main.startTime;
                this.logTiming(time, main.lineCount);
                if (main.times != null) {
                    main.times[main.timesCounter++] = time;
                }
            }
            if (main.globalProblemsCount > 0) {
                this.logProblemsSummary(main.globalProblemsCount, main.globalErrorsCount, main.globalWarningsCount, main.globalTasksCount);
            }
            if (main.exportedClassFilesCounter != 0 && (main.showProgress || isTimed || main.verbose)) {
                this.logNumberOfClassFilesGenerated(main.exportedClassFilesCounter);
            }
            if (this.isXml) {
                this.endTag(STATS);
            }
        }

        public void logTiming(long time, long lineCount) {
            if (this.isXml) {
                this.parameters.clear();
                this.parameters.put("value", new Long(time));
                this.printTag(TIME, this.parameters, true, true);
                this.parameters.clear();
                this.parameters.put("value", new Long(lineCount));
                this.printTag(NUMBER_OF_LINES, this.parameters, true, true);
            }
            if (lineCount != 0L) {
                this.printlnOut(Main.bind("compile.instantTime", new String[]{String.valueOf(lineCount), String.valueOf(time), String.valueOf((double)((int)((double)lineCount * 10000.0 / (double)time)) / 10.0)}));
            } else {
                this.printlnOut(Main.bind("compile.totalTime", String.valueOf(time)));
            }
        }

        public void logUsage(String usage) {
            this.printlnOut(usage);
        }

        public void logVersion() {
            this.printlnOut(Main.bind("misc.version", new String[]{Main.bind("compiler.name"), Main.bind("compiler.version"), Main.bind("compiler.copyright")}));
        }

        public void logWrongJDK() {
            if (this.isXml) {
                this.parameters.clear();
                this.parameters.put("message", Main.bind("configure.requiresJDK1.2orAbove"));
                this.printTag(ERROR, this.parameters, true, true);
            }
            this.printlnErr(Main.bind("configure.requiresJDK1.2orAbove"));
        }

        private void logXmlProblem(IProblem problem, char[] unitSource) {
            int sourceStart = problem.getSourceStart();
            int sourceEnd = problem.getSourceEnd();
            this.parameters.clear();
            this.parameters.put("id", this.getFieldName(problem.getID()));
            this.parameters.put(PROBLEM_SEVERITY, problem.isError() ? ERROR : WARNING);
            this.parameters.put(PROBLEM_LINE, new Integer(problem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(sourceStart));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(sourceEnd));
            this.printTag(PROBLEM_TAG, this.parameters, true, false);
            this.parameters.clear();
            this.parameters.put("value", problem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.parameters.clear();
            this.extractContext(problem, unitSource);
            this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
            String[] arguments = problem.getArguments();
            int length = arguments.length;
            if (length != 0) {
                this.printTag(PROBLEM_ARGUMENTS, null, true, false);
                this.parameters.clear();
                int i = 0;
                while (i < length) {
                    this.parameters.put("value", arguments[i]);
                    this.printTag("argument", this.parameters, true, true);
                    ++i;
                }
                this.endTag(PROBLEM_ARGUMENTS);
            }
            this.endTag(PROBLEM_TAG);
        }

        private void logXmlTask(IProblem problem, char[] unitSource) {
            this.parameters.clear();
            this.parameters.put(PROBLEM_LINE, new Integer(problem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(problem.getSourceStart()));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(problem.getSourceEnd()));
            this.printTag(TASK, this.parameters, true, false);
            this.parameters.clear();
            this.parameters.put("value", problem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.parameters.clear();
            this.extractContext(problem, unitSource);
            this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
            this.endTag(TASK);
        }

        private void printErr(String s) {
            this.err.print(s);
            if (!this.isXml && this.log != null) {
                this.log.print(s);
            }
        }

        private void printlnErr(String s) {
            this.err.println(s);
            if (!this.isXml && this.log != null) {
                this.log.println(s);
            }
        }

        private void printlnOut(String s) {
            this.out.println(s);
            if (!this.isXml && this.log != null) {
                this.log.println(s);
            }
        }

        public void printNewLine() {
            this.out.println();
        }

        private void printOut(char c) {
            this.out.print(c);
        }

        public void printTag(String name, HashMap params, boolean insertNewLine, boolean closeTag) {
            int i = this.tab;
            while (i > 0) {
                this.log.print('\t');
                --i;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("<");
            buffer.append(name);
            if (params != null) {
                Enumeration enumeration = Collections.enumeration(params.keySet());
                while (enumeration.hasMoreElements()) {
                    buffer.append(" ");
                    String key = (String)enumeration.nextElement();
                    buffer.append(key);
                    buffer.append("=\"");
                    buffer.append(Logger.getEscaped(String.valueOf(params.get(key))));
                    buffer.append("\"");
                }
            }
            if (closeTag) {
                buffer.append("/>");
            } else {
                buffer.append(">");
                ++this.tab;
            }
            if (insertNewLine) {
                this.log.println(String.valueOf(buffer));
            } else {
                this.log.print(String.valueOf(buffer));
            }
        }

        public void setLog(String logFileName) throws InvalidInputException {
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("d MMM yyyy HH:mm:ss", Locale.getDefault());
            try {
                this.log = new PrintWriter(new FileOutputStream(logFileName, false));
                int index = logFileName.lastIndexOf(46);
                if (index != -1) {
                    if (logFileName.substring(index).toLowerCase().equals(".xml")) {
                        this.isXml = true;
                        this.log.println(XML_HEADER);
                        this.log.println("<!-- " + dateFormat.format(date) + " -->");
                        this.log.println(XML_DTD_DECLARATION);
                        this.tab = 0;
                        this.parameters.clear();
                        this.parameters.put(COMPILER_NAME, Main.bind("compiler.name"));
                        this.parameters.put(COMPILER_VERSION, Main.bind("compiler.version"));
                        this.parameters.put(COMPILER_COPYRIGHT, Main.bind("compiler.copyright"));
                        this.printTag(COMPILER, this.parameters, true, false);
                    } else {
                        this.log.println("# " + dateFormat.format(date));
                    }
                } else {
                    this.log.println("# " + dateFormat.format(date));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new InvalidInputException(Main.bind("configure.cannotOpenLog"));
            }
        }

        private void startLoggingProblems(int errors, int warnings) {
            this.parameters.clear();
            this.parameters.put("problems", new Integer(errors + warnings));
            this.parameters.put(NUMBER_OF_ERRORS, new Integer(errors));
            this.parameters.put(NUMBER_OF_WARNINGS, new Integer(warnings));
            this.printTag("problems", this.parameters, true, false);
        }

        public void startLoggingSource(CompilationResult compilationResult) {
            if (this.isXml) {
                ICompilationUnit compilationUnit = compilationResult.compilationUnit;
                char[] fileName = compilationUnit.getFileName();
                File f = new File(new String(fileName));
                if (fileName != null) {
                    this.parameters.clear();
                    if (compilationUnit != null) {
                        this.parameters.put(PATH, f.getAbsolutePath());
                    }
                }
                this.printTag(SOURCE, this.parameters, true, false);
            }
        }

        public void startLoggingSources() {
            if (this.isXml) {
                this.printTag(SOURCES, null, true, false);
            }
        }

        public void startLoggingTasks(int tasks) {
            if (this.isXml) {
                this.parameters.clear();
                this.parameters.put("tasks", new Integer(tasks));
                this.printTag("tasks", this.parameters, true, false);
            }
        }
    }
}

