/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.Map;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.util.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapMergeChangeListener<K, V>
implements ChangeListener<Map.Entry<K, V>> {
    private final ChangeListener<FileCollectionSnapshot.Merge> listener;
    private final Map<K, V> newSnapshots;

    public MapMergeChangeListener(ChangeListener<FileCollectionSnapshot.Merge> listener, Map<K, V> targetMap) {
        this.listener = listener;
        this.newSnapshots = targetMap;
    }

    @Override
    public void added(Map.Entry<K, V> element) {
        DefaultMerge merge = new DefaultMerge();
        this.listener.added(merge);
        if (!merge.isIgnore()) {
            this.newSnapshots.put(element.getKey(), element.getValue());
        }
    }

    @Override
    public void removed(Map.Entry<K, V> element) {
        DefaultMerge merge = new DefaultMerge();
        this.listener.removed(merge);
        if (!merge.isIgnore()) {
            this.newSnapshots.remove(element.getKey());
        }
    }

    @Override
    public void changed(Map.Entry<K, V> element) {
        DefaultMerge merge = new DefaultMerge();
        this.listener.changed(merge);
        if (!merge.isIgnore()) {
            this.newSnapshots.put(element.getKey(), element.getValue());
        }
    }

    private static class DefaultMerge
    implements FileCollectionSnapshot.Merge {
        private boolean ignore;

        private DefaultMerge() {
        }

        public boolean isIgnore() {
            return this.ignore;
        }

        public void ignore() {
            this.ignore = true;
        }
    }
}

