#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc-citeproc
version: 0.9.1.1
id: pandoc-citeproc-0.9.1.1-1d27415813eae935b120436dc23bd090
key: pando_FR7BIejKllo93qfJu872TX
license: BSD3
maintainer: jgm@berkeley.edu
homepage: https://github.com/jgm/pandoc-citeproc
synopsis: Supports using pandoc with citeproc
description:
    The pandoc-citeproc library exports functions for
    using the citeproc system with pandoc.  It relies on
    citeproc-hs, a library for rendering
    bibliographic reference citations into a variety
    of styles using a macro language called Citation
    Style Language (CSL). More details on CSL can be
    found here: <http://citationstyles.org/>.
    .
    Currently this package includes a heavily revised
    copy of the citeproc-hs code. When citeproc-hs is
    updated to be compatible, this package will simply
    depend on citeproc-hs.
    .
    This package also contains an executable: pandoc-citeproc,
    which works as a pandoc filter, and
    also has a mode for converting bibliographic databases
    a YAML format suitable for inclusion in pandoc YAML
    metadata.
category: Text
author: John MacFarlane, Andrea Rossato
exposed: True
exposed-modules:
    Text.CSL.Pandoc Text.CSL Text.CSL.Reference Text.CSL.Style
    Text.CSL.Eval Text.CSL.Eval.Common Text.CSL.Eval.Date
    Text.CSL.Eval.Names Text.CSL.Eval.Output Text.CSL.Parser
    Text.CSL.Proc Text.CSL.Proc.Collapse Text.CSL.Proc.Disamb
    Text.CSL.Input.Bibutils Text.CSL.Input.Bibtex
    Text.CSL.Output.Pandoc Text.CSL.Output.Plain Text.CSL.Data
hidden-modules: Text.CSL.Util Prelude Paths_pandoc_citeproc
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/pandoc-citeproc-0.9.1.1
library-dirs: /usr/lib/ghc-7.10.3/site-local/pandoc-citeproc-0.9.1.1
data-dir: /usr/share/pandoc-citeproc
hs-libraries: HSpandoc-citeproc-0.9.1.1-FR7BIejKllo93qfJu872TX
depends:
    aeson-0.11.1.4-4ad27f2347131dcc86b1af72cd00fe7c
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    containers-0.5.6.2-169e53288f333dd2f0207994fd53822f
    data-default-0.5.3-a34fab0e414a3e31b9dccb1774520fca
    directory-1.2.2.0-17b2023f9d7e8036d19e6b52b4f75c98
    filepath-1.4.0.0-73e0bec80594160bf6dd6cb25217c6bf
    hs-bibutils-5.5-91f8c150a94b021e3f1d7580075e1ca0
    mtl-2.2.1-c516313407bc17046965067cb7cbb6a0
    old-locale-1.0.0.7-5aedb410aa2e5fddd3c57e9b4de1f46a
    pandoc-1.17.0.3-a12df7a7745e5ea4de39fe36e7ff7b76
    pandoc-types-1.16.1-5c682c2b5cffa962280d4abd090bac44
    parsec-3.1.9-3365ddffd9ca11d2f0b377e002b54baf
    setenv-0.1.1.3-4d70f2e61b1bd0645017164a0ca26ee9
    split-0.2.3-1755fd7a4bff52537a62f0056f73dfbc
    syb-0.6-56a5944f55f7a9d47e7b770375c0e1ae
    tagsoup-0.13.9-61f7129b459feb0b7d9b7f0c4b3300d3
    text-1.2.2.1-18afbfeccf88d72c4b6e468c86d2b77d
    text-icu-0.7.0.1-5ca732f0eac6589810e9e4239ad6c2ab
    time-1.5.0.1-cf94b0d806e26f6c4e356671290061b2
    unordered-containers-0.2.7.0-d91279dcd5fa13d7f88095dc08e2fda6
    vector-0.11.0.0-711d35c4a6ac1ea2e529dc3ee3328963
    xml-conduit-1.3.4-afe40bd27d2aaa75347b019ed922ee43
    yaml-0.8.16-50dd72d7df25e45cd672d7359cb18648
haddock-interfaces: /usr/share/doc/pandoc-citeproc/html/pandoc-citeproc.haddock
haddock-html: /usr/share/doc/pandoc-citeproc/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
