/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.GeoLocation;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.GpsDirectory;
import java.text.DecimalFormat;

public class GpsDescriptor
extends TagDescriptor<GpsDirectory> {
    public GpsDescriptor(@NotNull GpsDirectory gpsDirectory) {
        super(gpsDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 0: {
                return this.getGpsVersionIdDescription();
            }
            case 6: {
                return this.getGpsAltitudeDescription();
            }
            case 5: {
                return this.getGpsAltitudeRefDescription();
            }
            case 9: {
                return this.getGpsStatusDescription();
            }
            case 10: {
                return this.getGpsMeasureModeDescription();
            }
            case 12: {
                return this.getGpsSpeedRefDescription();
            }
            case 14: 
            case 16: 
            case 23: {
                return this.getGpsDirectionReferenceDescription(n);
            }
            case 15: 
            case 17: 
            case 24: {
                return this.getGpsDirectionDescription(n);
            }
            case 25: {
                return this.getGpsDestinationReferenceDescription();
            }
            case 7: {
                return this.getGpsTimeStampDescription();
            }
            case 4: {
                return this.getGpsLongitudeDescription();
            }
            case 2: {
                return this.getGpsLatitudeDescription();
            }
            case 30: {
                return this.getGpsDifferentialDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    private String getGpsVersionIdDescription() {
        return this.getVersionBytesDescription(0, 1);
    }

    @Nullable
    public String getGpsLatitudeDescription() {
        GeoLocation geoLocation = ((GpsDirectory)this._directory).getGeoLocation();
        return geoLocation == null ? null : GeoLocation.decimalToDegreesMinutesSecondsString(geoLocation.getLatitude());
    }

    @Nullable
    public String getGpsLongitudeDescription() {
        GeoLocation geoLocation = ((GpsDirectory)this._directory).getGeoLocation();
        return geoLocation == null ? null : GeoLocation.decimalToDegreesMinutesSecondsString(geoLocation.getLongitude());
    }

    @Nullable
    public String getGpsTimeStampDescription() {
        Rational[] rationalArray = ((GpsDirectory)this._directory).getRationalArray(7);
        DecimalFormat decimalFormat = new DecimalFormat("00.00");
        return rationalArray == null ? null : String.format("%02d:%02d:%s UTC", rationalArray[0].intValue(), rationalArray[1].intValue(), decimalFormat.format(rationalArray[2].doubleValue()));
    }

    @Nullable
    public String getGpsDestinationReferenceDescription() {
        String string = ((GpsDirectory)this._directory).getString(25);
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if ("K".equalsIgnoreCase(string2)) {
            return "kilometers";
        }
        if ("M".equalsIgnoreCase(string2)) {
            return "miles";
        }
        if ("N".equalsIgnoreCase(string2)) {
            return "knots";
        }
        return "Unknown (" + string2 + ")";
    }

    @Nullable
    public String getGpsDirectionDescription(int n) {
        Rational rational = ((GpsDirectory)this._directory).getRational(n);
        String string = rational != null ? new DecimalFormat("0.##").format(rational.doubleValue()) : ((GpsDirectory)this._directory).getString(n);
        return string == null || string.trim().length() == 0 ? null : string.trim() + " degrees";
    }

    @Nullable
    public String getGpsDirectionReferenceDescription(int n) {
        String string = ((GpsDirectory)this._directory).getString(n);
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if ("T".equalsIgnoreCase(string2)) {
            return "True direction";
        }
        if ("M".equalsIgnoreCase(string2)) {
            return "Magnetic direction";
        }
        return "Unknown (" + string2 + ")";
    }

    @Nullable
    public String getGpsSpeedRefDescription() {
        String string = ((GpsDirectory)this._directory).getString(12);
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if ("K".equalsIgnoreCase(string2)) {
            return "kph";
        }
        if ("M".equalsIgnoreCase(string2)) {
            return "mph";
        }
        if ("N".equalsIgnoreCase(string2)) {
            return "knots";
        }
        return "Unknown (" + string2 + ")";
    }

    @Nullable
    public String getGpsMeasureModeDescription() {
        String string = ((GpsDirectory)this._directory).getString(10);
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if ("2".equalsIgnoreCase(string2)) {
            return "2-dimensional measurement";
        }
        if ("3".equalsIgnoreCase(string2)) {
            return "3-dimensional measurement";
        }
        return "Unknown (" + string2 + ")";
    }

    @Nullable
    public String getGpsStatusDescription() {
        String string = ((GpsDirectory)this._directory).getString(9);
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if ("A".equalsIgnoreCase(string2)) {
            return "Active (Measurement in progress)";
        }
        if ("V".equalsIgnoreCase(string2)) {
            return "Void (Measurement Interoperability)";
        }
        return "Unknown (" + string2 + ")";
    }

    @Nullable
    public String getGpsAltitudeRefDescription() {
        return this.getIndexedDescription(5, "Sea level", "Below sea level");
    }

    @Nullable
    public String getGpsAltitudeDescription() {
        Rational rational = ((GpsDirectory)this._directory).getRational(6);
        return rational == null ? null : rational.intValue() + " metres";
    }

    @Nullable
    public String getGpsDifferentialDescription() {
        return this.getIndexedDescription(30, "No Correction", "Differential Corrected");
    }

    @Nullable
    public String getDegreesMinutesSecondsDescription() {
        GeoLocation geoLocation = ((GpsDirectory)this._directory).getGeoLocation();
        return geoLocation == null ? null : geoLocation.toDMSString();
    }
}

