/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.openstreetmap.josm.gui.help.HelpContentReaderException;
import org.openstreetmap.josm.gui.help.MissingHelpContentException;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.WikiReader;

public class HelpContentReader
extends WikiReader {
    public HelpContentReader(String string) {
        super(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String fetchHelpTopicContent(String string, boolean bl) throws HelpContentReaderException {
        if (string == null) {
            throw new MissingHelpContentException("helpTopicUrl is null");
        }
        HttpClient.Response response = null;
        try {
            URL uRL = new URL(string);
            response = HttpClient.create(uRL).connect();
            try (BufferedReader object = response.getContentReader();){
                String string2 = this.prepareHelpContent(object, bl, uRL);
                return string2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new HelpContentReaderException(malformedURLException);
        }
        catch (IOException iOException) {
            HelpContentReaderException helpContentReaderException = new HelpContentReaderException(iOException);
            if (response == null) throw helpContentReaderException;
            helpContentReaderException.setResponseCode(response.getResponseCode());
            throw helpContentReaderException;
        }
    }

    protected String prepareHelpContent(BufferedReader bufferedReader, boolean bl, URL uRL) throws HelpContentReaderException {
        String string = "";
        try {
            string = this.readFromTrac(bufferedReader, uRL);
        }
        catch (IOException iOException) {
            throw new HelpContentReaderException(iOException);
        }
        if (bl && string.isEmpty()) {
            throw new MissingHelpContentException(string);
        }
        return string;
    }
}

