/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.coerce;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChild(value="child", type=RubyNode.class)
public abstract class NameToSymbolOrStringNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toStr;

    public NameToSymbolOrStringNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.toStr = DispatchHeadNodeFactory.createMethodCall(context);
    }

    public abstract DynamicObject executeToSymbolOrString(VirtualFrame var1, Object var2);

    @Specialization(guards={"isRubySymbol(symbol)"})
    public DynamicObject coerceRubySymbol(DynamicObject symbol) {
        return symbol;
    }

    @Specialization(guards={"isRubyString(string)"})
    public DynamicObject coerceRubyString(DynamicObject string) {
        return string;
    }

    @Specialization(guards={"!isRubySymbol(object)", "!isRubyString(object)"})
    public DynamicObject coerceObject(VirtualFrame frame, Object object) {
        Object coerced;
        try {
            coerced = this.toStr.call(frame, object, "to_str", null, new Object[0]);
        }
        catch (RaiseException e) {
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getRubyException()) == this.getContext().getCoreLibrary().getNoMethodErrorClass()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeErrorNoImplicitConversion(object, "String", this));
            }
            throw e;
        }
        if (RubyGuards.isRubyString(coerced)) {
            return (DynamicObject)coerced;
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorBadCoercion(object, "String", "to_str", coerced, this));
    }
}

