/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.task;

import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.module.TaskExecutionRequestEvent;
import org.pdfsam.module.UsageService;
import org.pdfsam.task.TaskEventBroadcaster;
import org.sejda.core.notification.context.GlobalNotificationContext;
import org.sejda.core.service.TaskExecutionService;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.model.notification.event.PercentageOfWorkDoneChangedEvent;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;
import org.sejda.model.notification.event.TaskExecutionStartedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
class TaskExecutionController
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutionController.class);
    private TaskExecutionService executionService;
    private UsageService usageService;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    @Inject
    public TaskExecutionController(TaskExecutionService executionService, UsageService usageService) {
        this.executionService = executionService;
        this.usageService = usageService;
        StaticStudio.eventStudio().addAnnotatedListeners(this);
        GlobalNotificationContext.getContext().addListener(TaskExecutionFailedEvent.class, new TaskEventBroadcaster());
        GlobalNotificationContext.getContext().addListener(TaskExecutionStartedEvent.class, new TaskEventBroadcaster());
        GlobalNotificationContext.getContext().addListener(TaskExecutionCompletedEvent.class, new TaskEventBroadcaster());
        GlobalNotificationContext.getContext().addListener(PercentageOfWorkDoneChangedEvent.class, new TaskEventBroadcaster());
    }

    @EventListener(priority=0x7FFFFFFF)
    public void request(TaskExecutionRequestEvent event) {
        LOG.trace("Task execution request received");
        this.usageService.incrementUsageFor(event.getModuleId());
        this.executor.execute(() -> this.executionService.execute(event.getParameters()));
        LOG.trace("Task execution submitted");
    }

    @Override
    @PreDestroy
    public void close() {
        this.executor.shutdownNow();
    }
}

