/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control;

import java.util.ArrayList;
import java.util.List;

public class Matrix<T> {
    private List<List<T>> matrix = new ArrayList<List<T>>();

    public int rows() {
        return this.matrix.size();
    }

    public int cols() {
        int longestCol = 0;
        for (List<T> row : this.matrix) {
            if (row.size() <= longestCol) continue;
            longestCol = row.size();
        }
        return longestCol;
    }

    public List<T> row(int index) {
        return this.matrix.get(index);
    }

    public List<T> col(int index) {
        ArrayList<T> result = new ArrayList<T>(this.cols());
        for (List<T> row : this.matrix) {
            if (index < row.size()) {
                result.add(row.get(index));
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public T cell(int row, int col) {
        return this.row(row).get(col);
    }

    public boolean hasMoreRowsThanCols() {
        return this.rows() > this.cols();
    }

    public void invert() {
        ArrayList<List<T>> result = new ArrayList<List<T>>(this.cols());
        for (int i = 0; i < this.cols(); ++i) {
            result.add(this.col(i));
        }
        this.matrix = result;
    }

    public void addLine(List<T> line) {
        this.matrix.add(line);
    }

    public boolean isEmpty() {
        for (List<T> row : this.matrix) {
            if (row.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        for (List<T> row : this.matrix) {
            for (T value : row) {
                sb.append(value != null ? value : "null").append("\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

