/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific.sequence_aio;

import com.baselet.control.basics.Line1D;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.TextSplitter;
import com.baselet.element.facet.specific.sequence_aio.Container;
import com.baselet.element.facet.specific.sequence_aio.DrawingInfo;
import com.baselet.element.facet.specific.sequence_aio.HorizontalDrawingInfo;
import com.baselet.element.facet.specific.sequence_aio.Lifeline;
import com.baselet.element.facet.specific.sequence_aio.LifelineOccurrence;
import com.baselet.element.facet.specific.sequence_aio.LifelineSpanningTickSpanningOccurrence;
import com.baselet.element.facet.specific.sequence_aio.PentagonDrawingHelper;
import com.baselet.element.facet.specific.sequence_aio.SequenceDiagramCheckedException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class CombinedFragment
implements LifelineSpanningTickSpanningOccurrence,
Container {
    private static final double HEADER_CONSTRAINT_PADDING = 5.0;
    private static final double CONSTRAINT_Y_PADDING = 2.0;
    private static final double COMBINED_FRAGMENT_HORIZONTAL_BORDER_PADDING = 7.0;
    private static final double COMBINED_FRAGMENT_VERTICAL_BORDER_PADDING = 7.0;
    private final Lifeline[] coveredLifelines;
    private final int startTick;
    private final String[] operatorLines;
    private final Deque<Operand> operands;

    public CombinedFragment(Lifeline[] coveredLifelines, int startTick, String operator) {
        this.coveredLifelines = coveredLifelines;
        this.startTick = startTick;
        this.operatorLines = operator.split("\n");
        this.operands = new LinkedList<Operand>();
    }

    @Override
    public Lifeline getFirstLifeline() {
        return this.coveredLifelines[0];
    }

    @Override
    public Lifeline getLastLifeline() {
        return this.coveredLifelines[this.coveredLifelines.length - 1];
    }

    @Override
    public int getStartTick() {
        return this.startTick;
    }

    @Override
    public int getEndTick() {
        if (this.operands.isEmpty()) {
            return this.startTick;
        }
        return this.operands.getLast().endTick;
    }

    public void addOperand(int startTick, int endTick) {
        if (this.operands.size() == 0 && this.startTick != startTick) {
            throw new IllegalArgumentException("The start tick of the first operand must be equal to the start tick of the combined fragment");
        }
        this.operands.add(new Operand(startTick, endTick));
    }

    public void addOperand(int startTick, int endTick, String text, Lifeline constraintLifeline) throws SequenceDiagramCheckedException {
        if (this.operands.size() == 0 && this.startTick != startTick) {
            throw new IllegalArgumentException("The start tick of the first operand must be equal to the start tick of the combined fragment");
        }
        this.operands.add(new Operand(startTick, endTick, text, constraintLifeline));
    }

    @Override
    public void draw(DrawHandler drawHandler, DrawingInfo drawingInfo) {
        this.drawOperandLines(drawHandler, drawingInfo);
        PointDouble[] rectangle = new PointDouble[]{new PointDouble(drawingInfo.getHorizontalStart(this), drawingInfo.getVerticalStart(this)), new PointDouble(drawingInfo.getHorizontalEnd(this), drawingInfo.getVerticalStart(this)), new PointDouble(drawingInfo.getHorizontalEnd(this), drawingInfo.getVerticalEnd(this)), new PointDouble(drawingInfo.getHorizontalStart(this), drawingInfo.getVerticalEnd(this)), null};
        rectangle[4] = rectangle[0];
        drawHandler.drawLines(rectangle);
        ArrayList<Line1D> slopeNotPermittedAreas = new ArrayList<Line1D>(this.coveredLifelines.length);
        for (Lifeline lifeline : this.coveredLifelines) {
            if (!(lifeline.getLifelineLeftPartWidth(this.startTick) > 0.0)) continue;
            double llCenter = drawingInfo.getHDrawingInfo(lifeline).getHorizontalCenter();
            slopeNotPermittedAreas.add(new Line1D(llCenter - lifeline.getLifelineLeftPartWidth(this.startTick), llCenter + lifeline.getLifelineRightPartWidth(this.startTick)));
        }
        PointDouble headerSize = PentagonDrawingHelper.draw(drawHandler, this.operatorLines, drawingInfo.getWidth(this), rectangle[0], slopeNotPermittedAreas);
        double endOfHeadX = drawingInfo.getHorizontalStart(this) + headerSize.x;
        for (Lifeline ll : this.coveredLifelines) {
            if (!(drawingInfo.getHDrawingInfo(ll).getHorizontalCenter() - ll.getLifelineLeftPartWidth(this.startTick) <= endOfHeadX)) break;
            drawingInfo.getDrawingInfo(ll).addInterruptedArea(new Line1D(rectangle[0].y, rectangle[0].y + headerSize.y));
        }
        if (this.operands.size() > 0 && this.operands.getFirst().constraint != null) {
            Operand operand = this.operands.getFirst();
            Operand.InteractionConstraint firstIntConst = operand.constraint;
            double constraintTopY = drawingInfo.getVerticalStart(this) + headerSize.y + 5.0;
            double constraintBottomY = drawingInfo.getVerticalEnd(this.startTick);
            double textHeight = TextSplitter.getSplitStringHeight(firstIntConst.textLines, drawingInfo.getHDrawingInfo(firstIntConst.affectedLifeline).getSymmetricWidth(this.startTick), drawHandler);
            constraintTopY += (constraintBottomY - constraintTopY - (textHeight += 4.0)) / 2.0;
            TextSplitter.drawText(drawHandler, firstIntConst.textLines, drawingInfo.getHDrawingInfo(firstIntConst.affectedLifeline).getSymmetricHorizontalStart(this.startTick), constraintTopY, drawingInfo.getHDrawingInfo(firstIntConst.affectedLifeline).getSymmetricWidth(this.startTick), textHeight, AlignHorizontal.CENTER, AlignVertical.CENTER);
            drawingInfo.getDrawingInfo(firstIntConst.affectedLifeline).addInterruptedArea(new Line1D(constraintTopY, constraintTopY + textHeight));
        }
    }

    private void drawOperandLines(DrawHandler drawHandler, DrawingInfo drawingInfo) {
        Iterator<Operand> operandIter = this.operands.iterator();
        if (operandIter.hasNext()) {
            operandIter.next();
        }
        drawHandler.setLineType(LineType.DASHED);
        while (operandIter.hasNext()) {
            Operand op = operandIter.next();
            drawHandler.drawLine(drawingInfo.getHorizontalStart(this), drawingInfo.getVerticalStart(op.startTick) - drawingInfo.getTickVerticalPadding() / 2.0, drawingInfo.getHorizontalEnd(this), drawingInfo.getVerticalStart(op.startTick) - drawingInfo.getTickVerticalPadding() / 2.0);
        }
        drawHandler.setLineType(LineType.SOLID);
    }

    @Override
    public double getOverallMinWidth(DrawHandler drawHandler, double lifelineHorizontalPadding) {
        double minWidth = PentagonDrawingHelper.getMinimumWidth(drawHandler, this.operatorLines);
        if (this.operands.size() > 0 && this.operands.getFirst().constraint != null) {
            double constraintMinWidth = this.operands.getFirst().constraint.getMinWidth(drawHandler) * (double)this.coveredLifelines.length + (double)(this.coveredLifelines.length - 1) * lifelineHorizontalPadding;
            minWidth = Math.max(minWidth, constraintMinWidth);
        }
        return minWidth + this.getLastLifeline().getLifelineLeftPartWidth(this.startTick) + this.getLastLifeline().getLifelineRightPartWidth(this.startTick);
    }

    @Override
    public Map<Integer, Double> getEveryAdditionalYHeight(DrawHandler drawHandler, HorizontalDrawingInfo hInfo, double defaultTickHeight) {
        HashMap<Integer, Double> ret = new HashMap<Integer, Double>();
        double headerHeight = PentagonDrawingHelper.getHeight(drawHandler, this.operatorLines, hInfo.getWidth(this));
        headerHeight -= 7.0;
        if (this.operands.size() > 0 && this.operands.getFirst().constraint != null) {
            headerHeight += 5.0;
            headerHeight += TextSplitter.getSplitStringHeight(this.operands.getFirst().constraint.textLines, hInfo.getHDrawingInfo(this.operands.getFirst().constraint.affectedLifeline).getSymmetricWidth(this.startTick), drawHandler);
            headerHeight += 4.0;
        }
        if (headerHeight > defaultTickHeight) {
            ret.put(this.startTick, headerHeight - defaultTickHeight);
        }
        return ret;
    }

    @Override
    public LifelineSpanningTickSpanningOccurrence.ContainerPadding getPaddingInformation() {
        return new LifelineSpanningTickSpanningOccurrence.ContainerPadding(this, 7.0, 7.0, 7.0, 7.0);
    }

    private class Operand {
        private final int startTick;
        private final int endTick;
        private final InteractionConstraint constraint;

        public Operand(int startTick, int endTick) {
            this.startTick = startTick;
            this.endTick = endTick;
            this.constraint = null;
        }

        public Operand(int startTick, int endTick, String text, Lifeline constraintLifeline) throws SequenceDiagramCheckedException {
            this.startTick = startTick;
            this.endTick = endTick;
            this.constraint = new InteractionConstraint(text, constraintLifeline);
        }

        public boolean isFirstOperand() {
            return CombinedFragment.this.operands.getFirst() == this;
        }

        public boolean isLastOperand() {
            return CombinedFragment.this.operands.getLast() == this;
        }

        private class InteractionConstraint
        implements LifelineOccurrence {
            private final String[] textLines;
            private final Lifeline affectedLifeline;

            public InteractionConstraint(String constraintText, Lifeline affectedLifeline) throws SequenceDiagramCheckedException {
                this.textLines = ('[' + constraintText + ']').split("\n");
                this.affectedLifeline = affectedLifeline;
                affectedLifeline.addLifelineOccurrenceAtTick(this, Operand.this.startTick);
            }

            @Override
            public Line1D draw(DrawHandler drawHandler, PointDouble topLeft, PointDouble size) {
                if (Operand.this.isFirstOperand()) {
                    return null;
                }
                double textHeight = TextSplitter.getSplitStringHeight(this.textLines, (double)size.x, drawHandler);
                Line1D interruptedArea = new Line1D(topLeft.y + (size.y - textHeight) / 2.0 - 2.0, topLeft.y + (size.y - textHeight) / 2.0 + textHeight + 2.0);
                TextSplitter.drawText(drawHandler, this.textLines, topLeft.x, interruptedArea.getLow() + 2.0, size.x, textHeight, AlignHorizontal.CENTER, AlignVertical.CENTER);
                return interruptedArea;
            }

            @Override
            public double getMinWidth(DrawHandler drawHandler) {
                return TextSplitter.getTextMinWidth(this.textLines, drawHandler);
            }

            @Override
            public double getAdditionalYHeight(DrawHandler drawHandler, PointDouble size) {
                if (Operand.this.isFirstOperand()) {
                    return -1.0;
                }
                return TextSplitter.getSplitStringHeight(this.textLines, (double)size.x, drawHandler) + 4.0 - size.y;
            }
        }
    }
}

