/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintTypeFormula;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ConstraintExceptionFormula
extends ConstraintFormula {
    FunctionalExpression left;

    public ConstraintExceptionFormula(FunctionalExpression functionalExpression, TypeBinding typeBinding) {
        this.left = functionalExpression;
        this.right = typeBinding;
        this.relation = 7;
    }

    @Override
    public Object reduce(InferenceContext18 inferenceContext18) {
        int n;
        Object object;
        FunctionalExpression functionalExpression;
        int n2;
        int n3;
        Scope scope = inferenceContext18.scope;
        if (!this.right.isFunctionalInterface(scope)) {
            return FALSE;
        }
        MethodBinding methodBinding = this.right.getSingleAbstractMethod(scope, true);
        if (methodBinding == null) {
            return FALSE;
        }
        if (this.left instanceof LambdaExpression) {
            if (((LambdaExpression)this.left).argumentsTypeElided()) {
                n3 = methodBinding.parameters.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    if (methodBinding.parameters[n2].isProperType(true)) continue;
                    return FALSE;
                }
            }
            if (methodBinding.returnType != TypeBinding.VOID && !methodBinding.returnType.isProperType(true)) {
                return FALSE;
            }
        } else if (!((ReferenceExpression)this.left).isExactMethodReference()) {
            n3 = methodBinding.parameters.length;
            for (n2 = 0; n2 < n3; ++n2) {
                if (methodBinding.parameters[n2].isProperType(true)) continue;
                return FALSE;
            }
            if (methodBinding.returnType != TypeBinding.VOID && !methodBinding.returnType.isProperType(true)) {
                return FALSE;
            }
        }
        ReferenceBinding[] referenceBindingArray = methodBinding.thrownExceptions;
        InferenceVariable[] inferenceVariableArray = new InferenceVariable[referenceBindingArray.length];
        int n4 = 0;
        for (int i = 0; i < referenceBindingArray.length; ++i) {
            if (((TypeBinding)referenceBindingArray[i]).isProperType(true)) continue;
            inferenceVariableArray[n4++] = (InferenceVariable)referenceBindingArray[i];
        }
        if (n4 == 0) {
            return TRUE;
        }
        TypeBinding[] typeBindingArray = null;
        if (this.left instanceof LambdaExpression) {
            functionalExpression = ((LambdaExpression)this.left).getResolvedCopyForInferenceTargeting(this.right);
            if (functionalExpression == null) {
                return TRUE;
            }
            object = ((LambdaExpression)functionalExpression).getThrownExceptions();
            typeBindingArray = object.toArray(new TypeBinding[object.size()]);
        } else {
            functionalExpression = (ReferenceExpression)this.left;
            object = ((ReferenceExpression)functionalExpression).findCompileTimeMethodTargeting(this.right, scope);
            if (object != null) {
                typeBindingArray = ((MethodBinding)object).thrownExceptions;
            }
        }
        if (typeBindingArray == null) {
            return TRUE;
        }
        int n5 = typeBindingArray.length;
        object = new ArrayList<ConstraintTypeFormula>();
        block3: for (n = 0; n < n5; ++n) {
            int n6;
            if (typeBindingArray[n].isUncheckedException(false)) continue;
            for (n6 = 0; n6 < referenceBindingArray.length; ++n6) {
                if (((TypeBinding)referenceBindingArray[n6]).isProperType(true) && typeBindingArray[n].isCompatibleWith(referenceBindingArray[n6])) continue block3;
            }
            for (n6 = 0; n6 < n4; ++n6) {
                object.add(ConstraintTypeFormula.create(typeBindingArray[n], inferenceVariableArray[n6], 2));
            }
        }
        for (n = 0; n < n4; ++n) {
            inferenceContext18.currentBounds.inThrows.add(inferenceVariableArray[n]);
        }
        return object.toArray(new ConstraintFormula[object.size()]);
    }

    @Override
    Collection<InferenceVariable> inputVariables(InferenceContext18 inferenceContext18) {
        if (this.left instanceof LambdaExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(inferenceContext18.scope)) {
                LambdaExpression lambdaExpression = (LambdaExpression)this.left;
                MethodBinding methodBinding = this.right.getSingleAbstractMethod(inferenceContext18.scope, true);
                HashSet<InferenceVariable> hashSet = new HashSet<InferenceVariable>();
                if (lambdaExpression.argumentsTypeElided()) {
                    int n = methodBinding.parameters.length;
                    for (int i = 0; i < n; ++i) {
                        methodBinding.parameters[i].collectInferenceVariables(hashSet);
                    }
                }
                if (methodBinding.returnType != TypeBinding.VOID) {
                    methodBinding.returnType.collectInferenceVariables(hashSet);
                }
                return hashSet;
            }
        } else if (this.left instanceof ReferenceExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(inferenceContext18.scope)) {
                MethodBinding methodBinding = this.right.getSingleAbstractMethod(inferenceContext18.scope, true);
                HashSet<InferenceVariable> hashSet = new HashSet<InferenceVariable>();
                int n = methodBinding.parameters.length;
                for (int i = 0; i < n; ++i) {
                    methodBinding.parameters[i].collectInferenceVariables(hashSet);
                }
                methodBinding.returnType.collectInferenceVariables(hashSet);
                return hashSet;
            }
        }
        return EMPTY_VARIABLE_LIST;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append('\u27e8');
        this.left.printExpression(4, stringBuffer);
        stringBuffer.append(" \u2286throws ");
        this.appendTypeName(stringBuffer, this.right);
        stringBuffer.append('\u27e9');
        return stringBuffer.toString();
    }
}

