/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClasspathDirectory
extends ClasspathLocation {
    private Hashtable directoryCache;
    private String[] missingPackageHolder = new String[1];
    private int mode;
    private String encoding;

    ClasspathDirectory(File file, String string, int n, AccessRuleSet accessRuleSet, String string2) {
        super(accessRuleSet, string2);
        this.mode = n;
        try {
            this.path = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.path = file.getAbsolutePath();
        }
        if (!this.path.endsWith(File.separator)) {
            this.path = this.path + File.separator;
        }
        this.directoryCache = new Hashtable(11);
        this.encoding = string;
    }

    String[] directoryList(String string) {
        String[] stringArray = (String[])this.directoryCache.get(string);
        if (stringArray == this.missingPackageHolder) {
            return null;
        }
        if (stringArray != null) {
            return stringArray;
        }
        File file = new File(this.path + string);
        if (file.isDirectory()) {
            String string2;
            String string3;
            int n = string.length();
            int n2 = string.lastIndexOf(File.separatorChar);
            while (--n > n2 && !ScannerHelper.isUpperCase(string.charAt(n))) {
            }
            if (n <= n2 || !(n2 != -1 ? !this.doesFileExist(string3 = string.substring(n2 + 1), string2 = string.substring(0, n2)) : !this.doesFileExist(string, Util.EMPTY_STRING))) {
                stringArray = file.list();
                if (stringArray == null) {
                    stringArray = CharOperation.NO_STRINGS;
                }
                this.directoryCache.put(string, stringArray);
                return stringArray;
            }
        }
        this.directoryCache.put(string, this.missingPackageHolder);
        return null;
    }

    boolean doesFileExist(String string, String string2) {
        String[] stringArray = this.directoryList(string2);
        if (stringArray == null) {
            return false;
        }
        int n = stringArray.length;
        while (--n >= 0) {
            if (!string.equals(stringArray[n])) continue;
            return true;
        }
        return false;
    }

    @Override
    public List fetchLinkedJars(FileSystem.ClasspathSectionProblemReporter classpathSectionProblemReporter) {
        return null;
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2) {
        return this.findClass(cArray, string, string2, false);
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, boolean bl) {
        String string3;
        Object object;
        boolean bl2;
        if (!this.isPackage(string)) {
            return null;
        }
        String string4 = new String(cArray);
        boolean bl3 = (this.mode & 2) != 0 && this.doesFileExist(string4 + ".class", string);
        boolean bl4 = bl2 = (this.mode & 1) != 0 && this.doesFileExist(string4 + ".java", string);
        if (bl2 && !bl) {
            object = this.path + string2.substring(0, string2.length() - 6) + ".java";
            if (!bl3) {
                return new NameEnvironmentAnswer(new CompilationUnit(null, (String)object, this.encoding, this.destinationPath), this.fetchAccessRestriction(string2));
            }
            string3 = this.path + string2;
            long l = new File(string3).lastModified();
            long l2 = new File((String)object).lastModified();
            if (l2 > l) {
                return new NameEnvironmentAnswer(new CompilationUnit(null, (String)object, this.encoding, this.destinationPath), this.fetchAccessRestriction(string2));
            }
        }
        if (bl3) {
            try {
                object = ClassFileReader.read(this.path + string2);
                String string5 = string3 = string.length() > 0 ? string.replace(File.separatorChar, '/') + "/" + string4 : string4;
                if (!CharOperation.equals(((ClassFileReader)object).getName(), string3.toCharArray())) {
                    object = null;
                }
                if (object != null) {
                    return new NameEnvironmentAnswer((IBinaryType)object, this.fetchAccessRestriction(string2));
                }
            }
            catch (IOException iOException) {
            }
            catch (ClassFormatException classFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public char[][][] findTypeNames(String string) {
        int n;
        if (!this.isPackage(string)) {
            return null;
        }
        File file = new File(this.path + string);
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        String[] stringArray = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                String string2 = string.toLowerCase();
                return string2.endsWith(".class") || string2.endsWith(".java");
            }
        });
        if (stringArray == null || (n = stringArray.length) == 0) {
            return null;
        }
        char[][][] cArrayArray = new char[n][][];
        char[][] cArray = CharOperation.splitOn(File.separatorChar, string.toCharArray());
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            int n2 = string2.indexOf(46);
            cArrayArray[i] = CharOperation.arrayConcat(cArray, string2.substring(0, n2).toCharArray());
        }
        return cArrayArray;
    }

    @Override
    public void initialize() throws IOException {
    }

    @Override
    public boolean isPackage(String string) {
        return this.directoryList(string) != null;
    }

    @Override
    public void reset() {
        this.directoryCache = new Hashtable(11);
    }

    public String toString() {
        return "ClasspathDirectory " + this.path;
    }

    @Override
    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            this.normalizedPath = this.path.toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(this.normalizedPath, '\\', '/');
            }
        }
        return this.normalizedPath;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public int getMode() {
        return this.mode;
    }
}

