/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.Hashtable;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.optimizer.OptFunctionNode;

class OptTransformer
extends NodeTransformer {
    private Hashtable possibleDirectCalls;
    private ObjArray directCallTargets;

    OptTransformer(CompilerEnvirons compilerEnv, Hashtable possibleDirectCalls, ObjArray directCallTargets) {
        super(compilerEnv);
        this.possibleDirectCalls = possibleDirectCalls;
        this.directCallTargets = directCallTargets;
    }

    protected void visitNew(Node node, ScriptOrFnNode tree) {
        this.detectDirectCall(node, tree);
        super.visitNew(node, tree);
    }

    protected void visitCall(Node node, ScriptOrFnNode tree) {
        this.detectDirectCall(node, tree);
        Node left = node.getFirstChild();
        boolean addGetThis = false;
        if (left.getType() == 39) {
            boolean inFunction;
            String name = left.getString();
            boolean bl = inFunction = tree.getType() == 87;
            if (inFunction && tree.hasParamOrVar(name) && !this.inWithStatement()) {
                left.setType(59);
            } else {
                node.removeChild(left);
                left.setType(58);
                Node str = Node.newString(left.getString());
                Node getProp = new Node(34, left, str);
                node.addChildToFront(getProp);
                left = getProp;
                boolean bl2 = addGetThis = this.inWithStatement() || !inFunction;
            }
        }
        if (left.getType() != 34 && left.getType() != 36) {
            node.removeChild(left);
            Node tmp = OptTransformer.createNewTemp(left);
            Node use = OptTransformer.createUseTemp(tmp);
            use.putProp(2, tmp);
            Node parent = new Node(114, use);
            node.addChildToFront(parent);
            node.addChildToFront(tmp);
            return;
        }
        Node leftLeft = left.getFirstChild();
        left.removeChild(leftLeft);
        Node tmp = OptTransformer.createNewTemp(leftLeft);
        left.addChildToFront(tmp);
        Node use = OptTransformer.createUseTemp(tmp);
        use.putProp(2, tmp);
        if (addGetThis) {
            use = new Node(68, use);
        }
        node.addChildAfter(use, left);
        super.visitCall(node, tree);
    }

    private void detectDirectCall(Node node, ScriptOrFnNode tree) {
        if (tree.getType() == 87) {
            Node left = node.getFirstChild();
            int argCount = 0;
            Node arg = left.getNext();
            while (arg != null) {
                arg = arg.getNext();
                ++argCount;
            }
            if (argCount == 0) {
                OptFunctionNode.get((ScriptOrFnNode)tree).itsContainsCalls0 = true;
            }
            if (this.possibleDirectCalls != null) {
                OptFunctionNode ofn;
                String targetName = null;
                if (left.getType() == 39) {
                    targetName = left.getString();
                } else if (left.getType() == 34) {
                    targetName = left.getFirstChild().getNext().getString();
                }
                if (targetName != null && (ofn = (OptFunctionNode)this.possibleDirectCalls.get(targetName)) != null && argCount == ofn.fnode.getParamCount() && argCount <= 32) {
                    node.putProp(16, ofn);
                    if (!ofn.isTargetOfDirectCall()) {
                        int index = this.directCallTargets.size();
                        this.directCallTargets.add(ofn);
                        ofn.setDirectTargetIndex(index);
                    }
                }
            }
        }
    }

    static Node createNewTemp(Node n) {
        int type = n.getType();
        if (type == 41 || type == 40) {
            return n;
        }
        return new Node(116, n);
    }

    static Node createUseTemp(Node newTemp) {
        switch (newTemp.getType()) {
            case 116: {
                Node result = new Node(117);
                result.putProp(2, newTemp);
                int n = newTemp.getIntProp(6, 0);
                if (n != Integer.MAX_VALUE) {
                    newTemp.putIntProp(6, n + 1);
                }
                return result;
            }
            case 41: {
                return Node.newString(newTemp.getString());
            }
            case 40: {
                return Node.newNumber(newTemp.getDouble());
            }
        }
        throw Kit.codeBug();
    }
}

