/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.sejda.common.ComponentsUtility;
import org.sejda.common.LookupTable;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.impl.sambox.component.AcroFormsMerger;
import org.sejda.impl.sambox.component.Annotations;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.SignatureClipper;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.FileIndexAndPage;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.CombineReorderParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PageNotFoundException;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombineReorderTask
extends BaseTask<CombineReorderParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(CombineReorderTask.class);
    private SingleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> sourceOpener;
    private PDDocumentHandler destinationDocument;
    private List<PDDocumentHandler> documents = new ArrayList<PDDocumentHandler>();
    private AcroFormsMerger acroFormsMerger;
    private LookupTable<PDPage> pagesLookup = new LookupTable();

    @Override
    public void before(CombineReorderParameters parameters) {
        this.sourceOpener = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newSingleOutputWriter(parameters.getExistingOutputPolicy());
    }

    @Override
    public void execute(CombineReorderParameters parameters) throws TaskException {
        File tmpFile = IOUtils.createTemporaryPdfBuffer();
        LOG.debug("Created output temporary buffer {} ", (Object)tmpFile);
        this.destinationDocument = new PDDocumentHandler();
        this.destinationDocument.setCreatorOnPDDocument();
        this.destinationDocument.setVersionOnPDDocument(parameters.getVersion());
        this.destinationDocument.setCompress(parameters.isCompress());
        this.acroFormsMerger = new AcroFormsMerger(parameters.getAcroFormPolicy(), this.destinationDocument.getUnderlyingPDDocument());
        for (PdfSource input : parameters.getSourceList()) {
            LOG.debug("Opening {}", input.getSource());
            PDDocumentHandler sourceDocumentHandler = input.open(this.sourceOpener);
            this.documents.add(sourceDocumentHandler);
        }
        int currentStep = 0;
        int totalSteps = parameters.getPages().size() + this.documents.size();
        for (int i = 0; i < parameters.getPages().size(); ++i) {
            this.stopTaskIfCancelled();
            FileIndexAndPage filePage = parameters.getPages().get(i);
            int pageNum = filePage.getPage();
            try {
                PDPage page = this.documents.get(filePage.getFileIndex()).getPage(pageNum);
                this.pagesLookup.addLookupEntry(page, this.destinationDocument.importPage(page));
            }
            catch (PageNotFoundException ex) {
                String warning = String.format("Page %d was skipped, could not be processed", pageNum);
                ApplicationEventsNotifier.notifyEvent(this.getNotifiableTaskMetadata()).taskWarning(warning);
                LOG.warn(warning, ex);
            }
            ApplicationEventsNotifier.notifyEvent(this.getNotifiableTaskMetadata()).stepsCompleted(++currentStep).outOf(totalSteps);
        }
        for (PDDocumentHandler document : this.documents) {
            LookupTable<PDAnnotation> annotationsLookup = Annotations.processAnnotations(this.pagesLookup, document.getUnderlyingPDDocument());
            SignatureClipper.clipSignatures(annotationsLookup.values());
            this.acroFormsMerger.mergeForm(document.getUnderlyingPDDocument().getDocumentCatalog().getAcroForm(), annotationsLookup);
            ApplicationEventsNotifier.notifyEvent(this.getNotifiableTaskMetadata()).stepsCompleted(++currentStep).outOf(totalSteps);
        }
        if (this.acroFormsMerger.hasForm()) {
            LOG.debug("Adding generated AcroForm");
            this.destinationDocument.setDocumentAcroForm(this.acroFormsMerger.getForm());
        }
        this.destinationDocument.savePDDocument(tmpFile);
        this.closeResources();
        this.outputWriter.setOutput(FileOutput.file(tmpFile).name(parameters.getOutputName()));
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Input documents merged correctly and written to {}", (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        this.closeResources();
        this.outputWriter = null;
        this.documents.clear();
        this.pagesLookup.clear();
    }

    private void closeResources() {
        for (PDDocumentHandler document : this.documents) {
            ComponentsUtility.nullSafeCloseQuietly(document);
        }
        ComponentsUtility.nullSafeCloseQuietly(this.destinationDocument);
    }
}

