/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSObjectKey;
import org.sejda.sambox.cos.IndirectCOSObjectIdentifier;
import org.sejda.sambox.cos.IndirectCOSObjectReference;
import org.sejda.sambox.encryption.GeneralEncryptionAlgorithm;
import org.sejda.sambox.input.ExistingIndirectCOSObject;
import org.sejda.sambox.output.IndirectReferenceProvider;
import org.sejda.sambox.output.WriteOption;
import org.sejda.sambox.xref.XrefEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PDFWriteContext {
    private static final Logger LOG = LoggerFactory.getLogger(PDFWriteContext.class);
    private String contextId = UUID.randomUUID().toString();
    private IndirectReferenceProvider referencesProvider = new IndirectReferenceProvider();
    private Map<IndirectCOSObjectIdentifier, IndirectCOSObjectReference> lookupNewRef = new ConcurrentHashMap<IndirectCOSObjectIdentifier, IndirectCOSObjectReference>();
    private List<WriteOption> opts;
    private SortedMap<Long, XrefEntry> written = new ConcurrentSkipListMap<Long, XrefEntry>();
    public final Optional<GeneralEncryptionAlgorithm> encryptor;

    PDFWriteContext(GeneralEncryptionAlgorithm encryptor, WriteOption ... options) {
        this.encryptor = Optional.ofNullable(encryptor);
        this.opts = Arrays.asList(options);
    }

    IndirectCOSObjectReference createIndirectReferenceFor(COSBase item) {
        return this.createNewReference(item, this.referencesProvider::nextReferenceFor);
    }

    IndirectCOSObjectReference createNonStorableInObjectStreamIndirectReferenceFor(COSBase item) {
        return this.createNewReference(item, this.referencesProvider::nextNonStorableInObjectStreamsReferenceFor);
    }

    private IndirectCOSObjectReference createNewReference(COSBase item, Function<COSBase, IndirectCOSObjectReference> supplier) {
        if (item instanceof ExistingIndirectCOSObject) {
            ExistingIndirectCOSObject existingItem = (ExistingIndirectCOSObject)item;
            IndirectCOSObjectReference newRef = supplier.apply(item);
            LOG.trace("Created new indirect reference {} replacing the existing one {}", (Object)newRef, (Object)existingItem.id());
            this.lookupNewRef.put(existingItem.id(), newRef);
            return newRef;
        }
        IndirectCOSObjectReference newRef = supplier.apply(item);
        LOG.trace("Created new indirect reference '{}' ", (Object)newRef);
        item.idIfAbsent(new IndirectCOSObjectIdentifier(newRef.xrefEntry().key(), this.contextId));
        this.lookupNewRef.put(item.id(), newRef);
        return newRef;
    }

    IndirectCOSObjectReference getOrCreateIndirectReferenceFor(COSBase item) {
        if (this.hasIndirectReferenceFor(item)) {
            return this.lookupNewRef.get(item.id());
        }
        return this.createIndirectReferenceFor(item);
    }

    IndirectCOSObjectReference getIndirectReferenceFor(COSBase item) {
        return this.lookupNewRef.get(item.id());
    }

    boolean hasIndirectReferenceFor(COSBase item) {
        return item.hasId() && this.lookupNewRef.containsKey(item.id());
    }

    boolean hasWriteOption(WriteOption opt) {
        return this.opts.contains((Object)opt);
    }

    int written() {
        return this.written.size();
    }

    boolean hasWritten(XrefEntry entry) {
        return this.written.containsKey(entry.getObjectNumber());
    }

    XrefEntry putWritten(XrefEntry entry) {
        return this.written.put(entry.getObjectNumber(), entry);
    }

    XrefEntry highestWritten() {
        return (XrefEntry)this.written.get(this.written.lastKey());
    }

    XrefEntry lowestWritten() {
        return (XrefEntry)this.written.get(this.written.firstKey());
    }

    XrefEntry getWritten(Long objectNumber) {
        return (XrefEntry)this.written.get(objectNumber);
    }

    void writing(COSObjectKey key) {
        this.encryptor.ifPresent(e -> e.setCurrentCOSObjectKey(key));
    }
}

