/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Color;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.view.HighlightSearchEntry;

public class HighlighterManager
extends Observable {
    static HighlighterManager hilighterManager = null;
    private LinkedList<HighlightSearchEntry> highlights = new LinkedList();
    private List<SoftObserver> observers = new ArrayList<SoftObserver>();

    public static HighlighterManager getInstance() {
        if (hilighterManager == null) {
            hilighterManager = new HighlighterManager();
        }
        return hilighterManager;
    }

    public void reinitHighlights(LinkedList<HighlightSearchEntry> linkedList) {
        this.highlights = (LinkedList)linkedList.clone();
        this.setChanged();
        this.notifyObservers(null);
    }

    public void addHighlightEntry(String string, SearchMatch.Location location, boolean bl) {
        HighlightSearchEntry highlightSearchEntry = new HighlightSearchEntry(string, location, Color.red, bl);
        this.addHighlightEntry(highlightSearchEntry);
    }

    public void addHighlightEntry(HighlightSearchEntry highlightSearchEntry) {
        this.highlights.add(highlightSearchEntry);
        this.setChanged();
        this.notifyObservers(highlightSearchEntry);
    }

    public void removeHighlightEntry(int n) {
        this.highlights.remove(n);
        this.setChanged();
        this.notifyObservers(null);
    }

    public LinkedList<HighlightSearchEntry> getHighlights() {
        return (LinkedList)this.highlights.clone();
    }

    @Override
    public synchronized void addObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        Iterator<SoftObserver> iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            Observer observer2 = (Observer)iterator.next().get();
            if (observer2 == null) {
                iterator.remove();
                continue;
            }
            if (!observer.equals(observer2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.observers.add(new SoftObserver(observer));
        }
    }

    @Override
    public synchronized void deleteObserver(Observer observer) {
        Iterator<SoftObserver> iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            Observer observer2 = (Observer)iterator.next().get();
            if (observer2 == null) {
                iterator.remove();
                continue;
            }
            if (!observer.equals(observer2)) continue;
            iterator.remove();
            break;
        }
    }

    private synchronized void deleteSoftObserver(SoftObserver softObserver) {
        this.observers.remove(softObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyObservers(Object object) {
        Observer[] observerArray;
        HighlighterManager highlighterManager = this;
        synchronized (highlighterManager) {
            if (!this.hasChanged()) {
                return;
            }
            observerArray = new Observer[this.observers.size()];
            observerArray = this.observers.toArray(observerArray);
            this.clearChanged();
        }
        for (int i = observerArray.length - 1; i >= 0; --i) {
            observerArray[i].update(this, object);
        }
    }

    @Override
    public synchronized void deleteObservers() {
        this.observers.clear();
    }

    @Override
    public synchronized int countObservers() {
        return this.observers.size();
    }

    private class SoftObserver
    extends SoftReference<Observer>
    implements Observer {
        public SoftObserver(Observer observer) {
            super(observer);
        }

        @Override
        public void update(Observable observable, Object object) {
            Observer observer = (Observer)this.get();
            if (observer != null) {
                observer.update(observable, object);
            } else {
                HighlighterManager.this.deleteSoftObserver(this);
            }
        }
    }
}

