/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataFileCacheSession;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.PersistentStoreCollectionSession;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLHybrid
extends RowStoreAVL
implements PersistentStore {
    DataFileCacheSession cache;
    private int maxMemoryRowCount;
    private boolean useDisk;
    boolean isCached;
    int rowIdSequence = 0;

    public RowStoreAVLHybrid(Session session, PersistentStoreCollection persistentStoreCollection, TableBase tableBase, boolean bl) {
        this.session = session;
        this.manager = persistentStoreCollection;
        this.table = tableBase;
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.useDisk = bl;
        if (this.maxMemoryRowCount == 0) {
            this.useDisk = false;
        }
        if (tableBase.getTableType() == 9) {
            this.setTimestamp(session.getActionTimestamp());
        }
        this.resetAccessorKeys(tableBase.getIndexList());
        persistentStoreCollection.setStore(tableBase, this);
        this.nullsList = new boolean[tableBase.getColumnCount()];
    }

    @Override
    public boolean isMemory() {
        return !this.isCached;
    }

    @Override
    public void setMemory(boolean bl) {
        this.useDisk = !bl;
    }

    @Override
    public synchronized int getAccessCount() {
        return this.isCached ? this.cache.getAccessCount() : 0;
    }

    @Override
    public void set(CachedObject cachedObject) {
    }

    @Override
    public CachedObject get(long l) {
        try {
            if (this.isCached) {
                return this.cache.get(l, (PersistentStore)this, false);
            }
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    @Override
    public CachedObject get(long l, boolean bl) {
        try {
            if (this.isCached) {
                return this.cache.get(l, (PersistentStore)this, bl);
            }
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    @Override
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        try {
            if (this.isCached) {
                return this.cache.get(cachedObject, (PersistentStore)this, bl);
            }
            return cachedObject;
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    @Override
    public int getStorageSize(long l) {
        try {
            if (this.isCached) {
                return this.cache.get(l, (PersistentStore)this, false).getStorageSize();
            }
            return 0;
        }
        catch (HsqlException hsqlException) {
            return 0;
        }
    }

    @Override
    public void add(CachedObject cachedObject) {
        if (this.isCached) {
            int n = cachedObject.getRealSize(this.cache.rowOut);
            n += this.indexList.length * 16;
            n = this.cache.rowOut.getStorageSize(n);
            cachedObject.setStorageSize(n);
            this.cache.add(cachedObject);
        }
        Object[] objectArray = ((Row)cachedObject).getData();
        for (int i = 0; i < this.nullsList.length; ++i) {
            if (objectArray[i] != null) continue;
            this.nullsList[i] = true;
        }
    }

    @Override
    public CachedObject get(RowInputInterface rowInputInterface) {
        try {
            if (this.isCached) {
                return new RowAVLDisk(this.table, rowInputInterface);
            }
        }
        catch (HsqlException hsqlException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return null;
    }

    @Override
    public CachedObject getNewInstance(int n) {
        return null;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        if (!this.isCached && this.useDisk && this.elementCount >= (long)this.maxMemoryRowCount) {
            this.changeToDiskTable(session);
        }
        if (this.isCached) {
            RowAVLDisk rowAVLDisk = new RowAVLDisk(this.table, (Object[])object, this);
            this.add(rowAVLDisk);
            if (bl) {
                RowAction.addInsertAction(session, (Table)this.table, rowAVLDisk);
            }
            return rowAVLDisk;
        }
        int n = this.rowIdSequence++;
        RowAVL rowAVL = new RowAVL(this.table, (Object[])object, n, this);
        this.add(rowAVL);
        if (bl) {
            RowAction rowAction;
            rowAVL.rowAction = rowAction = new RowAction(session, this.table, 1, rowAVL, null);
        }
        return rowAVL;
    }

    @Override
    public void removeAll() {
        if (!this.isCached) {
            this.destroy();
        }
        this.elementCount = 0L;
        ArrayUtil.fillArray(this.accessorList, null);
        for (int i = 0; i < this.nullsList.length; ++i) {
            this.nullsList[i] = false;
        }
    }

    @Override
    public void remove(long l) {
        if (this.isCached) {
            this.cache.remove(l, this);
        }
    }

    @Override
    public void removePersistence(long l) {
    }

    @Override
    public void release(long l) {
        if (this.isCached) {
            this.cache.release(l);
        }
    }

    @Override
    public void commitPersistence(CachedObject cachedObject) {
    }

    @Override
    public void commitRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                this.remove(row.getPos());
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                this.remove(row.getPos());
                break;
            }
            case 3: {
                this.delete(session, row);
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                row = (Row)this.get((CachedObject)row, true);
                ((RowAVL)row).setNewNodes(this);
                row.keepInMemory(false);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache dataFileCache) {
        throw Error.runtimeError(201, "RowStoreAVLHybrid");
    }

    @Override
    public void release() {
        if (!this.isCached) {
            this.destroy();
        }
        ArrayUtil.fillArray(this.accessorList, null);
        if (this.isCached) {
            this.cache.adjustStoreCount(-1);
            this.cache = null;
            this.isCached = false;
        }
        this.manager.setStore(this.table, null);
        this.elementCount = 0L;
    }

    @Override
    public void delete(Session session, Row row) {
        super.delete(session, row);
    }

    @Override
    public void setAccessor(Index index, CachedObject cachedObject) {
        Index index2 = index;
        this.accessorList[index2.getPosition()] = cachedObject;
    }

    @Override
    public void setAccessor(Index index, long l) {
    }

    @Override
    public synchronized void resetAccessorKeys(Index[] indexArray) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = indexArray;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.isCached) {
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        super.resetAccessorKeys(indexArray);
    }

    @Override
    public boolean hasNull(int n) {
        return this.nullsList[n];
    }

    public final void changeToDiskTable(Session session) {
        this.cache = ((PersistentStoreCollectionSession)this.manager).getResultCache();
        if (this.cache != null) {
            IndexAVL indexAVL = (IndexAVL)this.indexList[0];
            NodeAVL nodeAVL = (NodeAVL)this.accessorList[0];
            RowIterator rowIterator = this.table.rowIterator(this);
            ArrayUtil.fillArray(this.accessorList, null);
            this.elementCount = 0L;
            this.isCached = true;
            this.cache.adjustStoreCount(1);
            while (rowIterator.hasNext()) {
                Row row = rowIterator.getNextRow();
                Row row2 = (Row)this.getNewCachedObject(session, row.getData(), false);
                this.indexRow(session, row2);
            }
            indexAVL.unlinkNodes(nodeAVL);
        }
        this.maxMemoryRowCount = Integer.MAX_VALUE;
    }
}

