/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;

public final class AutoCreateIndex {
    private final boolean needToCheck;
    private final boolean globallyDisabled;
    private final boolean dynamicMappingDisabled;
    private final String[] matches;
    private final String[] matches2;
    private final IndexNameExpressionResolver resolver;

    @Inject
    public AutoCreateIndex(Settings settings, IndexNameExpressionResolver resolver) {
        this.resolver = resolver;
        this.dynamicMappingDisabled = settings.getAsBoolean("index.mapper.dynamic", (Boolean)true) == false;
        String value = settings.get("action.auto_create_index");
        if (value == null || Booleans.isExplicitTrue(value)) {
            this.needToCheck = true;
            this.globallyDisabled = false;
            this.matches = null;
            this.matches2 = null;
        } else if (Booleans.isExplicitFalse(value)) {
            this.needToCheck = false;
            this.globallyDisabled = true;
            this.matches = null;
            this.matches2 = null;
        } else {
            this.needToCheck = true;
            this.globallyDisabled = false;
            this.matches = Strings.commaDelimitedListToStringArray(value);
            this.matches2 = new String[this.matches.length];
            for (int i = 0; i < this.matches.length; ++i) {
                this.matches2[i] = this.matches[i].substring(1);
            }
        }
    }

    public boolean needToCheck() {
        return this.needToCheck;
    }

    public boolean shouldAutoCreate(String index, ClusterState state) {
        if (!this.needToCheck) {
            return false;
        }
        boolean exists = this.resolver.hasIndexOrAlias(index, state);
        if (exists) {
            return false;
        }
        if (this.globallyDisabled || this.dynamicMappingDisabled) {
            return false;
        }
        if (this.matches == null) {
            return true;
        }
        for (int i = 0; i < this.matches.length; ++i) {
            char c = this.matches[i].charAt(0);
            if (c == '-') {
                if (!Regex.simpleMatch(this.matches2[i], index)) continue;
                return false;
            }
            if (!(c == '+' ? Regex.simpleMatch(this.matches2[i], index) : Regex.simpleMatch(this.matches[i], index))) continue;
            return true;
        }
        return false;
    }
}

