/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;

public class BulkByScrollTask
extends CancellableTask {
    private final AtomicLong total = new AtomicLong(0L);
    private final AtomicLong updated = new AtomicLong(0L);
    private final AtomicLong created = new AtomicLong(0L);
    private final AtomicLong deleted = new AtomicLong(0L);
    private final AtomicLong noops = new AtomicLong(0L);
    private final AtomicInteger batch = new AtomicInteger(0);
    private final AtomicLong versionConflicts = new AtomicLong(0L);
    private final AtomicLong retries = new AtomicLong(0L);

    public BulkByScrollTask(long id, String type, String action, String description) {
        super(id, type, action, description);
    }

    public Status getStatus() {
        return new Status(this.total.get(), this.updated.get(), this.created.get(), this.deleted.get(), this.batch.get(), this.versionConflicts.get(), this.noops.get(), this.retries.get(), this.getReasonCancelled());
    }

    public long getSuccessfullyProcessed() {
        return this.updated.get() + this.created.get() + this.deleted.get();
    }

    void setTotal(long totalHits) {
        this.total.set(totalHits);
    }

    void countBatch() {
        this.batch.incrementAndGet();
    }

    void countNoop() {
        this.noops.incrementAndGet();
    }

    void countCreated() {
        this.created.incrementAndGet();
    }

    void countUpdated() {
        this.updated.incrementAndGet();
    }

    void countDeleted() {
        this.deleted.incrementAndGet();
    }

    void countVersionConflict() {
        this.versionConflicts.incrementAndGet();
    }

    void countRetry() {
        this.retries.incrementAndGet();
    }

    public static class Status
    implements Task.Status {
        public static final Status PROTOTYPE = new Status(0L, 0L, 0L, 0L, 0, 0L, 0L, 0L, null);
        private final long total;
        private final long updated;
        private final long created;
        private final long deleted;
        private final int batches;
        private final long versionConflicts;
        private final long noops;
        private final long retries;
        private final String reasonCancelled;

        public Status(long total, long updated, long created, long deleted, int batches, long versionConflicts, long noops, long retries, @Nullable String reasonCancelled) {
            this.total = this.checkPositive(total, "total");
            this.updated = this.checkPositive(updated, "updated");
            this.created = this.checkPositive(created, "created");
            this.deleted = this.checkPositive(deleted, "deleted");
            this.batches = this.checkPositive(batches, "batches");
            this.versionConflicts = this.checkPositive(versionConflicts, "versionConflicts");
            this.noops = this.checkPositive(noops, "noops");
            this.retries = this.checkPositive(retries, "retries");
            this.reasonCancelled = reasonCancelled;
        }

        public Status(StreamInput in) throws IOException {
            this.total = in.readVLong();
            this.updated = in.readVLong();
            this.created = in.readVLong();
            this.deleted = in.readVLong();
            this.batches = in.readVInt();
            this.versionConflicts = in.readVLong();
            this.noops = in.readVLong();
            this.retries = in.readVLong();
            this.reasonCancelled = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.total);
            out.writeVLong(this.updated);
            out.writeVLong(this.created);
            out.writeVLong(this.deleted);
            out.writeVInt(this.batches);
            out.writeVLong(this.versionConflicts);
            out.writeVLong(this.noops);
            out.writeVLong(this.retries);
            out.writeOptionalString(this.reasonCancelled);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.innerXContent(builder, params, true, true);
            return builder.endObject();
        }

        public XContentBuilder innerXContent(XContentBuilder builder, ToXContent.Params params, boolean includeCreated, boolean includeDeleted) throws IOException {
            builder.field("total", this.total);
            builder.field("updated", this.updated);
            if (includeCreated) {
                builder.field("created", this.created);
            }
            if (includeDeleted) {
                builder.field("deleted", this.deleted);
            }
            builder.field("batches", this.batches);
            builder.field("version_conflicts", this.versionConflicts);
            builder.field("noops", this.noops);
            builder.field("retries", this.retries);
            if (this.reasonCancelled != null) {
                builder.field("canceled", this.reasonCancelled);
            }
            return builder;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("BulkIndexByScrollResponse[");
            this.innerToString(builder, true, true);
            return builder.append(']').toString();
        }

        public void innerToString(StringBuilder builder, boolean includeCreated, boolean includeDeleted) {
            builder.append("updated=").append(this.updated);
            if (includeCreated) {
                builder.append(",created=").append(this.created);
            }
            if (includeDeleted) {
                builder.append(",deleted=").append(this.deleted);
            }
            builder.append(",batches=").append(this.batches);
            builder.append(",versionConflicts=").append(this.versionConflicts);
            builder.append(",noops=").append(this.noops);
            builder.append(",retries=").append(this.retries);
            if (this.reasonCancelled != null) {
                builder.append(",canceled=").append(this.reasonCancelled);
            }
        }

        public String getWriteableName() {
            return "bulk-by-scroll";
        }

        public Status readFrom(StreamInput in) throws IOException {
            return new Status(in);
        }

        public long getTotal() {
            return this.total;
        }

        public long getUpdated() {
            return this.updated;
        }

        public long getCreated() {
            return this.created;
        }

        public long getDeleted() {
            return this.deleted;
        }

        public int getBatches() {
            return this.batches;
        }

        public long getVersionConflicts() {
            return this.versionConflicts;
        }

        public long getNoops() {
            return this.noops;
        }

        public long getRetries() {
            return this.retries;
        }

        public String getReasonCancelled() {
            return this.reasonCancelled;
        }

        private int checkPositive(int value, String name) {
            if (value < 0) {
                throw new IllegalArgumentException(name + " must be greater than 0 but was [" + value + "]");
            }
            return value;
        }

        private long checkPositive(long value, String name) {
            if (value < 0L) {
                throw new IllegalArgumentException(name + " must be greater than 0 but was [" + value + "]");
            }
            return value;
        }
    }
}

