/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix.tree;

import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.util.Collection;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.lucene.spatial.prefix.tree.FilterCellIterator;
import org.apache.lucene.spatial.prefix.tree.SingletonCellIterator;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;

public abstract class LegacyCell
implements Cell {
    private static final byte LEAF_BYTE = 43;
    protected byte[] bytes;
    protected int b_off;
    protected int b_len;
    protected boolean isLeaf;
    protected SpatialRelation shapeRel;
    protected Shape shape;

    protected LegacyCell(byte[] bytes, int off, int len) {
        this.bytes = bytes;
        this.b_off = off;
        this.b_len = len;
        this.readLeafAdjust();
    }

    protected void readCell(BytesRef bytes) {
        this.shapeRel = null;
        this.shape = null;
        this.bytes = bytes.bytes;
        this.b_off = bytes.offset;
        this.b_len = (short)bytes.length;
        this.readLeafAdjust();
    }

    protected void readLeafAdjust() {
        boolean bl = this.isLeaf = this.b_len > 0 && this.bytes[this.b_off + this.b_len - 1] == 43;
        if (this.isLeaf) {
            --this.b_len;
        }
        if (this.getLevel() == this.getMaxLevels()) {
            this.isLeaf = true;
        }
    }

    protected abstract SpatialPrefixTree getGrid();

    protected abstract int getMaxLevels();

    @Override
    public SpatialRelation getShapeRel() {
        return this.shapeRel;
    }

    @Override
    public void setShapeRel(SpatialRelation rel) {
        this.shapeRel = rel;
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public void setLeaf() {
        this.isLeaf = true;
    }

    @Override
    public BytesRef getTokenBytesWithLeaf(BytesRef result) {
        result = this.getTokenBytesNoLeaf(result);
        if (!this.isLeaf || this.getLevel() == this.getMaxLevels()) {
            return result;
        }
        if (result.bytes.length < result.offset + result.length + 1) {
            assert (false) : "Not supposed to happen; performance bug";
            byte[] copy = new byte[result.length + 1];
            System.arraycopy(result.bytes, result.offset, copy, 0, result.length - 1);
            result.bytes = copy;
            result.offset = 0;
        }
        result.bytes[result.offset + result.length++] = 43;
        return result;
    }

    @Override
    public BytesRef getTokenBytesNoLeaf(BytesRef result) {
        if (result == null) {
            return new BytesRef(this.bytes, this.b_off, this.b_len);
        }
        result.bytes = this.bytes;
        result.offset = this.b_off;
        result.length = this.b_len;
        return result;
    }

    @Override
    public int getLevel() {
        return this.b_len;
    }

    @Override
    public CellIterator getNextLevelCells(Shape shapeFilter) {
        assert (this.getLevel() < this.getGrid().getMaxLevels());
        if (shapeFilter instanceof Point) {
            LegacyCell cell = this.getSubCell((Point)shapeFilter);
            cell.shapeRel = SpatialRelation.CONTAINS;
            return new SingletonCellIterator(cell);
        }
        return new FilterCellIterator(this.getSubCells().iterator(), shapeFilter);
    }

    protected abstract LegacyCell getSubCell(Point var1);

    protected abstract Collection<Cell> getSubCells();

    public abstract int getSubCellsSize();

    @Override
    public boolean isPrefixOf(Cell c) {
        LegacyCell cell = (LegacyCell)c;
        boolean result = LegacyCell.sliceEquals(cell.bytes, cell.b_off, cell.b_len, this.bytes, this.b_off, this.b_len);
        assert (result == StringHelper.startsWith((BytesRef)c.getTokenBytesNoLeaf(null), (BytesRef)this.getTokenBytesNoLeaf(null)));
        return result;
    }

    private static boolean sliceEquals(byte[] sliceToTest_bytes, int sliceToTest_offset, int sliceToTest_length, byte[] other_bytes, int other_offset, int other_length) {
        if (sliceToTest_length < other_length) {
            return false;
        }
        int i = sliceToTest_offset;
        int j = other_offset;
        int k = other_offset + other_length;
        while (j < k) {
            if (sliceToTest_bytes[i++] == other_bytes[j++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareToNoLeaf(Cell fromCell) {
        LegacyCell b = (LegacyCell)fromCell;
        return LegacyCell.compare(this.bytes, this.b_off, this.b_len, b.bytes, b.b_off, b.b_len);
    }

    protected static int compare(byte[] aBytes, int aUpto, int a_length, byte[] bBytes, int bUpto, int b_length) {
        int aStop = aUpto + Math.min(a_length, b_length);
        while (aUpto < aStop) {
            int bByte;
            int aByte;
            int diff;
            if ((diff = (aByte = aBytes[aUpto++] & 0xFF) - (bByte = bBytes[bUpto++] & 0xFF)) == 0) continue;
            return diff;
        }
        return a_length - b_length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Cell) {
            Cell cell = (Cell)obj;
            return this.getTokenBytesWithLeaf(null).equals((Object)cell.getTokenBytesWithLeaf(null));
        }
        return false;
    }

    public int hashCode() {
        return this.getTokenBytesWithLeaf(null).hashCode();
    }

    public String toString() {
        return this.getTokenBytesWithLeaf(null).utf8ToString();
    }
}

