/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.awt.Rectangle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;

public class Courier
extends Base14Font {
    private static final URI fontFileURI;
    private static final String fontName = "Courier";
    private static final String fullName = "Courier";
    private static final Set familyNames;
    private static final int underlinePosition = -100;
    private static final int underlineThickness = 50;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 562;
    private static final int xHeight = 426;
    private static final int ascender = 629;
    private static final int descender = -157;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private static final Rectangle[] boundingBoxes;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private boolean enableKerning = false;

    public Courier() {
        this(false);
    }

    public Courier(boolean enableKerning) {
        this.enableKerning = enableKerning;
    }

    public String getEncodingName() {
        return encoding;
    }

    public URI getFontURI() {
        return fontFileURI;
    }

    public String getFontName() {
        return "Courier";
    }

    public String getEmbedFontName() {
        return this.getFontName();
    }

    public String getFullName() {
        return "Courier";
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    public FontType getFontType() {
        return FontType.TYPE1;
    }

    public int getAscender(int size) {
        return size * 629;
    }

    public int getCapHeight(int size) {
        return size * 562;
    }

    public int getDescender(int size) {
        return size * -157;
    }

    public int getXHeight(int size) {
        return size * 426;
    }

    public int getUnderlinePosition(int size) {
        return size * -100;
    }

    public int getUnderlineThickness(int size) {
        return size * 50;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    public int getWidth(int i, int size) {
        return size * width[i];
    }

    public Rectangle getBoundingBox(int glyphIndex, int size) {
        Rectangle bbox = boundingBoxes[glyphIndex];
        return new Rectangle(bbox.x * size, bbox.y * size, bbox.width * size, bbox.height * size);
    }

    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    public boolean hasKerningInfo() {
        return false;
    }

    public Map getKerningInfo() {
        return Collections.EMPTY_MAP;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        URI uri = null;
        try {
            uri = new URI("base14:" + "Courier".toLowerCase());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        fontFileURI = uri;
        width = new int[256];
        boundingBoxes = new Rectangle[256];
        Courier.width[65] = 600;
        Courier.boundingBoxes[65] = new Rectangle(3, 0, 594, 562);
        Courier.width[198] = 600;
        Courier.boundingBoxes[198] = new Rectangle(3, 0, 547, 562);
        Courier.width[193] = 600;
        Courier.boundingBoxes[193] = new Rectangle(3, 0, 594, 805);
        Courier.width[194] = 600;
        Courier.boundingBoxes[194] = new Rectangle(3, 0, 594, 787);
        Courier.width[196] = 600;
        Courier.boundingBoxes[196] = new Rectangle(3, 0, 594, 753);
        Courier.width[192] = 600;
        Courier.boundingBoxes[192] = new Rectangle(3, 0, 594, 805);
        Courier.width[197] = 600;
        Courier.boundingBoxes[197] = new Rectangle(3, 0, 594, 750);
        Courier.width[195] = 600;
        Courier.boundingBoxes[195] = new Rectangle(3, 0, 594, 729);
        Courier.width[66] = 600;
        Courier.boundingBoxes[66] = new Rectangle(43, 0, 516, 562);
        Courier.width[67] = 600;
        Courier.boundingBoxes[67] = new Rectangle(41, -18, 499, 598);
        Courier.width[199] = 600;
        Courier.boundingBoxes[199] = new Rectangle(41, -151, 499, 731);
        Courier.width[68] = 600;
        Courier.boundingBoxes[68] = new Rectangle(43, 0, 531, 562);
        Courier.width[69] = 600;
        Courier.boundingBoxes[69] = new Rectangle(53, 0, 497, 562);
        Courier.width[201] = 600;
        Courier.boundingBoxes[201] = new Rectangle(53, 0, 497, 805);
        Courier.width[202] = 600;
        Courier.boundingBoxes[202] = new Rectangle(53, 0, 497, 787);
        Courier.width[203] = 600;
        Courier.boundingBoxes[203] = new Rectangle(53, 0, 497, 753);
        Courier.width[200] = 600;
        Courier.boundingBoxes[200] = new Rectangle(53, 0, 497, 805);
        Courier.width[208] = 600;
        Courier.boundingBoxes[208] = new Rectangle(30, 0, 544, 562);
        Courier.width[128] = 600;
        Courier.boundingBoxes[128] = new Rectangle(0, 0, 0, 0);
        Courier.width[70] = 600;
        Courier.boundingBoxes[70] = new Rectangle(53, 0, 492, 562);
        Courier.width[71] = 600;
        Courier.boundingBoxes[71] = new Rectangle(31, -18, 544, 598);
        Courier.width[72] = 600;
        Courier.boundingBoxes[72] = new Rectangle(32, 0, 536, 562);
        Courier.width[73] = 600;
        Courier.boundingBoxes[73] = new Rectangle(96, 0, 408, 562);
        Courier.width[205] = 600;
        Courier.boundingBoxes[205] = new Rectangle(96, 0, 408, 805);
        Courier.width[206] = 600;
        Courier.boundingBoxes[206] = new Rectangle(96, 0, 408, 787);
        Courier.width[207] = 600;
        Courier.boundingBoxes[207] = new Rectangle(96, 0, 408, 753);
        Courier.width[204] = 600;
        Courier.boundingBoxes[204] = new Rectangle(96, 0, 408, 805);
        Courier.width[74] = 600;
        Courier.boundingBoxes[74] = new Rectangle(34, -18, 532, 580);
        Courier.width[75] = 600;
        Courier.boundingBoxes[75] = new Rectangle(38, 0, 544, 562);
        Courier.width[76] = 600;
        Courier.boundingBoxes[76] = new Rectangle(47, 0, 507, 562);
        Courier.width[77] = 600;
        Courier.boundingBoxes[77] = new Rectangle(4, 0, 592, 562);
        Courier.width[78] = 600;
        Courier.boundingBoxes[78] = new Rectangle(7, -13, 586, 575);
        Courier.width[209] = 600;
        Courier.boundingBoxes[209] = new Rectangle(7, -13, 586, 742);
        Courier.width[79] = 600;
        Courier.boundingBoxes[79] = new Rectangle(43, -18, 514, 598);
        Courier.width[140] = 600;
        Courier.boundingBoxes[140] = new Rectangle(7, 0, 560, 562);
        Courier.width[211] = 600;
        Courier.boundingBoxes[211] = new Rectangle(43, -18, 514, 823);
        Courier.width[212] = 600;
        Courier.boundingBoxes[212] = new Rectangle(43, -18, 514, 805);
        Courier.width[214] = 600;
        Courier.boundingBoxes[214] = new Rectangle(43, -18, 514, 771);
        Courier.width[210] = 600;
        Courier.boundingBoxes[210] = new Rectangle(43, -18, 514, 823);
        Courier.width[216] = 600;
        Courier.boundingBoxes[216] = new Rectangle(43, -80, 514, 709);
        Courier.width[213] = 600;
        Courier.boundingBoxes[213] = new Rectangle(43, -18, 514, 747);
        Courier.width[80] = 600;
        Courier.boundingBoxes[80] = new Rectangle(79, 0, 479, 562);
        Courier.width[81] = 600;
        Courier.boundingBoxes[81] = new Rectangle(43, -138, 514, 718);
        Courier.width[82] = 600;
        Courier.boundingBoxes[82] = new Rectangle(38, 0, 550, 562);
        Courier.width[83] = 600;
        Courier.boundingBoxes[83] = new Rectangle(72, -20, 457, 600);
        Courier.width[138] = 600;
        Courier.boundingBoxes[138] = new Rectangle(72, -20, 457, 822);
        Courier.width[84] = 600;
        Courier.boundingBoxes[84] = new Rectangle(38, 0, 525, 562);
        Courier.width[222] = 600;
        Courier.boundingBoxes[222] = new Rectangle(79, 0, 459, 562);
        Courier.width[85] = 600;
        Courier.boundingBoxes[85] = new Rectangle(17, -18, 566, 580);
        Courier.width[218] = 600;
        Courier.boundingBoxes[218] = new Rectangle(17, -18, 566, 823);
        Courier.width[219] = 600;
        Courier.boundingBoxes[219] = new Rectangle(17, -18, 566, 805);
        Courier.width[220] = 600;
        Courier.boundingBoxes[220] = new Rectangle(17, -18, 566, 771);
        Courier.width[217] = 600;
        Courier.boundingBoxes[217] = new Rectangle(17, -18, 566, 823);
        Courier.width[86] = 600;
        Courier.boundingBoxes[86] = new Rectangle(-4, -13, 608, 575);
        Courier.width[87] = 600;
        Courier.boundingBoxes[87] = new Rectangle(-3, -13, 606, 575);
        Courier.width[88] = 600;
        Courier.boundingBoxes[88] = new Rectangle(23, 0, 554, 562);
        Courier.width[89] = 600;
        Courier.boundingBoxes[89] = new Rectangle(24, 0, 552, 562);
        Courier.width[221] = 600;
        Courier.boundingBoxes[221] = new Rectangle(24, 0, 552, 805);
        Courier.width[159] = 600;
        Courier.boundingBoxes[159] = new Rectangle(24, 0, 552, 753);
        Courier.width[90] = 600;
        Courier.boundingBoxes[90] = new Rectangle(86, 0, 428, 562);
        Courier.width[142] = 600;
        Courier.boundingBoxes[142] = new Rectangle(86, 0, 428, 802);
        Courier.width[97] = 600;
        Courier.boundingBoxes[97] = new Rectangle(53, -15, 506, 456);
        Courier.width[225] = 600;
        Courier.boundingBoxes[225] = new Rectangle(53, -15, 506, 687);
        Courier.width[226] = 600;
        Courier.boundingBoxes[226] = new Rectangle(53, -15, 506, 669);
        Courier.width[180] = 600;
        Courier.boundingBoxes[180] = new Rectangle(242, 497, 227, 175);
        Courier.width[228] = 600;
        Courier.boundingBoxes[228] = new Rectangle(53, -15, 506, 635);
        Courier.width[230] = 600;
        Courier.boundingBoxes[230] = new Rectangle(19, -15, 551, 456);
        Courier.width[224] = 600;
        Courier.boundingBoxes[224] = new Rectangle(53, -15, 506, 687);
        Courier.width[38] = 600;
        Courier.boundingBoxes[38] = new Rectangle(63, -15, 475, 558);
        Courier.width[229] = 600;
        Courier.boundingBoxes[229] = new Rectangle(53, -15, 506, 642);
        Courier.width[94] = 600;
        Courier.boundingBoxes[94] = new Rectangle(94, 354, 412, 268);
        Courier.width[126] = 600;
        Courier.boundingBoxes[126] = new Rectangle(63, 197, 477, 123);
        Courier.width[42] = 600;
        Courier.boundingBoxes[42] = new Rectangle(116, 257, 368, 350);
        Courier.width[64] = 600;
        Courier.boundingBoxes[64] = new Rectangle(77, -15, 456, 637);
        Courier.width[227] = 600;
        Courier.boundingBoxes[227] = new Rectangle(53, -15, 506, 621);
        Courier.width[98] = 600;
        Courier.boundingBoxes[98] = new Rectangle(14, -15, 561, 644);
        Courier.width[92] = 600;
        Courier.boundingBoxes[92] = new Rectangle(118, -80, 364, 709);
        Courier.width[124] = 600;
        Courier.boundingBoxes[124] = new Rectangle(275, -250, 51, 1000);
        Courier.width[123] = 600;
        Courier.boundingBoxes[123] = new Rectangle(182, -108, 255, 730);
        Courier.width[125] = 600;
        Courier.boundingBoxes[125] = new Rectangle(163, -108, 255, 730);
        Courier.width[91] = 600;
        Courier.boundingBoxes[91] = new Rectangle(269, -108, 173, 730);
        Courier.width[93] = 600;
        Courier.boundingBoxes[93] = new Rectangle(158, -108, 173, 730);
        Courier.width[166] = 600;
        Courier.boundingBoxes[166] = new Rectangle(275, -175, 51, 850);
        Courier.width[149] = 600;
        Courier.boundingBoxes[149] = new Rectangle(172, 130, 256, 253);
        Courier.width[99] = 600;
        Courier.boundingBoxes[99] = new Rectangle(66, -15, 463, 456);
        Courier.width[231] = 600;
        Courier.boundingBoxes[231] = new Rectangle(66, -151, 463, 592);
        Courier.width[184] = 600;
        Courier.boundingBoxes[184] = new Rectangle(224, -151, 138, 161);
        Courier.width[162] = 600;
        Courier.boundingBoxes[162] = new Rectangle(96, -49, 404, 663);
        Courier.width[136] = 600;
        Courier.boundingBoxes[136] = new Rectangle(124, 477, 352, 177);
        Courier.width[58] = 600;
        Courier.boundingBoxes[58] = new Rectangle(229, -15, 142, 400);
        Courier.width[44] = 600;
        Courier.boundingBoxes[44] = new Rectangle(181, -112, 163, 234);
        Courier.width[169] = 600;
        Courier.boundingBoxes[169] = new Rectangle(0, -18, 600, 598);
        Courier.width[164] = 600;
        Courier.boundingBoxes[164] = new Rectangle(73, 58, 454, 448);
        Courier.width[100] = 600;
        Courier.boundingBoxes[100] = new Rectangle(45, -15, 546, 644);
        Courier.width[134] = 600;
        Courier.boundingBoxes[134] = new Rectangle(141, -78, 318, 658);
        Courier.width[135] = 600;
        Courier.boundingBoxes[135] = new Rectangle(141, -78, 318, 658);
        Courier.width[176] = 600;
        Courier.boundingBoxes[176] = new Rectangle(123, 269, 354, 353);
        Courier.width[168] = 600;
        Courier.boundingBoxes[168] = new Rectangle(148, 537, 305, 103);
        Courier.width[247] = 600;
        Courier.boundingBoxes[247] = new Rectangle(87, 48, 426, 419);
        Courier.width[36] = 600;
        Courier.boundingBoxes[36] = new Rectangle(105, -126, 391, 788);
        Courier.width[101] = 600;
        Courier.boundingBoxes[101] = new Rectangle(66, -15, 482, 456);
        Courier.width[233] = 600;
        Courier.boundingBoxes[233] = new Rectangle(66, -15, 482, 687);
        Courier.width[234] = 600;
        Courier.boundingBoxes[234] = new Rectangle(66, -15, 482, 669);
        Courier.width[235] = 600;
        Courier.boundingBoxes[235] = new Rectangle(66, -15, 482, 635);
        Courier.width[232] = 600;
        Courier.boundingBoxes[232] = new Rectangle(66, -15, 482, 687);
        Courier.width[56] = 600;
        Courier.boundingBoxes[56] = new Rectangle(102, -15, 396, 637);
        Courier.width[133] = 600;
        Courier.boundingBoxes[133] = new Rectangle(37, -15, 526, 126);
        Courier.width[151] = 600;
        Courier.boundingBoxes[151] = new Rectangle(0, 231, 600, 54);
        Courier.width[150] = 600;
        Courier.boundingBoxes[150] = new Rectangle(75, 231, 450, 54);
        Courier.width[61] = 600;
        Courier.boundingBoxes[61] = new Rectangle(80, 138, 440, 238);
        Courier.width[240] = 600;
        Courier.boundingBoxes[240] = new Rectangle(62, -15, 476, 644);
        Courier.width[33] = 600;
        Courier.boundingBoxes[33] = new Rectangle(236, -15, 128, 587);
        Courier.width[161] = 600;
        Courier.boundingBoxes[161] = new Rectangle(236, -157, 128, 587);
        Courier.width[102] = 600;
        Courier.boundingBoxes[102] = new Rectangle(114, 0, 417, 629);
        Courier.width[53] = 600;
        Courier.boundingBoxes[53] = new Rectangle(92, -15, 405, 622);
        Courier.width[131] = 600;
        Courier.boundingBoxes[131] = new Rectangle(4, -143, 535, 765);
        Courier.width[52] = 600;
        Courier.boundingBoxes[52] = new Rectangle(78, 0, 422, 622);
        Courier.width[103] = 600;
        Courier.boundingBoxes[103] = new Rectangle(45, -157, 521, 598);
        Courier.width[223] = 600;
        Courier.boundingBoxes[223] = new Rectangle(48, -15, 540, 644);
        Courier.width[96] = 600;
        Courier.boundingBoxes[96] = new Rectangle(151, 497, 227, 175);
        Courier.width[62] = 600;
        Courier.boundingBoxes[62] = new Rectangle(66, 42, 478, 430);
        Courier.width[171] = 600;
        Courier.boundingBoxes[171] = new Rectangle(37, 70, 526, 376);
        Courier.width[187] = 600;
        Courier.boundingBoxes[187] = new Rectangle(37, 70, 526, 376);
        Courier.width[139] = 600;
        Courier.boundingBoxes[139] = new Rectangle(149, 70, 302, 376);
        Courier.width[155] = 600;
        Courier.boundingBoxes[155] = new Rectangle(149, 70, 302, 376);
        Courier.width[104] = 600;
        Courier.boundingBoxes[104] = new Rectangle(18, 0, 564, 629);
        Courier.width[45] = 600;
        Courier.boundingBoxes[45] = new Rectangle(103, 231, 394, 54);
        Courier.width[105] = 600;
        Courier.boundingBoxes[105] = new Rectangle(95, 0, 410, 657);
        Courier.width[237] = 600;
        Courier.boundingBoxes[237] = new Rectangle(95, 0, 410, 672);
        Courier.width[238] = 600;
        Courier.boundingBoxes[238] = new Rectangle(94, 0, 411, 654);
        Courier.width[239] = 600;
        Courier.boundingBoxes[239] = new Rectangle(95, 0, 410, 620);
        Courier.width[236] = 600;
        Courier.boundingBoxes[236] = new Rectangle(95, 0, 410, 672);
        Courier.width[106] = 600;
        Courier.boundingBoxes[106] = new Rectangle(82, -157, 328, 814);
        Courier.width[107] = 600;
        Courier.boundingBoxes[107] = new Rectangle(43, 0, 537, 629);
        Courier.width[108] = 600;
        Courier.boundingBoxes[108] = new Rectangle(95, 0, 410, 629);
        Courier.width[60] = 600;
        Courier.boundingBoxes[60] = new Rectangle(41, 42, 478, 430);
        Courier.width[172] = 600;
        Courier.boundingBoxes[172] = new Rectangle(87, 108, 426, 261);
        Courier.width[109] = 600;
        Courier.boundingBoxes[109] = new Rectangle(-5, 0, 610, 441);
        Courier.width[175] = 600;
        Courier.boundingBoxes[175] = new Rectangle(120, 525, 360, 40);
        Courier.width[181] = 600;
        Courier.boundingBoxes[181] = new Rectangle(21, -157, 541, 583);
        Courier.width[215] = 600;
        Courier.boundingBoxes[215] = new Rectangle(87, 43, 428, 427);
        Courier.width[110] = 600;
        Courier.boundingBoxes[110] = new Rectangle(26, 0, 549, 441);
        Courier.width[57] = 600;
        Courier.boundingBoxes[57] = new Rectangle(96, -15, 393, 637);
        Courier.width[241] = 600;
        Courier.boundingBoxes[241] = new Rectangle(26, 0, 549, 606);
        Courier.width[35] = 600;
        Courier.boundingBoxes[35] = new Rectangle(93, -32, 414, 671);
        Courier.width[111] = 600;
        Courier.boundingBoxes[111] = new Rectangle(62, -15, 476, 456);
        Courier.width[243] = 600;
        Courier.boundingBoxes[243] = new Rectangle(62, -15, 476, 687);
        Courier.width[244] = 600;
        Courier.boundingBoxes[244] = new Rectangle(62, -15, 476, 669);
        Courier.width[246] = 600;
        Courier.boundingBoxes[246] = new Rectangle(62, -15, 476, 635);
        Courier.width[156] = 600;
        Courier.boundingBoxes[156] = new Rectangle(19, -15, 540, 456);
        Courier.width[242] = 600;
        Courier.boundingBoxes[242] = new Rectangle(62, -15, 476, 687);
        Courier.width[49] = 600;
        Courier.boundingBoxes[49] = new Rectangle(96, 0, 409, 622);
        Courier.width[189] = 600;
        Courier.boundingBoxes[189] = new Rectangle(0, -57, 611, 722);
        Courier.width[188] = 600;
        Courier.boundingBoxes[188] = new Rectangle(0, -57, 600, 722);
        Courier.width[185] = 600;
        Courier.boundingBoxes[185] = new Rectangle(172, 249, 256, 373);
        Courier.width[170] = 600;
        Courier.boundingBoxes[170] = new Rectangle(156, 249, 286, 331);
        Courier.width[186] = 600;
        Courier.boundingBoxes[186] = new Rectangle(157, 249, 286, 331);
        Courier.width[248] = 600;
        Courier.boundingBoxes[248] = new Rectangle(62, -80, 476, 586);
        Courier.width[245] = 600;
        Courier.boundingBoxes[245] = new Rectangle(62, -15, 476, 621);
        Courier.width[112] = 600;
        Courier.boundingBoxes[112] = new Rectangle(9, -157, 546, 598);
        Courier.width[182] = 600;
        Courier.boundingBoxes[182] = new Rectangle(50, -78, 461, 640);
        Courier.width[40] = 600;
        Courier.boundingBoxes[40] = new Rectangle(269, -108, 171, 730);
        Courier.width[41] = 600;
        Courier.boundingBoxes[41] = new Rectangle(160, -108, 171, 730);
        Courier.width[37] = 600;
        Courier.boundingBoxes[37] = new Rectangle(81, -15, 437, 637);
        Courier.width[46] = 600;
        Courier.boundingBoxes[46] = new Rectangle(229, -15, 142, 124);
        Courier.width[183] = 600;
        Courier.boundingBoxes[183] = new Rectangle(222, 189, 156, 138);
        Courier.width[137] = 600;
        Courier.boundingBoxes[137] = new Rectangle(3, -15, 597, 637);
        Courier.width[43] = 600;
        Courier.boundingBoxes[43] = new Rectangle(80, 44, 440, 426);
        Courier.width[177] = 600;
        Courier.boundingBoxes[177] = new Rectangle(87, 44, 426, 514);
        Courier.width[113] = 600;
        Courier.boundingBoxes[113] = new Rectangle(45, -157, 546, 598);
        Courier.width[63] = 600;
        Courier.boundingBoxes[63] = new Rectangle(129, -15, 363, 587);
        Courier.width[191] = 600;
        Courier.boundingBoxes[191] = new Rectangle(108, -157, 363, 587);
        Courier.width[34] = 600;
        Courier.boundingBoxes[34] = new Rectangle(187, 328, 226, 234);
        Courier.width[132] = 600;
        Courier.boundingBoxes[132] = new Rectangle(143, -134, 314, 234);
        Courier.width[147] = 600;
        Courier.boundingBoxes[147] = new Rectangle(143, 328, 328, 234);
        Courier.width[148] = 600;
        Courier.boundingBoxes[148] = new Rectangle(143, 328, 314, 234);
        Courier.width[145] = 600;
        Courier.boundingBoxes[145] = new Rectangle(224, 328, 163, 234);
        Courier.width[146] = 600;
        Courier.boundingBoxes[146] = new Rectangle(213, 328, 163, 234);
        Courier.width[130] = 600;
        Courier.boundingBoxes[130] = new Rectangle(213, -134, 163, 234);
        Courier.width[39] = 600;
        Courier.boundingBoxes[39] = new Rectangle(259, 328, 82, 234);
        Courier.width[114] = 600;
        Courier.boundingBoxes[114] = new Rectangle(60, 0, 499, 441);
        Courier.width[174] = 600;
        Courier.boundingBoxes[174] = new Rectangle(0, -18, 600, 598);
        Courier.width[115] = 600;
        Courier.boundingBoxes[115] = new Rectangle(80, -15, 433, 456);
        Courier.width[154] = 600;
        Courier.boundingBoxes[154] = new Rectangle(80, -15, 433, 684);
        Courier.width[167] = 600;
        Courier.boundingBoxes[167] = new Rectangle(113, -78, 375, 658);
        Courier.width[59] = 600;
        Courier.boundingBoxes[59] = new Rectangle(181, -112, 190, 497);
        Courier.width[55] = 600;
        Courier.boundingBoxes[55] = new Rectangle(82, 0, 401, 607);
        Courier.width[54] = 600;
        Courier.boundingBoxes[54] = new Rectangle(111, -15, 386, 637);
        Courier.width[47] = 600;
        Courier.boundingBoxes[47] = new Rectangle(125, -80, 350, 709);
        Courier.width[32] = 600;
        Courier.boundingBoxes[32] = new Rectangle(0, 0, 0, 0);
        Courier.width[163] = 600;
        Courier.boundingBoxes[163] = new Rectangle(84, -21, 437, 632);
        Courier.width[116] = 600;
        Courier.boundingBoxes[116] = new Rectangle(87, -15, 443, 576);
        Courier.width[254] = 600;
        Courier.boundingBoxes[254] = new Rectangle(-6, -157, 561, 786);
        Courier.width[51] = 600;
        Courier.boundingBoxes[51] = new Rectangle(75, -15, 391, 637);
        Courier.width[190] = 600;
        Courier.boundingBoxes[190] = new Rectangle(8, -56, 585, 722);
        Courier.width[179] = 600;
        Courier.boundingBoxes[179] = new Rectangle(155, 240, 251, 382);
        Courier.width[152] = 600;
        Courier.boundingBoxes[152] = new Rectangle(105, 489, 398, 117);
        Courier.width[153] = 600;
        Courier.boundingBoxes[153] = new Rectangle(-23, 263, 646, 299);
        Courier.width[50] = 600;
        Courier.boundingBoxes[50] = new Rectangle(70, 0, 401, 622);
        Courier.width[178] = 600;
        Courier.boundingBoxes[178] = new Rectangle(177, 249, 247, 373);
        Courier.width[117] = 600;
        Courier.boundingBoxes[117] = new Rectangle(21, -15, 541, 441);
        Courier.width[250] = 600;
        Courier.boundingBoxes[250] = new Rectangle(21, -15, 541, 687);
        Courier.width[251] = 600;
        Courier.boundingBoxes[251] = new Rectangle(21, -15, 541, 669);
        Courier.width[252] = 600;
        Courier.boundingBoxes[252] = new Rectangle(21, -15, 541, 635);
        Courier.width[249] = 600;
        Courier.boundingBoxes[249] = new Rectangle(21, -15, 541, 687);
        Courier.width[95] = 600;
        Courier.boundingBoxes[95] = new Rectangle(0, -125, 600, 50);
        Courier.width[118] = 600;
        Courier.boundingBoxes[118] = new Rectangle(10, -10, 580, 436);
        Courier.width[119] = 600;
        Courier.boundingBoxes[119] = new Rectangle(-4, -10, 608, 436);
        Courier.width[120] = 600;
        Courier.boundingBoxes[120] = new Rectangle(20, 0, 560, 426);
        Courier.width[121] = 600;
        Courier.boundingBoxes[121] = new Rectangle(7, -157, 585, 583);
        Courier.width[253] = 600;
        Courier.boundingBoxes[253] = new Rectangle(7, -157, 585, 829);
        Courier.width[255] = 600;
        Courier.boundingBoxes[255] = new Rectangle(7, -157, 585, 777);
        Courier.width[165] = 600;
        Courier.boundingBoxes[165] = new Rectangle(26, 0, 548, 562);
        Courier.width[122] = 600;
        Courier.boundingBoxes[122] = new Rectangle(99, 0, 403, 426);
        Courier.width[158] = 600;
        Courier.boundingBoxes[158] = new Rectangle(99, 0, 403, 669);
        Courier.width[48] = 600;
        Courier.boundingBoxes[48] = new Rectangle(106, -15, 388, 637);
        familyNames = new HashSet();
        familyNames.add("Courier");
    }
}

