/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class ChangeWorkImprovementTypeMessage
extends DOMMessage {
    private final String unitId;
    private final String improvementId;

    public ChangeWorkImprovementTypeMessage(Unit unit, TileImprovementType type) {
        super(ChangeWorkImprovementTypeMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.improvementId = type.getId();
    }

    public ChangeWorkImprovementTypeMessage(Game game, Element element) {
        super(ChangeWorkImprovementTypeMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.improvementId = element.getAttribute("improvementType");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        Tile tile = unit.getTile();
        if (tile == null) {
            return DOMMessage.clientError("Unit is not on the map: " + this.unitId);
        }
        if (!unit.hasAbility("model.ability.improveTerrain")) {
            return DOMMessage.clientError("Unit can not improve tiles: " + this.unitId);
        }
        TileImprovementType type = server.getSpecification().getTileImprovementType(this.improvementId);
        if (type == null) {
            return DOMMessage.clientError("Not a tile improvement type: " + this.improvementId);
        }
        if (type.isNatural()) {
            return DOMMessage.clientError("ImprovementType must not be natural: " + this.improvementId);
        }
        if (!type.isTileTypeAllowed(tile.getType())) {
            return DOMMessage.clientError("ImprovementType not allowed on tile: " + this.improvementId);
        }
        TileImprovement improvement = tile.getTileImprovement(type);
        if (improvement == null) {
            if (!type.isWorkerAllowed(unit)) {
                return DOMMessage.clientError("Unit can not create improvement: " + this.improvementId);
            }
        } else if (!improvement.isWorkerAllowed(unit)) {
            return DOMMessage.clientError("Unit can not work on improvement: " + this.improvementId);
        }
        return server.getInGameController().changeWorkImprovementType(serverPlayer, unit, type);
    }

    @Override
    public Element toXMLElement() {
        return ChangeWorkImprovementTypeMessage.createMessage(ChangeWorkImprovementTypeMessage.getXMLElementTagName(), "unit", this.unitId, "improvementType", this.improvementId);
    }

    public static String getXMLElementTagName() {
        return "changeWorkImprovementType";
    }
}

