/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;

public class MulticolumnAtom
extends Atom {
    protected int n;
    protected int align;
    protected float w = 0.0f;
    protected Atom cols;
    protected int beforeVlines;
    protected int afterVlines;
    protected int row;
    protected int col;

    public MulticolumnAtom(int n, String string, Atom atom) {
        this.n = n >= 1 ? n : 1;
        this.cols = atom;
        this.align = this.parseAlign(string);
    }

    public void setWidth(float f) {
        this.w = f;
    }

    public int getSkipped() {
        return this.n;
    }

    public boolean hasRightVline() {
        return this.afterVlines != 0;
    }

    public void setRowColumn(int n, int n2) {
        this.row = n;
        this.col = n2;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    private int parseAlign(String string) {
        int n = string.length();
        int n2 = 2;
        boolean bl = true;
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case 'l': {
                    n2 = 0;
                    bl = false;
                    continue block6;
                }
                case 'r': {
                    n2 = 1;
                    bl = false;
                    continue block6;
                }
                case 'c': {
                    n2 = 2;
                    bl = false;
                    continue block6;
                }
                case '|': {
                    if (bl) {
                        this.beforeVlines = 1;
                    } else {
                        this.afterVlines = 1;
                    }
                    while (++i < n) {
                        c = string.charAt(i);
                        if (c != '|') {
                            --i;
                            continue block6;
                        }
                        if (bl) {
                            ++this.beforeVlines;
                            continue;
                        }
                        ++this.afterVlines;
                    }
                    continue block6;
                }
            }
        }
        return n2;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        Box box = this.w == 0.0f ? this.cols.createBox(teXEnvironment) : new HorizontalBox(this.cols.createBox(teXEnvironment), this.w, this.align);
        box.type = 12;
        return box;
    }
}

