/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.LinkedList;
import java.util.ListIterator;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.VerticalBox;

public class VRowAtom
extends Atom {
    protected LinkedList<Atom> elements = new LinkedList();
    private SpaceAtom raise = new SpaceAtom(1, 0.0f, 0.0f, 0.0f);
    protected boolean addInterline = false;

    public VRowAtom() {
    }

    public VRowAtom(Atom atom) {
        if (atom != null) {
            if (atom instanceof VRowAtom) {
                this.elements.addAll(((VRowAtom)atom).elements);
            } else {
                this.elements.add(atom);
            }
        }
    }

    public void setAddInterline(boolean bl) {
        this.addInterline = bl;
    }

    public boolean getAddInterline() {
        return this.addInterline;
    }

    public void setRaise(int n, float f) {
        this.raise = new SpaceAtom(n, f, 0.0f, 0.0f);
    }

    public Atom getLastAtom() {
        return this.elements.removeLast();
    }

    public final void add(Atom atom) {
        if (atom != null) {
            this.elements.add(0, atom);
        }
    }

    public final void append(Atom atom) {
        if (atom != null) {
            this.elements.add(atom);
        }
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        VerticalBox verticalBox = new VerticalBox();
        StrutBox strutBox = new StrutBox(0.0f, teXEnvironment.getInterline(), 0.0f, 0.0f);
        ListIterator listIterator = this.elements.listIterator();
        while (listIterator.hasNext()) {
            verticalBox.add(((Atom)listIterator.next()).createBox(teXEnvironment));
            if (!this.addInterline || !listIterator.hasNext()) continue;
            verticalBox.add(strutBox);
        }
        verticalBox.setShift(-this.raise.createBox(teXEnvironment).getWidth());
        float f = verticalBox.getSize() == 0 ? 0.0f : ((Box)verticalBox.children.getLast()).getDepth();
        verticalBox.setHeight(verticalBox.getDepth() + verticalBox.getHeight() - f);
        verticalBox.setDepth(f);
        return verticalBox;
    }
}

