/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.tasks.TaskInstantiationException;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskFactory
implements ITaskFactory {
    private final ClassGenerator generator;
    private final ProjectInternal project;
    private final Instantiator instantiator;
    private final Set<String> validTaskArguments;

    public TaskFactory(ClassGenerator generator) {
        this(generator, null, null);
    }

    TaskFactory(ClassGenerator generator, ProjectInternal project, Instantiator instantiator) {
        this.generator = generator;
        this.project = project;
        this.instantiator = instantiator;
        this.validTaskArguments = new HashSet<String>();
        this.validTaskArguments.add("action");
        this.validTaskArguments.add("dependsOn");
        this.validTaskArguments.add("description");
        this.validTaskArguments.add("group");
        this.validTaskArguments.add("name");
        this.validTaskArguments.add("overwrite");
        this.validTaskArguments.add("type");
    }

    @Override
    public ITaskFactory createChild(ProjectInternal project, Instantiator instantiator) {
        return new TaskFactory(this.generator, project, instantiator);
    }

    @Override
    public TaskInternal createTask(Map<String, ?> args) {
        Object action;
        Object group;
        Object description;
        HashMap<String, Object> actualArgs = new HashMap<String, Object>(args);
        this.checkTaskArgsAndCreateDefaultValues(actualArgs);
        String name = actualArgs.get("name").toString();
        if (!GUtil.isTrue((Object)name)) {
            throw new InvalidUserDataException("The task name must be provided.");
        }
        Class type = (Class)actualArgs.get("type");
        Object task = this.create(name, type);
        Object dependsOnTasks = actualArgs.get("dependsOn");
        if (dependsOnTasks != null) {
            task.dependsOn(dependsOnTasks);
        }
        if ((description = actualArgs.get("description")) != null) {
            task.setDescription(description.toString());
        }
        if ((group = actualArgs.get("group")) != null) {
            task.setGroup(group.toString());
        }
        if ((action = actualArgs.get("action")) instanceof Action) {
            Action taskAction = (Action)action;
            task.doFirst((Action<? super Task>)taskAction);
        } else if (action != null) {
            Closure closure = (Closure)action;
            task.doFirst(closure);
        }
        return task;
    }

    public <S extends TaskInternal> S create(String name, final Class<S> type) {
        if (!Task.class.isAssignableFrom(type)) {
            throw new InvalidUserDataException(String.format("Cannot create task of type '%s' as it does not implement the Task interface.", type.getSimpleName()));
        }
        final Class<DefaultTask> generatedType = type.isAssignableFrom(DefaultTask.class) ? this.generator.generate(DefaultTask.class) : this.generator.generate(type);
        return (S)((TaskInternal)type.cast(AbstractTask.injectIntoNewInstance(this.project, name, new Callable<Task>(){

            @Override
            public Task call() throws Exception {
                try {
                    return (Task)TaskFactory.this.instantiator.newInstance(generatedType, new Object[0]);
                }
                catch (ObjectInstantiationException e) {
                    throw new TaskInstantiationException(String.format("Could not create task of type '%s'.", type.getSimpleName()), e.getCause());
                }
            }
        })));
    }

    private void checkTaskArgsAndCreateDefaultValues(Map<String, Object> args) {
        this.validateArgs(args);
        this.setIfNull(args, "name", "");
        this.setIfNull(args, "type", DefaultTask.class);
    }

    private void validateArgs(Map<String, Object> args) {
        if (!this.validTaskArguments.containsAll(args.keySet())) {
            HashMap<String, Object> unknownArguments = new HashMap<String, Object>(args);
            unknownArguments.keySet().removeAll(this.validTaskArguments);
            throw new InvalidUserDataException(String.format("Could not create task '%s': Unknown argument(s) in task definition: %s", args.get("name"), unknownArguments.keySet()));
        }
    }

    private void setIfNull(Map<String, Object> map, String key, Object defaultValue) {
        if (map.get(key) == null) {
            map.put(key, defaultValue);
        }
    }
}

