/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodePredicate;
import org.gradle.model.internal.inspect.AbstractExtractedModelRule;
import org.gradle.model.internal.inspect.ExtractedModelRule;
import org.gradle.model.internal.inspect.MethodModelRuleApplicationContext;
import org.gradle.model.internal.inspect.MethodModelRuleExtractionContext;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.ModelRuleInvoker;
import org.gradle.model.internal.inspect.RuleSourceValidationProblemCollector;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentBinaries;
import org.gradle.platform.base.VariantComponentSpec;
import org.gradle.platform.base.internal.registry.AbstractAnnotationDrivenComponentModelRuleExtractor;
import org.gradle.platform.base.internal.registry.ModelMapBasedRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBinariesModelRuleExtractor
extends AbstractAnnotationDrivenComponentModelRuleExtractor<ComponentBinaries> {
    private static final ModelType<BinarySpec> BINARY_SPEC = ModelType.of(BinarySpec.class);
    private static final ModelType<VariantComponentSpec> COMPONENT_SPEC = ModelType.of(VariantComponentSpec.class);

    @Nullable
    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition, MethodModelRuleExtractionContext context) {
        return this.createRegistration(ruleDefinition, (RuleSourceValidationProblemCollector)context);
    }

    private <R, S extends BinarySpec, C extends VariantComponentSpec> ExtractedModelRule createRegistration(MethodRuleDefinition<R, ?> ruleDefinition, RuleSourceValidationProblemCollector problems) {
        AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector dataCollector = new AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector(this);
        this.visitAndVerifyMethodSignature(dataCollector, ruleDefinition, problems);
        if (problems.hasProblems()) {
            return null;
        }
        ModelType binaryType = dataCollector.getParameterType(BINARY_SPEC);
        ModelType componentType = dataCollector.getParameterType(COMPONENT_SPEC);
        return new ExtractedComponentBinariesRule(componentType, binaryType, ruleDefinition);
    }

    private void visitAndVerifyMethodSignature(AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector dataCollector, MethodRuleDefinition<?, ?> ruleDefinition, RuleSourceValidationProblemCollector problems) {
        this.validateIsVoidMethod(ruleDefinition, problems);
        this.visitSubject(dataCollector, ruleDefinition, BINARY_SPEC, problems);
        this.visitDependency(dataCollector, ruleDefinition, ModelType.of(VariantComponentSpec.class), problems);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractedComponentBinariesRule<S extends BinarySpec, C extends VariantComponentSpec>
    extends AbstractExtractedModelRule {
        private final ModelType<C> componentType;
        private final ModelType<S> binaryType;

        public ExtractedComponentBinariesRule(ModelType<C> componentType, ModelType<S> binaryType, MethodRuleDefinition<?, ?> ruleDefinition) {
            super(ruleDefinition);
            this.componentType = componentType;
            this.binaryType = binaryType;
        }

        public void apply(MethodModelRuleApplicationContext context, MutableModelNode target) {
            ModelReference subject = ModelReference.of(this.componentType);
            ComponentBinariesRule<S, C> componentBinariesRule = new ComponentBinariesRule<S, C>(subject, this.componentType, this.binaryType, this.getRuleDefinition());
            ModelAction componentBinariesAction = context.contextualize(componentBinariesRule);
            target.applyTo(NodePredicate.allDescendants(), ModelActionRole.Finalize, componentBinariesAction);
        }

        public List<? extends Class<?>> getRuleDependencies() {
            return ImmutableList.of(ComponentModelBasePlugin.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComponentBinariesRule<S extends BinarySpec, C extends VariantComponentSpec>
    extends ModelMapBasedRule<VariantComponentSpec, C> {
        private final ModelType<S> binaryType;

        public ComponentBinariesRule(ModelReference<C> subject, ModelType<C> componentType, ModelType<S> binaryType, MethodRuleDefinition<?, ?> ruleDefinition) {
            super(subject, componentType, ruleDefinition, new ModelReference[0]);
            this.binaryType = binaryType;
        }

        protected void execute(ModelRuleInvoker<?> invoker, C component, List<ModelView<?>> inputs) {
            this.invoke(invoker, inputs, component.getBinaries().withType(this.binaryType.getConcreteClass()), component, new Object[0]);
        }
    }
}

