/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.IOException;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import jspecview.api.JSVExporter;
import jspecview.common.Coordinate;
import jspecview.common.ExportType;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.Spectrum;
import jspecview.export.JDXCompressor;
import jspecview.source.JDXReader;

public class JDXExporter
implements JSVExporter {
    public static final String newLine = System.getProperty("line.separator");
    private OC out;
    private ExportType type;
    private Spectrum spectrum;
    private JSViewer vwr;
    private static final double FACTOR_DIVISOR = 1000000.0;

    @Override
    public String exportTheSpectrum(JSViewer jSViewer, ExportType exportType, OC oC, Spectrum spectrum, int n, int n2, PanelData panelData, boolean bl) throws IOException {
        this.out = oC;
        this.type = exportType;
        this.spectrum = spectrum;
        this.vwr = jSViewer;
        this.toStringAux(n, n2);
        oC.closeChannel();
        return "OK " + oC.getByteCount() + " bytes";
    }

    private void toStringAux(int n, int n2) {
        int n3;
        Coordinate[] coordinateArray = this.spectrum.getXYCoords();
        String string = "";
        String string2 = "XYDATA";
        if (this.spectrum.isHZtoPPM()) {
            Coordinate[] coordinateArray2 = coordinateArray;
            coordinateArray = new Coordinate[coordinateArray2.length];
            for (int i = 0; i < coordinateArray2.length; ++i) {
                coordinateArray[i] = coordinateArray2[i].copy();
            }
            Coordinate.applyScale(coordinateArray, this.spectrum.getObservedFreq(), 1.0);
        }
        double d = this.spectrum.getXFactor();
        boolean bl = JDXExporter.areIntegers(coordinateArray, n, n2, 1.0, true);
        if (!bl && !JDXExporter.areIntegers(coordinateArray, n, n2, d, true)) {
            d = 1.0;
        }
        double d2 = Coordinate.getMinY(coordinateArray, n, n2);
        double d3 = Coordinate.getMaxY(coordinateArray, n, n2);
        double d4 = this.spectrum.getYFactor();
        switch (this.type) {
            case XY: {
                d4 = 1.0;
                string2 = this.spectrum.isContinuous() ? "XYDATA" : "XYPOINTS";
                break;
            }
            case PAC: {
                d4 = 1.0;
                break;
            }
            default: {
                n3 = JDXExporter.areIntegers(coordinateArray, n, n2, 1.0, false);
                if (n3 != 0 || JDXExporter.areIntegers(coordinateArray, n, n2, d4, false)) break;
                d4 = (d3 - d2) / 1000000.0;
            }
        }
        n3 = 1;
        if (this.spectrum.isExportXAxisLeftToRight() != this.spectrum.getFirstX() < this.spectrum.getLastX()) {
            int n4 = n;
            n = n2;
            n2 = n4;
            n3 = -1;
        }
        switch (this.type) {
            case DIF: 
            case DIFDUP: {
                string = JDXCompressor.compressDIF(coordinateArray, n, n2, n3, d, d4, this.type == ExportType.DIFDUP);
                break;
            }
            case FIX: {
                string = JDXCompressor.compressFIX(coordinateArray, n, n2, n3, d, d4);
                break;
            }
            case PAC: {
                string = JDXCompressor.compressPAC(coordinateArray, n, n2, n3, d, d4);
                break;
            }
            case SQZ: {
                string = JDXCompressor.compressSQZ(coordinateArray, n, n2, n3, d, d4);
                break;
            }
            case XY: {
                string = JDXCompressor.getXYList(coordinateArray, n, n2, n3);
                break;
            }
        }
        String string3 = JDXReader.getVarList(string2);
        this.getHeaderString(string2, d2, d3, d, d4, n, n2);
        this.out.append("##" + string2 + "= " + string3 + newLine);
        this.out.append(string);
        this.out.append("##END=");
    }

    private void getHeaderString(String string, double d, double d2, double d3, double d4, int n, int n2) {
        Coordinate[] coordinateArray;
        this.out.append("##TITLE= ").append(this.spectrum.getTitle()).append(newLine);
        this.out.append("##JCAMP-DX= 5.01").append(newLine);
        this.out.append("##DATA TYPE= ").append(this.spectrum.getDataType()).append(newLine);
        this.out.append("##DATA CLASS= ").append(string).append(newLine);
        this.out.append("##ORIGIN= ").append(this.spectrum.getOrigin()).append(newLine);
        this.out.append("##OWNER= ").append(this.spectrum.getOwner()).append(newLine);
        String string2 = this.spectrum.getDate();
        String string3 = "";
        String string4 = this.vwr.apiPlatform.getDateFormat(null);
        string3 = this.spectrum.getLongDate().equals("") || string2.length() != 8 ? string4 + " $$ export date from JSpecView" : (string2.length() == 8 ? (string2.charAt(0) < '5' ? "20" : "19") + string2 + " " + this.spectrum.getTime() : this.spectrum.getLongDate());
        this.out.append("##LONGDATE= ").append(string3).append(newLine);
        Lst<String[]> lst = this.spectrum.getHeaderTable();
        for (int i = 0; i < lst.size(); ++i) {
            String[] stringArray = (String[])lst.get(i);
            String string5 = stringArray[0];
            String string6 = stringArray[1];
            coordinateArray = string6.startsWith("<") && string6.contains("</") ? newLine : "";
            this.out.append(string5).append("= ").append((String)coordinateArray).append(string6).append(newLine);
        }
        double d5 = this.spectrum.getObservedFreq();
        if (!this.spectrum.is1D()) {
            this.out.append("##NUM DIM= ").append("" + this.spectrum.numDim).append(newLine);
        }
        if (d5 != Double.MAX_VALUE) {
            this.out.append("##.OBSERVE FREQUENCY= ").append("" + d5).append(newLine);
        }
        if (this.spectrum.observedNucl != "") {
            this.out.append("##.OBSERVE NUCLEUS= ").append(this.spectrum.observedNucl).append(newLine);
        }
        this.out.append("##XUNITS= ").append(this.spectrum.isHZtoPPM() ? "HZ" : this.spectrum.getXUnits()).append(newLine);
        this.out.append("##YUNITS= ").append(this.spectrum.getYUnits()).append(newLine);
        this.out.append("##XFACTOR= ").append(JDXExporter.fixExponentInt(d3)).append(newLine);
        this.out.append("##YFACTOR= ").append(JDXExporter.fixExponentInt(d4)).append(newLine);
        double d6 = this.spectrum.isHZtoPPM() ? d5 : 1.0;
        coordinateArray = this.spectrum.getXYCoords();
        this.out.append("##FIRSTX= ").append(JDXExporter.fixExponentInt(coordinateArray[n].getXVal() * d6)).append(newLine);
        this.out.append("##FIRSTY= ").append(JDXExporter.fixExponentInt(coordinateArray[n].getYVal())).append(newLine);
        this.out.append("##LASTX= ").append(JDXExporter.fixExponentInt(coordinateArray[n2].getXVal() * d6)).append(newLine);
        this.out.append("##NPOINTS= ").append("" + (Math.abs(n2 - n) + 1)).append(newLine);
        this.out.append("##MINY= ").append(JDXExporter.fixExponentInt(d)).append(newLine);
        this.out.append("##MAXY= ").append(JDXExporter.fixExponentInt(d2)).append(newLine);
    }

    private static boolean areIntegers(Coordinate[] coordinateArray, int n, int n2, double d, boolean bl) {
        for (int i = n; i <= n2; ++i) {
            double d2 = (bl ? coordinateArray[i].getXVal() : coordinateArray[i].getYVal()) / d;
            if (!JDXExporter.isAlmostInteger(d2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAlmostInteger(double d) {
        return d != 0.0 && Math.abs(d - Math.floor(d)) / d > 1.0E-8;
    }

    private static String fixExponentInt(double d) {
        return d == Math.floor(d) ? String.valueOf((int)d) : PT.rep(JDXExporter.fixExponent(d), "E+00", "");
    }

    private static String fixExponent(double d) {
        String string = DF.formatDecimalDbl(d, -7);
        int n = string.indexOf("E");
        if (n < 0) {
            return string;
        }
        if (string.length() == n + 3) {
            string = string.substring(0, n + 2) + "0" + string.substring(n + 2);
        }
        return string;
    }
}

