/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Map;
import javajs.J2SRequireImport;
import javajs.api.EventManager;
import javajs.util.AU;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.api.Interface;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.MeasurementPending;
import org.jmol.thread.HoverWatcherThread;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;
import org.jmol.util.Rectangle;
import org.jmol.viewer.Gesture;
import org.jmol.viewer.MouseState;
import org.jmol.viewer.Viewer;
import org.jmol.viewer.binding.Binding;
import org.jmol.viewer.binding.JmolBinding;

@J2SRequireImport(value={GT.class})
public class ActionManager
implements EventManager {
    protected Viewer vwr;
    protected boolean haveMultiTouchInput;
    protected boolean isMultiTouch;
    public Binding b;
    private Binding jmolBinding;
    private Binding pfaatBinding;
    private Binding dragBinding;
    private Binding rasmolBinding;
    private Binding predragBinding;
    private int LEFT_CLICKED;
    private int LEFT_DRAGGED;
    protected Thread hoverWatcherThread;
    private Gesture dragGesture;
    public static final int ACTION_assignNew = 0;
    public static final int ACTION_center = 1;
    public static final int ACTION_clickFrank = 2;
    public static final int ACTION_connectAtoms = 3;
    public static final int ACTION_deleteAtom = 4;
    public static final int ACTION_deleteBond = 5;
    public static final int ACTION_depth = 6;
    public static final int ACTION_dragAtom = 7;
    public static final int ACTION_dragDrawObject = 8;
    public static final int ACTION_dragDrawPoint = 9;
    public static final int ACTION_dragLabel = 10;
    public static final int ACTION_dragMinimize = 11;
    public static final int ACTION_dragMinimizeMolecule = 12;
    public static final int ACTION_dragSelected = 13;
    public static final int ACTION_dragZ = 14;
    public static final int ACTION_multiTouchSimulation = 15;
    public static final int ACTION_navTranslate = 16;
    public static final int ACTION_pickAtom = 17;
    public static final int ACTION_pickIsosurface = 18;
    public static final int ACTION_pickLabel = 19;
    public static final int ACTION_pickMeasure = 20;
    public static final int ACTION_pickNavigate = 21;
    public static final int ACTION_pickPoint = 22;
    public static final int ACTION_popupMenu = 23;
    public static final int ACTION_reset = 24;
    public static final int ACTION_rotate = 25;
    public static final int ACTION_rotateBranch = 26;
    public static final int ACTION_rotateSelected = 27;
    public static final int ACTION_rotateZ = 28;
    public static final int ACTION_rotateZorZoom = 29;
    public static final int ACTION_select = 30;
    public static final int ACTION_selectAndDrag = 31;
    public static final int ACTION_selectAndNot = 32;
    public static final int ACTION_selectNone = 33;
    public static final int ACTION_selectOr = 34;
    public static final int ACTION_selectToggle = 35;
    public static final int ACTION_selectToggleExtended = 36;
    public static final int ACTION_setMeasure = 37;
    public static final int ACTION_slab = 38;
    public static final int ACTION_slabAndDepth = 39;
    public static final int ACTION_slideZoom = 40;
    public static final int ACTION_spinDrawObjectCCW = 41;
    public static final int ACTION_spinDrawObjectCW = 42;
    public static final int ACTION_stopMotion = 43;
    public static final int ACTION_swipe = 44;
    public static final int ACTION_translate = 45;
    public static final int ACTION_wheelZoom = 46;
    public static final int ACTION_count = 47;
    static final String[] actionInfo = new String[47];
    static final String[] actionNames = new String[47];
    private int apm = 1;
    private int bondPickingMode;
    public static final int PICKING_OFF = 0;
    public static final int PICKING_IDENTIFY = 1;
    public static final int PICKING_LABEL = 2;
    public static final int PICKING_CENTER = 3;
    public static final int PICKING_DRAW = 4;
    public static final int PICKING_SPIN = 5;
    public static final int PICKING_SYMMETRY = 6;
    public static final int PICKING_DELETE_ATOM = 7;
    public static final int PICKING_DELETE_BOND = 8;
    public static final int PICKING_SELECT_ATOM = 9;
    public static final int PICKING_SELECT_GROUP = 10;
    public static final int PICKING_SELECT_CHAIN = 11;
    public static final int PICKING_SELECT_MOLECULE = 12;
    public static final int PICKING_SELECT_POLYMER = 13;
    public static final int PICKING_SELECT_STRUCTURE = 14;
    public static final int PICKING_SELECT_SITE = 15;
    public static final int PICKING_SELECT_MODEL = 16;
    public static final int PICKING_SELECT_ELEMENT = 17;
    public static final int PICKING_MEASURE = 18;
    public static final int PICKING_MEASURE_DISTANCE = 19;
    public static final int PICKING_MEASURE_ANGLE = 20;
    public static final int PICKING_MEASURE_TORSION = 21;
    public static final int PICKING_MEASURE_SEQUENCE = 22;
    public static final int PICKING_NAVIGATE = 23;
    public static final int PICKING_CONNECT = 24;
    public static final int PICKING_STRUTS = 25;
    public static final int PICKING_DRAG_SELECTED = 26;
    public static final int PICKING_DRAG_MOLECULE = 27;
    public static final int PICKING_DRAG_ATOM = 28;
    public static final int PICKING_DRAG_MINIMIZE = 29;
    public static final int PICKING_DRAG_MINIMIZE_MOLECULE = 30;
    public static final int PICKING_INVERT_STEREO = 31;
    public static final int PICKING_ASSIGN_ATOM = 32;
    public static final int PICKING_ASSIGN_BOND = 33;
    public static final int PICKING_ROTATE_BOND = 34;
    public static final int PICKING_IDENTIFY_BOND = 35;
    public static final int PICKING_DRAG_LIGAND = 36;
    public static final int PICKINGSTYLE_SELECT_JMOL = 0;
    public static final int PICKINGSTYLE_SELECT_CHIME = 0;
    public static final int PICKINGSTYLE_SELECT_RASMOL = 1;
    public static final int PICKINGSTYLE_SELECT_PFAAT = 2;
    public static final int PICKINGSTYLE_SELECT_DRAG = 3;
    public static final int PICKINGSTYLE_MEASURE_ON = 4;
    public static final int PICKINGSTYLE_MEASURE_OFF = 5;
    private static final String[] pickingModeNames = "off identify label center draw spin symmetry deleteatom deletebond atom group chain molecule polymer structure site model element measure distance angle torsion sequence navigate connect struts dragselected dragmolecule dragatom dragminimize dragminimizemolecule invertstereo assignatom assignbond rotatebond identifybond dragligand".split(" ");
    private static final String[] pickingStyleNames = "toggle selectOrToggle extendedSelect drag measure measureoff".split(" ");
    private int pickingStyle;
    private int pickingStyleSelect = 0;
    private int pickingStyleMeasure = 5;
    private int rootPickingStyle = 0;
    private String pickAtomAssignType = "C";
    private char pickBondAssignType = (char)112;
    private boolean isPickAtomAssignCharge;
    private static final long MAX_DOUBLE_CLICK_MILLIS = 700L;
    protected static final long MININUM_GESTURE_DELAY_MILLISECONDS = 10L;
    private static final int SLIDE_ZOOM_X_PERCENT = 98;
    public static final float DEFAULT_MOUSE_DRAG_FACTOR = 1.0f;
    public static final float DEFAULT_MOUSE_WHEEL_FACTOR = 1.15f;
    public static final float DEFAULT_GESTURE_SWIPE_FACTOR = 1.0f;
    protected int xyRange = 0;
    private float gestureSwipeFactor = 1.0f;
    protected float mouseDragFactor = 1.0f;
    protected float mouseWheelFactor = 1.15f;
    protected final MouseState current = new MouseState("current");
    protected final MouseState moved = new MouseState("moved");
    private final MouseState clicked = new MouseState("clicked");
    private final MouseState pressed = new MouseState("pressed");
    private final MouseState dragged = new MouseState("dragged");
    protected int pressedCount;
    protected int clickedCount;
    private boolean drawMode;
    private boolean labelMode;
    private boolean dragSelectedMode;
    private boolean measuresEnabled = true;
    private boolean haveSelection;
    private boolean hoverActive = false;
    private MeasurementPending mp;
    private int dragAtomIndex = -1;
    private boolean rubberbandSelectionMode = false;
    private final Rectangle rectRubber = new Rectangle();
    private boolean isAltKeyReleased = true;
    private boolean keyProcessing;
    protected boolean isMultiTouchClient;
    protected boolean isMultiTouchServer;
    private int pressAction;
    private int dragAction;
    private int clickAction;
    private MeasurementPending measurementQueued;
    private boolean selectionWorking = false;

    public void setViewer(Viewer viewer, String string) {
        this.vwr = viewer;
        if (!viewer.isJS) {
            this.createActions();
        }
        this.jmolBinding = new JmolBinding();
        this.setBinding(this.jmolBinding);
        this.LEFT_CLICKED = Binding.getMouseAction(1, 16, 2);
        this.LEFT_DRAGGED = Binding.getMouseAction(1, 16, 1);
        this.dragGesture = new Gesture(20, viewer);
    }

    public void checkHover() {
        if (!(this.vwr.getInMotion(true) || this.vwr.tm.spinOn || this.vwr.tm.navOn || this.vwr.checkObjectHovered(this.current.x, this.current.y))) {
            int n = this.vwr.findNearestAtomIndex(this.current.x, this.current.y);
            if (n < 0) {
                return;
            }
            boolean bl = this.apm == 2 && this.bnd(Binding.getMouseAction(this.clickedCount, this.moved.modifiers, 1), 10);
            this.vwr.hoverOn(n, bl);
        }
    }

    public void processMultitouchEvent(int n, int n2, int n3, int n4, P3 p3, long l) {
    }

    void bind(String string, String string2) {
        int n = ActionManager.getActionFromName(string2);
        int n2 = Binding.getMouseActionStr(string);
        if (n2 == 0) {
            return;
        }
        if (n >= 0) {
            this.b.bindAction(n2, n);
        } else {
            this.b.bindName(n2, string2);
        }
    }

    protected void clearBindings() {
        this.jmolBinding = new JmolBinding();
        this.setBinding(this.jmolBinding);
        this.pfaatBinding = null;
        this.dragBinding = null;
        this.rasmolBinding = null;
    }

    void unbindAction(String string, String string2) {
        if (string == null && string2 == null) {
            this.clearBindings();
            return;
        }
        int n = ActionManager.getActionFromName(string2);
        int n2 = Binding.getMouseActionStr(string);
        if (n >= 0) {
            this.b.unbindAction(n2, n);
        } else if (n2 != 0) {
            this.b.unbindName(n2, string2);
        }
        if (string2 == null) {
            this.b.unbindUserAction(string);
        }
    }

    static void newAction(int n, String string, String string2) {
        ActionManager.actionInfo[n] = string2;
        ActionManager.actionNames[n] = string;
    }

    void createActions() {
        if (actionInfo[0] != null) {
            return;
        }
        ActionManager.newAction(0, "_assignNew", GT.o(GT._("assign/new atom or bond (requires {0})"), "set picking assignAtom_??/assignBond_?"));
        ActionManager.newAction(1, "_center", GT._("center"));
        ActionManager.newAction(2, "_clickFrank", GT._("pop up recent context menu (click on Jmol frank)"));
        ActionManager.newAction(4, "_deleteAtom", GT.o(GT._("delete atom (requires {0})"), "set picking DELETE ATOM"));
        ActionManager.newAction(5, "_deleteBond", GT.o(GT._("delete bond (requires {0})"), "set picking DELETE BOND"));
        ActionManager.newAction(6, "_depth", GT.o(GT._("adjust depth (back plane; requires {0})"), "SLAB ON"));
        ActionManager.newAction(7, "_dragAtom", GT.o(GT._("move atom (requires {0})"), "set picking DRAGATOM"));
        ActionManager.newAction(8, "_dragDrawObject", GT.o(GT._("move whole DRAW object (requires {0})"), "set picking DRAW"));
        ActionManager.newAction(9, "_dragDrawPoint", GT.o(GT._("move specific DRAW point (requires {0})"), "set picking DRAW"));
        ActionManager.newAction(10, "_dragLabel", GT.o(GT._("move label (requires {0})"), "set picking LABEL"));
        ActionManager.newAction(11, "_dragMinimize", GT.o(GT._("move atom and minimize molecule (requires {0})"), "set picking DRAGMINIMIZE"));
        ActionManager.newAction(12, "_dragMinimizeMolecule", GT.o(GT._("move and minimize molecule (requires {0})"), "set picking DRAGMINIMIZEMOLECULE"));
        ActionManager.newAction(13, "_dragSelected", GT.o(GT._("move selected atoms (requires {0})"), "set DRAGSELECTED"));
        ActionManager.newAction(14, "_dragZ", GT.o(GT._("drag atoms in Z direction (requires {0})"), "set DRAGSELECTED"));
        ActionManager.newAction(15, "_multiTouchSimulation", GT._("simulate multi-touch using the mouse)"));
        ActionManager.newAction(16, "_navTranslate", GT.o(GT._("translate navigation point (requires {0} and {1})"), new String[]{"set NAVIGATIONMODE", "set picking NAVIGATE"}));
        ActionManager.newAction(17, "_pickAtom", GT._("pick an atom"));
        ActionManager.newAction(3, "_pickConnect", GT.o(GT._("connect atoms (requires {0})"), "set picking CONNECT"));
        ActionManager.newAction(18, "_pickIsosurface", GT.o(GT._("pick an ISOSURFACE point (requires {0}"), "set DRAWPICKING"));
        ActionManager.newAction(19, "_pickLabel", GT.o(GT._("pick a label to toggle it hidden/displayed (requires {0})"), "set picking LABEL"));
        ActionManager.newAction(20, "_pickMeasure", GT.o(GT._("pick an atom to include it in a measurement (after starting a measurement or after {0})"), "set picking DISTANCE/ANGLE/TORSION"));
        ActionManager.newAction(21, "_pickNavigate", GT.o(GT._("pick a point or atom to navigate to (requires {0})"), "set NAVIGATIONMODE"));
        ActionManager.newAction(22, "_pickPoint", GT.o(GT._("pick a DRAW point (for measurements) (requires {0}"), "set DRAWPICKING"));
        ActionManager.newAction(23, "_popupMenu", GT._("pop up the full context menu"));
        ActionManager.newAction(24, "_reset", GT._("reset (when clicked off the model)"));
        ActionManager.newAction(25, "_rotate", GT._("rotate"));
        ActionManager.newAction(26, "_rotateBranch", GT.o(GT._("rotate branch around bond (requires {0})"), "set picking ROTATEBOND"));
        ActionManager.newAction(27, "_rotateSelected", GT.o(GT._("rotate selected atoms (requires {0})"), "set DRAGSELECTED"));
        ActionManager.newAction(28, "_rotateZ", GT._("rotate Z"));
        ActionManager.newAction(29, "_rotateZorZoom", GT._("rotate Z (horizontal motion of mouse) or zoom (vertical motion of mouse)"));
        ActionManager.newAction(30, "_select", GT.o(GT._("select an atom (requires {0})"), "set pickingStyle EXTENDEDSELECT"));
        ActionManager.newAction(31, "_selectAndDrag", GT.o(GT._("select and drag atoms (requires {0})"), "set DRAGSELECTED"));
        ActionManager.newAction(32, "_selectAndNot", GT.o(GT._("unselect this group of atoms (requires {0})"), "set pickingStyle DRAG/EXTENDEDSELECT"));
        ActionManager.newAction(33, "_selectNone", GT.o(GT._("select NONE (requires {0})"), "set pickingStyle EXTENDEDSELECT"));
        ActionManager.newAction(34, "_selectOr", GT.o(GT._("add this group of atoms to the set of selected atoms (requires {0})"), "set pickingStyle DRAG/EXTENDEDSELECT"));
        ActionManager.newAction(35, "_selectToggle", GT.o(GT._("toggle selection (requires {0})"), "set pickingStyle DRAG/EXTENDEDSELECT/RASMOL"));
        ActionManager.newAction(36, "_selectToggleOr", GT.o(GT._("if all are selected, unselect all, otherwise add this group of atoms to the set of selected atoms (requires {0})"), "set pickingStyle DRAG"));
        ActionManager.newAction(37, "_setMeasure", GT._("pick an atom to initiate or conclude a measurement"));
        ActionManager.newAction(38, "_slab", GT.o(GT._("adjust slab (front plane; requires {0})"), "SLAB ON"));
        ActionManager.newAction(39, "_slabAndDepth", GT.o(GT._("move slab/depth window (both planes; requires {0})"), "SLAB ON"));
        ActionManager.newAction(40, "_slideZoom", GT._("zoom (along right edge of window)"));
        ActionManager.newAction(41, "_spinDrawObjectCCW", GT.o(GT._("click on two points to spin around axis counterclockwise (requires {0})"), "set picking SPIN"));
        ActionManager.newAction(42, "_spinDrawObjectCW", GT.o(GT._("click on two points to spin around axis clockwise (requires {0})"), "set picking SPIN"));
        ActionManager.newAction(43, "_stopMotion", GT.o(GT._("stop motion (requires {0})"), "set waitForMoveTo FALSE"));
        ActionManager.newAction(44, "_swipe", GT._("spin model (swipe and release button and stop motion simultaneously)"));
        ActionManager.newAction(45, "_translate", GT._("translate"));
        ActionManager.newAction(46, "_wheelZoom", GT._("zoom"));
    }

    public static String getActionName(int n) {
        return n < actionNames.length ? actionNames[n] : null;
    }

    public static int getActionFromName(String string) {
        for (int i = 0; i < actionNames.length; ++i) {
            if (!actionNames[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public String getBindingInfo(String string) {
        return this.b.getBindingInfo(actionInfo, actionNames, string);
    }

    protected void setBinding(Binding binding) {
        this.b = binding;
    }

    boolean bnd(int n, int ... nArray) {
        int n2 = nArray.length;
        while (--n2 >= 0) {
            if (!this.b.isBound(n, nArray[n2])) continue;
            return true;
        }
        return false;
    }

    private boolean isDrawOrLabelAction(int n) {
        return this.drawMode && this.bnd(n, 8, 9) || this.labelMode && this.bnd(n, 10);
    }

    public static final String getPickingModeName(int n) {
        return n < 0 || n >= pickingModeNames.length ? "off" : pickingModeNames[n];
    }

    public static final int getPickingMode(String string) {
        int n = pickingModeNames.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(pickingModeNames[n])) continue;
            return n;
        }
        return -1;
    }

    public static final String getPickingStyleName(int n) {
        return n < 0 || n >= pickingStyleNames.length ? "toggle" : pickingStyleNames[n];
    }

    public static final int getPickingStyleIndex(String string) {
        int n = pickingStyleNames.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(pickingStyleNames[n])) continue;
            return n;
        }
        return -1;
    }

    int getAtomPickingMode() {
        return this.apm;
    }

    void setPickingMode(int n) {
        boolean bl = false;
        switch (n) {
            case -1: {
                bl = true;
                this.bondPickingMode = 35;
                n = 1;
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                this.vwr.setBooleanProperty("bondPicking", true);
                this.bondPickingMode = n;
                return;
            }
            case 8: {
                this.bondPickingMode = n;
                if (this.vwr.getBondPicking()) {
                    return;
                }
                bl = true;
            }
        }
        boolean bl2 = this.apm != n;
        this.apm = n;
        if (bl |= bl2) {
            this.resetMeasurement();
        }
    }

    void setAtomPickingOption(String string) {
        switch (this.apm) {
            case 32: {
                this.pickAtomAssignType = string;
                this.isPickAtomAssignCharge = this.pickAtomAssignType.equals("Pl") || this.pickAtomAssignType.equals("Mi");
            }
        }
    }

    void setBondPickingOption(String string) {
        switch (this.bondPickingMode) {
            case 33: {
                this.pickBondAssignType = Character.toLowerCase(string.charAt(0));
            }
        }
    }

    public String getPickingState() {
        String string = ";set modelkitMode " + this.vwr.getBoolean(603979883) + ";set picking " + ActionManager.getPickingModeName(this.apm);
        if (this.apm == 32) {
            string = string + "_" + this.pickAtomAssignType;
        }
        string = string + ";";
        if (this.bondPickingMode != 0) {
            string = string + "set picking " + ActionManager.getPickingModeName(this.bondPickingMode);
        }
        if (this.bondPickingMode == 33) {
            string = string + "_" + this.pickBondAssignType;
        }
        string = string + ";";
        return string;
    }

    int getPickingStyle() {
        return this.pickingStyle;
    }

    void setPickingStyle(int n) {
        this.pickingStyle = n;
        if (n >= 4) {
            this.pickingStyleMeasure = n;
            this.resetMeasurement();
        } else {
            if (n < 3) {
                this.rootPickingStyle = n;
            }
            this.pickingStyleSelect = n;
        }
        this.rubberbandSelectionMode = false;
        switch (this.pickingStyleSelect) {
            case 2: {
                if (this.b.name.equals("extendedSelect")) break;
                this.setBinding(this.pfaatBinding == null ? (this.pfaatBinding = Binding.newBinding(this.vwr, "Pfaat")) : this.pfaatBinding);
                break;
            }
            case 3: {
                if (!this.b.name.equals("drag")) {
                    this.setBinding(this.dragBinding == null ? (this.dragBinding = Binding.newBinding(this.vwr, "Drag")) : this.dragBinding);
                }
                this.rubberbandSelectionMode = true;
                break;
            }
            case 1: {
                if (this.b.name.equals("selectOrToggle")) break;
                this.setBinding(this.rasmolBinding == null ? (this.rasmolBinding = Binding.newBinding(this.vwr, "Rasmol")) : this.rasmolBinding);
                break;
            }
            default: {
                if (this.b == this.jmolBinding) break;
                this.setBinding(this.jmolBinding);
            }
        }
        if (!this.b.name.equals("drag")) {
            this.predragBinding = this.b;
        }
    }

    void setGestureSwipeFactor(float f) {
        this.gestureSwipeFactor = f;
    }

    void setMouseDragFactor(float f) {
        this.mouseDragFactor = f;
    }

    void setMouseWheelFactor(float f) {
        this.mouseWheelFactor = f;
    }

    protected void setCurrent(long l, int n, int n2, int n3) {
        this.vwr.hoverOff();
        this.current.set(l, n, n2, n3);
    }

    int getCurrentX() {
        return this.current.x;
    }

    int getCurrentY() {
        return this.current.y;
    }

    public void setMouseMode() {
        this.labelMode = false;
        this.drawMode = false;
        this.dragSelectedMode = this.vwr.getDragSelected();
        boolean bl = this.measuresEnabled = !this.dragSelectedMode;
        if (!this.dragSelectedMode) {
            switch (this.apm) {
                default: {
                    return;
                }
                case 32: {
                    this.measuresEnabled = !this.isPickAtomAssignCharge;
                    return;
                }
                case 4: {
                    this.drawMode = true;
                    this.measuresEnabled = false;
                    break;
                }
                case 2: {
                    this.labelMode = true;
                    this.measuresEnabled = false;
                    break;
                }
                case 9: {
                    this.measuresEnabled = false;
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    this.measuresEnabled = false;
                    return;
                }
            }
        }
        this.exitMeasurementMode(null);
    }

    protected void clearMouseInfo() {
        this.clickedCount = 0;
        this.pressedCount = 0;
        this.dragGesture.setAction(0, 0L);
        this.exitMeasurementMode(null);
    }

    public void setDragAtomIndex(int n) {
        this.dragAtomIndex = n;
    }

    public boolean isMTClient() {
        return this.isMultiTouchClient;
    }

    public boolean isMTServer() {
        return this.isMultiTouchServer;
    }

    public void dispose() {
        this.clear();
    }

    public void clear() {
        this.startHoverWatcher(false);
        if (this.predragBinding != null) {
            this.b = this.predragBinding;
        }
        this.vwr.setPickingMode(null, 1);
        this.vwr.setPickingStyle(null, this.rootPickingStyle);
        this.isAltKeyReleased = true;
    }

    public synchronized void startHoverWatcher(boolean bl) {
        if (this.vwr.isPreviewOnly) {
            return;
        }
        try {
            if (bl) {
                if (this.hoverWatcherThread != null) {
                    return;
                }
                this.current.time = -1L;
                this.hoverWatcherThread = new HoverWatcherThread(this, this.current, this.moved, this.vwr);
            } else {
                if (this.hoverWatcherThread == null) {
                    return;
                }
                this.current.time = -1L;
                this.hoverWatcherThread.interrupt();
                this.hoverWatcherThread = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setModeMouse(int n) {
        if (n == -1) {
            this.startHoverWatcher(false);
        }
    }

    @Override
    public boolean keyPressed(int n, int n2) {
        if (this.keyProcessing) {
            return false;
        }
        this.vwr.hoverOff();
        this.keyProcessing = true;
        switch (n) {
            case 18: {
                if (this.dragSelectedMode && this.isAltKeyReleased) {
                    this.vwr.moveSelected(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false, false);
                }
                this.isAltKeyReleased = false;
                this.moved.modifiers |= 8;
                break;
            }
            case 16: {
                this.dragged.modifiers |= 1;
                this.moved.modifiers |= 1;
                break;
            }
            case 17: {
                this.moved.modifiers |= 2;
                break;
            }
            case 27: {
                this.exitMeasurementMode("escape");
            }
        }
        int n3 = 0x2110 | this.moved.modifiers;
        if (!this.labelMode && !this.b.isUserAction(n3)) {
            this.checkMotionRotateZoom(n3, this.current.x, 0, 0, false);
        }
        if (this.vwr.getBoolean(603979889)) {
            switch (n) {
                case 32: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 46: {
                    this.vwr.navigate(n, n2);
                }
            }
        }
        this.keyProcessing = false;
        return true;
    }

    @Override
    public void keyReleased(int n) {
        switch (n) {
            case 18: {
                if (this.dragSelectedMode) {
                    this.vwr.moveSelected(Integer.MAX_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false, false);
                }
                this.isAltKeyReleased = true;
                this.moved.modifiers &= 0xFFFFFFF7;
                break;
            }
            case 16: {
                this.moved.modifiers &= 0xFFFFFFFE;
                break;
            }
            case 17: {
                this.moved.modifiers &= 0xFFFFFFFD;
            }
        }
        if (this.moved.modifiers == 0) {
            this.vwr.setCursor(0);
        }
        if (!this.vwr.getBoolean(603979889)) {
            return;
        }
        switch (n) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.vwr.navigate(0, 0);
            }
        }
    }

    @Override
    public void mouseEnterExit(long l, int n, int n2, boolean bl) {
        if (this.vwr.tm.stereoDoubleDTI) {
            n <<= 1;
        }
        this.setCurrent(l, n, n2, 0);
        if (bl) {
            this.exitMeasurementMode("mouseExit");
        }
    }

    private void setMouseActions(int n, int n2, boolean bl) {
        this.pressAction = Binding.getMouseAction(n, n2, bl ? 5 : 4);
        this.dragAction = Binding.getMouseAction(n, n2, 1);
        this.clickAction = Binding.getMouseAction(n, n2, 2);
    }

    @Override
    public void mouseAction(int n, long l, int n2, int n3, int n4, int n5) {
        if (!this.vwr.getMouseEnabled()) {
            return;
        }
        if (Logger.debuggingHigh && n != 0) {
            this.vwr.showString("mouse action: " + n + " " + n5 + " " + Binding.getMouseActionName(Binding.getMouseAction(n4, n5, n), false), false);
        }
        if (this.vwr.tm.stereoDoubleDTI) {
            n2 <<= 1;
        }
        switch (n) {
            case 0: {
                this.setCurrent(l, n2, n3, n5);
                this.moved.setCurrent(this.current, 0);
                if (this.mp != null || this.hoverActive) {
                    this.clickAction = Binding.getMouseAction(this.clickedCount, n5, 0);
                    this.checkClickAction(n2, n3, l, 0);
                    return;
                }
                if (this.isZoomArea(n2)) {
                    this.checkMotionRotateZoom(this.LEFT_DRAGGED, 0, 0, 0, false);
                    return;
                }
                if (this.vwr.currentCursor == 8) {
                    this.vwr.setCursor(0);
                }
                return;
            }
            case 4: {
                this.setMouseMode();
                int n6 = this.pressedCount = this.pressed.check(20, n2, n3, n5, l, 700L) ? this.pressedCount + 1 : 1;
                if (this.pressedCount == 1) {
                    this.vwr.checkInMotion(1);
                    this.setCurrent(l, n2, n3, n5);
                }
                this.pressAction = Binding.getMouseAction(this.pressedCount, n5, 4);
                this.vwr.setCursor(12);
                this.pressed.setCurrent(this.current, 1);
                this.dragged.setCurrent(this.current, 1);
                this.vwr.setFocus();
                this.dragGesture.setAction(this.dragAction, l);
                this.checkPressedAction(n2, n3, l);
                return;
            }
            case 1: {
                this.setMouseMode();
                this.setMouseActions(this.pressedCount, n5, false);
                int n7 = n2 - this.dragged.x;
                int n8 = n3 - this.dragged.y;
                this.setCurrent(l, n2, n3, n5);
                this.dragged.setCurrent(this.current, -1);
                this.dragGesture.add(this.dragAction, n2, n3, l);
                this.checkDragWheelAction(this.dragAction, n2, n3, n7, n8, l, 1);
                return;
            }
            case 5: {
                this.setMouseActions(this.pressedCount, n5, true);
                this.setCurrent(l, n2, n3, n5);
                this.vwr.spinXYBy(0, 0, 0.0f);
                boolean bl = !this.pressed.check(this.xyRange, n2, n3, n5, l, Long.MAX_VALUE);
                this.checkReleaseAction(n2, n3, l, bl);
                return;
            }
            case 3: {
                if (this.vwr.isApplet && !this.vwr.hasFocus()) {
                    return;
                }
                this.setCurrent(l, this.current.x, this.current.y, n5);
                this.checkDragWheelAction(Binding.getMouseAction(0, n5, 3), this.current.x, this.current.y, 0, n3, l, 3);
                return;
            }
            case 2: {
                this.setMouseMode();
                int n9 = n4 > 1 ? n4 : (this.clickedCount = this.clicked.check(0, 0, 0, n5, l, 700L) ? this.clickedCount + 1 : 1);
                if (this.clickedCount == 1) {
                    this.setCurrent(l, n2, n3, n5);
                }
                this.setMouseActions(this.clickedCount, n5, false);
                this.clicked.setCurrent(this.current, this.clickedCount);
                this.vwr.setFocus();
                if (this.apm != 9 && this.bnd(Binding.getMouseAction(1, n5, 4), 31)) {
                    return;
                }
                this.clickAction = Binding.getMouseAction(this.clickedCount, n5, 2);
                this.checkClickAction(n2, n3, l, this.clickedCount);
                return;
            }
        }
    }

    private void checkPressedAction(int n, int n2, long l) {
        int n3 = Binding.getButtonMods(this.pressAction);
        boolean bl = this.bnd(Binding.getMouseAction(1, n3, 4), 31);
        if (n3 != 0) {
            this.pressAction = this.vwr.notifyMouseClicked(n, n2, this.pressAction, 4);
            if (this.pressAction == 0) {
                return;
            }
            n3 = Binding.getButtonMods(this.pressAction);
        }
        this.setMouseActions(this.pressedCount, n3, false);
        if (Logger.debugging) {
            Logger.debug(Binding.getMouseActionName(this.pressAction, false));
        }
        if (this.isDrawOrLabelAction(this.dragAction)) {
            this.vwr.checkObjectDragged(Integer.MIN_VALUE, 0, n, n2, this.dragAction);
            return;
        }
        this.checkUserAction(this.pressAction, n, n2, 0, 0, l, 4);
        boolean bl2 = false;
        switch (this.apm) {
            case 32: {
                bl2 = this.bnd(this.clickAction, 0);
                break;
            }
            case 28: {
                bl2 = this.bnd(this.dragAction, 7, 14);
                break;
            }
            case 26: 
            case 27: 
            case 36: {
                bl2 = this.bnd(this.dragAction, 7, 14, 27);
                break;
            }
            case 29: {
                bl2 = this.bnd(this.dragAction, 11, 14);
                break;
            }
            case 30: {
                bl2 = this.bnd(this.dragAction, 11, 14, 27);
            }
        }
        if (bl2) {
            this.dragAtomIndex = this.vwr.findNearestAtomIndexMovable(n, n2, true);
            if (this.dragAtomIndex >= 0 && (this.apm == 32 || this.apm == 31) && this.vwr.ms.isAtomAssignable(this.dragAtomIndex)) {
                this.enterMeasurementMode(this.dragAtomIndex);
                this.mp.addPoint(this.dragAtomIndex, null, false);
            }
            return;
        }
        if (this.bnd(this.pressAction, 23)) {
            int n4 = 106;
            if (this.vwr.getBoolean(603979883)) {
                Map<String, Object> map = this.vwr.checkObjectClicked(n, n2, this.LEFT_CLICKED);
                n4 = map != null && "bond".equals(map.get("type")) ? 98 : (this.vwr.findNearestAtomIndex(n, n2) >= 0 ? 97 : 109);
            }
            this.vwr.popupMenu(n, n2, (char)n4);
            return;
        }
        if (this.dragSelectedMode) {
            boolean bl3 = this.haveSelection = !bl || this.vwr.findNearestAtomIndexMovable(n, n2, true) >= 0;
            if (this.haveSelection && this.bnd(this.dragAction, 13, 14)) {
                this.vwr.moveSelected(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false, false);
            }
            return;
        }
        this.checkMotionRotateZoom(this.dragAction, n, 0, 0, true);
    }

    private void checkDragWheelAction(int n, int n2, int n3, int n4, int n5, long l, int n6) {
        int n7 = Binding.getButtonMods(n);
        if (n7 != 0) {
            int n8 = this.vwr.notifyMouseClicked(n2, n3, Binding.getMouseAction(this.pressedCount, n7, n6), n6);
            if (n8 == 0) {
                return;
            }
            if (n8 > 0) {
                n = n8;
            }
        }
        if (this.isRubberBandSelect(n)) {
            this.calcRectRubberBand();
            this.vwr.refresh(3, "rubberBand selection");
            return;
        }
        if (this.checkUserAction(n, n2, n3, n4, n5, l, n6)) {
            return;
        }
        if (this.vwr.getRotateBondIndex() >= 0) {
            if (this.bnd(n, 26)) {
                this.vwr.moveSelected(n4, n5, Integer.MIN_VALUE, n2, n3, null, false, false);
                return;
            }
            if (!this.bnd(n, 25)) {
                this.vwr.setRotateBondIndex(-1);
            }
        }
        BS bS = null;
        if (this.dragAtomIndex >= 0 && this.apm != 2) {
            switch (this.apm) {
                case 26: {
                    this.dragSelected(n, n4, n5, true);
                    return;
                }
                case 27: 
                case 30: 
                case 36: {
                    bS = this.vwr.ms.getAtoms(0x41400010, BSUtil.newAndSetBit(this.dragAtomIndex));
                    if (this.apm == 36) {
                        bS.and(this.vwr.getAtomBitSet("ligand"));
                    }
                }
                case 28: 
                case 29: {
                    if (this.dragGesture.getPointCount() == 1) {
                        this.vwr.undoMoveActionClear(this.dragAtomIndex, 2, true);
                    }
                    this.setMotion(13, true);
                    if (this.bnd(n, 27)) {
                        this.vwr.rotateSelected(this.getDegrees(n4, true), this.getDegrees(n5, false), bS);
                    } else {
                        switch (this.apm) {
                            case 27: 
                            case 30: 
                            case 36: {
                                this.vwr.select(bS, false, 0, true);
                            }
                        }
                        this.vwr.moveAtomWithHydrogens(this.dragAtomIndex, n4, n5, this.bnd(n, 14) ? -n5 : Integer.MIN_VALUE, bS);
                    }
                    return;
                }
            }
        }
        if (this.dragAtomIndex >= 0 && n6 == 1 && this.bnd(this.clickAction, 0) && this.apm == 32) {
            int n9 = this.vwr.findNearestAtomIndexMovable(n2, n3, false);
            if (n9 >= 0) {
                if (this.mp != null) {
                    this.mp.setCount(1);
                } else if (this.measuresEnabled) {
                    this.enterMeasurementMode(n9);
                }
                this.addToMeasurement(n9, null, true);
                this.mp.colix = (short)20;
            } else if (this.mp != null) {
                this.mp.setCount(1);
                this.mp.colix = (short)23;
            }
            if (this.mp == null) {
                return;
            }
            this.mp.traceX = n2;
            this.mp.traceY = n3;
            this.vwr.refresh(3, "assignNew");
            return;
        }
        if (!this.drawMode && !this.labelMode && this.bnd(n, 45)) {
            this.vwr.translateXYBy(n4, n5);
            return;
        }
        if (this.dragSelectedMode && this.haveSelection && this.bnd(n, 13, 27)) {
            int n10 = this.vwr.bsA().nextSetBit(0);
            if (n10 < 0) {
                return;
            }
            if (this.dragGesture.getPointCount() == 1) {
                this.vwr.undoMoveActionClear(n10, 2, true);
            } else {
                this.vwr.moveSelected(Integer.MAX_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false, false);
            }
            this.dragSelected(n, n4, n5, false);
            return;
        }
        if (this.isDrawOrLabelAction(n)) {
            this.setMotion(13, true);
            this.vwr.checkObjectDragged(this.dragged.x, this.dragged.y, n2, n3, n);
            return;
        }
        if (this.checkMotionRotateZoom(n, n2, n4, n5, true)) {
            if (this.vwr.tm.slabEnabled && this.bnd(n, 39)) {
                this.vwr.slabDepthByPixels(n5);
            } else {
                this.vwr.zoomBy(n5);
            }
            return;
        }
        if (this.bnd(n, 25)) {
            this.vwr.rotateXYBy(this.getDegrees(n4, true), this.getDegrees(n5, false));
            return;
        }
        if (this.bnd(n, 29)) {
            if (n4 == 0 && Math.abs(n5) > 1) {
                this.setMotion(8, true);
                this.vwr.zoomBy(n5 + (n5 > 0 ? -1 : 1));
            } else if (n5 == 0 && Math.abs(n4) > 1) {
                this.setMotion(13, true);
                this.vwr.rotateZBy(-n4 + (n4 > 0 ? 1 : -1), Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            return;
        }
        if (this.vwr.tm.slabEnabled) {
            if (this.bnd(n, 6)) {
                this.vwr.depthByPixels(n5);
                return;
            }
            if (this.bnd(n, 38)) {
                this.vwr.slabByPixels(n5);
                return;
            }
            if (this.bnd(n, 39)) {
                this.vwr.slabDepthByPixels(n5);
                return;
            }
        }
        if (this.bnd(n, 46)) {
            this.zoomByFactor(n5, Integer.MAX_VALUE, Integer.MAX_VALUE);
            return;
        }
        if (this.bnd(n, 28)) {
            this.setMotion(13, true);
            this.vwr.rotateZBy(-n4, Integer.MAX_VALUE, Integer.MAX_VALUE);
            return;
        }
    }

    private void dragSelected(int n, int n2, int n3, boolean bl) {
        this.setMotion(13, true);
        if (this.bnd(n, 27) && this.vwr.getBoolean(603979785)) {
            this.vwr.rotateSelected(this.getDegrees(n2, true), this.getDegrees(n3, false), null);
        } else {
            this.vwr.moveSelected(n2, n3, bl && this.bnd(n, 14) ? -n3 : Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, true, false);
        }
    }

    private void checkReleaseAction(int n, int n2, long l, boolean bl) {
        if (Logger.debugging) {
            Logger.debug(Binding.getMouseActionName(this.pressAction, false));
        }
        this.vwr.checkInMotion(0);
        this.vwr.setInMotion(false);
        this.vwr.setCursor(0);
        this.dragGesture.add(this.dragAction, n, n2, l);
        if (bl) {
            this.vwr.setRotateBondIndex(Integer.MIN_VALUE);
        }
        if (this.dragAtomIndex >= 0 && (this.apm == 29 || this.apm == 30)) {
            this.minimize(true);
        }
        if (this.apm == 32 && this.bnd(this.clickAction, 0)) {
            if (this.mp == null || this.dragAtomIndex < 0) {
                return;
            }
            this.assignNew(n, n2);
            return;
        }
        this.dragAtomIndex = -1;
        boolean bl2 = this.isRubberBandSelect(this.dragAction);
        if (bl2) {
            this.selectRb(this.clickAction);
        }
        this.rubberbandSelectionMode = this.b.name.equals("drag");
        this.rectRubber.x = Integer.MAX_VALUE;
        if (bl) {
            this.vwr.notifyMouseClicked(n, n2, Binding.getMouseAction(this.pressedCount, 0, 5), 5);
        }
        if (this.isDrawOrLabelAction(this.dragAction)) {
            this.vwr.checkObjectDragged(Integer.MAX_VALUE, 0, n, n2, this.dragAction);
            return;
        }
        if (this.haveSelection && this.dragSelectedMode && this.bnd(this.dragAction, 13)) {
            this.vwr.moveSelected(Integer.MAX_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false, false);
        }
        if (bl && this.checkUserAction(this.pressAction, n, n2, 0, 0, l, 5)) {
            return;
        }
        if (this.vwr.getBoolean(0x24000004) && this.bnd(this.dragAction, 44)) {
            float f = this.getExitRate();
            if (f > 0.0f) {
                this.vwr.spinXYBy(this.dragGesture.getDX(4, 2), this.dragGesture.getDY(4, 2), f * 30.0f * this.gestureSwipeFactor);
            }
            if (this.vwr.g.logGestures) {
                this.vwr.log("$NOW$ swipe " + this.dragGesture + " " + f);
            }
            return;
        }
    }

    private void checkClickAction(int n, int n2, long l, int n3) {
        if (n3 > 0) {
            if (this.checkUserAction(this.clickAction, n, n2, 0, 0, l, 32768)) {
                return;
            }
            this.clickAction = this.vwr.notifyMouseClicked(n, n2, this.clickAction, 32768);
            if (this.clickAction == 0) {
                return;
            }
        }
        if (Logger.debugging) {
            Logger.debug(Binding.getMouseActionName(this.clickAction, false));
        }
        if (this.bnd(this.clickAction, 2)) {
            if (this.vwr.frankClicked(n, n2)) {
                this.vwr.popupMenu(-n, n2, 'j');
                return;
            }
            if (this.vwr.frankClickedModelKit(n, n2)) {
                this.vwr.popupMenu(0, 0, 'm');
                return;
            }
        }
        Point3fi point3fi = null;
        boolean bl = false;
        boolean bl2 = false;
        Map<String, Object> map = null;
        if (!this.drawMode && (map = this.vwr.checkObjectClicked(n, n2, this.clickAction)) != null) {
            bl = "bond".equals(map.get("type"));
            bl2 = "isosurface".equals(map.get("type"));
            point3fi = this.getPoint(map);
        }
        if (bl) {
            n3 = 1;
        }
        if (point3fi != null && Float.isNaN(point3fi.x)) {
            return;
        }
        int n4 = this.findNearestAtom(n, n2, point3fi, n3 > 0);
        if (n3 == 0 && this.apm != 32) {
            if (this.mp == null) {
                return;
            }
            if (point3fi != null || this.mp.getIndexOf(n4) == 0) {
                this.mp.addPoint(n4, point3fi, false);
            }
            if (this.mp.haveModified) {
                this.vwr.setPendingMeasurement(this.mp);
            }
            this.vwr.refresh(3, "measurementPending");
            return;
        }
        this.setMouseMode();
        if (this.bnd(this.clickAction, 43)) {
            this.vwr.tm.stopMotion();
        }
        if (this.vwr.getBoolean(603979889) && this.apm == 23 && this.bnd(this.clickAction, 21)) {
            this.vwr.navTranslatePercent((float)n * 100.0f / (float)this.vwr.getScreenWidth() - 50.0f, (float)n2 * 100.0f / (float)this.vwr.getScreenHeight() - 50.0f);
            return;
        }
        if (bl) {
            int[] nArray = new int[1];
            int n5 = nArray[0] = this.bondPickingMode == 34 || this.bondPickingMode == 33 ? 0 : 5;
            if (this.bnd(this.clickAction, nArray)) {
                this.bondPicked((Integer)map.get("index"));
                return;
            }
        } else {
            if (bl2) {
                return;
            }
            if (this.apm != 32 && this.mp != null && this.bnd(this.clickAction, 20)) {
                this.atomOrPointPicked(n4, point3fi);
                if (this.addToMeasurement(n4, point3fi, false) == 4) {
                    this.toggleMeasurement();
                }
                return;
            }
            if (this.bnd(this.clickAction, 37)) {
                if (this.mp != null) {
                    this.addToMeasurement(n4, point3fi, true);
                    this.toggleMeasurement();
                } else if (!this.drawMode && !this.labelMode && !this.dragSelectedMode && this.measuresEnabled) {
                    this.enterMeasurementMode(n4);
                    this.addToMeasurement(n4, point3fi, true);
                }
                this.atomOrPointPicked(n4, point3fi);
                return;
            }
        }
        if (this.isSelectAction(this.clickAction)) {
            if (!bl2) {
                this.atomOrPointPicked(n4, point3fi);
            }
            return;
        }
        if (this.bnd(this.clickAction, 24)) {
            if (n4 < 0) {
                this.reset();
            }
            return;
        }
    }

    private boolean checkUserAction(int n, int n2, int n3, int n4, int n5, long l, int n6) {
        if (!this.b.isUserAction(n)) {
            return false;
        }
        boolean bl = false;
        Map<String, Object> map = this.b.getBindings();
        String string = n + "\t";
        for (String string2 : map.keySet()) {
            Object object;
            if (string2.indexOf(string) != 0 || !AU.isAS(object = map.get(string2))) continue;
            String string3 = ((String[])object)[1];
            P3 p3 = null;
            if (string3.indexOf("_ATOM") >= 0) {
                int n7 = this.findNearestAtom(n2, n3, null, true);
                string3 = PT.rep(string3, "_ATOM", "({" + (n7 >= 0 ? "" + n7 : "") + "})");
                if (n7 >= 0) {
                    string3 = PT.rep(string3, "_POINT", Escape.eP(this.vwr.ms.at[n7]));
                }
            }
            if (!(this.drawMode || string3.indexOf("_POINT") < 0 && string3.indexOf("_OBJECT") < 0 && string3.indexOf("_BOND") < 0)) {
                Map<String, Object> map2 = this.vwr.checkObjectClicked(n2, n3, n);
                if (map2 != null && (p3 = (P3)map2.get("pt")) != null) {
                    boolean bl2 = map2.get("type").equals("bond");
                    if (bl2) {
                        string3 = PT.rep(string3, "_BOND", "[{" + map2.get("index") + "}]");
                    }
                    string3 = PT.rep(string3, "_POINT", Escape.eP(p3));
                    string3 = PT.rep(string3, "_OBJECT", Escape.escapeMap(map2));
                }
                string3 = PT.rep(string3, "_BOND", "[{}]");
                string3 = PT.rep(string3, "_OBJECT", "{}");
            }
            string3 = PT.rep(string3, "_POINT", "{}");
            string3 = PT.rep(string3, "_ACTION", "" + n);
            string3 = PT.rep(string3, "_X", "" + n2);
            string3 = PT.rep(string3, "_Y", "" + (this.vwr.getScreenHeight() - n3));
            string3 = PT.rep(string3, "_DELTAX", "" + n4);
            string3 = PT.rep(string3, "_DELTAY", "" + n5);
            string3 = PT.rep(string3, "_TIME", "" + l);
            if ((string3 = PT.rep(string3, "_MODE", "" + n6)).startsWith("+:")) {
                bl = true;
                string3 = string3.substring(2);
            }
            this.vwr.evalStringQuiet(string3);
        }
        return !bl;
    }

    private boolean checkMotionRotateZoom(int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        boolean bl3 = this.bnd(n, 40) && this.isZoomArea(this.pressed.x);
        boolean bl4 = this.bnd(n, 25);
        boolean bl5 = this.bnd(n, 29);
        if (!(bl3 || bl4 || bl5)) {
            return false;
        }
        boolean bl6 = bl2 = bl5 && (n3 == 0 || Math.abs(n4) > 5 * Math.abs(n3));
        int n5 = bl2 || this.isZoomArea(this.moved.x) || this.bnd(n, 46) ? 8 : (bl4 || bl5 ? 13 : (this.bnd(n, 1) ? 12 : 0));
        this.setMotion(n5, bl);
        return bl2 || bl3;
    }

    private float getExitRate() {
        long l = this.dragGesture.getTimeDifference(2);
        return this.isMultiTouch ? (l > 80L ? 0.0f : this.dragGesture.getSpeedPixelsPerMillisecond(2, 1)) : (l > 10L ? 0.0f : this.dragGesture.getSpeedPixelsPerMillisecond(4, 2));
    }

    private boolean isRubberBandSelect(int n) {
        n = n & 0xFFFFDFFF | 0x8000;
        return this.rubberbandSelectionMode && this.bnd(n, 35, 34, 32);
    }

    Rectangle getRubberBand() {
        return this.rubberbandSelectionMode && this.rectRubber.x != Integer.MAX_VALUE ? this.rectRubber : null;
    }

    private void calcRectRubberBand() {
        int n;
        int n2 = n = this.vwr.antialiased ? 2 : 1;
        if (this.current.x < this.pressed.x) {
            this.rectRubber.x = this.current.x * n;
            this.rectRubber.width = (this.pressed.x - this.current.x) * n;
        } else {
            this.rectRubber.x = this.pressed.x * n;
            this.rectRubber.width = (this.current.x - this.pressed.x) * n;
        }
        if (this.current.y < this.pressed.y) {
            this.rectRubber.y = this.current.y * n;
            this.rectRubber.height = (this.pressed.y - this.current.y) * n;
        } else {
            this.rectRubber.y = this.pressed.y * n;
            this.rectRubber.height = (this.current.y - this.pressed.y) * n;
        }
    }

    protected float getDegrees(float f, boolean bl) {
        return f / (float)Math.min(500, bl ? this.vwr.getScreenWidth() : this.vwr.getScreenHeight()) * 180.0f * this.mouseDragFactor;
    }

    private boolean isZoomArea(int n) {
        return (float)n > (float)(this.vwr.getScreenWidth() * (this.vwr.tm.stereoDoubleFull || this.vwr.tm.stereoDoubleDTI ? 2 : 1) * 98) / 100.0f;
    }

    private Point3fi getPoint(Map<String, Object> map) {
        Point3fi point3fi = new Point3fi();
        point3fi.setT((P3)map.get("pt"));
        point3fi.mi = (short)((Integer)map.get("modelIndex")).intValue();
        return point3fi;
    }

    private int findNearestAtom(int n, int n2, Point3fi point3fi, boolean bl) {
        int n3 = this.drawMode || point3fi != null ? -1 : this.vwr.findNearestAtomIndexMovable(n, n2, false);
        return n3 >= 0 && (bl || this.mp == null) && !this.vwr.slm.isInSelectionSubset(n3) ? -1 : n3;
    }

    private boolean isSelectAction(int n) {
        return this.bnd(n, 17) || !this.drawMode && !this.labelMode && this.apm == 1 && this.bnd(n, 1) || this.dragSelectedMode && this.bnd(this.dragAction, 27, 13) || this.bnd(n, 22, 35, 32, 34, 36, 30);
    }

    private void enterMeasurementMode(int n) {
        this.vwr.setPicked(-1);
        this.vwr.setPicked(n);
        this.vwr.setCursor(1);
        this.mp = this.getMP();
        this.vwr.setPendingMeasurement(this.mp);
        this.measurementQueued = this.mp;
    }

    private MeasurementPending getMP() {
        return ((MeasurementPending)Interface.getInterface("org.jmol.modelset.MeasurementPending", this.vwr, "mouse")).set(this.vwr.ms);
    }

    private int addToMeasurement(int n, Point3fi point3fi, boolean bl) {
        if (n == -1 && point3fi == null || this.mp == null) {
            this.exitMeasurementMode(null);
            return 0;
        }
        int n2 = this.mp.count;
        if (this.mp.traceX != Integer.MIN_VALUE && n2 == 2) {
            n2 = 1;
            this.mp.setCount(1);
        }
        return n2 == 4 && !bl ? n2 : this.mp.addPoint(n, point3fi, true);
    }

    private void resetMeasurement() {
        this.exitMeasurementMode(null);
        this.measurementQueued = this.getMP();
    }

    void exitMeasurementMode(String string) {
        if (this.mp == null) {
            return;
        }
        this.mp = null;
        this.vwr.setPendingMeasurement(null);
        this.vwr.setCursor(0);
        if (string != null) {
            this.vwr.refresh(3, string);
        }
    }

    private void getSequence() {
        int n = this.measurementQueued.getAtomIndex(1);
        int n2 = this.measurementQueued.getAtomIndex(2);
        if (n < 0 || n2 < 0) {
            return;
        }
        try {
            String string = this.vwr.getSmilesOpt(null, n, n2, 0x100000, null);
            this.vwr.setStatusMeasuring("measureSequence", -2, string, 0.0f);
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
        }
    }

    private void minimize(boolean bl) {
        int n = this.dragAtomIndex;
        if (bl) {
            this.dragAtomIndex = -1;
        }
        this.vwr.dragMinimizeAtom(n);
    }

    private int queueAtom(int n, Point3fi point3fi) {
        int n2 = this.measurementQueued.addPoint(n, point3fi, true);
        if (n >= 0) {
            this.vwr.setStatusAtomPicked(n, "Atom #" + n2 + ":" + this.vwr.getAtomInfo(n), null);
        }
        return n2;
    }

    protected void setMotion(int n, boolean bl) {
        switch (this.vwr.currentCursor) {
            case 3: {
                break;
            }
            default: {
                this.vwr.setCursor(n);
            }
        }
        if (bl) {
            this.vwr.setInMotion(true);
        }
    }

    protected void zoomByFactor(int n, int n2, int n3) {
        if (n == 0) {
            return;
        }
        this.setMotion(8, true);
        this.vwr.zoomByFactor((float)Math.pow(this.mouseWheelFactor, n), n2, n3);
        this.vwr.setInMotion(false);
    }

    private void runScript(String string) {
        this.vwr.script(string);
    }

    private void atomOrPointPicked(int n, Point3fi point3fi) {
        if (n < 0) {
            this.resetMeasurement();
            if (this.bnd(this.clickAction, 33)) {
                this.runScript("select none");
                return;
            }
            if (this.apm != 5 && this.apm != 6) {
                return;
            }
        }
        int n2 = 2;
        switch (this.apm) {
            case 28: 
            case 29: {
                return;
            }
            case 0: {
                return;
            }
            case 8: 
            case 24: 
            case 25: {
                boolean bl = this.apm == 8;
                boolean bl2 = this.apm == 25;
                int[] nArray = new int[1];
                int n3 = nArray[0] = bl ? 5 : 3;
                if (!this.bnd(this.clickAction, nArray)) {
                    return;
                }
                if (this.measurementQueued == null || this.measurementQueued.count == 0 || this.measurementQueued.count > 2) {
                    this.resetMeasurement();
                    this.enterMeasurementMode(n);
                }
                this.addToMeasurement(n, point3fi, true);
                if (this.queueAtom(n, point3fi) != 2) {
                    return;
                }
                String string = bl || this.measurementQueued.isConnected(this.vwr.ms.at, 2) ? " DELETE" : (bl2 ? "STRUTS" : "");
                this.runScript("connect " + this.measurementQueued.getMeasurementScript(" ", true) + string);
                this.resetMeasurement();
                return;
            }
            case 21: {
                ++n2;
            }
            case 20: {
                ++n2;
            }
            case 18: 
            case 19: 
            case 22: {
                if (!this.bnd(this.clickAction, 20)) {
                    return;
                }
                if (this.measurementQueued == null || this.measurementQueued.count == 0 || this.measurementQueued.count > n2) {
                    this.resetMeasurement();
                    this.enterMeasurementMode(n);
                }
                this.addToMeasurement(n, point3fi, true);
                this.queueAtom(n, point3fi);
                int n4 = this.measurementQueued.count;
                if (n4 == 1) {
                    this.vwr.setPicked(-1);
                    this.vwr.setPicked(n);
                }
                if (n4 < n2) {
                    return;
                }
                if (this.apm == 22) {
                    this.getSequence();
                } else {
                    this.vwr.setStatusMeasuring("measurePicked", n2, this.measurementQueued.getStringDetail(), this.measurementQueued.value);
                    if (this.apm == 18 || this.pickingStyleMeasure == 4) {
                        this.runScript("measure " + this.measurementQueued.getMeasurementScript(" ", true));
                    }
                }
                this.resetMeasurement();
                return;
            }
        }
        int n5 = this.mp != null && this.apm != 1 ? 1 : this.apm;
        switch (n5) {
            case 3: {
                if (!this.bnd(this.clickAction, 17)) {
                    return;
                }
                if (point3fi == null) {
                    this.zoomTo(n);
                } else {
                    this.runScript("zoomTo " + Escape.eP(point3fi));
                }
                return;
            }
            case 5: 
            case 6: {
                if (!this.bnd(this.clickAction, 17)) break;
                this.checkTwoAtomAction(point3fi, n);
            }
        }
        if (point3fi != null) {
            return;
        }
        switch (n5) {
            case 1: {
                if (!this.drawMode && !this.labelMode && this.bnd(this.clickAction, 1)) {
                    this.zoomTo(n);
                } else if (this.bnd(this.clickAction, 17)) {
                    this.vwr.setStatusAtomPicked(n, null, null);
                }
                return;
            }
            case 2: {
                if (this.bnd(this.clickAction, 19)) {
                    this.runScript("set labeltoggle {atomindex=" + n + "}");
                    this.vwr.setStatusAtomPicked(n, null, null);
                }
                return;
            }
            case 31: {
                if (this.bnd(this.clickAction, 0)) {
                    this.vwr.invertRingAt(n, true);
                }
                return;
            }
            case 7: {
                if (this.bnd(this.clickAction, 4)) {
                    BS bS = BSUtil.newAndSetBit(n);
                    this.vwr.deleteAtoms(bS, false);
                    this.vwr.setStatusAtomPicked(n, "deleted: " + Escape.eBS(bS), null);
                }
                return;
            }
        }
        String string = "atomindex=" + n;
        switch (this.apm) {
            default: {
                return;
            }
            case 9: {
                this.selectAtoms(string);
                break;
            }
            case 10: {
                this.selectAtoms("within(group, " + string + ")");
                break;
            }
            case 11: {
                this.selectAtoms("within(chain, " + string + ")");
                break;
            }
            case 13: {
                this.selectAtoms("within(polymer, " + string + ")");
                break;
            }
            case 14: {
                this.selectAtoms("within(structure, " + string + ")");
                break;
            }
            case 12: {
                this.selectAtoms("within(molecule, " + string + ")");
                break;
            }
            case 16: {
                this.selectAtoms("within(model, " + string + ")");
                break;
            }
            case 17: {
                this.selectAtoms("visible and within(element, " + string + ")");
                break;
            }
            case 15: {
                this.selectAtoms("visible and within(site, " + string + ")");
            }
        }
        this.vwr.clearClickCount();
        this.vwr.setStatusAtomPicked(n, null, null);
    }

    private void assignNew(int n, int n2) {
        if (this.mp.count == 2) {
            this.vwr.undoMoveActionClear(-1, 4146, true);
            this.runScript("assign connect " + this.mp.getMeasurementScript(" ", false));
        } else if (this.pickAtomAssignType.equals("Xx")) {
            this.exitMeasurementMode("bond dropped");
        } else if (this.pressed.inRange(this.xyRange, this.dragged.x, this.dragged.y)) {
            String string = "assign atom ({" + this.dragAtomIndex + "}) \"" + this.pickAtomAssignType + "\"";
            if (this.isPickAtomAssignCharge) {
                string = string + ";{atomindex=" + this.dragAtomIndex + "}.label='%C'; ";
                this.vwr.undoMoveActionClear(this.dragAtomIndex, 4, true);
            } else {
                this.vwr.undoMoveActionClear(-1, 4146, true);
            }
            this.runScript(string);
        } else if (!this.isPickAtomAssignCharge) {
            this.vwr.undoMoveActionClear(-1, 4146, true);
            Atom atom = this.vwr.ms.at[this.dragAtomIndex];
            if (atom.getElementNumber() == 1) {
                this.runScript("assign atom ({" + this.dragAtomIndex + "}) \"X\"");
            } else {
                P3 p3 = P3.new3(n, n2, atom.sZ);
                this.vwr.tm.unTransformPoint(p3, p3);
                this.runScript("assign atom ({" + this.dragAtomIndex + "}) \"" + this.pickAtomAssignType + "\" " + Escape.eP(p3));
            }
        }
        this.exitMeasurementMode(null);
    }

    private void bondPicked(int n) {
        if (this.bondPickingMode == 33) {
            this.vwr.undoMoveActionClear(-1, 4146, true);
        }
        switch (this.bondPickingMode) {
            case 33: {
                this.runScript("assign bond [{" + n + "}] \"" + this.pickBondAssignType + "\"");
                break;
            }
            case 34: {
                this.vwr.setRotateBondIndex(n);
                break;
            }
            case 8: {
                this.vwr.deleteBonds(BSUtil.newAndSetBit(n));
            }
        }
    }

    private void checkTwoAtomAction(Point3fi point3fi, int n) {
        int n2;
        boolean bl;
        boolean bl2 = bl = this.apm == 5;
        if (this.vwr.tm.spinOn || this.vwr.tm.navOn || this.vwr.getPendingMeasurement() != null) {
            this.resetMeasurement();
            if (this.vwr.tm.spinOn) {
                this.runScript("spin off");
            }
            return;
        }
        if (this.measurementQueued.count >= 2) {
            this.resetMeasurement();
        }
        if ((n2 = this.measurementQueued.count) == 1 && (point3fi == null ? this.measurementQueued.getAtomIndex(1) == n : this.measurementQueued.getAtom(1).distance(point3fi) == 0.0f)) {
            return;
        }
        if (n >= 0 || point3fi != null) {
            n2 = this.queueAtom(n, point3fi);
        }
        if (n2 < 2) {
            if (bl) {
                this.vwr.scriptStatus(n2 == 1 ? GT._("pick one more atom in order to spin the model around an axis") : GT._("pick two atoms in order to spin the model around an axis"));
            } else {
                this.vwr.scriptStatus(n2 == 1 ? GT._("pick one more atom in order to display the symmetry relationship") : GT._("pick two atoms in order to display the symmetry relationship between them"));
            }
            return;
        }
        String string = this.measurementQueued.getMeasurementScript(" ", false);
        if (bl) {
            this.runScript("spin" + string + " " + this.vwr.getInt(553648157));
        } else {
            this.runScript("draw symop " + string + ";show symop " + string);
        }
    }

    private void reset() {
        this.runScript("!reset");
    }

    private void selectAtoms(String string) {
        String string2;
        if (this.mp != null || this.selectionWorking) {
            return;
        }
        this.selectionWorking = true;
        String string3 = this.rubberbandSelectionMode || this.bnd(this.clickAction, 35) ? "selected and not (" + string + ") or (not selected) and " : (this.bnd(this.clickAction, 32) ? "selected and not " : (this.bnd(this.clickAction, 34) ? "selected or " : (this.clickAction == 0 || this.bnd(this.clickAction, 36) ? "selected tog " : (string2 = this.bnd(this.clickAction, 30) ? "" : null))));
        if (string2 != null) {
            string2 = string2 + "(" + string + ")";
            try {
                BS bS = this.vwr.getAtomBitSetEval(null, string2);
                this.vwr.select(bS, false, 0, false);
                this.vwr.refresh(3, "selections set");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.selectionWorking = false;
    }

    private void selectRb(int n) {
        BS bS = this.vwr.ms.findAtomsInRectangle(this.rectRubber);
        if (bS.length() > 0) {
            String string = Escape.eBS(bS);
            if (this.bnd(n, 34)) {
                this.runScript("selectionHalos on;select selected or " + string);
            } else if (this.bnd(n, 32)) {
                this.runScript("selectionHalos on;select selected and not " + string);
            } else {
                this.runScript("selectionHalos on;select selected tog " + string);
            }
        }
        this.vwr.refresh(3, "mouseReleased");
    }

    private void toggleMeasurement() {
        if (this.mp == null) {
            return;
        }
        int n = this.mp.count;
        if (n >= 2 && n <= 4) {
            this.runScript("!measure " + this.mp.getMeasurementScript(" ", true));
        }
        this.exitMeasurementMode(null);
    }

    private void zoomTo(int n) {
        this.runScript("zoomTo (atomindex=" + n + ")");
        this.vwr.setStatusAtomPicked(n, null, null);
    }

    @Override
    public boolean keyTyped(int n, int n2) {
        return false;
    }
}

