// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var E, GPG, colgrep, iced, ispawn, parse, set_gpg_cmd, __iced_k, __iced_k_noop, _gpg_cmd, _log;

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  colgrep = require('./colgrep').colgrep;

  E = require('./err').E;

  parse = require('pgp-utils').userid.parse;

  ispawn = require('iced-spawn');

  _gpg_cmd = "gpg";

  exports.set_gpg_cmd = set_gpg_cmd = function(c) {
    return _gpg_cmd = c;
  };

  exports.get_gpg_cmd = function() {
    return _gpg_cmd;
  };

  _log = null;

  exports.set_log = function(l) {
    return _log = l;
  };

  exports.find_and_set_cmd = function(cmd, cb) {
    var cmds, err, v, ___iced_passed_deferral, __iced_deferrals, __iced_k;
    __iced_k = __iced_k_noop;
    ___iced_passed_deferral = iced.findDeferral(arguments);
    (function(_this) {
      return (function(__iced_k) {
        if (cmd != null) {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/gpg-wrapper/src/gpg.iced",
              funcname: "find_and_set_cmd"
            });
            (new GPG({
              cmd: cmd
            })).test(__iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  err = arguments[0];
                  return v = arguments[1];
                };
              })(),
              lineno: 20
            }));
            __iced_deferrals._fulfill();
          })(function() {
            return __iced_k(typeof err !== "undefined" && err !== null ? err = new Error("Could not access the supplied GPG command '" + cmd + "'") : void 0);
          });
        } else {
          cmds = ["gpg2", "gpg"];
          (function(__iced_k) {
            var _i, _len, _ref, _results, _while;
            _ref = cmds;
            _len = _ref.length;
            _i = 0;
            _results = [];
            _while = function(__iced_k) {
              var _break, _continue, _next;
              _break = function() {
                return __iced_k(_results);
              };
              _continue = function() {
                return iced.trampoline(function() {
                  ++_i;
                  return _while(__iced_k);
                });
              };
              _next = function(__iced_next_arg) {
                _results.push(__iced_next_arg);
                return _continue();
              };
              if (!(_i < _len)) {
                return _break();
              } else {
                cmd = _ref[_i];
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/gpg-wrapper/src/gpg.iced",
                    funcname: "find_and_set_cmd"
                  });
                  (new GPG({
                    cmd: cmd
                  })).test(__iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        err = arguments[0];
                        return v = arguments[1];
                      };
                    })(),
                    lineno: 26
                  }));
                  __iced_deferrals._fulfill();
                })(function() {
                  (function(__iced_k) {
                    if (!err) {
                      (function(__iced_k) {
_break()
                      })(__iced_k);
                    } else {
                      return __iced_k();
                    }
                  })(_next);
                });
              }
            };
            _while(__iced_k);
          })(function() {
            return __iced_k(err != null ? err = new Error("Could not find GPG command: tried 'gpg2' and 'gpg'") : void 0);
          });
        }
      });
    })(this)((function(_this) {
      return function() {
        if (typeof err === "undefined" || err === null) {
          set_gpg_cmd(cmd);
        }
        return cb(err, v, cmd);
      };
    })(this));
  };

  exports.GPG = GPG = (function() {
    function GPG(opts) {
      var c;
      this.CMD = (c = opts != null ? opts.cmd : void 0) != null ? c : _gpg_cmd;
    }

    GPG.prototype.mutate_args = function(args) {};

    GPG.prototype.test = function(cb) {
      var err, out, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/gpg.iced",
            funcname: "GPG.test"
          });
          ispawn.run({
            name: _this.CMD,
            args: ["--version"],
            quiet: true
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 49
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, out);
        };
      })(this));
    };

    GPG.prototype.run = function(inargs, cb) {
      var env, err, out, stderr, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      stderr = null;
      this.mutate_args(inargs);
      env = process.env;
      delete env.LANGUAGE;
      inargs.name = this.CMD;
      inargs.eklass = E.GpgError;
      inargs.opts = {
        env: env
      };
      if (_log != null) {
        inargs.log = _log;
      }
      if ((inargs.stderr == null) && inargs.quiet) {
        inargs.stderr = stderr = new ispawn.BufferOutStream();
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/gpg.iced",
            funcname: "GPG.run"
          });
          ispawn.run(inargs, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 64
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if ((typeof err !== "undefined" && err !== null) && (stderr != null)) {
            err.stderr = stderr.data();
          }
          return cb(err, out);
        };
      })(this));
    };

    GPG.prototype.command_line = function(inargs) {
      var v;
      this.mutate_args(inargs);
      v = [this.CMD].concat(inargs.args);
      return v.join(" ");
    };

    GPG.prototype.assert_no_collision = function(id, cb) {
      var args, err, n, out, rows, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      args = ["-k", "--with-colons", id];
      n = 0;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/gpg.iced",
            funcname: "GPG.assert_no_collision"
          });
          _this.run({
            args: args,
            quiet: true
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 81
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err !== "undefined" && err !== null) {

          } else {
            rows = colgrep({
              patterns: {
                0: /^[sp]ub$/,
                4: new RegExp("^.*" + id + "$", "i")
              },
              buffer: out,
              separator: /:/
            });
            if ((n = rows.length) > 1) {
              err = new E.PgpIdCollisionError("Found two keys for ID=" + short_id);
            }
          }
          return cb(err, n);
        };
      })(this));
    };

    GPG.prototype.assert_exactly_one = function(short_id, cb) {
      var err, n, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/gpg-wrapper/src/gpg.iced",
            funcname: "GPG.assert_exactly_one"
          });
          _this.assert_no_collision(short_id, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return n = arguments[1];
              };
            })(),
            lineno: 99
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (n !== 1) {
            err = new E.NotFoundError("Didn't find a key for " + short_id);
          }
          return cb(err);
        };
      })(this));
    };

    return GPG;

  })();

}).call(this);
