/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ByteContainer;
import com.carrotsearch.hppc.DoubleByteAssociativeContainer;
import com.carrotsearch.hppc.DoubleByteMap;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.DoubleLookupContainer;
import com.carrotsearch.hppc.HashContainerUtils;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.cursors.DoubleByteCursor;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import com.carrotsearch.hppc.procedures.DoubleByteProcedure;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class DoubleByteOpenHashMap
implements DoubleByteMap,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public double[] keys;
    public byte[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    protected int resizeAt;
    protected int lastSlot;
    protected int perturbation;

    public DoubleByteOpenHashMap() {
        this(16);
    }

    public DoubleByteOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public DoubleByteOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public DoubleByteOpenHashMap(DoubleByteAssociativeContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public byte put(double key, byte value) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                byte oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = value;
        }
        return 0;
    }

    @Override
    public int putAll(DoubleByteAssociativeContainer container) {
        int count = this.assigned;
        for (DoubleByteCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    @Override
    public int putAll(Iterable<? extends DoubleByteCursor> iterable) {
        int count = this.assigned;
        for (DoubleByteCursor doubleByteCursor : iterable) {
            this.put(doubleByteCursor.key, doubleByteCursor.value);
        }
        return this.assigned - count;
    }

    public boolean putIfAbsent(double key, byte value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public byte putOrAdd(double key, byte putValue, byte additionValue) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                this.values[slot] = (byte)(this.values[slot] + additionValue);
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, putValue, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = key;
            this.values[slot] = putValue;
        }
        return putValue;
    }

    @Override
    public byte addTo(double key, byte additionValue) {
        return this.putOrAdd(key, additionValue, additionValue);
    }

    private void expandAndPut(double pendingKey, byte pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        double[] oldKeys = this.keys;
        byte[] oldValues = this.values;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        double[] keys = this.keys;
        byte[] values = this.values;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            double k = oldKeys[i];
            byte v = oldValues[i];
            int slot = Internals.rehash(k, this.perturbation) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys[slot] = k;
            values[slot] = v;
        }
    }

    private void allocateBuffers(int capacity) {
        double[] keys = new double[capacity];
        byte[] values = new byte[capacity];
        boolean[] allocated = new boolean[capacity];
        this.keys = keys;
        this.values = values;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
        this.perturbation = this.computePerturbationValue(capacity);
    }

    protected int computePerturbationValue(int capacity) {
        return HashContainerUtils.PERTURBATIONS[Integer.numberOfLeadingZeros(capacity)];
    }

    @Override
    public byte remove(double key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                --this.assigned;
                byte v = this.values[slot];
                this.shiftConflictingKeys(slot);
                return v;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    protected void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr], this.perturbation) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
            this.values[slotPrev] = this.values[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    @Override
    public int removeAll(DoubleContainer container) {
        int before = this.assigned;
        for (DoubleCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.assigned;
    }

    @Override
    public int removeAll(DoublePredicate predicate) {
        int before = this.assigned;
        double[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = 0;
        while (i < states.length) {
            if (states[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    @Override
    public byte get(double key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public byte getOrDefault(double key, byte defaultValue) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    public byte lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public byte lset(byte key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.allocated[this.lastSlot]) : "Last call to exists did not have any associated value.";
        byte previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    public int lslot() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        return this.lastSlot;
    }

    @Override
    public boolean containsKey(double key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(this.keys[slot])) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (DoubleByteCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            DoubleByteMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof DoubleByteMap && (other = (DoubleByteMap)obj).size() == this.size()) {
                for (DoubleByteCursor c : this) {
                    byte v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<DoubleByteCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends DoubleByteProcedure> T forEach(T procedure) {
        double[] keys = this.keys;
        byte[] values = this.values;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ByteContainer values() {
        return new ValuesContainer();
    }

    public DoubleByteOpenHashMap clone() {
        try {
            DoubleByteOpenHashMap cloned = (DoubleByteOpenHashMap)super.clone();
            cloned.keys = (double[])this.keys.clone();
            cloned.values = (byte[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (DoubleByteCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static DoubleByteOpenHashMap from(double[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        DoubleByteOpenHashMap map = new DoubleByteOpenHashMap();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static DoubleByteOpenHashMap from(DoubleByteAssociativeContainer container) {
        return new DoubleByteOpenHashMap(container);
    }

    public static DoubleByteOpenHashMap newInstance() {
        return new DoubleByteOpenHashMap();
    }

    public static DoubleByteOpenHashMap newInstanceWithoutPerturbations() {
        return new DoubleByteOpenHashMap(){

            @Override
            protected int computePerturbationValue(int capacity) {
                return 0;
            }
        };
    }

    public static DoubleByteOpenHashMap newInstance(int initialCapacity, float loadFactor) {
        return new DoubleByteOpenHashMap(initialCapacity, loadFactor);
    }

    public static DoubleByteOpenHashMap newInstanceWithExpectedSize(int expectedSize) {
        return DoubleByteOpenHashMap.newInstanceWithExpectedSize(expectedSize, 0.75f);
    }

    public static DoubleByteOpenHashMap newInstanceWithExpectedSize(int expectedSize, float loadFactor) {
        return DoubleByteOpenHashMap.newInstance((int)((float)expectedSize / loadFactor) + 1, loadFactor);
    }

    private final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor = new ByteCursor();

        public ValuesIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected ByteCursor fetch() {
            int i;
            int max = DoubleByteOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !DoubleByteOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (ByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = DoubleByteOpenHashMap.this.values[i];
            return this.cursor;
        }
    }

    private final class ValuesContainer
    extends AbstractByteCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return DoubleByteOpenHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return DoubleByteOpenHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(byte value) {
            boolean[] allocated = DoubleByteOpenHashMap.this.allocated;
            byte[] values = DoubleByteOpenHashMap.this.values;
            for (int slot = 0; slot < allocated.length; ++slot) {
                if (!allocated[slot] || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            boolean[] allocated = DoubleByteOpenHashMap.this.allocated;
            byte[] values = DoubleByteOpenHashMap.this.values;
            for (int i = 0; i < allocated.length; ++i) {
                if (!allocated[i]) continue;
                procedure.apply(values[i]);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            boolean[] allocated = DoubleByteOpenHashMap.this.allocated;
            byte[] values = DoubleByteOpenHashMap.this.values;
            for (int i = 0; i < allocated.length && (!allocated[i] || predicate.apply(values[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAllOccurrences(byte e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();

        public KeysIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected DoubleCursor fetch() {
            int i;
            int max = DoubleByteOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !DoubleByteOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (DoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = DoubleByteOpenHashMap.this.keys[i];
            return this.cursor;
        }
    }

    public final class KeysContainer
    extends AbstractDoubleCollection
    implements DoubleLookupContainer {
        private final DoubleByteOpenHashMap owner;

        public KeysContainer() {
            this.owner = DoubleByteOpenHashMap.this;
        }

        @Override
        public boolean contains(double e) {
            return DoubleByteOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            double[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length; ++i) {
                if (!localStates[i]) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            double[] localKeys = this.owner.keys;
            boolean[] localStates = this.owner.allocated;
            for (int i = 0; i < localStates.length && (!localStates[i] || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(double e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<DoubleByteCursor> {
        private final DoubleByteCursor cursor = new DoubleByteCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected DoubleByteCursor fetch() {
            int i;
            int max = DoubleByteOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !DoubleByteOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (DoubleByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = DoubleByteOpenHashMap.this.keys[i];
            this.cursor.value = DoubleByteOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

