/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.List;
import morfologik.speller.Speller;
import morfologik.stemming.Dictionary;
import org.languagetool.JLanguageTool;
import org.languagetool.tools.StringTools;

public class MorfologikSpeller {
    private final Dictionary dictionary;
    private final Speller speller;

    public MorfologikSpeller(String fileInClassPath, int maxEditDistance) throws IOException {
        this(Dictionary.read((URL)JLanguageTool.getDataBroker().getFromResourceDirAsUrl(fileInClassPath)), maxEditDistance);
    }

    public MorfologikSpeller(String fileInClassPath) throws IOException {
        this(fileInClassPath, 1);
    }

    MorfologikSpeller(Dictionary dictionary, int maxEditDistance) {
        if (maxEditDistance <= 0) {
            throw new RuntimeException("maxEditDistance must be > 0: " + maxEditDistance);
        }
        this.dictionary = dictionary;
        this.speller = new Speller(dictionary, maxEditDistance);
    }

    public boolean isMisspelled(String word) {
        return word.length() > 0 && !"LanguageTool".equals(word) && !"LanguageToolFx".equals(word) && this.speller.isMisspelled(word);
    }

    public List<String> getSuggestions(String word) {
        ArrayList<String> suggestions = new ArrayList<String>();
        try {
            suggestions.addAll(this.speller.findReplacements(word));
            suggestions.addAll(this.speller.replaceRunOnWords(word));
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        if (this.dictionary.metadata.isConvertingCase() && StringTools.startsWithUppercase(word)) {
            for (int i = 0; i < suggestions.size(); ++i) {
                String uppercaseFirst = StringTools.uppercaseFirstChar((String)suggestions.get(i));
                int auxIndex = suggestions.indexOf(uppercaseFirst);
                if (auxIndex > i) {
                    suggestions.remove(auxIndex);
                }
                if (auxIndex > -1 && auxIndex < i) {
                    suggestions.remove(i);
                    --i;
                    continue;
                }
                suggestions.set(i, uppercaseFirst);
            }
        }
        return suggestions;
    }

    public boolean convertsCase() {
        return this.speller.convertsCase();
    }
}

