/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.awt.EventQueue;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnUninstallationProgressCallback;

class UninstallationProgressDialogue
extends AbstractDialog {
    private static final long serialVersionUID = 6544278337930125848L;
    private static final int MS_TO_WAIT_BEFORE_SHOW = 500;
    private static final int EXTENSION_UNINSTALL_WEIGHT = 10;
    private static final int MINIMUM_TO_IMMEDIATELY_SHOW_DIALOGUE = 50;
    private JLabel statusLabel;
    private JProgressBar progressBar;
    private JLabel customLabel;
    private UninstallationProgressEvent.Type currentType;
    private String keyBaseStatusMessage = "";
    private AddOn currentAddOn;
    private boolean update;
    private boolean failedUninstallations;
    private long startTime;
    private boolean done;
    private boolean setVisibleInvoked;
    private List<AddOnUninstallListener> listeners = Collections.emptyList();
    private boolean synchronous;

    public UninstallationProgressDialogue(Window window, Set<AddOn> set) {
        super(window, true);
        this.setTitle(Constant.messages.getString("cfu.uninstallation.progress.dialogue.title"));
        this.setDefaultCloseOperation(0);
        int n = 0;
        for (AddOn object2 : set) {
            n += object2.getFiles().size();
            n += object2.getAscanrules().size();
            n += object2.getPscanrules().size();
            n += object2.getLoadedExtensions().size() * 10;
        }
        this.getProgressBar().setValue(0);
        this.getProgressBar().setMaximum(n);
        this.getStatusLabel().setText(" ");
        this.getCustomLabel().setText(" ");
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setHonorsVisibility(false);
        JLabel jLabel = new JLabel(Constant.messages.getString("cfu.uninstallation.progress.dialogue.uninstalling"));
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel).addComponent(this.getStatusLabel()).addComponent(this.getProgressBar(), 200, -1, -1).addComponent(this.getCustomLabel()));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(jLabel).addComponent(this.getStatusLabel()).addComponent(this.getProgressBar()).addComponent(this.getCustomLabel()));
        this.setContentPane(jPanel);
        this.pack();
    }

    private JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel();
        }
        return this.statusLabel;
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
        }
        return this.progressBar;
    }

    private JLabel getCustomLabel() {
        if (this.customLabel == null) {
            this.customLabel = new JLabel();
        }
        return this.customLabel;
    }

    private void incrementProgress(int n) {
        int n2 = this.getProgressBar().getValue() + n;
        this.getProgressBar().setValue(n2);
    }

    private void setCurrentAddOn(AddOn addOn) {
        this.currentAddOn = addOn;
        this.getStatusLabel().setText(MessageFormat.format(Constant.messages.getString("cfu.uninstallation.progress.dialogue.currentAddOn"), addOn.getName(), addOn.getFileVersion()));
    }

    private void setCustomMessage(String string) {
        this.getCustomLabel().setText(string);
    }

    public void addAddOnUninstallListener(AddOnUninstallListener addOnUninstallListener) {
        if (this.listeners.isEmpty()) {
            this.listeners = new ArrayList<AddOnUninstallListener>(1);
        }
        this.listeners.add(addOnUninstallListener);
    }

    public void bind(SwingWorker<?, UninstallationProgressEvent> swingWorker) {
        swingWorker.addPropertyChangeListener(new WaitForDoneWorkerCloseListener());
    }

    public void setSynchronous(boolean bl) {
        this.synchronous = bl;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && !this.synchronous) {
            this.startTime = System.currentTimeMillis();
            this.done = false;
            if (50 > this.getProgressBar().getMaximum()) {
                return;
            }
        }
        super.setVisible(bl);
    }

    /*
     * WARNING - void declaration
     */
    public void update(List<UninstallationProgressEvent> list) {
        if (!(this.isVisible() || System.currentTimeMillis() - this.startTime < 500L || this.done || this.setVisibleInvoked)) {
            this.setVisibleInvoked = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!UninstallationProgressDialogue.this.done) {
                        UninstallationProgressDialogue.super.setVisible(true);
                    }
                }
            });
        }
        int n = 0;
        AddOn addOn = null;
        for (UninstallationProgressEvent object : list) {
            n += object.getAmount();
            if (UninstallationProgressEvent.Type.FINISHED_ADD_ON == object.getType()) {
                for (AddOnUninstallListener addOnUninstallListener : this.listeners) {
                    this.failedUninstallations = !object.isUninstalled();
                    addOnUninstallListener.addOnUninstalled(this.currentAddOn, this.update, object.isUninstalled());
                }
                continue;
            }
            if (UninstallationProgressEvent.Type.ADD_ON != object.getType()) continue;
            this.currentAddOn = addOn = object.getAddOn();
            this.update = object.isUpdate();
            for (AddOnUninstallListener addOnUninstallListener : this.listeners) {
                addOnUninstallListener.uninstallingAddOn(addOn, this.update);
            }
        }
        UninstallationProgressEvent uninstallationProgressEvent = list.get(list.size() - 1);
        if (addOn != null) {
            this.setCurrentAddOn(addOn);
        }
        if (n != 0) {
            this.incrementProgress(n);
        }
        if (this.currentType != uninstallationProgressEvent.getType()) {
            void var5_11;
            switch (uninstallationProgressEvent.getType()) {
                case FILE: {
                    String string = "cfu.uninstallation.progress.dialogue.uninstallingFile";
                    break;
                }
                case ACTIVE_RULE: {
                    String string = "cfu.uninstallation.progress.dialogue.uninstallingActiveScanner";
                    break;
                }
                case PASSIVE_RULE: {
                    String string = "cfu.uninstallation.progress.dialogue.uninstallingPassiveScanner";
                    break;
                }
                case EXTENSION: {
                    String string = "cfu.uninstallation.progress.dialogue.uninstallingExtension";
                    break;
                }
                default: {
                    String string = "";
                }
            }
            this.currentType = uninstallationProgressEvent.getType();
            this.keyBaseStatusMessage = var5_11;
        }
        if (this.keyBaseStatusMessage.isEmpty()) {
            this.setCustomMessage("");
        } else {
            this.setCustomMessage(MessageFormat.format(Constant.messages.getString(this.keyBaseStatusMessage), uninstallationProgressEvent.getValue(), uninstallationProgressEvent.getMax()));
        }
    }

    private class WaitForDoneWorkerCloseListener
    implements PropertyChangeListener {
        private WaitForDoneWorkerCloseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("state".equals(propertyChangeEvent.getPropertyName()) && SwingWorker.StateValue.DONE == propertyChangeEvent.getNewValue()) {
                UninstallationProgressDialogue.this.setVisible(false);
                UninstallationProgressDialogue.this.dispose();
                UninstallationProgressDialogue.this.done = true;
                if (UninstallationProgressDialogue.this.failedUninstallations) {
                    View.getSingleton().showWarningDialog(UninstallationProgressDialogue.this.getOwner(), Constant.messages.getString("cfu.unintall.failed"));
                }
            }
        }
    }

    public static interface AddOnUninstallListener {
        public void uninstallingAddOn(AddOn var1, boolean var2);

        public void addOnUninstalled(AddOn var1, boolean var2, boolean var3);
    }

    public static abstract class UninstallationProgressHandler
    implements AddOnUninstallationProgressCallback {
        private UninstallationProgressEvent.Type type = null;
        private int currentValue = 0;
        private int currentMax = 0;

        protected abstract void publishEvent(UninstallationProgressEvent var1);

        @Override
        public void uninstallingAddOn(AddOn addOn, boolean bl) {
            this.publishEvent(new UninstallationProgressEvent(addOn, bl));
        }

        @Override
        public void activeScanRulesWillBeRemoved(int n) {
            this.resetTypeAndValues(UninstallationProgressEvent.Type.ACTIVE_RULE, n);
        }

        private void resetTypeAndValues(UninstallationProgressEvent.Type type, int n) {
            this.type = type;
            this.currentValue = 0;
            this.currentMax = n;
            this.publishEvent(new UninstallationProgressEvent(type, this.currentValue, this.currentMax));
        }

        @Override
        public void activeScanRuleRemoved(String string) {
            this.publish();
        }

        private void publish() {
            ++this.currentValue;
            this.publishEvent(new UninstallationProgressEvent(this.type, this.currentValue, this.currentMax));
        }

        @Override
        public void passiveScanRulesWillBeRemoved(int n) {
            this.resetTypeAndValues(UninstallationProgressEvent.Type.PASSIVE_RULE, n);
        }

        @Override
        public void passiveScanRuleRemoved(String string) {
            this.publish();
        }

        @Override
        public void filesWillBeRemoved(int n) {
            this.resetTypeAndValues(UninstallationProgressEvent.Type.FILE, n);
        }

        @Override
        public void fileRemoved() {
            this.publish();
        }

        @Override
        public void extensionsWillBeRemoved(int n) {
            this.resetTypeAndValues(UninstallationProgressEvent.Type.EXTENSION, n);
        }

        @Override
        public void extensionRemoved(String string) {
            this.publish();
        }

        @Override
        public void addOnUninstalled(boolean bl) {
            this.publishEvent(new UninstallationProgressEvent(bl));
        }
    }

    static final class UninstallationProgressEvent {
        private final AddOn addOn;
        private final boolean update;
        private final boolean uninstalled;
        private final Type type;
        private final int amount;
        private final int value;
        private final int max;

        public UninstallationProgressEvent(AddOn addOn, boolean bl) {
            this.addOn = addOn;
            this.update = bl;
            this.uninstalled = false;
            this.amount = 0;
            this.type = Type.ADD_ON;
            this.value = 0;
            this.max = 0;
        }

        public UninstallationProgressEvent(Type type, int n, int n2) {
            this.addOn = null;
            this.update = false;
            this.uninstalled = false;
            this.type = type;
            this.amount = type == Type.EXTENSION ? 10 : 1;
            this.value = n;
            this.max = n2;
        }

        public UninstallationProgressEvent(boolean bl) {
            this.uninstalled = bl;
            this.type = Type.FINISHED_ADD_ON;
            this.addOn = null;
            this.update = false;
            this.amount = 0;
            this.value = 0;
            this.max = 0;
        }

        public AddOn getAddOn() {
            return this.addOn;
        }

        public boolean isUpdate() {
            return this.update;
        }

        public boolean isUninstalled() {
            return this.uninstalled;
        }

        public int getAmount() {
            return this.amount;
        }

        private Type getType() {
            return this.type;
        }

        public int getValue() {
            return this.value;
        }

        public int getMax() {
            return this.max;
        }

        private static enum Type {
            ADD_ON,
            FILE,
            ACTIVE_RULE,
            PASSIVE_RULE,
            EXTENSION,
            FINISHED_ADD_ON;

        }
    }
}

