/*
 * Decompiled with CFR 0.152.
 */
package com.github.arara.utils;

import com.github.arara.exception.AraraException;
import com.github.arara.model.AraraDirective;
import com.github.arara.utils.AraraLocalization;
import com.github.arara.utils.AraraResolver;
import com.github.arara.utils.AraraUtils;
import com.github.arara.utils.ConfigurationLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.representer.Representer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectiveExtractor {
    static final Logger logger = LoggerFactory.getLogger(DirectiveExtractor.class);
    private List<AraraDirective> directives = new ArrayList<AraraDirective>();
    private File file;
    private int currentLineNumber;
    private ConfigurationLoader configuration;
    static final AraraLocalization localization = AraraLocalization.getInstance();

    public DirectiveExtractor() {
        this.file = null;
    }

    public DirectiveExtractor(File file, ConfigurationLoader configuration) {
        this.configuration = configuration;
        this.file = file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public List<AraraDirective> getDirectives() {
        return this.directives;
    }

    public void extract() throws FileNotFoundException, IOException, AraraException {
        String currentLine;
        FileReader fileReader = new FileReader(this.file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        this.currentLineNumber = 0;
        logger.info("Reading directives from {}.", (Object)this.file.getName());
        while ((currentLine = bufferedReader.readLine()) != null) {
            ++this.currentLineNumber;
            this.extractDirective(currentLine);
        }
        bufferedReader.close();
        fileReader.close();
    }

    private void extractDirective(String currentLine) throws AraraException {
        Pattern linePattern = Pattern.compile(this.configuration.getChosenFilePattern().getPattern());
        Matcher matcher = linePattern.matcher(currentLine);
        if (matcher.find() && !"".equals(currentLine = currentLine.substring(matcher.end(), currentLine.length()).trim())) {
            logger.trace(localization.getMessage("Log_DirectiveFound", this.currentLineNumber, currentLine));
            if (AraraUtils.checkForFullDirective(currentLine)) {
                this.addAraraDirective(currentLine);
            } else if (AraraUtils.checkForEmptyDirective(currentLine)) {
                this.addEmptyAraraDirective(currentLine.trim());
            } else {
                throw new AraraException(localization.getMessage("Error_InvalidDirective", this.currentLineNumber));
            }
        }
    }

    private void addEmptyAraraDirective(String currentLine) {
        AraraDirective araraDirective = new AraraDirective();
        araraDirective.setName(currentLine);
        araraDirective.setConfig(new HashMap());
        araraDirective.setLineNumber(this.currentLineNumber);
        this.directives.add(araraDirective);
    }

    private void addAraraDirective(String currentLine) throws AraraException {
        try {
            Yaml yaml = new Yaml(new Constructor(), new Representer(), new DumperOptions(), new AraraResolver());
            Map config = (Map)yaml.load(currentLine);
            AraraDirective ad = new AraraDirective();
            ad.setName(currentLine);
            ad.setConfig(config);
            ad.setLineNumber(this.currentLineNumber);
            this.directives.add(ad);
        }
        catch (MarkedYAMLException yamlException) {
            throw new AraraException(localization.getMessage("Error_InvalidYAMLDirective", this.currentLineNumber).concat("\n\n").concat(AraraUtils.extractInformationFromYAMLException(yamlException)));
        }
    }
}

