/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.routing.DjbHashFunction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.LoggerInfoStream;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.lucene.index.ElasticsearchLeafReader;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.common.math.MathUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.CreateFailedEngineException;
import org.elasticsearch.index.engine.DeleteByQueryFailedEngineException;
import org.elasticsearch.index.engine.DeleteFailedEngineException;
import org.elasticsearch.index.engine.DeleteVersionValue;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.ElasticsearchConcurrentMergeScheduler;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.EngineSearcherFactory;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.FlushNotAllowedEngineException;
import org.elasticsearch.index.engine.IndexFailedEngineException;
import org.elasticsearch.index.engine.LiveVersionMap;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.engine.VersionValue;
import org.elasticsearch.index.indexing.ShardIndexingService;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.search.nested.IncludeNestedDocsQuery;
import org.elasticsearch.index.shard.ElasticsearchMergePolicy;
import org.elasticsearch.index.shard.MergeSchedulerConfig;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.TranslogRecoveryPerformer;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogCorruptedException;
import org.elasticsearch.indices.IndicesWarmer;

public class InternalEngine
extends Engine {
    private volatile long lastDeleteVersionPruneTimeMSec;
    private final ShardIndexingService indexingService;
    @Nullable
    private final IndicesWarmer warmer;
    private final Translog translog;
    private final ElasticsearchConcurrentMergeScheduler mergeScheduler;
    private final IndexWriter indexWriter;
    private final SearcherFactory searcherFactory;
    private final SearcherManager searcherManager;
    private final Lock flushLock;
    private final ReentrantLock optimizeLock;
    private final LiveVersionMap versionMap;
    private final Object[] dirtyLocks;
    private final AtomicBoolean versionMapRefreshPending;
    private volatile SegmentInfos lastCommittedSegmentInfos;
    private final Engine.IndexThrottle throttle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InternalEngine(EngineConfig engineConfig, boolean skipInitialTranslogRecovery) throws EngineException {
        block16: {
            super(engineConfig);
            this.flushLock = new ReentrantLock();
            this.optimizeLock = new ReentrantLock();
            this.versionMapRefreshPending = new AtomicBoolean();
            this.versionMap = new LiveVersionMap();
            this.store.incRef();
            IndexWriter writer = null;
            Translog translog = null;
            SearcherManager manager = null;
            EngineMergeScheduler scheduler = null;
            boolean success = false;
            try {
                Translog.TranslogGeneration translogGeneration;
                this.lastDeleteVersionPruneTimeMSec = engineConfig.getThreadPool().estimatedTimeInMillis();
                this.indexingService = engineConfig.getIndexingService();
                this.warmer = engineConfig.getWarmer();
                scheduler = new EngineMergeScheduler(engineConfig.getShardId(), engineConfig.getIndexSettings(), engineConfig.getMergeSchedulerConfig());
                this.mergeScheduler = scheduler;
                this.dirtyLocks = new Object[Runtime.getRuntime().availableProcessors() * 10];
                for (int i = 0; i < this.dirtyLocks.length; ++i) {
                    this.dirtyLocks[i] = new Object();
                }
                this.throttle = new Engine.IndexThrottle();
                this.searcherFactory = new SearchFactory(this.logger, this.isClosed, engineConfig);
                try {
                    boolean create = engineConfig.isCreate();
                    this.indexWriter = writer = this.createWriter(create);
                    translog = this.openTranslog(engineConfig, writer, create || skipInitialTranslogRecovery || engineConfig.forceNewTranslog());
                    translogGeneration = translog.getGeneration();
                    assert (translogGeneration != null);
                }
                catch (IOException | TranslogCorruptedException e) {
                    throw new EngineCreationFailureException(this.shardId, "failed to create engine", e);
                }
                catch (AssertionError e) {
                    if (ExceptionsHelper.stackTrace((Throwable)((Object)e)).contains("org.apache.lucene.index.IndexWriter.filesExist")) {
                        throw new EngineCreationFailureException(this.shardId, "failed to create engine", (Throwable)((Object)e));
                    }
                    throw e;
                }
                this.translog = translog;
                this.searcherManager = manager = this.createSearcherManager();
                this.versionMap.setManager((ReferenceManager)this.searcherManager);
                try {
                    if (skipInitialTranslogRecovery) {
                        this.commitIndexWriter(writer, translog, (String)this.lastCommittedSegmentInfos.getUserData().get("sync_id"));
                    } else {
                        this.recoverFromTranslog(engineConfig, translogGeneration);
                    }
                }
                catch (IOException | EngineException ex) {
                    throw new EngineCreationFailureException(this.shardId, "failed to recover from translog", ex);
                }
                success = true;
                if (success) break block16;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{writer, translog, manager, scheduler});
                    this.versionMap.clear();
                    if (!this.isClosed.get()) {
                        this.store.decRef();
                    }
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{writer, translog, manager, scheduler});
            this.versionMap.clear();
            if (!this.isClosed.get()) {
                this.store.decRef();
            }
        }
        this.logger.trace("created new InternalEngine", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Translog openTranslog(EngineConfig engineConfig, IndexWriter writer, boolean createNew) throws IOException {
        Translog.TranslogGeneration generation = this.loadTranslogIdFromCommit(writer);
        TranslogConfig translogConfig = engineConfig.getTranslogConfig();
        if (!createNew) {
            if (generation == null) {
                throw new IllegalStateException("no translog generation present in commit data but translog is expected to exist");
            }
            translogConfig.setTranslogGeneration(generation);
            if (generation != null && generation.translogUUID == null) {
                Translog.upgradeLegacyTranslog(this.logger, translogConfig);
            }
        }
        Translog translog = new Translog(translogConfig);
        if (generation != null && generation.translogUUID != null) return translog;
        if (generation == null) {
            this.logger.debug("no translog ID present in the current generation - creating one", new Object[0]);
        } else if (generation.translogUUID == null) {
            this.logger.debug("upgraded translog to pre 2.0 format, associating translog with index - writing translog UUID", new Object[0]);
        }
        boolean success = false;
        try {
            this.commitIndexWriter(writer, translog);
            return translog;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{translog});
            throw throwable;
        }
    }

    @Override
    public Translog getTranslog() {
        this.ensureOpen();
        return this.translog;
    }

    protected void recoverFromTranslog(EngineConfig engineConfig, Translog.TranslogGeneration translogGeneration) throws IOException {
        int opsRecovered = 0;
        TranslogRecoveryPerformer handler = engineConfig.getTranslogRecoveryPerformer();
        try (Translog.Snapshot snapshot = this.translog.newSnapshot();){
            opsRecovered = handler.recoveryFromSnapshot(this, snapshot);
        }
        catch (Throwable e) {
            throw new EngineException(this.shardId, "failed to recover from translog", e);
        }
        if (opsRecovered > 0) {
            this.logger.trace("flushing post recovery from translog. ops recovered [{}]. committed translog id [{}]. current id [{}]", opsRecovered, translogGeneration == null ? null : Long.valueOf(translogGeneration.translogFileGeneration), this.translog.currentFileGeneration());
            this.flush(true, true);
        } else if (!this.translog.isCurrent(translogGeneration)) {
            this.commitIndexWriter(this.indexWriter, this.translog, (String)this.lastCommittedSegmentInfos.getUserData().get("sync_id"));
        }
    }

    @Nullable
    private Translog.TranslogGeneration loadTranslogIdFromCommit(IndexWriter writer) throws IOException {
        Map commitUserData = writer.getCommitData();
        if (commitUserData.containsKey("translog_id")) {
            assert (!commitUserData.containsKey("translog_uuid")) : "legacy commit contains translog UUID";
            return new Translog.TranslogGeneration(null, Long.parseLong((String)commitUserData.get("translog_id")));
        }
        if (commitUserData.containsKey("translog_generation")) {
            if (!commitUserData.containsKey("translog_uuid")) {
                throw new IllegalStateException("commit doesn't contain translog UUID");
            }
            String translogUUID = (String)commitUserData.get("translog_uuid");
            long translogGen = Long.parseLong((String)commitUserData.get("translog_generation"));
            return new Translog.TranslogGeneration(translogUUID, translogGen);
        }
        return null;
    }

    private SearcherManager createSearcherManager() throws EngineException {
        SearcherManager searcherManager;
        block7: {
            boolean success = false;
            SearcherManager searcherManager2 = null;
            try {
                ElasticsearchDirectoryReader directoryReader = ElasticsearchDirectoryReader.wrap(DirectoryReader.open((IndexWriter)this.indexWriter, (boolean)true), this.shardId);
                searcherManager2 = new SearcherManager((DirectoryReader)directoryReader, this.searcherFactory);
                this.lastCommittedSegmentInfos = InternalEngine.readLastCommittedSegmentInfos(searcherManager2, this.store);
                success = true;
                searcherManager = searcherManager2;
                if (success) break block7;
            }
            catch (IOException e) {
                try {
                    this.maybeFailEngine("start", e);
                    try {
                        this.indexWriter.rollback();
                    }
                    catch (IOException e1) {
                        e.addSuppressed(e1);
                    }
                    throw new EngineCreationFailureException(this.shardId, "failed to open reader on writer", e);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{searcherManager2, this.indexWriter});
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{searcherManager2, this.indexWriter});
        }
        return searcherManager;
    }

    private void updateIndexWriterSettings() {
        try {
            LiveIndexWriterConfig iwc = this.indexWriter.getConfig();
            iwc.setRAMBufferSizeMB(this.engineConfig.getIndexingBufferSize().mbFrac());
            iwc.setUseCompoundFile(this.engineConfig.isCompoundOnFlush());
        }
        catch (AlreadyClosedException alreadyClosedException) {
            // empty catch block
        }
    }

    @Override
    public Engine.GetResult get(Engine.Get get) throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            VersionValue versionValue;
            this.ensureOpen();
            if (get.realtime() && (versionValue = this.versionMap.getUnderLock(get.uid().bytes())) != null) {
                if (versionValue.delete()) {
                    Engine.GetResult getResult = Engine.GetResult.NOT_EXISTS;
                    return getResult;
                }
                if (get.versionType().isVersionConflictForReads(versionValue.version(), get.version())) {
                    Uid uid = Uid.createUid(get.uid().text());
                    throw new VersionConflictEngineException(this.shardId, uid.type(), uid.id(), versionValue.version(), get.version());
                }
                Translog.Operation op = this.translog.read(versionValue.translogLocation());
                if (op != null) {
                    Engine.GetResult getResult = new Engine.GetResult(true, versionValue.version(), op.getSource());
                    return getResult;
                }
            }
            Engine.GetResult getResult = this.getFromSearcher(get);
            return getResult;
        }
    }

    @Override
    public void create(Engine.Create create) throws EngineException {
        block27: {
            try (ReleasableLock lock = this.readLock.acquire();){
                this.ensureOpen();
                if (create.origin() == Engine.Operation.Origin.RECOVERY) {
                    this.innerCreate(create);
                    break block27;
                }
                try (Releasable r = this.throttle.acquireThrottle();){
                    this.innerCreate(create);
                }
            }
            catch (IOException | IllegalStateException | OutOfMemoryError t) {
                this.maybeFailEngine("create", t);
                throw new CreateFailedEngineException(this.shardId, create.type(), create.id(), t);
            }
        }
        this.checkVersionMapRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerCreate(Engine.Create create) throws IOException {
        if (this.engineConfig.isOptimizeAutoGenerateId() && create.autoGeneratedId() && !create.canHaveDuplicates()) {
            this.innerCreateNoLock(create, -1L, null);
        } else {
            Object object = this.dirtyLock(create.uid());
            synchronized (object) {
                VersionValue versionValue = this.versionMap.getUnderLock(create.uid().bytes());
                long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(create.uid()) : (this.engineConfig.isEnableGcDeletes() && versionValue.delete() && this.engineConfig.getThreadPool().estimatedTimeInMillis() - versionValue.time() > this.engineConfig.getGcDeletesInMillis() ? -1L : versionValue.version());
                this.innerCreateNoLock(create, currentVersion, versionValue);
            }
        }
    }

    private void innerCreateNoLock(Engine.Create create, long currentVersion, VersionValue versionValue) throws IOException {
        long expectedVersion = create.version();
        if (create.versionType().isVersionConflictForWrites(currentVersion, expectedVersion)) {
            if (create.origin() == Engine.Operation.Origin.RECOVERY) {
                return;
            }
            throw new VersionConflictEngineException(this.shardId, create.type(), create.id(), currentVersion, expectedVersion);
        }
        long updatedVersion = create.versionType().updateVersion(currentVersion, expectedVersion);
        boolean doUpdate = false;
        if (versionValue != null && !versionValue.delete() || versionValue == null && currentVersion != -1L) {
            if (create.origin() == Engine.Operation.Origin.RECOVERY) {
                return;
            }
            if (create.origin() == Engine.Operation.Origin.REPLICA) {
                doUpdate = true;
            } else if (create.origin() == Engine.Operation.Origin.PRIMARY && create.autoGeneratedId() && create.canHaveDuplicates() && currentVersion == 1L && create.version() == -3L) {
                doUpdate = true;
                updatedVersion = 1L;
            } else {
                assert (create.origin() == Engine.Operation.Origin.PRIMARY);
                throw new DocumentAlreadyExistsException(this.shardId, create.type(), create.id());
            }
        }
        create.updateVersion(updatedVersion);
        if (doUpdate) {
            if (create.docs().size() > 1) {
                this.indexWriter.updateDocuments(create.uid(), create.docs());
            } else {
                this.indexWriter.updateDocument(create.uid(), (Iterable)create.docs().get(0));
            }
        } else if (create.docs().size() > 1) {
            this.indexWriter.addDocuments(create.docs());
        } else {
            this.indexWriter.addDocument((Iterable)create.docs().get(0));
        }
        Translog.Location translogLocation = this.translog.add(new Translog.Create(create));
        this.versionMap.putUnderLock(create.uid().bytes(), new VersionValue(updatedVersion, translogLocation));
        create.setTranslogLocation(translogLocation);
        this.indexingService.postCreateUnderLock(create);
    }

    @Override
    public boolean index(Engine.Index index) throws EngineException {
        boolean created;
        block27: {
            try (ReleasableLock lock = this.readLock.acquire();){
                this.ensureOpen();
                if (index.origin() == Engine.Operation.Origin.RECOVERY) {
                    created = this.innerIndex(index);
                    break block27;
                }
                try (Releasable r = this.throttle.acquireThrottle();){
                    created = this.innerIndex(index);
                }
            }
            catch (IOException | IllegalStateException | OutOfMemoryError t) {
                this.maybeFailEngine("index", t);
                throw new IndexFailedEngineException(this.shardId, index.type(), index.id(), t);
            }
        }
        this.checkVersionMapRefresh();
        return created;
    }

    private void checkVersionMapRefresh() {
        if (this.versionMap.ramBytesUsedForRefresh() > this.config().getVersionMapSize().bytes() && !this.versionMapRefreshPending.getAndSet(true)) {
            try {
                if (this.isClosed.get()) {
                    return;
                }
                this.engineConfig.getThreadPool().executor("refresh").execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            InternalEngine.this.refresh("version_table_full");
                        }
                        catch (EngineClosedException engineClosedException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (EsRejectedExecutionException esRejectedExecutionException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean innerIndex(Engine.Index index) throws IOException {
        Object object = this.dirtyLock(index.uid());
        synchronized (object) {
            boolean created;
            VersionValue versionValue = this.versionMap.getUnderLock(index.uid().bytes());
            long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(index.uid()) : (this.engineConfig.isEnableGcDeletes() && versionValue.delete() && this.engineConfig.getThreadPool().estimatedTimeInMillis() - versionValue.time() > this.engineConfig.getGcDeletesInMillis() ? -1L : versionValue.version());
            long expectedVersion = index.version();
            if (index.versionType().isVersionConflictForWrites(currentVersion, expectedVersion)) {
                if (index.origin() == Engine.Operation.Origin.RECOVERY) {
                    return false;
                }
                throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), currentVersion, expectedVersion);
            }
            long updatedVersion = index.versionType().updateVersion(currentVersion, expectedVersion);
            index.updateVersion(updatedVersion);
            if (currentVersion == -1L) {
                created = true;
                if (index.docs().size() > 1) {
                    this.indexWriter.addDocuments(index.docs());
                } else {
                    this.indexWriter.addDocument((Iterable)index.docs().get(0));
                }
            } else {
                created = versionValue != null ? versionValue.delete() : false;
                if (index.docs().size() > 1) {
                    this.indexWriter.updateDocuments(index.uid(), index.docs());
                } else {
                    this.indexWriter.updateDocument(index.uid(), (Iterable)index.docs().get(0));
                }
            }
            Translog.Location translogLocation = this.translog.add(new Translog.Index(index));
            this.versionMap.putUnderLock(index.uid().bytes(), new VersionValue(updatedVersion, translogLocation));
            index.setTranslogLocation(translogLocation);
            this.indexingService.postIndexUnderLock(index);
            return created;
        }
    }

    @Override
    public void delete(Engine.Delete delete) throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.innerDelete(delete);
        }
        catch (IOException | IllegalStateException | OutOfMemoryError t) {
            this.maybeFailEngine("delete", t);
            throw new DeleteFailedEngineException(this.shardId, delete, t);
        }
        this.maybePruneDeletedTombstones();
        this.checkVersionMapRefresh();
    }

    private void maybePruneDeletedTombstones() {
        if (this.engineConfig.isEnableGcDeletes() && (double)(this.engineConfig.getThreadPool().estimatedTimeInMillis() - this.lastDeleteVersionPruneTimeMSec) > (double)this.engineConfig.getGcDeletesInMillis() * 0.25) {
            this.pruneDeletedTombstones();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerDelete(Engine.Delete delete) throws IOException {
        Object object = this.dirtyLock(delete.uid());
        synchronized (object) {
            boolean found;
            VersionValue versionValue = this.versionMap.getUnderLock(delete.uid().bytes());
            long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(delete.uid()) : (this.engineConfig.isEnableGcDeletes() && versionValue.delete() && this.engineConfig.getThreadPool().estimatedTimeInMillis() - versionValue.time() > this.engineConfig.getGcDeletesInMillis() ? -1L : versionValue.version());
            long expectedVersion = delete.version();
            if (delete.versionType().isVersionConflictForWrites(currentVersion, expectedVersion)) {
                if (delete.origin() == Engine.Operation.Origin.RECOVERY) {
                    return;
                }
                throw new VersionConflictEngineException(this.shardId, delete.type(), delete.id(), currentVersion, expectedVersion);
            }
            long updatedVersion = delete.versionType().updateVersion(currentVersion, expectedVersion);
            if (currentVersion == -1L) {
                found = false;
            } else if (versionValue != null && versionValue.delete()) {
                found = false;
            } else {
                this.indexWriter.deleteDocuments(new Term[]{delete.uid()});
                found = true;
            }
            delete.updateVersion(updatedVersion, found);
            Translog.Location translogLocation = this.translog.add(new Translog.Delete(delete));
            this.versionMap.putUnderLock(delete.uid().bytes(), new DeleteVersionValue(updatedVersion, this.engineConfig.getThreadPool().estimatedTimeInMillis(), translogLocation));
            delete.setTranslogLocation(translogLocation);
            this.indexingService.postDeleteUnderLock(delete);
        }
    }

    @Override
    @Deprecated
    public void delete(Engine.DeleteByQuery delete) throws EngineException {
        block25: {
            try (ReleasableLock lock = this.readLock.acquire();){
                this.ensureOpen();
                if (delete.origin() == Engine.Operation.Origin.RECOVERY) {
                    this.innerDelete(delete);
                    break block25;
                }
                try (Releasable r = this.throttle.acquireThrottle();){
                    this.innerDelete(delete);
                }
            }
        }
    }

    private void innerDelete(Engine.DeleteByQuery delete) throws EngineException {
        try {
            Query query = delete.query();
            if (delete.aliasFilter() != null) {
                query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(delete.aliasFilter(), BooleanClause.Occur.FILTER).build();
            }
            if (delete.nested()) {
                query = new IncludeNestedDocsQuery(query, delete.parentFilter());
            }
            this.indexWriter.deleteDocuments(new Query[]{query});
            this.translog.add(new Translog.DeleteByQuery(delete));
        }
        catch (Throwable t) {
            this.maybeFailEngine("delete_by_query", t);
            throw new DeleteByQueryFailedEngineException(this.shardId, delete, t);
        }
        this.refresh("delete_by_query");
    }

    @Override
    public void refresh(String source) throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.searcherManager.maybeRefreshBlocking();
        }
        catch (AlreadyClosedException e) {
            this.ensureOpen();
            this.maybeFailEngine("refresh", e);
        }
        catch (EngineClosedException e) {
            throw e;
        }
        catch (Throwable t) {
            this.failEngine("refresh failed", t);
            throw new RefreshFailedEngineException(this.shardId, t);
        }
        this.maybePruneDeletedTombstones();
        this.versionMapRefreshPending.set(false);
        this.mergeScheduler.refreshConfig();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Engine.SyncedFlushResult syncFlush(String syncId, Engine.CommitId expectedCommitId) throws EngineException {
        this.ensureOpen();
        if (this.indexWriter.hasUncommittedChanges()) {
            this.logger.trace("can't sync commit [{}]. have pending changes", syncId);
            return Engine.SyncedFlushResult.PENDING_OPERATIONS;
        }
        if (!expectedCommitId.idsEqual(this.lastCommittedSegmentInfos.getId())) {
            this.logger.trace("can't sync commit [{}]. current commit id is not equal to expected.", syncId);
            return Engine.SyncedFlushResult.COMMIT_MISMATCH;
        }
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            if (this.indexWriter.hasUncommittedChanges()) {
                this.logger.trace("can't sync commit [{}]. have pending changes", syncId);
                Engine.SyncedFlushResult syncedFlushResult = Engine.SyncedFlushResult.PENDING_OPERATIONS;
                return syncedFlushResult;
            }
            if (!expectedCommitId.idsEqual(this.lastCommittedSegmentInfos.getId())) {
                this.logger.trace("can't sync commit [{}]. current commit id is not equal to expected.", syncId);
                Engine.SyncedFlushResult syncedFlushResult = Engine.SyncedFlushResult.COMMIT_MISMATCH;
                return syncedFlushResult;
            }
            this.logger.trace("starting sync commit [{}]", syncId);
            this.commitIndexWriter(this.indexWriter, this.translog, syncId);
            this.logger.debug("successfully sync committed. sync id [{}].", syncId);
            this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
            Engine.SyncedFlushResult syncedFlushResult = Engine.SyncedFlushResult.SUCCESS;
            return syncedFlushResult;
        }
        catch (IOException ex) {
            this.maybeFailEngine("sync commit", ex);
            throw new EngineException(this.shardId, "failed to sync commit", ex);
        }
    }

    @Override
    public Engine.CommitId flush() throws EngineException {
        return this.flush(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Engine.CommitId flush(boolean force, boolean waitIfOngoing) throws EngineException {
        byte[] newCommitId;
        this.ensureOpen();
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            if (!this.flushLock.tryLock()) {
                if (!waitIfOngoing) throw new FlushNotAllowedEngineException(this.shardId, "already flushing...");
                this.logger.trace("waiting for in-flight flush to finish", new Object[0]);
                this.flushLock.lock();
                this.logger.trace("acquired flush lock after blocking", new Object[0]);
            } else {
                this.logger.trace("acquired flush lock immediately", new Object[0]);
            }
            try {
                if (this.indexWriter.hasUncommittedChanges() || force) {
                    try {
                        this.translog.prepareCommit();
                        this.logger.trace("starting commit for flush; commitTranslog=true", new Object[0]);
                        this.commitIndexWriter(this.indexWriter, this.translog);
                        this.logger.trace("finished commit for flush", new Object[0]);
                        this.refresh("version_table_flush");
                        this.translog.commit();
                    }
                    catch (Throwable e) {
                        throw new FlushFailedEngineException(this.shardId, e);
                    }
                }
                this.store.incRef();
                try {
                    this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
                }
                catch (Throwable e) {
                    if (!this.isClosed.get()) {
                        this.logger.warn("failed to read latest segment infos on flush", e, new Object[0]);
                        if (Lucene.isCorruptionException(e)) {
                            throw new FlushFailedEngineException(this.shardId, e);
                        }
                    }
                }
                finally {
                    this.store.decRef();
                }
                newCommitId = this.lastCommittedSegmentInfos.getId();
            }
            catch (FlushFailedEngineException ex) {
                this.maybeFailEngine("flush", ex);
                throw ex;
            }
            finally {
                this.flushLock.unlock();
            }
        }
        if (!this.engineConfig.isEnableGcDeletes()) return new Engine.CommitId(newCommitId);
        this.pruneDeletedTombstones();
        return new Engine.CommitId(newCommitId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneDeletedTombstones() {
        long timeMSec = this.engineConfig.getThreadPool().estimatedTimeInMillis();
        for (Map.Entry<BytesRef, VersionValue> entry : this.versionMap.getAllTombstones()) {
            BytesRef uid = entry.getKey();
            Object object = this.dirtyLock(uid);
            synchronized (object) {
                VersionValue versionValue = this.versionMap.getTombstoneUnderLock(uid);
                if (versionValue != null && timeMSec - versionValue.time() > this.engineConfig.getGcDeletesInMillis()) {
                    this.versionMap.removeTombstoneUnderLock(uid);
                }
            }
        }
        this.lastDeleteVersionPruneTimeMSec = timeMSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, boolean upgrade, boolean upgradeOnlyAncientSegments) throws EngineException, EngineClosedException, IOException {
        assert (this.indexWriter.getConfig().getMergePolicy() instanceof ElasticsearchMergePolicy) : "MergePolicy is " + this.indexWriter.getConfig().getMergePolicy().getClass().getName();
        ElasticsearchMergePolicy mp = (ElasticsearchMergePolicy)this.indexWriter.getConfig().getMergePolicy();
        this.optimizeLock.lock();
        try {
            this.ensureOpen();
            if (upgrade) {
                this.logger.info("starting segment upgrade upgradeOnlyAncientSegments={}", upgradeOnlyAncientSegments);
                mp.setUpgradeInProgress(true, upgradeOnlyAncientSegments);
            }
            this.store.incRef();
            try {
                if (onlyExpungeDeletes) {
                    assert (!upgrade);
                    this.indexWriter.forceMergeDeletes(true);
                } else if (maxNumSegments <= 0) {
                    assert (!upgrade);
                    this.indexWriter.maybeMerge();
                } else {
                    this.indexWriter.forceMerge(maxNumSegments, true);
                }
                if (flush && !this.tryRenewSyncCommit()) {
                    this.flush(false, true);
                }
                if (upgrade) {
                    this.logger.info("finished segment upgrade", new Object[0]);
                }
            }
            finally {
                this.store.decRef();
            }
        }
        catch (Throwable t) {
            this.maybeFailEngine("force merge", t);
            throw t;
        }
        finally {
            try {
                mp.setUpgradeInProgress(false, false);
            }
            finally {
                this.optimizeLock.unlock();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SnapshotIndexCommit snapshotIndex(boolean flushFirst) throws EngineException {
        if (flushFirst) {
            this.logger.trace("start flush for snapshot", new Object[0]);
            this.flush(false, true);
            this.logger.trace("finish flush for snapshot", new Object[0]);
        }
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.logger.trace("pulling snapshot", new Object[0]);
            SnapshotIndexCommit snapshotIndexCommit = this.deletionPolicy.snapshot();
            return snapshotIndexCommit;
        }
        catch (IOException e) {
            throw new SnapshotFailedEngineException(this.shardId, (Throwable)e);
        }
    }

    @Override
    protected boolean maybeFailEngine(String source, Throwable t) {
        boolean shouldFail = super.maybeFailEngine(source, t);
        if (shouldFail) {
            return true;
        }
        if (t instanceof AlreadyClosedException) {
            if (!this.indexWriter.isOpen() && this.indexWriter.getTragicException() != null) {
                this.failEngine("already closed by tragic event on the index writer", this.indexWriter.getTragicException());
            } else if (!this.translog.isOpen() && this.translog.getTragicException() != null) {
                this.failEngine("already closed by tragic event on the translog", this.translog.getTragicException());
            }
            return true;
        }
        if (t != null && (!this.indexWriter.isOpen() && this.indexWriter.getTragicException() == t || !this.translog.isOpen() && this.translog.getTragicException() == t)) {
            this.failEngine(source, t);
            return true;
        }
        return false;
    }

    @Override
    protected SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    @Override
    protected final void writerSegmentStats(SegmentsStats stats) {
        stats.addVersionMapMemoryInBytes(this.versionMap.ramBytesUsed());
        stats.addIndexWriterMemoryInBytes(this.indexWriter.ramBytesUsed());
        stats.addIndexWriterMaxMemoryInBytes((long)(this.indexWriter.getConfig().getRAMBufferSizeMB() * 1024.0 * 1024.0));
    }

    @Override
    public long indexWriterRAMBytesUsed() {
        return this.indexWriter.ramBytesUsed();
    }

    @Override
    public List<Segment> segments(boolean verbose) {
        try (ReleasableLock lock = this.readLock.acquire();){
            Segment[] segmentsArr = this.getSegmentInfo(this.lastCommittedSegmentInfos, verbose);
            Set<OnGoingMerge> onGoingMerges = this.mergeScheduler.onGoingMerges();
            for (OnGoingMerge onGoingMerge : onGoingMerges) {
                block10: for (SegmentCommitInfo segmentInfoPerCommit : onGoingMerge.getMergedSegments()) {
                    for (Segment segment : segmentsArr) {
                        if (!segment.getName().equals(segmentInfoPerCommit.info.name)) continue;
                        segment.mergeId = onGoingMerge.getId();
                        continue block10;
                    }
                }
            }
            List<Segment> list = Arrays.asList(segmentsArr);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void closeNoLock(String reason) {
        if (this.isClosed.compareAndSet(false, true)) {
            assert (this.rwl.isWriteLockedByCurrentThread() || this.failEngineLock.isHeldByCurrentThread()) : "Either the write lock must be held or the engine must be currently be failing itself";
            try {
                this.versionMap.clear();
                try {
                    IOUtils.close((Closeable[])new Closeable[]{this.searcherManager});
                }
                catch (Throwable t) {
                    this.logger.warn("Failed to close SearcherManager", t, new Object[0]);
                }
                try {
                    IOUtils.close((Closeable[])new Closeable[]{this.translog});
                }
                catch (Throwable t) {
                    this.logger.warn("Failed to close translog", t, new Object[0]);
                }
                this.logger.trace("rollback indexWriter", new Object[0]);
                try {
                    this.indexWriter.rollback();
                }
                catch (AlreadyClosedException t) {
                    // empty catch block
                }
                this.logger.trace("rollback indexWriter done", new Object[0]);
                this.store.decRef();
            }
            catch (Throwable e) {
                try {
                    this.logger.warn("failed to rollback writer on close", e, new Object[0]);
                    this.store.decRef();
                }
                catch (Throwable throwable) {
                    this.store.decRef();
                    this.logger.debug("engine closed [{}]", reason);
                    throw throwable;
                }
                this.logger.debug("engine closed [{}]", reason);
            }
            this.logger.debug("engine closed [{}]", reason);
        }
    }

    @Override
    public boolean hasUncommittedChanges() {
        return this.indexWriter.hasUncommittedChanges();
    }

    @Override
    protected SearcherManager getSearcherManager() {
        return this.searcherManager;
    }

    private Object dirtyLock(BytesRef uid) {
        int hash = DjbHashFunction.DJB_HASH(uid.bytes, uid.offset, uid.length);
        return this.dirtyLocks[MathUtils.mod(hash, this.dirtyLocks.length)];
    }

    private Object dirtyLock(Term uid) {
        return this.dirtyLock(uid.bytes());
    }

    private long loadCurrentVersionFromIndex(Term uid) throws IOException {
        try (Engine.Searcher searcher = this.acquireSearcher("load_version", false);){
            long l = Versions.loadVersion(searcher.reader(), uid);
            return l;
        }
    }

    private IndexWriter createWriter(boolean create) throws IOException {
        try {
            IndexWriterConfig iwc = new IndexWriterConfig(this.engineConfig.getAnalyzer());
            iwc.setCommitOnClose(false);
            iwc.setOpenMode(create ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND);
            iwc.setIndexDeletionPolicy((IndexDeletionPolicy)this.deletionPolicy);
            boolean verbose = false;
            try {
                verbose = Boolean.parseBoolean(System.getProperty("tests.verbose"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            iwc.setInfoStream((InfoStream)(verbose ? InfoStream.getDefault() : new LoggerInfoStream(this.logger)));
            iwc.setMergeScheduler((MergeScheduler)this.mergeScheduler);
            MergePolicy mergePolicy = this.config().getMergePolicy();
            mergePolicy = new ElasticsearchMergePolicy(mergePolicy);
            iwc.setMergePolicy(mergePolicy);
            iwc.setSimilarity(this.engineConfig.getSimilarity());
            iwc.setRAMBufferSizeMB(this.engineConfig.getIndexingBufferSize().mbFrac());
            iwc.setCodec(this.engineConfig.getCodec());
            iwc.setWriteLockTimeout(5000L);
            iwc.setUseCompoundFile(this.engineConfig.isCompoundOnFlush());
            iwc.setMergedSegmentWarmer(new IndexWriter.IndexReaderWarmer(){

                public void warm(LeafReader reader) throws IOException {
                    block5: {
                        try {
                            ElasticsearchLeafReader esLeafReader = new ElasticsearchLeafReader(reader, InternalEngine.this.shardId);
                            assert (Engine.isMergedSegment((LeafReader)esLeafReader));
                            if (InternalEngine.this.warmer != null) {
                                Engine.Searcher searcher = new Engine.Searcher("warmer", InternalEngine.this.searcherFactory.newSearcher((IndexReader)esLeafReader, null));
                                IndicesWarmer.WarmerContext context = new IndicesWarmer.WarmerContext(InternalEngine.this.shardId, searcher);
                                InternalEngine.this.warmer.warmNewReaders(context);
                            }
                        }
                        catch (Throwable t) {
                            if (!InternalEngine.this.isClosed.get()) {
                                InternalEngine.this.logger.warn("Warm-up failed", t, new Object[0]);
                            }
                            if (!(t instanceof Error)) break block5;
                            throw (Error)t;
                        }
                    }
                }
            });
            return new IndexWriter(this.store.directory(), iwc);
        }
        catch (LockObtainFailedException ex) {
            boolean isLocked = IndexWriter.isLocked((Directory)this.store.directory());
            this.logger.warn("Could not lock IndexWriter isLocked [{}]", ex, isLocked);
            throw ex;
        }
    }

    public void activateThrottling() {
        this.throttle.activate();
    }

    public void deactivateThrottling() {
        this.throttle.deactivate();
    }

    long getGcDeletesInMillis() {
        return this.engineConfig.getGcDeletesInMillis();
    }

    LiveIndexWriterConfig getCurrentIndexWriterConfig() {
        return this.indexWriter.getConfig();
    }

    private void commitIndexWriter(IndexWriter writer, Translog translog, String syncId) throws IOException {
        try {
            Translog.TranslogGeneration translogGeneration = translog.getGeneration();
            this.logger.trace("committing writer with translog id [{}]  and sync id [{}] ", translogGeneration.translogFileGeneration, syncId);
            HashMap<String, String> commitData = new HashMap<String, String>(2);
            commitData.put("translog_generation", Long.toString(translogGeneration.translogFileGeneration));
            commitData.put("translog_uuid", translogGeneration.translogUUID);
            if (syncId != null) {
                commitData.put("sync_id", syncId);
            }
            this.indexWriter.setCommitData(commitData);
            writer.commit();
        }
        catch (Throwable ex) {
            this.failEngine("lucene commit failed", ex);
            throw ex;
        }
    }

    private void commitIndexWriter(IndexWriter writer, Translog translog) throws IOException {
        this.commitIndexWriter(writer, translog, null);
    }

    @Override
    public void onSettingsChanged() {
        this.mergeScheduler.refreshConfig();
        this.updateIndexWriterSettings();
        this.checkVersionMapRefresh();
        this.maybePruneDeletedTombstones();
    }

    @Override
    public MergeStats getMergeStats() {
        return this.mergeScheduler.stats();
    }

    final boolean tryRenewSyncCommit() {
        boolean renewed = false;
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            String syncId = (String)this.lastCommittedSegmentInfos.getUserData().get("sync_id");
            if (syncId != null && this.translog.totalOperations() == 0 && this.indexWriter.hasUncommittedChanges()) {
                this.logger.trace("start renewing sync commit [{}]", syncId);
                this.commitIndexWriter(this.indexWriter, this.translog, syncId);
                this.logger.debug("successfully sync committed. sync id [{}].", syncId);
                this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
                renewed = true;
            }
        }
        catch (IOException ex) {
            this.maybeFailEngine("renew sync commit", ex);
            throw new EngineException(this.shardId, "failed to renew sync commit", ex);
        }
        if (renewed) {
            this.refresh("renew sync commit");
        }
        return renewed;
    }

    private final class EngineMergeScheduler
    extends ElasticsearchConcurrentMergeScheduler {
        private final AtomicInteger numMergesInFlight;
        private final AtomicBoolean isThrottling;

        EngineMergeScheduler(ShardId shardId, Settings indexSettings, MergeSchedulerConfig config) {
            super(shardId, indexSettings, config);
            this.numMergesInFlight = new AtomicInteger(0);
            this.isThrottling = new AtomicBoolean();
        }

        @Override
        public synchronized void beforeMerge(OnGoingMerge merge) {
            int maxNumMerges = InternalEngine.this.mergeScheduler.getMaxMergeCount();
            if (this.numMergesInFlight.incrementAndGet() > maxNumMerges && !this.isThrottling.getAndSet(true)) {
                this.logger.info("now throttling indexing: numMergesInFlight={}, maxNumMerges={}", this.numMergesInFlight, maxNumMerges);
                InternalEngine.this.indexingService.throttlingActivated();
                InternalEngine.this.activateThrottling();
            }
        }

        @Override
        public synchronized void afterMerge(OnGoingMerge merge) {
            int maxNumMerges = InternalEngine.this.mergeScheduler.getMaxMergeCount();
            if (this.numMergesInFlight.decrementAndGet() < maxNumMerges && this.isThrottling.getAndSet(false)) {
                this.logger.info("stop throttling indexing: numMergesInFlight={}, maxNumMerges={}", this.numMergesInFlight, maxNumMerges);
                InternalEngine.this.indexingService.throttlingDeactivated();
                InternalEngine.this.deactivateThrottling();
            }
        }

        protected void handleMergeException(final Directory dir, final Throwable exc) {
            this.logger.error("failed to merge", exc, new Object[0]);
            if (InternalEngine.this.config().getMergeSchedulerConfig().isNotifyOnMergeFailure()) {
                InternalEngine.this.engineConfig.getThreadPool().generic().execute(new AbstractRunnable(){

                    @Override
                    public void onFailure(Throwable t) {
                        EngineMergeScheduler.this.logger.debug("merge failure action rejected", t, new Object[0]);
                    }

                    @Override
                    protected void doRun() throws Exception {
                        MergePolicy.MergeException e = new MergePolicy.MergeException(exc, dir);
                        InternalEngine.this.failEngine("merge failed", (Throwable)e);
                    }
                });
            }
        }
    }

    static final class SearchFactory
    extends EngineSearcherFactory {
        private final IndicesWarmer warmer;
        private final ShardId shardId;
        private final ESLogger logger;
        private final AtomicBoolean isEngineClosed;

        SearchFactory(ESLogger logger, AtomicBoolean isEngineClosed, EngineConfig engineConfig) {
            super(engineConfig);
            this.warmer = engineConfig.getWarmer();
            this.shardId = engineConfig.getShardId();
            this.logger = logger;
            this.isEngineClosed = isEngineClosed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public IndexSearcher newSearcher(IndexReader reader, IndexReader previousReader) throws IOException {
            IndexSearcher searcher = super.newSearcher(reader, previousReader);
            if (reader instanceof LeafReader && Engine.isMergedSegment((LeafReader)reader)) {
                return searcher;
            }
            if (this.warmer == null) return searcher;
            IndexSearcher newSearcher = null;
            boolean closeNewSearcher = false;
            try {
                if (previousReader == null) {
                    newSearcher = searcher;
                } else {
                    ArrayList<LeafReader> readers = new ArrayList<LeafReader>();
                    for (LeafReaderContext newReaderContext : reader.leaves()) {
                        if (Engine.isMergedSegment(newReaderContext.reader())) continue;
                        boolean found = false;
                        for (LeafReaderContext currentReaderContext : previousReader.leaves()) {
                            if (!currentReaderContext.reader().getCoreCacheKey().equals(newReaderContext.reader().getCoreCacheKey())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        readers.add(newReaderContext.reader());
                    }
                    if (!readers.isEmpty()) {
                        MultiReader newReader = new MultiReader(readers.toArray(new IndexReader[readers.size()]), false);
                        newSearcher = super.newSearcher((IndexReader)newReader, null);
                        closeNewSearcher = true;
                    }
                }
                if (newSearcher != null) {
                    IndicesWarmer.WarmerContext context = new IndicesWarmer.WarmerContext(this.shardId, new Engine.Searcher("new_reader_warming", newSearcher));
                    this.warmer.warmNewReaders(context);
                }
                assert (searcher.getIndexReader() instanceof ElasticsearchDirectoryReader) : "this class needs an ElasticsearchDirectoryReader but got: " + searcher.getIndexReader().getClass();
                this.warmer.warmTopReader(new IndicesWarmer.WarmerContext(this.shardId, new Engine.Searcher("top_reader_warming", searcher)));
                if (newSearcher == null || !closeNewSearcher) return searcher;
            }
            catch (Throwable e) {
                try {
                    if (!this.isEngineClosed.get()) {
                        this.logger.warn("failed to prepare/warm", e, new Object[0]);
                    }
                    if (newSearcher == null || !closeNewSearcher) return searcher;
                }
                catch (Throwable throwable) {
                    if (newSearcher == null || !closeNewSearcher) throw throwable;
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{newSearcher.getIndexReader()});
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{newSearcher.getIndexReader()});
                return searcher;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{newSearcher.getIndexReader()});
            return searcher;
        }
    }
}

