/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.Map;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.ParseOption;
import org.scilab.forge.jlatexmath.RotateBox;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;

public class RotateAtom
extends Atom {
    private Atom base;
    private double angle;
    private int option = -1;
    private int xunit;
    private int yunit;
    private float x;
    private float y;

    public RotateAtom(Atom atom, String string, String string2) {
        this.type = atom.type;
        this.base = atom;
        this.angle = Double.parseDouble(string);
        this.option = RotateBox.getOrigin(string2);
    }

    public RotateAtom(Atom atom, double d, String string) {
        this.type = atom.type;
        this.base = atom;
        this.angle = d;
        Map<String, String> map = ParseOption.parseMap(string);
        if (map.containsKey("origin")) {
            this.option = RotateBox.getOrigin(map.get("origin"));
        } else {
            float[] fArray;
            if (map.containsKey("x")) {
                fArray = SpaceAtom.getLength(map.get("x"));
                this.xunit = (int)fArray[0];
                this.x = fArray[1];
            } else {
                this.xunit = 3;
                this.x = 0.0f;
            }
            if (map.containsKey("y")) {
                fArray = SpaceAtom.getLength(map.get("y"));
                this.yunit = (int)fArray[0];
                this.y = fArray[1];
            } else {
                this.yunit = 3;
                this.y = 0.0f;
            }
        }
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        if (this.option != -1) {
            return new RotateBox(this.base.createBox(teXEnvironment), this.angle, this.option);
        }
        return new RotateBox(this.base.createBox(teXEnvironment), this.angle, this.x * SpaceAtom.getFactor(this.xunit, teXEnvironment), this.y * SpaceAtom.getFactor(this.yunit, teXEnvironment));
    }
}

