/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class GenerateDataKeyWithoutPlaintextRequestMarshaller
implements Marshaller<Request<GenerateDataKeyWithoutPlaintextRequest>, GenerateDataKeyWithoutPlaintextRequest> {
    public Request<GenerateDataKeyWithoutPlaintextRequest> marshall(GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest) {
        if (generateDataKeyWithoutPlaintextRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)generateDataKeyWithoutPlaintextRequest, "AWSKMS");
        String target = "TrentService.GenerateDataKeyWithoutPlaintext";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag grantTokensList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (generateDataKeyWithoutPlaintextRequest.getKeyId() != null) {
                jsonWriter.key("KeyId").value((Object)generateDataKeyWithoutPlaintextRequest.getKeyId());
            }
            if (generateDataKeyWithoutPlaintextRequest.getEncryptionContext() != null && !generateDataKeyWithoutPlaintextRequest.getEncryptionContext().isEmpty()) {
                jsonWriter.key("EncryptionContext");
                jsonWriter.object();
                for (Map.Entry<String, String> encryptionContextListValue : generateDataKeyWithoutPlaintextRequest.getEncryptionContext().entrySet()) {
                    if (encryptionContextListValue.getValue() == null) continue;
                    jsonWriter.key(encryptionContextListValue.getKey());
                    jsonWriter.value((Object)encryptionContextListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (generateDataKeyWithoutPlaintextRequest.getKeySpec() != null) {
                jsonWriter.key("KeySpec").value((Object)generateDataKeyWithoutPlaintextRequest.getKeySpec());
            }
            if (generateDataKeyWithoutPlaintextRequest.getNumberOfBytes() != null) {
                jsonWriter.key("NumberOfBytes").value((Object)generateDataKeyWithoutPlaintextRequest.getNumberOfBytes());
            }
            if (!((grantTokensList = (ListWithAutoConstructFlag)generateDataKeyWithoutPlaintextRequest.getGrantTokens()) == null || grantTokensList.isAutoConstruct() && grantTokensList.isEmpty())) {
                jsonWriter.key("GrantTokens");
                jsonWriter.array();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonWriter.value((Object)grantTokensListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

