/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import com.google.common.io.CharSource;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.UncheckedException;

public class CharSourceBackedTextResource
implements TextResource {
    private final CharSource charSource;

    public CharSourceBackedTextResource(CharSource charSource) {
        this.charSource = charSource;
    }

    public String asString() {
        try {
            return this.charSource.read();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public Reader asReader() {
        try {
            return this.charSource.openStream();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public File asFile(String charset) {
        throw new UnsupportedOperationException("Cannot create file for char source " + this.charSource);
    }

    public File asFile() {
        throw new UnsupportedOperationException("Cannot create file for char source " + this.charSource);
    }

    public Object getInputProperties() {
        return null;
    }

    public FileCollection getInputFiles() {
        return null;
    }

    public TaskDependency getBuildDependencies() {
        return new TaskDependency(){

            @Override
            public Set<? extends Task> getDependencies(Task task) {
                return Collections.emptySet();
            }
        };
    }
}

