/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.ProtocolContext;
import org.gradle.messaging.remote.internal.protocol.ConsumerAvailable;
import org.gradle.messaging.remote.internal.protocol.ConsumerReady;
import org.gradle.messaging.remote.internal.protocol.ConsumerStopped;
import org.gradle.messaging.remote.internal.protocol.ConsumerStopping;
import org.gradle.messaging.remote.internal.protocol.ConsumerUnavailable;
import org.gradle.messaging.remote.internal.protocol.ProducerAvailable;
import org.gradle.messaging.remote.internal.protocol.ProducerReady;
import org.gradle.messaging.remote.internal.protocol.ProducerStopped;
import org.gradle.messaging.remote.internal.protocol.ProducerUnavailable;
import org.gradle.messaging.remote.internal.protocol.RoutableMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendProtocol
implements Protocol<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendProtocol.class);
    private final String channelKey;
    private final UUID id;
    private final String displayName;
    private ProtocolContext<Message> context;
    private boolean stopping;
    private final Map<Object, ConsumerAvailable> pending = new HashMap<Object, ConsumerAvailable>();
    private final Set<Object> consumers = new HashSet<Object>();

    public SendProtocol(UUID id, String displayName, String channelKey) {
        this.channelKey = channelKey;
        this.id = id;
        this.displayName = displayName;
    }

    @Override
    public void start(ProtocolContext<Message> context) {
        LOGGER.debug("Starting producer {}", (Object)this.id);
        this.context = context;
        context.dispatchOutgoing(new ProducerAvailable(this.id, this.displayName, this.channelKey));
    }

    @Override
    public void handleIncoming(Message message) {
        if (message instanceof ConsumerAvailable) {
            LOGGER.debug("Consumer available: {}", (Object)message);
            ConsumerAvailable consumerAvailable = (ConsumerAvailable)message;
            this.pending.put(consumerAvailable.getId(), consumerAvailable);
            this.consumers.add(consumerAvailable.getId());
            this.context.dispatchOutgoing(new ProducerReady(this.id, consumerAvailable.getId()));
        } else if (message instanceof ConsumerReady) {
            LOGGER.debug("Consumer ready: {}", (Object)message);
            ConsumerReady consumerReady = (ConsumerReady)message;
            this.context.dispatchIncoming(this.pending.remove(consumerReady.getConsumerId()));
        } else if (message instanceof ConsumerStopping) {
            LOGGER.debug("Consumer stopping: {}", (Object)message);
            ConsumerStopping consumerStopping = (ConsumerStopping)message;
            this.context.dispatchIncoming(new ConsumerUnavailable(consumerStopping.getConsumerId()));
            this.context.dispatchOutgoing(new ProducerStopped(this.id, consumerStopping.getConsumerId()));
        } else if (message instanceof ConsumerStopped) {
            LOGGER.debug("Consumer stopped: {}", (Object)message);
            ConsumerStopped consumerStopped = (ConsumerStopped)message;
            this.consumers.remove(consumerStopped.getConsumerId());
            this.maybeStop();
        } else if (message instanceof ConsumerUnavailable) {
            LOGGER.debug("Consumer unavailable: {}", (Object)message);
            ConsumerUnavailable consumerUnavailable = (ConsumerUnavailable)message;
            this.consumers.remove(consumerUnavailable.getId());
            if (this.pending.remove(consumerUnavailable.getId()) == null) {
                this.context.dispatchIncoming(new ConsumerUnavailable(consumerUnavailable.getId()));
            }
            this.maybeStop();
        } else {
            throw new IllegalArgumentException(String.format("Unexpected incoming message received: %s", message));
        }
    }

    private void maybeStop() {
        if (this.consumers.isEmpty() && this.stopping) {
            LOGGER.debug("All consumers stopped. Stopping now.");
            this.context.dispatchOutgoing(new ProducerUnavailable(this.id));
            this.context.stopped();
        }
    }

    @Override
    public void handleOutgoing(Message message) {
        if (message instanceof RoutableMessage) {
            RoutableMessage routableMessage = (RoutableMessage)((Object)message);
            if (!this.consumers.contains(routableMessage.getDestination())) {
                throw new IllegalStateException(String.format("Message to unexpected destination dispatched: %s", message));
            }
        } else {
            throw new IllegalArgumentException(String.format("Unexpected outgoing message dispatched: %s", message));
        }
        this.context.dispatchOutgoing(message);
    }

    @Override
    public void stopRequested() {
        this.stopping = true;
        if (this.consumers.isEmpty()) {
            this.maybeStop();
            return;
        }
        LOGGER.debug("Waiting for consumers to stop: {}", this.consumers);
        this.context.stopLater();
        for (Object consumerId : this.consumers) {
            this.context.dispatchOutgoing(new ProducerStopped(this.id, consumerId));
        }
    }
}

