/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.daemon.AbstractDaemonCompiler;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonFactory;
import org.gradle.api.internal.tasks.compile.daemon.DaemonForkOptions;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.api.tasks.compile.GroovyForkOptions;
import org.gradle.language.base.internal.compile.Compiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonGroovyCompiler
extends AbstractDaemonCompiler<GroovyJavaJointCompileSpec> {
    private static final Iterable<String> SHARED_PACKAGES = Arrays.asList("groovy", "org.codehaus.groovy", "groovyjarjarantlr", "groovyjarjarasm", "groovyjarjarcommonscli", "org.apache.tools.ant", "com.sun.tools.javac");
    private final ClassPathRegistry classPathRegistry;

    public DaemonGroovyCompiler(File daemonWorkingDir, Compiler<GroovyJavaJointCompileSpec> delegate, ClassPathRegistry classPathRegistry, CompilerDaemonFactory daemonFactory) {
        super(daemonWorkingDir, delegate, daemonFactory);
        this.classPathRegistry = classPathRegistry;
    }

    protected DaemonForkOptions toDaemonOptions(GroovyJavaJointCompileSpec spec) {
        return this.createJavaForkOptions(spec).mergeWith(this.createGroovyForkOptions(spec));
    }

    private DaemonForkOptions createJavaForkOptions(GroovyJavaJointCompileSpec spec) {
        ForkOptions options = spec.getCompileOptions().getForkOptions();
        return new DaemonForkOptions(options.getMemoryInitialSize(), options.getMemoryMaximumSize(), (Iterable)options.getJvmArgs());
    }

    private DaemonForkOptions createGroovyForkOptions(GroovyJavaJointCompileSpec spec) {
        GroovyForkOptions options = spec.getGroovyCompileOptions().getForkOptions();
        List antFiles = this.classPathRegistry.getClassPath("ANT").getAsFiles();
        Iterable groovyFiles = Iterables.concat((Iterable)spec.getGroovyClasspath(), (Iterable)antFiles);
        return new DaemonForkOptions(options.getMemoryInitialSize(), options.getMemoryMaximumSize(), (Iterable)options.getJvmArgs(), groovyFiles, SHARED_PACKAGES);
    }
}

