/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.G3DRenderer;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.PrecisionRenderer;
import org.jmol.util.GData;
import org.jmol.util.Rgb16;

public class TriangleRenderer
extends PrecisionRenderer
implements G3DRenderer {
    private Graphics3D g3d;
    private static final int DEFAULT = 64;
    private int[] ax = new int[3];
    private int[] ay = new int[3];
    private int[] az = new int[3];
    private float[] aa = new float[64];
    private float[] bb = new float[64];
    private int[] axW = new int[64];
    private int[] azW = new int[64];
    private int[] axE = new int[64];
    private int[] azE = new int[64];
    private Rgb16[] rgb16sW;
    private Rgb16[] rgb16sE;
    private Rgb16[] rgb16sGouraud;
    final Rgb16 rgb16t1 = new Rgb16();
    final Rgb16 rgb16t2 = new Rgb16();
    private P3[] abc = new P3[3];

    @Override
    public G3DRenderer set(JmolRendererInterface jmolRendererInterface, GData gData) {
        try {
            this.rgb16sW = new Rgb16[64];
            this.rgb16sE = new Rgb16[64];
            int n = 64;
            while (--n >= 0) {
                this.rgb16sW[n] = new Rgb16();
                this.rgb16sE[n] = new Rgb16();
            }
            this.g3d = (Graphics3D)jmolRendererInterface;
            this.rgb16sGouraud = new Rgb16[3];
            n = 3;
            while (--n >= 0) {
                this.rgb16sGouraud[n] = new Rgb16();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    Rgb16[] reallocRgb16s(Rgb16[] rgb16Array, int n) {
        Rgb16[] rgb16Array2 = new Rgb16[n];
        System.arraycopy(rgb16Array, 0, rgb16Array2, 0, rgb16Array.length);
        for (int i = rgb16Array.length; i < n; ++i) {
            rgb16Array2[i] = new Rgb16();
        }
        return rgb16Array2;
    }

    void setGouraud(int n, int n2, int n3) {
        this.rgb16sGouraud[0].setInt(n);
        this.rgb16sGouraud[1].setInt(n2);
        this.rgb16sGouraud[2].setInt(n3);
    }

    void fillTriangleXYZ(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        this.ax[0] = n;
        this.ax[1] = n4;
        this.ax[2] = n7;
        this.ay[0] = n2;
        this.ay[1] = n5;
        this.ay[2] = n8;
        this.az[0] = n3;
        this.az[1] = n6;
        this.az[2] = n9;
        this.abc[0] = null;
        this.fillTriangleB(bl);
    }

    void fillTriangleP3i(P3i p3i, P3i p3i2, P3i p3i3, boolean bl) {
        this.ax[0] = p3i.x;
        this.ax[1] = p3i2.x;
        this.ax[2] = p3i3.x;
        this.ay[0] = p3i.y;
        this.ay[1] = p3i2.y;
        this.ay[2] = p3i3.y;
        this.az[0] = p3i.z;
        this.az[1] = p3i2.z;
        this.az[2] = p3i3.z;
        this.abc[0] = null;
        this.fillTriangleB(bl);
    }

    void fillTriangleP3f(P3 p3, P3 p32, P3 p33, boolean bl, boolean bl2) {
        this.ax[0] = Math.round(p3.x);
        this.ax[1] = Math.round(p32.x);
        this.ax[2] = Math.round(p33.x);
        this.ay[0] = Math.round(p3.y);
        this.ay[1] = Math.round(p32.y);
        this.ay[2] = Math.round(p33.y);
        this.az[0] = Math.round(p3.z);
        this.az[1] = Math.round(p32.z);
        this.az[2] = Math.round(p33.z);
        if (bl2) {
            this.abc[0] = p3;
            this.abc[1] = p32;
            this.abc[2] = p33;
        } else {
            this.abc[0] = null;
        }
        this.fillTriangleB(bl);
    }

    private void fillTriangleB(boolean bl) {
        int n;
        int n2;
        int n3;
        Rgb16[] rgb16Array;
        Rgb16[] rgb16Array2;
        int n4;
        int n5;
        int n6;
        boolean bl2;
        int n7;
        int n8;
        if (this.az[0] <= 1 || this.az[1] <= 1 || this.az[2] <= 1) {
            return;
        }
        int n9 = this.g3d.clipCode3(this.ax[0], this.ay[0], this.az[0]);
        int n10 = n9 | (n8 = this.g3d.clipCode3(this.ax[1], this.ay[1], this.az[1])) | (n7 = this.g3d.clipCode3(this.ax[2], this.ay[2], this.az[2]));
        boolean bl3 = bl2 = n10 != 0;
        if (bl2 && (n10 == -1 || (n9 & n8 & n7) != 0)) {
            return;
        }
        boolean bl4 = this.abc[0] != null;
        int n11 = 0;
        if (this.ay[1] < this.ay[n11]) {
            n11 = 1;
        }
        if (this.ay[2] < this.ay[n11]) {
            n11 = 2;
        }
        if (this.ay[n6 = (n11 + 1) % 3] > this.ay[n5 = (n11 + 2) % 3]) {
            n4 = n6;
            n6 = n5;
            n5 = n4;
        }
        n4 = this.ay[n11];
        int n12 = this.ay[n6];
        int n13 = this.ay[n5];
        int n14 = n13 - n4 + 1;
        if (n14 > this.g3d.height * 3) {
            return;
        }
        if (n14 > this.axW.length) {
            int n15 = n14 + 31 & 0xFFFFFFE0;
            this.axW = new int[n15];
            this.azW = new int[n15];
            this.axE = new int[n15];
            this.azE = new int[n15];
            if (bl4) {
                this.aa = new float[n15];
                this.bb = new float[n15];
            }
            this.rgb16sW = this.reallocRgb16s(this.rgb16sW, n15);
            this.rgb16sE = this.reallocRgb16s(this.rgb16sE, n15);
        }
        if (bl) {
            rgb16Array2 = this.rgb16sW;
            rgb16Array = this.rgb16sE;
        } else {
            rgb16Array = null;
            rgb16Array2 = null;
        }
        int n16 = n12 - n4;
        if (n16 == 0) {
            if (this.ax[n6] < this.ax[n11]) {
                n3 = n6;
                n6 = n11;
                n11 = n3;
            }
            this.generateRaster(n14, n11, n5, this.axW, this.azW, this.aa, bl4, 0, rgb16Array2, false);
            this.generateRaster(n14, n6, n5, this.axE, this.azE, this.bb, bl4, 0, rgb16Array, true);
        } else if (n12 == n13) {
            if (this.ax[n5] < this.ax[n6]) {
                n3 = n6;
                n6 = n5;
                n5 = n3;
            }
            this.generateRaster(n14, n11, n6, this.axW, this.azW, this.aa, bl4, 0, rgb16Array2, false);
            this.generateRaster(n14, n11, n5, this.axE, this.azE, this.bb, bl4, 0, rgb16Array, true);
        } else {
            n3 = this.ax[n5] - this.ax[n11];
            n2 = GData.roundInt(n14 / 2);
            if (n3 < 0) {
                n2 = -n2;
            }
            if ((n = this.ax[n11] + (n3 * n16 + n2) / n14) < this.ax[n6]) {
                this.generateRaster(n14, n11, n5, this.axW, this.azW, this.aa, bl4, 0, rgb16Array2, false);
                this.generateRaster(n16 + 1, n11, n6, this.axE, this.azE, this.bb, bl4, 0, rgb16Array, true);
                this.generateRaster(n14 - n16, n6, n5, this.axE, this.azE, this.bb, bl4, n16, rgb16Array, true);
            } else {
                this.generateRaster(n16 + 1, n11, n6, this.axW, this.azW, this.aa, bl4, 0, rgb16Array2, false);
                this.generateRaster(n14 - n16, n6, n5, this.axW, this.azW, this.aa, bl4, n16, rgb16Array2, false);
                this.generateRaster(n14, n11, n5, this.axE, this.azE, this.bb, bl4, 0, rgb16Array, true);
            }
        }
        this.g3d.setZMargin(5);
        n3 = this.g3d.pass2Flag01;
        n2 = 1 - n3;
        int n17 = 0;
        if (n4 < 0) {
            n14 += n4;
            n17 -= n4;
            n4 = 0;
        }
        if (n4 + n14 > this.g3d.height) {
            n14 = this.g3d.height - n4;
        }
        if (bl) {
            if (bl2) {
                while (--n14 >= n3) {
                    n = this.axW[n17];
                    int n18 = this.axE[n17] - n + n2;
                    if (n18 > 0) {
                        this.g3d.plotPixelsClippedRaster(n18, n, n4, this.azW[n17], this.azE[n17], this.rgb16sW[n17], this.rgb16sE[n17]);
                    }
                    ++n4;
                    ++n17;
                }
            } else {
                while (--n14 >= n3) {
                    n = this.axW[n17];
                    int n19 = this.axE[n17] - n + n2;
                    if (n3 == 1 && n19 < 0) {
                        n19 = 1;
                        --n;
                    }
                    if (n19 > 0) {
                        this.g3d.plotPixelsUnclippedRaster(n19, n, n4, this.azW[n17], this.azE[n17], this.rgb16sW[n17], this.rgb16sE[n17]);
                    }
                    ++n4;
                    ++n17;
                }
            }
        } else if (bl4) {
            if (bl2) {
                while (--n14 >= n3) {
                    n = this.axW[n17];
                    int n20 = this.axE[n17] - n + n2;
                    if (n20 > 0) {
                        this.g3d.plotPixelsClippedRasterBits(n20, n, n4, this.azW[n17], this.azE[n17], null, null, this.aa[n17], this.bb[n17]);
                    }
                    ++n4;
                    ++n17;
                }
            } else {
                while (--n14 >= n3) {
                    n = this.axW[n17];
                    int n21 = this.axE[n17] - n + n2;
                    if (n3 == 1 && n21 < 0) {
                        n21 = 1;
                        --n;
                    }
                    if (n21 > 0) {
                        this.g3d.plotPixelsUnclippedRasterBits(n21, n, n4, null, null, this.aa[n17], this.bb[n17]);
                    }
                    ++n4;
                    ++n17;
                }
            }
        } else if (bl2) {
            while (--n14 >= n3) {
                n = this.axW[n17];
                int n22 = this.axE[n17] - n + n2;
                if (n22 > 0) {
                    this.g3d.plotPixelsClippedRaster(n22, n, n4, this.azW[n17], this.azE[n17], null, null);
                }
                ++n4;
                ++n17;
            }
        } else {
            while (--n14 >= n3) {
                n = this.axW[n17];
                int n23 = this.axE[n17] - n + n2;
                if (n3 == 1 && n23 < 0) {
                    n23 = 1;
                    --n;
                }
                if (n23 > 0) {
                    this.g3d.plotPixelsUnclippedRaster(n23, n, n4, this.azW[n17], this.azE[n17], null, null);
                }
                ++n4;
                ++n17;
            }
        }
        this.g3d.setZMargin(0);
    }

    private void generateRaster(int n, int n2, int n3, int[] nArray, int[] nArray2, float[] fArray, boolean bl, int n4, Rgb16[] rgb16Array, boolean bl2) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = this.ax[n2];
        int n14 = this.az[n2];
        int n15 = this.ax[n3];
        int n16 = this.az[n3];
        int n17 = n15 - n13;
        int n18 = n16 - n14;
        int n19 = n13;
        if (n17 >= 0) {
            n12 = 1;
            n11 = n17;
            n10 = 0;
        } else {
            n12 = -1;
            n11 = -n17;
            n10 = 1 - n;
        }
        if (bl) {
            this.setRastAB(this.abc[n2].y, this.abc[n2].z, this.abc[n3].y, this.abc[n3].z);
        }
        if (n11 <= n) {
            n9 = 0;
            n8 = n11;
        } else {
            n9 = GData.roundInt(n17 / n);
            n8 = n11 % n;
        }
        if (bl) {
            float f = this.a;
            float f2 = this.b;
            n7 = this.ay[n2];
            n6 = n4;
            for (n5 = 0; n5 < n; ++n5) {
                nArray[n6] = n19;
                if (n6 == 0 || n6 > n4) {
                    if (n6 > fArray.length) {
                        System.out.println("triangle rend errror");
                    }
                    fArray[n6] = this.getZCurrent(f, f2, n7++);
                    nArray2[n6] = (int)fArray[n6];
                    if (bl2) {
                        this.setRastAB(this.axW[n6], this.aa[n6], n19, fArray[n6]);
                        this.aa[n6] = this.a;
                        this.bb[n6] = this.b;
                    }
                }
                n19 += n9;
                if ((n10 += n8) > 0) {
                    n19 += n12;
                    n10 -= n;
                }
                ++n6;
            }
        } else {
            int n20 = (n14 << 10) + 512;
            int n21 = GData.roundInt(n / 2);
            if (n18 < 0) {
                n21 = -n21;
            }
            n7 = ((n18 << 10) + n21) / n;
            n6 = n4;
            for (n5 = 0; n5 < n; ++n5) {
                nArray[n6] = n19;
                nArray2[n6] = n20 >> 10;
                n19 += n9;
                if ((n10 += n8) > 0) {
                    n19 += n12;
                    n10 -= n;
                }
                n20 += n7;
                ++n6;
            }
        }
        if (rgb16Array != null) {
            Rgb16 rgb16 = this.rgb16t1;
            rgb16.setRgb(this.rgb16sGouraud[n2]);
            Rgb16 rgb162 = this.rgb16t2;
            rgb162.diffDiv(this.rgb16sGouraud[n3], rgb16, n);
            n5 = n4 + n;
            for (n7 = n4; n7 < n5; ++n7) {
                rgb16Array[n7].setAndIncrement(rgb16, rgb162);
            }
        }
    }
}

