/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.event;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;

public class SelectionEventManager
implements SelectionChangedListener {
    private static final SelectionEventManager instance = new SelectionEventManager();
    private Collection<? extends OsmPrimitive> selection;
    private final CopyOnWriteArrayList<ListenerInfo> inEDTListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerInfo> normalListeners = new CopyOnWriteArrayList();
    private final Runnable edtRunnable = new Runnable(){

        @Override
        public void run() {
            if (SelectionEventManager.this.selection != null) {
                SelectionEventManager.this.fireEvents(SelectionEventManager.this.inEDTListeners, SelectionEventManager.this.selection);
            }
        }
    };

    public static SelectionEventManager getInstance() {
        return instance;
    }

    public SelectionEventManager() {
        DataSet.addSelectionListener(this);
    }

    public void addSelectionListener(SelectionChangedListener selectionChangedListener, DatasetEventManager.FireMode fireMode) {
        if (fireMode == DatasetEventManager.FireMode.IN_EDT) {
            throw new UnsupportedOperationException("IN_EDT mode not supported, you probably want to use IN_EDT_CONSOLIDATED.");
        }
        if (fireMode == DatasetEventManager.FireMode.IN_EDT || fireMode == DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED) {
            this.inEDTListeners.addIfAbsent(new ListenerInfo(selectionChangedListener));
        } else {
            this.normalListeners.addIfAbsent(new ListenerInfo(selectionChangedListener));
        }
    }

    public void removeSelectionListener(SelectionChangedListener selectionChangedListener) {
        ListenerInfo listenerInfo = new ListenerInfo(selectionChangedListener);
        this.inEDTListeners.remove(listenerInfo);
        this.normalListeners.remove(listenerInfo);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        this.fireEvents(this.normalListeners, collection);
        this.selection = collection;
        SwingUtilities.invokeLater(this.edtRunnable);
    }

    private void fireEvents(List<ListenerInfo> list, Collection<? extends OsmPrimitive> collection) {
        for (ListenerInfo listenerInfo : list) {
            listenerInfo.listener.selectionChanged(collection);
        }
    }

    private static class ListenerInfo {
        private final SelectionChangedListener listener;

        ListenerInfo(SelectionChangedListener selectionChangedListener) {
            this.listener = selectionChangedListener;
        }

        public int hashCode() {
            return Objects.hash(this.listener);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ListenerInfo listenerInfo = (ListenerInfo)object;
            return Objects.equals(this.listener, listenerInfo.listener);
        }
    }
}

