/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.parser;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.jruby.truffle.format.nodes.UnpackRootNode;
import org.jruby.truffle.format.parser.PackCompiler;
import org.jruby.truffle.format.parser.PackErrorListener;
import org.jruby.truffle.format.parser.PackLexer;
import org.jruby.truffle.format.parser.PackParser;
import org.jruby.truffle.format.parser.UnpackTreeBuilder;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;

public class UnpackCompiler {
    private final RubyContext context;
    private final RubyNode currentNode;

    public UnpackCompiler(RubyContext context, RubyNode currentNode) {
        this.context = context;
        this.currentNode = currentNode;
    }

    public CallTarget compile(String format) {
        if (format.length() > this.context.getOptions().PACK_RECOVER_LOOP_MIN) {
            format = PackCompiler.recoverLoop(format);
        }
        PackErrorListener errorListener = new PackErrorListener(this.context, this.currentNode);
        ANTLRInputStream input = new ANTLRInputStream(format);
        PackLexer lexer = new PackLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener(errorListener);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        PackParser parser = new PackParser(tokens);
        UnpackTreeBuilder builder = new UnpackTreeBuilder(this.context, this.currentNode);
        parser.addParseListener(builder);
        parser.removeErrorListeners();
        parser.addErrorListener(errorListener);
        parser.sequence();
        return Truffle.getRuntime().createCallTarget(new UnpackRootNode(PackCompiler.describe(format), builder.getEncoding(), builder.getNode()));
    }
}

