/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objectstorage;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.nodes.ShapeCachingGuards;
import org.jruby.truffle.runtime.Options;

@ImportStatic(value={ShapeCachingGuards.class})
public abstract class ReadHeadObjectFieldNode
extends Node {
    private final Object defaultValue;
    protected final Object name;

    public ReadHeadObjectFieldNode(Object name, Object defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public Object getName() {
        return this.name;
    }

    public abstract Object execute(DynamicObject var1);

    @Specialization(guards={"receiver.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="getCacheLimit()")
    protected Object readObjectFieldCached(DynamicObject receiver, @Cached(value="receiver.getShape()") Shape cachedShape, @Cached(value="cachedShape.getProperty(name)") Property property) {
        if (property != null) {
            return property.get(receiver, cachedShape);
        }
        return this.defaultValue;
    }

    @Specialization(guards={"updateShape(object)"})
    public Object updateShapeAndRead(DynamicObject object) {
        return this.execute(object);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(contains={"readObjectFieldCached", "updateShapeAndRead"})
    protected Object readObjectFieldUncached(DynamicObject receiver) {
        return receiver.get(this.name, this.defaultValue);
    }

    protected int getCacheLimit() {
        return Options.FIELD_LOOKUP_CACHE;
    }
}

