/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import junit.framework.TestCase;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.RuleMatch;

public class CommaWhitespaceRuleTest
extends TestCase {
    private CommaWhitespaceRule rule;
    private JLanguageTool langTool;

    public void setUp() throws IOException {
        this.rule = new CommaWhitespaceRule(TestTools.getEnglishMessages());
        this.langTool = new JLanguageTool(TestTools.getDemoLanguage());
    }

    public void testRule() throws IOException {
        this.assertMatches("This is a test sentence.", 0);
        this.assertMatches("This, is, a test sentence.", 0);
        this.assertMatches("This (foo bar) is a test!.", 0);
        this.assertMatches("Das kostet \u20ac2,45.", 0);
        this.assertMatches("Das kostet 50,- Euro", 0);
        this.assertMatches("This is a sentence with ellipsis ...", 0);
        this.assertMatches("This is a figure: .5 and it's correct.", 0);
        this.assertMatches("This is $1,000,000.", 0);
        this.assertMatches("This is 1,5.", 0);
        this.assertMatches("This is a ,,test''.", 0);
        this.assertMatches("This is,\u00a0really,\u00a0non-breaking whitespace.", 0);
        this.assertMatches("In his book,\u0002 Einstein proved this to be true.", 0);
        this.assertMatches("This,is a test sentence.", 1);
        this.assertMatches("This , is a test sentence.", 1);
        this.assertMatches("This ,is a test sentence.", 2);
        this.assertMatches(",is a test sentence.", 2);
        this.assertMatches("This ( foo bar) is a test!.", 1);
        this.assertMatches("This (foo bar ) is a test!.", 1);
        this.assertMatches("This [ foo bar) is a test!.", 1);
        this.assertMatches("This (foo bar ] is a test!.", 1);
        this.assertMatches("This { foo bar) is a test!.", 1);
        this.assertMatches("This (foo bar } is a test!.", 1);
        this.assertMatches("This is a sentence with an orphaned full stop .", 1);
        this.assertMatches("This is a test with a OOo footnote\u0002, which is denoted by 0x2 in the text.", 0);
        RuleMatch[] matches = this.rule.match(this.langTool.getAnalyzedSentence("ABB (  z.B. )"));
        CommaWhitespaceRuleTest.assertEquals((int)2, (int)matches.length);
        CommaWhitespaceRuleTest.assertEquals((int)4, (int)matches[0].getFromPos());
        CommaWhitespaceRuleTest.assertEquals((int)6, (int)matches[0].getToPos());
        CommaWhitespaceRuleTest.assertEquals((int)11, (int)matches[1].getFromPos());
        CommaWhitespaceRuleTest.assertEquals((int)13, (int)matches[1].getToPos());
        this.assertMatches("Ellipsis . . . as suggested by The Chicago Manual of Style", 3);
        this.assertMatches("Ellipsis . . . . as suggested by The Chicago Manual of Style", 4);
    }

    private void assertMatches(String text, int expectedMatches) throws IOException {
        CommaWhitespaceRuleTest.assertEquals((int)expectedMatches, (int)this.rule.match(this.langTool.getAnalyzedSentence(text)).length);
    }
}

