/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.commandline;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.MultiThreadedJLanguageTool;
import org.languagetool.bitext.TabBitextReader;
import org.languagetool.commandline.CommandLineOptions;
import org.languagetool.commandline.CommandLineParser;
import org.languagetool.commandline.CommandLineTools;
import org.languagetool.commandline.UnknownParameterException;
import org.languagetool.commandline.WrongParameterNumberException;
import org.languagetool.language.English;
import org.languagetool.language.LanguageIdentifier;
import org.languagetool.rules.Rule;
import org.languagetool.rules.bitext.BitextRule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.tools.JnaTools;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;
import org.xml.sax.SAXException;

class Main {
    private static final int MAX_FILE_SIZE = 64000;
    private final boolean verbose;
    private final boolean apiFormat;
    private final boolean taggerOnly;
    private final boolean applySuggestions;
    private final boolean autoDetect;
    private final boolean singleLineBreakMarksParagraph;
    private final boolean listUnknownWords;
    private final List<String> unknownWords;
    private final String[] enabledRules;
    private final String[] disabledRules;
    private final Language motherTongue;
    private MultiThreadedJLanguageTool lt;
    private boolean profileRules;
    private boolean bitextMode;
    private MultiThreadedJLanguageTool srcLt;
    private List<BitextRule> bRules;
    private Rule currentRule;

    Main(CommandLineOptions options) throws IOException {
        this.verbose = options.isVerbose();
        this.apiFormat = options.isApiFormat();
        this.taggerOnly = options.isTaggerOnly();
        this.applySuggestions = options.isApplySuggestions();
        this.autoDetect = options.isAutoDetect();
        this.enabledRules = options.getEnabledRules();
        this.disabledRules = options.getDisabledRules();
        this.motherTongue = options.getMotherTongue();
        this.singleLineBreakMarksParagraph = options.isSingleLineBreakMarksParagraph();
        this.listUnknownWords = options.isListUnknown();
        this.unknownWords = new ArrayList<String>();
        this.profileRules = false;
        this.bitextMode = false;
        this.srcLt = null;
        this.bRules = null;
        this.lt = new MultiThreadedJLanguageTool(options.getLanguage(), this.motherTongue);
        if (options.getRuleFile() != null) {
            this.addExternalRules(options.getRuleFile());
        }
        if (options.getLanguageModel() != null) {
            this.lt.activateLanguageModelRules(options.getLanguageModel());
        }
        Tools.selectRules((JLanguageTool)this.lt, this.disabledRules, this.enabledRules, options.isUseEnabledOnly());
    }

    private void addExternalRules(String filename) throws IOException {
        PatternRuleLoader ruleLoader = new PatternRuleLoader();
        try (FileInputStream is = new FileInputStream(filename);){
            List<AbstractPatternRule> externalRules = ruleLoader.getRules(is, filename);
            for (AbstractPatternRule externalRule : externalRules) {
                this.lt.addRule(externalRule);
            }
        }
    }

    boolean isSpellCheckingActive() {
        List<Rule> rules = this.lt.getAllActiveRules();
        for (Rule rule : rules) {
            if (!rule.isDictionaryBasedSpellingRule()) continue;
            return true;
        }
        return false;
    }

    JLanguageTool getJLanguageTool() {
        return this.lt;
    }

    private void setListUnknownWords(boolean listUnknownWords) {
        this.lt.setListUnknownWords(listUnknownWords);
    }

    private void cleanUp() {
        if (this.lt != null) {
            this.lt.shutdown();
        }
        if (this.srcLt != null) {
            this.srcLt.shutdown();
        }
        JLanguageTool.removeTemporaryFiles();
    }

    private void setProfilingMode() {
        this.profileRules = true;
    }

    private void setBitextMode(Language sourceLang, String[] disabledRules, String[] enabledRules, File bitextRuleFile) throws IOException, ParserConfigurationException, SAXException {
        this.bitextMode = true;
        Language target = this.lt.getLanguage();
        this.lt = new MultiThreadedJLanguageTool(target, null);
        this.srcLt = new MultiThreadedJLanguageTool(sourceLang);
        Tools.selectRules(this.lt, disabledRules, enabledRules);
        Tools.selectRules(this.srcLt, disabledRules, enabledRules);
        this.bRules = Tools.getBitextRules(sourceLang, this.lt.getLanguage(), bitextRuleFile);
        ArrayList<BitextRule> bRuleList = new ArrayList<BitextRule>(this.bRules);
        for (BitextRule bitextRule : this.bRules) {
            for (String disabledRule : disabledRules) {
                if (!bitextRule.getId().equals(disabledRule)) continue;
                bRuleList.remove(bitextRule);
            }
        }
        this.bRules = bRuleList;
        if (enabledRules.length > 0) {
            bRuleList = new ArrayList();
            for (String enabledRule : enabledRules) {
                for (BitextRule bitextRule : this.bRules) {
                    if (!bitextRule.getId().equals(enabledRule)) continue;
                    bRuleList.add(bitextRule);
                }
            }
            this.bRules = bRuleList;
        }
    }

    private void runOnFile(String filename, String encoding, boolean xmlFiltering) throws IOException {
        boolean oneTime = false;
        if (!this.isStdIn(filename)) {
            File file;
            if (this.autoDetect) {
                Language language = Main.detectLanguageOfFile(filename, encoding);
                if (language == null) {
                    System.err.println("Could not detect language well enough, using English");
                    language = new English();
                }
                this.changeLanguage(language, this.motherTongue, this.disabledRules, this.enabledRules);
                System.err.println("Using " + language.getName() + " for file " + filename);
            }
            boolean bl = oneTime = (file = new File(filename)).length() < 64000L || this.bitextMode;
        }
        if (oneTime) {
            this.runOnFileInOneGo(filename, encoding, xmlFiltering);
        } else {
            this.runOnFileLineByLine(filename, encoding);
        }
    }

    private void runOnFileInOneGo(String filename, String encoding, boolean xmlFiltering) throws IOException {
        if (this.bitextMode) {
            TabBitextReader reader = new TabBitextReader(filename, encoding);
            if (this.applySuggestions) {
                CommandLineTools.correctBitext(reader, this.srcLt, this.lt, this.bRules);
            } else {
                CommandLineTools.checkBitext(reader, this.srcLt, this.lt, this.bRules, this.apiFormat);
            }
        } else {
            String text = this.getFilteredText(filename, encoding, xmlFiltering);
            if (this.applySuggestions) {
                System.out.print(Tools.correctText(text, this.lt));
            } else if (this.profileRules) {
                CommandLineTools.profileRulesOnText(text, this.lt);
            } else if (!this.taggerOnly) {
                CommandLineTools.checkText(text, this.lt, this.apiFormat, 0, this.listUnknownWords);
            } else {
                CommandLineTools.tagText(text, this.lt);
            }
            if (this.listUnknownWords && !this.apiFormat) {
                System.out.println("Unknown words: " + this.lt.getUnknownWords());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnFileLineByLine(String filename, String encoding) throws IOException {
        if (this.verbose) {
            this.lt.setOutput(System.err);
        }
        if (!this.apiFormat && !this.applySuggestions) {
            if (this.isStdIn(filename)) {
                System.err.println("Working on STDIN...");
            } else {
                System.err.println("Working on " + filename + "...");
            }
        }
        if (this.profileRules && this.isStdIn(filename)) {
            throw new IllegalArgumentException("Profiling mode cannot be used with input from STDIN");
        }
        int runCount = 1;
        List<Rule> rules = this.lt.getAllActiveRules();
        if (this.profileRules) {
            System.out.printf("Testing %d rules\n", rules.size());
            System.out.println("Rule ID\tTime\tSentences\tMatches\tSentences per sec.");
            runCount = rules.size();
        }
        int lineOffset = 0;
        int tmpLineOffset = 0;
        this.handleLine(StringTools.XmlPrintMode.START_XML, 0, new StringBuilder());
        StringBuilder sb = new StringBuilder();
        for (int ruleIndex = 0; !rules.isEmpty() && ruleIndex < runCount; ++ruleIndex) {
            this.currentRule = rules.get(ruleIndex);
            int matches = 0;
            long sentences = 0L;
            long startTime = System.currentTimeMillis();
            try (InputStreamReader isr = this.getInputStreamReader(filename, encoding);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                int lineCount = 0;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    if (++lineCount == 1 && this.autoDetect) {
                        Language language = Main.detectLanguageOfString(line);
                        if (language == null) {
                            System.err.println("Could not detect language well enough, using English");
                            language = new English();
                        }
                        System.err.println("Language used is: " + language.getName());
                        language.getSentenceTokenizer().setSingleLineBreaksMarksParagraph(this.singleLineBreakMarksParagraph);
                        this.changeLanguage(language, this.motherTongue, this.disabledRules, this.enabledRules);
                    }
                    sb.append('\n');
                    ++tmpLineOffset;
                    if (!this.isBreakPoint(sb, line)) continue;
                    matches += this.handleLine(StringTools.XmlPrintMode.CONTINUE_XML, lineOffset, sb);
                    sentences += (long)this.lt.getSentenceCount();
                    if (this.profileRules) {
                        sentences += (long)this.lt.sentenceTokenize(sb.toString()).size();
                    }
                    this.rememberUnknownWords();
                    sb = new StringBuilder();
                    lineOffset = tmpLineOffset;
                }
                continue;
            }
            finally {
                if (sb.length() > 0) {
                    sentences += (long)this.lt.getSentenceCount();
                    if (this.profileRules) {
                        sentences += (long)this.lt.sentenceTokenize(sb.toString()).size();
                    }
                    this.rememberUnknownWords();
                }
                this.printTimingInformation(rules, ruleIndex, matches += this.handleLine(StringTools.XmlPrintMode.END_XML, tmpLineOffset - 1, sb), sentences, startTime);
            }
        }
    }

    private boolean isBreakPoint(StringBuilder sb, String line) {
        return this.lt.getLanguage().getSentenceTokenizer().singleLineBreaksMarksPara() || "".equals(line) || sb.length() >= 64000;
    }

    private void rememberUnknownWords() {
        if (this.listUnknownWords && !this.taggerOnly) {
            for (String word : this.lt.getUnknownWords()) {
                if (this.unknownWords.contains(word)) continue;
                this.unknownWords.add(word);
            }
        }
    }

    private InputStreamReader getInputStreamReader(String filename, String encoding) throws UnsupportedEncodingException, FileNotFoundException {
        InputStreamReader isr;
        if (!this.isStdIn(filename)) {
            File file = new File(filename);
            isr = encoding != null ? new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), encoding) : new InputStreamReader(new BufferedInputStream(new FileInputStream(file)));
        } else {
            isr = encoding != null ? new InputStreamReader((InputStream)new BufferedInputStream(System.in), encoding) : new InputStreamReader(new BufferedInputStream(System.in));
        }
        return isr;
    }

    private boolean isStdIn(String filename) {
        return "-".equals(filename);
    }

    private void printTimingInformation(List<Rule> rules, int ruleIndex, int matches, long sentences, long startTime) {
        if (!this.applySuggestions) {
            long endTime = System.currentTimeMillis();
            long time = endTime - startTime;
            float timeInSeconds = (float)time / 1000.0f;
            float sentencesPerSecond = (float)sentences / timeInSeconds;
            if (this.apiFormat) {
                System.out.println("<!--");
            }
            if (this.profileRules) {
                System.out.printf(Locale.ENGLISH, "%s\t%d\t%d\t%d\t%.1f", rules.get(ruleIndex).getId(), time, sentences, matches, Float.valueOf(sentencesPerSecond));
                System.out.println();
            } else {
                System.out.printf(Locale.ENGLISH, "Time: %dms for %d sentences (%.1f sentences/sec)", time, sentences, Float.valueOf(sentencesPerSecond));
                System.out.println();
            }
            if (this.listUnknownWords && !this.apiFormat) {
                Collections.sort(this.unknownWords);
                System.out.println("Unknown words: " + this.unknownWords);
            }
            if (this.apiFormat) {
                System.out.println("-->");
            }
        }
    }

    private int handleLine(StringTools.XmlPrintMode mode, int lineOffset, StringBuilder sb) throws IOException {
        int matches = 0;
        String s = StringTools.filterXML(sb.toString());
        if (this.applySuggestions) {
            System.out.print(Tools.correctText(s, this.lt));
        } else if (this.profileRules) {
            matches += Tools.profileRulesOnLine(s, this.lt, this.currentRule);
        } else if (!this.taggerOnly) {
            matches += CommandLineTools.checkText(s, this.lt, this.apiFormat, -1, lineOffset, matches, mode, this.listUnknownWords, this.unknownWords);
        } else {
            CommandLineTools.tagText(s, this.lt);
        }
        return matches;
    }

    private void runRecursive(String filename, String encoding, boolean xmlFiltering) {
        File dir = new File(filename);
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException(dir.getAbsolutePath() + " is not a directory, cannot use recursion");
        }
        for (File file : files) {
            try {
                if (file.isDirectory()) {
                    this.runRecursive(file.getAbsolutePath(), encoding, xmlFiltering);
                    continue;
                }
                this.runOnFile(file.getAbsolutePath(), encoding, xmlFiltering);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not check text in file " + file, e);
            }
        }
    }

    private String getFilteredText(String filename, String encoding, boolean xmlFiltering) throws IOException {
        if (this.verbose) {
            this.lt.setOutput(System.err);
        }
        if (!this.apiFormat && !this.applySuggestions) {
            System.out.println("Working on " + filename + "...");
        }
        String fileContents = StringTools.streamToString(new FileInputStream(filename), encoding != null ? encoding : Charset.defaultCharset().name());
        if (xmlFiltering) {
            return StringTools.filterXML(fileContents);
        }
        return fileContents;
    }

    private void changeLanguage(Language language, Language motherTongue, String[] disabledRules, String[] enabledRules) {
        try {
            this.lt = new MultiThreadedJLanguageTool(language, motherTongue);
            Tools.selectRules(this.lt, disabledRules, enabledRules);
            if (this.verbose) {
                this.lt.setOutput(System.err);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create LanguageTool instance for language " + language, e);
        }
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        JnaTools.setBugWorkaroundProperty();
        CommandLineParser commandLineParser = new CommandLineParser();
        CommandLineOptions options = null;
        try {
            options = commandLineParser.parseOptions(args);
        }
        catch (WrongParameterNumberException e) {
            commandLineParser.printUsage();
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
        catch (UnknownParameterException e) {
            if (e.getMessage() != null) {
                System.err.println(e.getMessage());
            } else {
                System.err.println(e.toString());
            }
            commandLineParser.printUsage(System.err);
            System.exit(1);
        }
        if (options.isPrintUsage()) {
            commandLineParser.printUsage();
            System.exit(1);
        }
        if (options.isPrintVersion()) {
            System.out.println("LanguageTool version 3.2 (" + JLanguageTool.BUILD_DATE + ")");
            System.exit(0);
        }
        if (options.isPrintLanguages()) {
            Main.printLanguages();
            System.exit(0);
        }
        if (options.getFilename() == null) {
            options.setFilename("-");
        }
        String languageHint = null;
        if (options.getLanguage() == null) {
            if (!options.isApiFormat() && !options.isAutoDetect()) {
                System.err.println("No language specified, using English (no spell checking active, specify a language variant like 'en-GB' if available)");
            }
            options.setLanguage((Language)new English());
        } else if (!options.isApiFormat() && !options.isApplySuggestions()) {
            languageHint = "Expected text language: " + options.getLanguage().getName();
        }
        options.getLanguage().getSentenceTokenizer().setSingleLineBreaksMarksParagraph(options.isSingleLineBreakMarksParagraph());
        Main prg = new Main(options);
        if (options.getFalseFriendFile() != null) {
            List<AbstractPatternRule> ffRules = prg.lt.loadFalseFriendRules(options.getFalseFriendFile());
            for (AbstractPatternRule ffRule : ffRules) {
                prg.lt.addRule(ffRule);
            }
        }
        if (prg.lt.getAllActiveRules().size() == 0) {
            throw new RuntimeException("WARNING: No rules are active. Please make sure your rule ids are correct: " + Arrays.toString(options.getEnabledRules()));
        }
        if (languageHint != null) {
            String spellHint = prg.isSpellCheckingActive() ? "" : " (no spell checking active, specify a language variant like 'en-GB' if available)";
            System.err.println(languageHint + spellHint);
        }
        prg.setListUnknownWords(options.isListUnknown());
        if (options.isProfile()) {
            prg.setProfilingMode();
        }
        if (options.isBitext()) {
            if (options.getMotherTongue() == null) {
                throw new IllegalArgumentException("You have to set the source language (as mother tongue) in bitext mode");
            }
            File bitextRuleFile = options.getBitextRuleFile() != null ? new File(options.getBitextRuleFile()) : null;
            prg.setBitextMode(options.getMotherTongue(), options.getDisabledRules(), options.getEnabledRules(), bitextRuleFile);
        }
        if (options.isRecursive()) {
            prg.runRecursive(options.getFilename(), options.getEncoding(), options.isXmlFiltering());
        } else {
            prg.runOnFile(options.getFilename(), options.getEncoding(), options.isXmlFiltering());
        }
        prg.cleanUp();
    }

    private static void printLanguages() {
        ArrayList<String> languages = new ArrayList<String>();
        for (Language language : Languages.get()) {
            languages.add(language.getShortNameWithCountryAndVariant() + " " + language.getName());
        }
        Collections.sort(languages);
        for (String s : languages) {
            System.out.println(s);
        }
    }

    private static Language detectLanguageOfFile(String filename, String encoding) throws IOException {
        String text = StringTools.readStream(new FileInputStream(filename), encoding);
        return Main.detectLanguageOfString(text);
    }

    private static Language detectLanguageOfString(String text) {
        LanguageIdentifier identifier = new LanguageIdentifier();
        return identifier.detectLanguage(text);
    }
}

