/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.server.Constants;
import org.apache.tomcat.websocket.server.WsContextListener;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.apache.tomcat.websocket.server.WsSessionListener;

@HandlesTypes(value={ServerEndpoint.class, ServerApplicationConfig.class, Endpoint.class})
public class WsSci
implements ServletContainerInitializer {
    private static boolean logMessageWritten = false;
    private static final Log log = LogFactory.getLog(WsSci.class);
    private static final StringManager sm = StringManager.getManager(Constants.PACKAGE_NAME);

    @Override
    public void onStartup(Set<Class<?>> clazzes, ServletContext ctx) throws ServletException {
        if (!WsSci.isJava7OrLater()) {
            if (!logMessageWritten) {
                logMessageWritten = true;
                log.info((Object)sm.getString("sci.noWebSocketSupport"));
            }
            return;
        }
        WsServerContainer sc = WsSci.init(ctx, true);
        if (clazzes == null || clazzes.size() == 0) {
            return;
        }
        HashSet<ServerApplicationConfig> serverApplicationConfigs = new HashSet<ServerApplicationConfig>();
        HashSet<Class<? extends Endpoint>> scannedEndpointClazzes = new HashSet<Class<? extends Endpoint>>();
        HashSet scannedPojoEndpoints = new HashSet();
        try {
            String wsPackage = ContainerProvider.class.getName();
            wsPackage = wsPackage.substring(0, wsPackage.lastIndexOf(46) + 1);
            for (Class<?> clazz : clazzes) {
                int n = clazz.getModifiers();
                if (!Modifier.isPublic(n) || Modifier.isAbstract(n) || clazz.getName().startsWith(wsPackage)) continue;
                if (ServerApplicationConfig.class.isAssignableFrom(clazz)) {
                    serverApplicationConfigs.add((ServerApplicationConfig)clazz.newInstance());
                }
                if (Endpoint.class.isAssignableFrom(clazz)) {
                    Class<?> endpoint = clazz;
                    scannedEndpointClazzes.add(endpoint);
                }
                if (!clazz.isAnnotationPresent(ServerEndpoint.class)) continue;
                scannedPojoEndpoints.add(clazz);
            }
        }
        catch (InstantiationException e) {
            throw new ServletException(e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException(e);
        }
        HashSet<ServerEndpointConfig> filteredEndpointConfigs = new HashSet<ServerEndpointConfig>();
        HashSet filteredPojoEndpoints = new HashSet();
        if (serverApplicationConfigs.isEmpty()) {
            filteredPojoEndpoints.addAll(scannedPojoEndpoints);
        } else {
            for (ServerApplicationConfig serverApplicationConfig : serverApplicationConfigs) {
                Set<Class<?>> configFilteredPojos;
                Set<ServerEndpointConfig> configFilteredEndpoints = serverApplicationConfig.getEndpointConfigs(scannedEndpointClazzes);
                if (configFilteredEndpoints != null) {
                    filteredEndpointConfigs.addAll(configFilteredEndpoints);
                }
                if ((configFilteredPojos = serverApplicationConfig.getAnnotatedEndpointClasses(scannedPojoEndpoints)) == null) continue;
                filteredPojoEndpoints.addAll(configFilteredPojos);
            }
        }
        try {
            for (ServerEndpointConfig serverEndpointConfig : filteredEndpointConfigs) {
                sc.addEndpoint(serverEndpointConfig);
            }
            for (Class clazz : filteredPojoEndpoints) {
                sc.addEndpoint(clazz);
            }
        }
        catch (DeploymentException e) {
            throw new ServletException(e);
        }
    }

    static WsServerContainer init(ServletContext servletContext, boolean initBySciMechanism) {
        WsServerContainer sc = new WsServerContainer(servletContext);
        servletContext.setAttribute("javax.websocket.server.ServerContainer", sc);
        servletContext.addListener(new WsSessionListener(sc));
        if (initBySciMechanism) {
            servletContext.addListener(new WsContextListener());
        }
        return sc;
    }

    private static boolean isJava7OrLater() {
        try {
            Class.forName("java.nio.channels.AsynchronousSocketChannel");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

