/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.core.scanner.MultipartFormParser;
import org.parosproxy.paros.core.scanner.MultipartParam;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMessage;

public class VariantMultipartFormQuery
implements Variant {
    private final List<NameValuePair> stringParam = new ArrayList<NameValuePair>();
    private final List<MultipartParam> fileParam = new ArrayList<MultipartParam>();
    private String boundary = null;

    @Override
    public void setMessage(HttpMessage httpMessage) {
        String string = httpMessage.getRequestHeader().getHeader("Content-Type");
        if (string == null || !string.startsWith("multipart/form-data")) {
            return;
        }
        try {
            MultipartParam multipartParam;
            MultipartFormParser multipartFormParser = new MultipartFormParser(httpMessage);
            int n = 0;
            this.boundary = multipartFormParser.getBoundary();
            while ((multipartParam = multipartFormParser.getNextParam()) != null) {
                if (multipartParam.getFileName() == null) {
                    this.stringParam.add(new NameValuePair(2, multipartParam.getName(), multipartParam.getContent(), n++));
                    continue;
                }
                this.fileParam.add(multipartParam);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.stringParam;
    }

    @Override
    public String setParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        return this.setParameter(httpMessage, nameValuePair, string, string2, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        return this.setParameter(httpMessage, nameValuePair, string, string2, true);
    }

    private String setParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.stringParam.size(); ++i) {
            NameValuePair nameValuePair2 = this.stringParam.get(i);
            stringBuilder.append(this.boundary);
            stringBuilder.append("\r\n");
            stringBuilder.append("Content-Disposition: form-data; name=\"");
            if (i == nameValuePair.getPosition()) {
                stringBuilder.append(string);
                stringBuilder.append("\"\r\n\r\n");
                stringBuilder.append(string2);
            } else {
                stringBuilder.append(nameValuePair2.getName());
                stringBuilder.append("\"\r\n\r\n");
                stringBuilder.append(nameValuePair2.getValue());
            }
            stringBuilder.append("\r\n");
        }
        for (MultipartParam multipartParam : this.fileParam) {
            stringBuilder.append(this.boundary);
            stringBuilder.append("\r\n");
            stringBuilder.append(multipartParam.toString());
        }
        stringBuilder.append(this.boundary);
        stringBuilder.append("--");
        stringBuilder.append("\r\n");
        String string3 = stringBuilder.toString();
        httpMessage.getRequestBody().setBody(string3);
        return string3;
    }
}

